/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.HTMLElementName;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.MasonTagTypes;
import au.id.jericho.lib.html.PHPTagTypes;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.TagType;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Tag
extends Segment
implements HTMLElementName {
    String name = null;
    public static final String PROCESSING_INSTRUCTION = StartTagType.XML_PROCESSING_INSTRUCTION.getNamePrefixForTagConstant();
    public static final String XML_DECLARATION = StartTagType.XML_DECLARATION.getNamePrefixForTagConstant();
    public static final String DOCTYPE_DECLARATION = StartTagType.DOCTYPE_DECLARATION.getNamePrefixForTagConstant();
    public static final String SERVER_PHP = PHPTagTypes.PHP_STANDARD.getNamePrefixForTagConstant();
    public static final String SERVER_COMMON = StartTagType.SERVER_COMMON.getNamePrefixForTagConstant();
    public static final String SERVER_MASON_NAMED_BLOCK = MasonTagTypes.MASON_NAMED_BLOCK.getNamePrefixForTagConstant();
    public static final String SERVER_MASON_COMPONENT_CALL = MasonTagTypes.MASON_COMPONENT_CALL.getNamePrefixForTagConstant();
    public static final String SERVER_MASON_COMPONENT_CALLED_WITH_CONTENT = MasonTagTypes.MASON_COMPONENT_CALLED_WITH_CONTENT.getNamePrefixForTagConstant();
    private static final boolean INCLUDE_UNREGISTERED_IN_SEARCH = false;

    Tag(Source source, int begin, int end, String name) {
        super(source, begin, end);
        this.name = HTMLElements.getConstantElementName(name.toLowerCase());
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isUnregistered();

    public abstract TagType getTagType();

    public abstract String regenerateHTML();

    public static final boolean isXMLNameStartChar(char ch) {
        return Character.isLetter(ch) || ch == '_' || ch == ':';
    }

    public static final boolean isXMLNameChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '.' || ch == '-' || ch == '_' || ch == ':';
    }

    final boolean includeInSearch() {
        return !this.isUnregistered();
    }

    static final Tag findPreviousOrNextTag(Source source, int pos, boolean previous) {
        return source.cache.findPreviousOrNextTag(pos, previous);
    }

    static final Tag findPreviousOrNextTagUncached(Source source, int pos, boolean previous, int breakAtPos) {
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            do {
                int n = begin = previous ? parseText.lastIndexOf('<', begin, breakAtPos) : parseText.indexOf('<', begin, breakAtPos);
                if (begin == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source, begin);
                if (tag == null || !tag.includeInSearch()) continue;
                return tag;
            } while (Tag.inRange(source, begin += previous ? -1 : 1));
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    static final Tag findPreviousOrNextTag(Source source, int pos, TagType tagType, boolean previous) {
        return source.cache.findPreviousOrNextTag(pos, tagType, previous);
    }

    static final Tag findPreviousOrNextTagUncached(Source source, int pos, TagType tagType, boolean previous, int breakAtPos) {
        if (tagType == null) {
            return Tag.findPreviousOrNextTagUncached(source, pos, previous, breakAtPos);
        }
        char[] startDelimiterCharArray = tagType.getStartDelimiterCharArray();
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            do {
                int n = begin = previous ? parseText.lastIndexOf(startDelimiterCharArray, begin, breakAtPos) : parseText.indexOf(startDelimiterCharArray, begin, breakAtPos);
                if (begin == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source, begin);
                if (tag == null || tag.getTagType() != tagType) continue;
                return tag;
            } while (Tag.inRange(source, begin += previous ? -1 : 1));
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        return null;
    }

    static final Tag getTagAt(Source source, int pos) {
        return source.cache.getTagAt(pos);
    }

    static final Tag getTagAtUncached(Source source, int pos) {
        return TagType.getTagAt(source, pos);
    }

    static final boolean inRange(Source source, int pos) {
        return pos >= 0 && pos <= source.length();
    }

    static Iterator getNextTagIterator(Source source, int pos) {
        return new NextTagIterator(source, pos);
    }

    private static final class NextTagIterator
    implements Iterator {
        private Tag nextTag = null;

        public NextTagIterator(Source source, int pos) {
            this.nextTag = Tag.findPreviousOrNextTag(source, pos, false);
        }

        public boolean hasNext() {
            return this.nextTag != null;
        }

        public Object next() {
            Tag result = this.nextTag;
            try {
                this.nextTag = Tag.findPreviousOrNextTag(result.source, result.begin + 1, false);
            }
            catch (NullPointerException ex) {
                throw new NoSuchElementException();
            }
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

