/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util.property;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import org.eigenbase.util.property.PersistentPropertyStorage;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.StringProperty;

public class PersistentStringProperty
extends StringProperty {
    private static final Logger tracer = Logger.getLogger(Property.class.getName());
    private StringProperty propertyFileLocation;
    private PersistentPropertyStorage storage;
    private boolean storageInitialized;

    public PersistentStringProperty(Properties properties, String path, String defaultValue, StringProperty propertyFileLocation) {
        super(properties, path, defaultValue);
        this.propertyFileLocation = propertyFileLocation;
        this.storage = null;
        this.storageInitialized = false;
    }

    @Override
    public synchronized String set(String value) {
        String prevValue = super.set(value);
        if (!this.storageInitialized) {
            this.storageInitialized = true;
            if (this.propertyFileLocation.get() == null) {
                tracer.warning("Cannot store property '" + this.getPath() + "' because storage location is not set");
                return prevValue;
            }
            try {
                this.storage = PersistentPropertyStorage.newPersistentPropertyStorage(this.propertyFileLocation.get());
            }
            catch (IOException e) {
                tracer.warning("Unable to initialize persistent property storage for '" + this.getPath() + "'");
                tracer.throwing("PersistentPropertyStorage", "<init>", e);
                return prevValue;
            }
        }
        if (this.storage != null) {
            try {
                this.storage.storeProperty(this);
            }
            catch (IOException e) {
                tracer.warning("Unable to persist property '" + this.getPath() + "'");
                tracer.throwing("PersistentPropertyStorage", "set(String)", e);
            }
        }
        return prevValue;
    }
}

