/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.quidem;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.hydromatic.quidem.OutputFormat;
import net.hydromatic.quidem.Quidem;

enum BuiltInOutputFormat implements OutputFormat
{
    CSV{

        @Override
        public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, boolean sort) throws Exception {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int n = metaData.getColumnCount();
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(metaData.getColumnLabel(i + 1));
            }
            headerLines.add(buf.toString());
            buf.setLength(0);
            ArrayList<String> lines = new ArrayList<String>();
            while (resultSet.next()) {
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(resultSet.getString(i + 1));
                }
                lines.add(buf.toString());
                buf.setLength(0);
            }
            if (sort) {
                Collections.sort(lines);
            }
            bodyLines.addAll(lines);
        }
    }
    ,
    MYSQL{

        @Override
        public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, boolean sort) throws Exception {
            Quidem.format(resultSet, headerLines, bodyLines, footerLines, sort, this);
        }
    }
    ,
    ORACLE{

        @Override
        public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, boolean sort) throws Exception {
            Quidem.format(resultSet, headerLines, bodyLines, footerLines, sort, this);
        }
    }
    ,
    PSQL{

        @Override
        public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, boolean sort) throws Exception {
            Quidem.format(resultSet, headerLines, bodyLines, footerLines, sort, this);
        }
    };

}

