/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.quidem;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.hydromatic.quidem.AbstractCommand;
import net.hydromatic.quidem.BuiltInOutputFormat;
import net.hydromatic.quidem.Command;
import net.hydromatic.quidem.CommandHandler;
import net.hydromatic.quidem.ConnectionFactories;
import net.hydromatic.quidem.Launcher;
import net.hydromatic.quidem.LimitWriter;
import net.hydromatic.quidem.OutputFormat;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Quidem {
    private static final Ordering<String[]> ORDERING = Ordering.natural().nullsLast().lexicographical().onResultOf(input -> Arrays.asList(input));
    public static final boolean DEBUG = "true".equals(System.getProperties().getProperty("quidem.debug"));
    private static final int DEFAULT_MAX_STACK_LENGTH = 16384;
    public static final Function<String, Object> EMPTY_ENV = name -> null;
    public static final ConnectionFactory EMPTY_CONNECTION_FACTORY = ConnectionFactories.empty();
    public static final CommandHandler EMPTY_COMMAND_HANDLER = (lines, content, line) -> null;
    public static final PropertyHandler EMPTY_PROPERTY_HANDLER = (propertyName, value) -> {};
    private static final int ORACLE_FEEDBACK = 6;
    private final BufferedReader reader;
    private final PrintWriter writer;
    private final Map<String, List<Object>> map = new HashMap<String, List<Object>>();
    private final Config config;
    private ResultSet resultSet;
    private Throwable resultSetException;
    private final List<String> lines = new ArrayList<String>();
    private String pushedLine;
    private final StringBuilder buf = new StringBuilder();
    private Connection connection;
    private Connection refConnection;
    private boolean execute = true;
    private boolean skip = false;
    private final Function<String, Object> env;
    private SqlCommand previousSqlCommand;

    public Quidem(Reader reader, Writer writer) {
        this(Quidem.configBuilder().withReader(reader).withWriter(writer).build());
    }

    public Quidem(Config config) {
        this.config = config;
        Reader rawReader = config.reader();
        this.reader = rawReader instanceof BufferedReader ? (BufferedReader)rawReader : new BufferedReader(rawReader);
        Writer rawWriter = config.writer();
        this.writer = rawWriter instanceof PrintWriter ? (PrintWriter)rawWriter : new PrintWriter(rawWriter);
        ArrayList<BuiltInOutputFormat> list = new ArrayList<BuiltInOutputFormat>();
        list.add(BuiltInOutputFormat.CSV);
        this.map.put(Property.OUTPUTFORMAT.propertyName(), list);
        this.env = new TopEnv(config.env());
    }

    public static ConfigBuilder configBuilder() {
        return new ConfigBuilder(new StringReader(""), new StringWriter(), EMPTY_CONNECTION_FACTORY, EMPTY_COMMAND_HANDLER, EMPTY_PROPERTY_HANDLER, EMPTY_ENV, 16384);
    }

    private ConfigBuilder copyConfigBuilder() {
        return Quidem.configBuilder().withReader(this.config.reader()).withWriter(this.config.writer()).withConnectionFactory(this.config.connectionFactory()).withCommandHandler(this.config.commandHandler()).withPropertyHandler(this.config.propertyHandler()).withEnv(this.config.env());
    }

    public static void main(String[] args) {
        PrintWriter out = new PrintWriter(System.out);
        PrintWriter err = new PrintWriter(System.err);
        int code = Launcher.main2(out, err, Arrays.asList(args));
        System.exit(code);
    }

    private void close() throws SQLException {
        Connection c;
        if (this.connection != null) {
            c = this.connection;
            this.connection = null;
            c.close();
        }
        if (this.refConnection != null) {
            c = this.refConnection;
            this.refConnection = null;
            c.close();
        }
    }

    public void execute() {
        try {
            Command command = new Parser().parse();
            try {
                command.execute(new ContextImpl(), this.execute);
                this.close();
            }
            catch (AssertionError | Exception e) {
                throw new RuntimeException("Error while executing command " + command, (Throwable)e);
            }
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.writer.close();
            try {
                this.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private void use(String connectionName) throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.refConnection != null) {
            this.refConnection.close();
        }
        ConnectionFactory connectionFactory = this.config.connectionFactory();
        this.connection = connectionFactory.connect(connectionName, false);
        this.refConnection = connectionFactory.connect(connectionName, true);
    }

    protected void echo(Iterable<String> lines) {
        for (String line : lines) {
            try {
                this.writer.println(line);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while writing output", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(String sql, boolean execute, boolean output, Command.ResultChecker checker, Command.Context x) throws Exception {
        if (execute) {
            if (this.connection == null) {
                throw new RuntimeException("no connection");
            }
            Statement statement = this.connection.createStatement();
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            try {
                if (DEBUG) {
                    System.out.println("execute: " + this);
                }
                this.resultSet = null;
                this.resultSetException = null;
                int updateCount = statement.executeUpdate(sql);
                this.writer.printf("(%d%s modified)%n", updateCount, updateCount == 1 ? " row" : " rows");
            }
            catch (SQLException e) {
                this.resultSetException = e;
            }
            catch (Throwable e) {
                System.out.println("Warning: JDBC driver threw non-SQLException");
                this.resultSetException = e;
            }
            finally {
                statement.close();
            }
            checker.checkResultSet(x, this.resultSetException);
            this.writer.println();
            this.resultSet = null;
            this.resultSetException = null;
        } else {
            this.echo(checker.getOutput(x));
        }
        this.echo(this.lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkResult(boolean execute, boolean output, Command.ResultChecker checker, Command.Context x) throws Exception {
        if (execute) {
            if (this.connection == null) {
                throw new RuntimeException("no connection");
            }
            SqlCommand sqlCommand = x.previousSqlCommand();
            Statement statement = this.connection.createStatement();
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            try {
                ArrayList<String> headerLines = new ArrayList<String>();
                ArrayList<String> bodyLines = new ArrayList<String>();
                ArrayList<String> footerLines = new ArrayList<String>();
                try {
                    if (DEBUG) {
                        System.out.println("execute: " + this);
                    }
                    this.resultSet = null;
                    this.resultSetException = null;
                    this.resultSet = statement.executeQuery(sqlCommand.sql);
                    if (this.resultSet != null) {
                        OutputFormat format = (OutputFormat)this.env.apply(Property.OUTPUTFORMAT.propertyName());
                        format.format(this.resultSet, headerLines, bodyLines, footerLines, sqlCommand.sort);
                    }
                }
                catch (SQLException e) {
                    this.resultSetException = e;
                }
                catch (Throwable e) {
                    System.out.println("Warning: JDBC driver threw non-SQLException");
                    this.resultSetException = e;
                }
                if (this.resultSetException == null && this.resultSet != null) {
                    List<String> expectedLines = checker.getOutput(x);
                    ArrayList<String> lines = new ArrayList<String>(expectedLines);
                    ImmutableList actualLines = ImmutableList.builder().addAll(headerLines).addAll(bodyLines).addAll(footerLines).build();
                    for (String line : headerLines) {
                        if (lines.isEmpty()) continue;
                        lines.remove(0);
                    }
                    for (String line : footerLines) {
                        if (lines.isEmpty()) continue;
                        lines.remove(lines.size() - 1);
                    }
                    for (String line : headerLines) {
                        if (!output) continue;
                        this.writer.println(line);
                    }
                    for (String line : lines) {
                        if (sqlCommand.sort) {
                            if (!bodyLines.remove(line) || !output) continue;
                            this.writer.println(line);
                            continue;
                        }
                        if (bodyLines.isEmpty() || !((String)bodyLines.get(0)).equals(line)) continue;
                        bodyLines.remove(0);
                        if (!output) continue;
                        this.writer.println(line);
                    }
                    for (String line : bodyLines) {
                        if (!output) continue;
                        this.writer.println(line);
                    }
                    for (String line : footerLines) {
                        if (!output) continue;
                        this.writer.println(line);
                    }
                    this.resultSet.close();
                    if (!output && !actualLines.equals(expectedLines)) {
                        StringWriter buf = new StringWriter();
                        PrintWriter w = new PrintWriter(buf);
                        w.println("Reference query returned different results.");
                        w.println("expected:");
                        for (String line : expectedLines) {
                            w.println(line);
                        }
                        w.println("actual:");
                        for (String line : actualLines) {
                            w.println(line);
                        }
                        w.close();
                        throw new IllegalArgumentException(buf.toString());
                    }
                }
                checker.checkResultSet(x, this.resultSetException);
                if (this.resultSet == null && this.resultSetException == null) {
                    throw new AssertionError((Object)"neither resultSet nor exception set");
                }
                this.resultSet = null;
                this.resultSetException = null;
            }
            finally {
                statement.close();
            }
        }
        if (output) {
            this.echo(checker.getOutput(x));
        }
        this.echo(this.lines);
    }

    Command of(List<Command> commands) {
        return commands.size() == 1 ? commands.get(0) : new CompositeCommand((List<Command>)ImmutableList.copyOf(commands));
    }

    private static String pad(String s, int width, boolean right) {
        int x;
        if (s == null) {
            s = "";
        }
        if ((x = width - s.length()) <= 0) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        if (right) {
            buf.append(Quidem.chars(' ', x)).append(s);
        } else {
            buf.append(s).append(Quidem.chars(' ', x));
        }
        return buf.toString();
    }

    <E> Iterator<String> stringIterator(final Enumeration<E> enumeration) {
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public String next() {
                return enumeration.nextElement().toString();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static CharSequence chars(final char c, final int length) {
        return new CharSequence(){

            @Override
            public String toString() {
                return Strings.repeat((String)("" + c), (int)length);
            }

            @Override
            public int length() {
                return length;
            }

            @Override
            public char charAt(int index) {
                return c;
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return Quidem.chars(c, end - start);
            }
        };
    }

    private boolean getBoolean(List<String> names) {
        if (names.size() == 1) {
            if (names.get(0).equals("true")) {
                return true;
            }
            if (names.get(0).equals("false")) {
                return false;
            }
        }
        Function e = this.env;
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            Object value = e.apply((String)name);
            if (value instanceof Function) {
                e = (Function)value;
                continue;
            }
            if (i != names.size() - 1) continue;
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return value != null && value.toString().equalsIgnoreCase("true");
        }
        return false;
    }

    public boolean isProbablyDeterministic(String sql) {
        int openCount;
        String upperSql = sql.toUpperCase();
        if (!upperSql.contains("ORDER BY")) {
            return false;
        }
        int i = upperSql.lastIndexOf("ORDER BY");
        String tail = upperSql.substring(i);
        int closeCount = tail.length() - tail.replace(")", "").length();
        return closeCount <= (openCount = tail.length() - tail.replace("(", "").length());
    }

    static void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, boolean sort, BuiltInOutputFormat format) throws SQLException {
        int i;
        int i2;
        boolean mysql = format == BuiltInOutputFormat.MYSQL;
        ResultSetMetaData metaData = resultSet.getMetaData();
        int n = metaData.getColumnCount();
        int[] widths = new int[n];
        ArrayList<String[]> rows = new ArrayList<String[]>();
        boolean[] rights = new boolean[n];
        for (i2 = 0; i2 < n; ++i2) {
            widths[i2] = metaData.getColumnLabel(i2 + 1).length();
        }
        while (resultSet.next()) {
            String[] row = new String[n];
            for (i = 0; i < n; ++i) {
                String value = resultSet.getString(i + 1);
                widths[i] = Math.max(widths[i], value == null ? 0 : value.length());
                row[i] = value;
            }
            rows.add(row);
        }
        for (i2 = 0; i2 < widths.length; ++i2) {
            switch (metaData.getColumnType(i2 + 1)) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    rights[i2] = true;
                }
            }
        }
        if (sort) {
            Collections.sort(rows, ORDERING);
        }
        switch (format) {
            case ORACLE: {
                if (!rows.isEmpty()) break;
                footerLines.add("");
                footerLines.add("no rows selected");
                footerLines.add("");
                return;
            }
        }
        StringBuilder buf = new StringBuilder();
        block29: for (i = 0; i < n; ++i) {
            switch (format) {
                case ORACLE: {
                    buf.append(i > 0 ? " " : "");
                    buf.append(Quidem.chars('-', widths[i]));
                    continue block29;
                }
                default: {
                    buf.append(format == BuiltInOutputFormat.MYSQL || i > 0 ? "+" : "");
                    buf.append(Quidem.chars('-', widths[i] + 2));
                }
            }
        }
        buf.append(mysql ? "+" : "");
        String hyphens = Quidem.flush(buf);
        switch (format) {
            case MYSQL: {
                headerLines.add(hyphens);
            }
        }
        block30: for (int i3 = 0; i3 < n; ++i3) {
            String label = metaData.getColumnLabel(i3 + 1);
            switch (format) {
                case ORACLE: {
                    buf.append(i3 > 0 ? " " : "");
                    buf.append(i3 < n - 1 ? Quidem.pad(label, widths[i3], false) : label);
                    continue block30;
                }
                case MYSQL: {
                    buf.append(i3 > 0 ? " | " : "| ");
                    buf.append(Quidem.pad(label, widths[i3], false));
                    continue block30;
                }
                default: {
                    buf.append(i3 > 0 ? " | " : " ");
                    buf.append(i3 < n - 1 ? Quidem.pad(label, widths[i3], false) : label);
                }
            }
        }
        buf.append(mysql ? " |" : "");
        headerLines.add(Quidem.flush(buf));
        headerLines.add(hyphens);
        for (String[] row : rows) {
            switch (format) {
                case MYSQL: {
                    int i4;
                    for (i4 = 0; i4 < n; ++i4) {
                        buf.append(i4 > 0 ? " | " : "| ").append(Quidem.pad(row[i4], widths[i4], rights[i4]));
                    }
                    buf.append(" |");
                    break;
                }
                case ORACLE: {
                    String s;
                    int i4;
                    for (i4 = 0; i4 < n; ++i4) {
                        buf.append(i4 > 0 ? " " : "");
                        s = i4 == n - 1 && !rights[i4] ? row[i4] : Quidem.pad(row[i4], widths[i4], rights[i4]);
                        buf.append(s);
                    }
                    while (buf.length() > 0 && buf.substring(buf.length() - 1).equals(" ")) {
                        buf.setLength(buf.length() - 1);
                    }
                    break;
                }
                default: {
                    String s;
                    int i4;
                    for (i4 = 0; i4 < n; ++i4) {
                        buf.append(i4 > 0 ? " | " : " ");
                        s = i4 == n - 1 && !rights[i4] ? row[i4] : Quidem.pad(row[i4], widths[i4], rights[i4]);
                        buf.append(s);
                    }
                    while (buf.length() > 0 && buf.substring(buf.length() - 1).equals(" ")) {
                        buf.setLength(buf.length() - 1);
                    }
                    break block16;
                }
            }
            bodyLines.add(Quidem.flush(buf));
        }
        switch (format) {
            case MYSQL: {
                footerLines.add(hyphens);
            }
            case PSQL: {
                footerLines.add(rows.size() == 1 ? "(1 row)" : "(" + rows.size() + " rows)");
                break;
            }
            case ORACLE: {
                if (rows.size() < 6) break;
                footerLines.add("");
                footerLines.add(rows.size() + " rows selected.");
            }
        }
        footerLines.add("");
    }

    private static String flush(StringBuilder buf) {
        String s = buf.toString();
        buf.setLength(0);
        return s;
    }

    public static class SqlCommand
    extends SimpleCommand {
        public final String sql;
        public final boolean sort;

        protected SqlCommand(List<String> lines, String sql, boolean sort) {
            super(lines);
            this.sql = Objects.requireNonNull(sql);
            this.sort = sort;
        }

        @Override
        public String describe(Command.Context x) {
            return this.commandName() + "[sql: " + this.sql + ", sort:" + this.sort + "]";
        }

        @Override
        public void execute(Command.Context x, boolean execute) throws Exception {
            if (execute) {
                ((ContextImpl)x).setPreviousSqlCommand(this);
            }
            x.echo((List<String>)this.lines);
        }
    }

    public static interface Config {
        public Reader reader();

        public Writer writer();

        public ConnectionFactory connectionFactory();

        public CommandHandler commandHandler();

        public PropertyHandler propertyHandler();

        public Function<String, Object> env();

        public int stackLimit();
    }

    public static class ConfigBuilder {
        private final Reader reader;
        private final Writer writer;
        private final ConnectionFactory connectionFactory;
        private final CommandHandler commandHandler;
        private final PropertyHandler propertyHandler;
        private final Function<String, Object> env;
        private final int stackLimit;

        private ConfigBuilder(Reader reader, Writer writer, ConnectionFactory connectionFactory, CommandHandler commandHandler, PropertyHandler propertyHandler, Function<String, Object> env, int stackLimit) {
            this.reader = Objects.requireNonNull(reader);
            this.writer = Objects.requireNonNull(writer);
            this.connectionFactory = Objects.requireNonNull(connectionFactory);
            this.commandHandler = commandHandler;
            this.propertyHandler = Objects.requireNonNull(propertyHandler);
            this.env = Objects.requireNonNull(env);
            this.stackLimit = stackLimit;
        }

        public Config build() {
            return new Config(){

                @Override
                public Reader reader() {
                    return reader;
                }

                @Override
                public Writer writer() {
                    return writer;
                }

                @Override
                public ConnectionFactory connectionFactory() {
                    return connectionFactory;
                }

                @Override
                public CommandHandler commandHandler() {
                    return commandHandler;
                }

                @Override
                public PropertyHandler propertyHandler() {
                    return propertyHandler;
                }

                @Override
                public Function<String, Object> env() {
                    return env;
                }

                @Override
                public int stackLimit() {
                    return stackLimit;
                }
            };
        }

        public ConfigBuilder withReader(Reader reader) {
            return new ConfigBuilder(reader, this.writer, this.connectionFactory, this.commandHandler, this.propertyHandler, this.env, this.stackLimit);
        }

        public ConfigBuilder withWriter(Writer writer) {
            return new ConfigBuilder(this.reader, writer, this.connectionFactory, this.commandHandler, this.propertyHandler, this.env, this.stackLimit);
        }

        public ConfigBuilder withPropertyHandler(PropertyHandler propertyHandler) {
            return new ConfigBuilder(this.reader, this.writer, this.connectionFactory, this.commandHandler, propertyHandler, this.env, this.stackLimit);
        }

        public ConfigBuilder withEnv(Function<String, Object> env) {
            return new ConfigBuilder(this.reader, this.writer, this.connectionFactory, this.commandHandler, this.propertyHandler, env, this.stackLimit);
        }

        public ConfigBuilder withConnectionFactory(ConnectionFactory connectionFactory) {
            return new ConfigBuilder(this.reader, this.writer, connectionFactory, this.commandHandler, this.propertyHandler, this.env, this.stackLimit);
        }

        public ConfigBuilder withCommandHandler(CommandHandler commandHandler) {
            return new ConfigBuilder(this.reader, this.writer, this.connectionFactory, commandHandler, this.propertyHandler, this.env, this.stackLimit);
        }

        public ConfigBuilder withStackLimit(int stackLimit) {
            return new ConfigBuilder(this.reader, this.writer, this.connectionFactory, this.commandHandler, this.propertyHandler, this.env, stackLimit);
        }
    }

    static enum Property {
        OUTPUTFORMAT,
        OTHER;


        String propertyName() {
            return this.name().toLowerCase();
        }
    }

    private class TopEnv
    implements Function<String, Object> {
        private final Function<String, Object> env;

        TopEnv(Function<String, Object> env) {
            this.env = env;
        }

        @Override
        public Object apply(String s) {
            List list = (List)Quidem.this.map.get(s);
            if (list == null || list.isEmpty()) {
                return this.env.apply(s);
            }
            return list.get(list.size() - 1);
        }
    }

    public static interface ConnectionFactory {
        public @Nullable Connection connect(String var1, boolean var2) throws Exception;

        default public Supplier<Connection> supplier(String name) {
            return () -> {
                try {
                    return this.connect(name, false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
    }

    public static interface PropertyHandler {
        public void onSet(String var1, Object var2);
    }

    private class Parser {
        final List<Command> commands = new ArrayList<Command>();

        private Parser() {
        }

        Command parse() {
            while (true) {
                Command previousCommand;
                Command mergedCommand;
                Command command;
                try {
                    command = this.nextCommand();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while reading next command", e);
                }
                if (command == null) break;
                while (!this.commands.isEmpty() && (mergedCommand = command.merge(previousCommand = this.commands.get(this.commands.size() - 1))) != null) {
                    this.commands.remove(this.commands.size() - 1);
                    command = mergedCommand;
                }
                this.commands.add(command);
            }
            return Quidem.this.of(this.commands);
        }

        private Command nextCommand() throws IOException {
            boolean last;
            Quidem.this.lines.clear();
            ImmutableList content = ImmutableList.of();
            do {
                block26: {
                    String line;
                    if ((line = this.nextLine()) == null) {
                        return null;
                    }
                    if (line.startsWith("#") || line.isEmpty()) {
                        return new CommentCommand(Quidem.this.lines);
                    }
                    if (line.startsWith("!")) {
                        line = line.substring(1);
                        while (line.startsWith(" ")) {
                            line = line.substring(1);
                        }
                        if (line.startsWith("use")) {
                            String[] parts = line.split(" ");
                            return new UseCommand(Quidem.this.lines, parts[1]);
                        }
                        if (line.startsWith("ok")) {
                            return new OkCommand((List<String>)Quidem.this.lines, (ImmutableList<String>)content);
                        }
                        if (line.startsWith("verify")) {
                            return new VerifyCommand(Quidem.this.lines);
                        }
                        if (line.startsWith("update")) {
                            return new UpdateCommand(Quidem.this.lines, (ImmutableList<String>)content);
                        }
                        if (line.startsWith("plan")) {
                            return new ExplainCommand(Quidem.this.lines, (ImmutableList<String>)content);
                        }
                        if (line.startsWith("type")) {
                            return new TypeCommand(Quidem.this.lines, (ImmutableList<String>)content);
                        }
                        if (line.startsWith("error")) {
                            return new ErrorCommand((List<String>)Quidem.this.lines, (ImmutableList<String>)content);
                        }
                        if (line.startsWith("skip")) {
                            return new SkipCommand(Quidem.this.lines);
                        }
                        if (line.startsWith("pop")) {
                            String[] parts = line.split(" ");
                            String propertyName = parts[1];
                            Property property = propertyName.equals("outputformat") ? Property.OUTPUTFORMAT : Property.OTHER;
                            return new PopCommand(Quidem.this.lines, property, propertyName);
                        }
                        if (line.startsWith("set ") || line.startsWith("push ")) {
                            Object value;
                            Property property;
                            String valueString;
                            String[] parts = line.split(" ");
                            String propertyName = parts[1];
                            if (parts[2].startsWith("\"")) {
                                String nextLine;
                                StringBuilder b = new StringBuilder(parts[2]);
                                while ((b.length() < 2 || b.charAt(b.length() - 1) != '\"') && (nextLine = this.nextLine()) != null) {
                                    b.append(nextLine);
                                }
                                valueString = b.toString();
                            } else {
                                valueString = parts[2];
                            }
                            if (propertyName.equals("outputformat")) {
                                property = Property.OUTPUTFORMAT;
                                value = BuiltInOutputFormat.valueOf(parts[2].toUpperCase());
                            } else {
                                property = Property.OTHER;
                                value = valueString.equals("null") ? null : (valueString.equals("true") ? Boolean.TRUE : (valueString.equals("false") ? Boolean.FALSE : (valueString.matches("-?[0-9]+") ? new BigDecimal(valueString) : valueString)));
                            }
                            return line.startsWith("push ") ? new PushCommand(Quidem.this.lines, property, propertyName, value) : new SetCommand(Quidem.this.lines, property, propertyName, value);
                        }
                        if (line.startsWith("show ")) {
                            String[] parts = line.split(" ");
                            String propertyName = parts[1];
                            Property property = propertyName.equals("outputformat") ? Property.OUTPUTFORMAT : Property.OTHER;
                            return new ShowCommand(Quidem.this.lines, property, propertyName);
                        }
                        if (line.matches("if \\([A-Za-z-][A-Za-z_0-9.]*\\) \\{")) {
                            ImmutableList ifLines = ImmutableList.copyOf((Collection)Quidem.this.lines);
                            Quidem.this.lines.clear();
                            Command command = new Parser().parse();
                            String variable = line.substring("if (".length(), line.length() - ") {".length());
                            ImmutableList variables = ImmutableList.copyOf(Quidem.this.stringIterator(new StringTokenizer(variable, ".")));
                            return new IfCommand((List<String>)ifLines, Quidem.this.lines, command, (List<String>)variables);
                        }
                        if (line.equals("}")) {
                            return null;
                        }
                        Command command = Quidem.this.config.commandHandler().parseCommand(Quidem.this.lines, (List<String>)content, line);
                        if (command != null) {
                            return command;
                        }
                        throw new RuntimeException("Unknown command: " + line);
                    }
                    Quidem.this.buf.setLength(0);
                    last = false;
                    do {
                        if (line.endsWith(";")) {
                            last = true;
                            line = line.substring(0, line.length() - 1);
                        }
                        Quidem.this.buf.append(line);
                        if (last) break block26;
                        Quidem.this.buf.append("\n");
                        line = this.nextLine();
                        if (line != null) continue;
                        throw new RuntimeException("end of file reached before end of SQL command");
                    } while (!line.startsWith("!") && !line.startsWith("#"));
                    this.pushLine();
                }
                content = ImmutableList.copyOf((Collection)Quidem.this.lines);
                Quidem.this.lines.clear();
            } while (!last);
            String sql = Quidem.this.buf.toString();
            boolean sort = !Quidem.this.isProbablyDeterministic(sql);
            return new SqlCommand((List<String>)content, sql, sort);
        }

        private void pushLine() {
            if (Quidem.this.pushedLine != null) {
                throw new AssertionError((Object)"cannot push two lines");
            }
            if (Quidem.this.lines.size() == 0) {
                throw new AssertionError((Object)"no line has been read");
            }
            Quidem.this.pushedLine = (String)Quidem.this.lines.get(Quidem.this.lines.size() - 1);
            Quidem.this.lines.remove(Quidem.this.lines.size() - 1);
        }

        private String nextLine() throws IOException {
            String line;
            if (Quidem.this.pushedLine != null) {
                line = Quidem.this.pushedLine;
                Quidem.this.pushedLine = null;
            } else {
                line = Quidem.this.reader.readLine();
                if (line == null) {
                    return null;
                }
            }
            Quidem.this.lines.add(line);
            return line;
        }
    }

    private class ContextImpl
    implements Command.Context {
        private ContextImpl() {
        }

        @Override
        public PrintWriter writer() {
            return Quidem.this.writer;
        }

        @Override
        public Connection connection() {
            return Quidem.this.connection;
        }

        @Override
        public Connection refConnection() {
            return Quidem.this.refConnection;
        }

        @Override
        public Function<String, Object> env() {
            return Quidem.this.env;
        }

        @Override
        public void use(String connectionName) throws Exception {
            Quidem.this.use(connectionName);
        }

        @Override
        public void checkResult(boolean execute, boolean output, Command.ResultChecker checker) throws Exception {
            Quidem.this.checkResult(execute, output, checker, this);
        }

        @Override
        public void update(String sql, boolean execute, boolean output, Command.ResultChecker checker) throws Exception {
            Quidem.this.update(sql, execute, output, checker, this);
        }

        @Override
        public void echo(List<String> lines) {
            Quidem.this.echo(lines);
        }

        @Override
        public void stack(Throwable e, Writer w) {
            int stackLimit = Quidem.this.config.stackLimit();
            if (stackLimit >= 0) {
                w = new LimitWriter(w, stackLimit);
            }
            PrintWriter pw = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
            e.printStackTrace(pw);
            if (stackLimit >= 0) {
                assert (w instanceof LimitWriter);
                ((LimitWriter)w).ellipsis(" (stack truncated)\n");
            }
        }

        @Override
        public SqlCommand previousSqlCommand() {
            if (Quidem.this.previousSqlCommand != null) {
                return Quidem.this.previousSqlCommand;
            }
            throw new AssertionError((Object)"no previous SQL command");
        }

        @Override
        public boolean execute() {
            return Quidem.this.execute;
        }

        private void setPreviousSqlCommand(SqlCommand sqlCommand) {
            Quidem.this.previousSqlCommand = sqlCommand;
        }
    }

    static class CompositeCommand
    extends AbstractCommand {
        private final List<Command> commands;

        CompositeCommand(List<Command> commands) {
            this.commands = commands;
        }

        @Override
        public void execute(Command.Context x, boolean execute) throws Exception {
            for (Command command : this.commands) {
                boolean abort = false;
                Object e = null;
                try {
                    command.execute(x, execute && x.execute());
                }
                catch (RuntimeException e0) {
                    e = e0;
                }
                catch (Exception e0) {
                    e = e0;
                }
                catch (AssertionError e0) {
                    e = e0;
                }
                catch (Throwable e0) {
                    e = e0;
                    abort = true;
                }
                if (e == null) continue;
                command.execute(x, false);
                x.writer().printf("Error while executing command %s%n", command.describe(x));
                x.stack((Throwable)e, x.writer());
                if (!abort) continue;
                throw (Error)e;
            }
        }
    }

    class SkipCommand
    extends SimpleCommand {
        SkipCommand(List<String> lines) {
            super(lines);
        }

        @Override
        public void execute(Command.Context x, boolean execute) throws Exception {
            x.echo((List<String>)this.lines);
            Quidem.this.skip = true;
            Quidem.this.execute = false;
        }
    }

    class IfCommand
    extends AbstractCommand {
        private final List<String> ifLines;
        private final List<String> endLines;
        private final Command command;
        private final List<String> variables;

        IfCommand(List<String> ifLines, List<String> endLines, Command command, List<String> variables) {
            this.variables = ImmutableList.copyOf(variables);
            this.ifLines = ImmutableList.copyOf(ifLines);
            this.endLines = ImmutableList.copyOf(endLines);
            this.command = command;
        }

        @Override
        public void execute(Command.Context x, boolean execute) throws Exception {
            x.echo(this.ifLines);
            boolean oldExecute = Quidem.this.execute;
            boolean newExecute = Quidem.this.skip ? oldExecute : Quidem.this.getBoolean(this.variables);
            this.command.execute(x, newExecute);
            x.echo(this.endLines);
        }
    }

    class CommentCommand
    extends SimpleCommand {
        CommentCommand(List<String> lines) {
            super(lines);
        }

        @Override
        public void execute(Command.Context x, boolean execute) throws Exception {
            x.echo((List<String>)this.lines);
        }
    }

    class ShowCommand
    extends SimpleCommand {
        private final Property property;
        private final String propertyName;

        ShowCommand(List<String> lines, Property property, String propertyName) {
            super(lines);
            this.property = Objects.requireNonNull(property);
            this.propertyName = Objects.requireNonNull(propertyName);
            Preconditions.checkArgument((property == Property.OTHER || propertyName.equals(property.propertyName()) ? 1 : 0) != 0);
        }

        @Override
        public void execute(Command.Context x, boolean execute) throws Exception {
            Object value = Quidem.this.env.apply(this.propertyName);
            Quidem.this.writer.println(this.propertyName + " " + value);
            x.echo((List<String>)this.lines);
        }
    }

    class PopCommand
    extends SimpleCommand {
        private final Property property;
        private final String propertyName;

        PopCommand(List<String> lines, Property property, String propertyName) {
            super(lines);
            this.property = Objects.requireNonNull(property);
            this.propertyName = Objects.requireNonNull(propertyName);
            Preconditions.checkArgument((property == Property.OTHER || propertyName.equals(property.propertyName()) ? 1 : 0) != 0);
        }

        @Override
        public void execute(Command.Context x, boolean execute) throws Exception {
            x.echo((List<String>)this.lines);
            List list = (List)Quidem.this.map.get(this.propertyName);
            if (list == null || list.isEmpty()) {
                Quidem.this.writer.println("Cannot pop " + this.propertyName + ": stack is empty");
            } else {
                list.remove(list.size() - 1);
            }
            Object newValue = Quidem.this.env.apply(this.propertyName);
            Quidem.this.config.propertyHandler().onSet(this.propertyName, newValue);
        }
    }

    class PushCommand
    extends SetCommand {
        PushCommand(List<String> lines, Property property, String propertyName, Object value) {
            super(lines, property, propertyName, value);
        }
    }

    class SetCommand
    extends SimpleCommand {
        private final Property property;
        private final String propertyName;
        private final Object value;

        SetCommand(List<String> lines, Property property, String propertyName, Object value) {
            super(lines);
            this.property = Objects.requireNonNull(property);
            this.propertyName = Objects.requireNonNull(propertyName);
            Preconditions.checkArgument((property == Property.OTHER || propertyName.equals(property.propertyName()) ? 1 : 0) != 0);
            this.value = value;
            Preconditions.checkArgument((value == null || value instanceof Boolean || value instanceof BigDecimal || value instanceof String || value instanceof BuiltInOutputFormat ? 1 : 0) != 0);
        }

        @Override
        public void execute(Command.Context x, boolean execute) throws Exception {
            x.echo((List<String>)this.lines);
            List list = Quidem.this.map.computeIfAbsent(this.propertyName, k -> new ArrayList());
            if (list.isEmpty() || this instanceof PushCommand) {
                list.add(this.value);
            } else {
                list.set(list.size() - 1, this.value);
            }
            Quidem.this.config.propertyHandler().onSet(this.propertyName, this.value);
        }
    }

    static class TypeCommand
    extends SimpleCommand {
        private final ImmutableList<String> content;

        TypeCommand(List<String> lines, ImmutableList<String> content) {
            super(lines);
            this.content = content;
        }

        @Override
        public String describe(Command.Context x) {
            return this.commandName() + "[sql: " + x.previousSqlCommand().sql + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Command.Context x, boolean execute) throws Exception {
            if (execute) {
                SqlCommand sqlCommand = x.previousSqlCommand();
                try (PreparedStatement statement = x.connection().prepareStatement(sqlCommand.sql);){
                    ResultSetMetaData metaData = statement.getMetaData();
                    StringBuilder buf = new StringBuilder();
                    int n = metaData.getColumnCount();
                    for (int i = 1; i <= n; ++i) {
                        int nullable;
                        String label = metaData.getColumnLabel(i);
                        String typeName = metaData.getColumnTypeName(i);
                        buf.append(label).append(' ').append(typeName);
                        int precision = metaData.getPrecision(i);
                        if (precision > 0) {
                            buf.append("(").append(precision);
                            int scale = metaData.getScale(i);
                            if (scale > 0) {
                                buf.append(", ").append(scale);
                            }
                            buf.append(")");
                        }
                        if ((nullable = metaData.isNullable(i)) == 0) {
                            buf.append(" NOT NULL");
                        }
                        buf.append("\n");
                    }
                    x.writer().print(buf);
                    x.writer().flush();
                }
            } else {
                x.echo((List<String>)this.content);
            }
            x.echo((List<String>)this.lines);
        }
    }

    static class ExplainCommand
    extends SimpleCommand {
        private final ImmutableList<String> content;

        ExplainCommand(List<String> lines, ImmutableList<String> content) {
            super(lines);
            this.content = content;
        }

        @Override
        public String describe(Command.Context x) {
            return this.commandName() + " [sql: " + x.previousSqlCommand().sql + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Command.Context x, boolean execute) throws Exception {
            block9: {
                if (execute) {
                    SqlCommand sqlCommand = x.previousSqlCommand();
                    try (Statement statement = x.connection().createStatement();
                         ResultSet resultSet = statement.executeQuery("explain plan for " + sqlCommand.sql);){
                        StringBuilder buf = new StringBuilder();
                        while (resultSet.next()) {
                            String line = resultSet.getString(1);
                            buf.append(line);
                            if (line.endsWith("\n")) continue;
                            buf.append("\n");
                        }
                        if (buf.length() == 0) {
                            throw new AssertionError((Object)"explain returned 0 records");
                        }
                        x.writer().print(buf);
                        x.writer().flush();
                        break block9;
                    }
                }
                x.echo((List<String>)this.content);
            }
            x.echo((List<String>)this.lines);
        }
    }

    static class ErrorCommand
    extends OkCommand {
        ErrorCommand(List<String> lines, ImmutableList<String> output) {
            super(lines, output);
        }

        @Override
        public void checkResultSet(Command.Context x, Throwable resultSetException) {
            if (resultSetException == null) {
                x.writer().println("Expected error, but SQL command did not give one");
                return;
            }
            if (!this.output.isEmpty()) {
                StringWriter sw = new StringWriter();
                x.stack(resultSetException, sw);
                String actual = this.squash(sw.toString());
                String expected = this.squash(this.concat((List<String>)this.output, false));
                if (actual.contains(expected)) {
                    for (String line : this.output) {
                        x.writer().println(line);
                    }
                    return;
                }
            }
            super.checkResultSet(x, resultSetException);
        }

        private String squash(String s) {
            return s.replace("\r\n", "\n").replaceAll("[ \t]+", " ").replaceAll("\n ", "\n").replaceAll("^ ", "").replaceAll(" \n", "\n").replaceAll(" $", "\n");
        }

        private String concat(List<String> lines, boolean trailing) {
            StringBuilder buf = new StringBuilder();
            for (String line : lines) {
                buf.append(line).append("\n");
            }
            if (!trailing && buf.length() > 0) {
                buf.setLength(buf.length() - 1);
            }
            return buf.toString();
        }
    }

    static class UpdateCommand
    extends SimpleCommand
    implements Command.ResultChecker {
        protected final ImmutableList<String> output;

        UpdateCommand(List<String> lines, ImmutableList<String> output) {
            super(lines);
            this.output = output;
        }

        @Override
        public String describe(Command.Context x) {
            return this.commandName() + "[sql: " + x.previousSqlCommand().sql + "]";
        }

        @Override
        public void execute(Command.Context x, boolean execute) throws Exception {
            SqlCommand sqlCommand = x.previousSqlCommand();
            x.update(sqlCommand.sql, execute, true, this);
            x.echo((List<String>)this.lines);
        }

        @Override
        public List<String> getOutput(Command.Context x) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkResultSet(Command.Context x, Throwable resultSetException) {
            if (resultSetException != null) {
                x.stack(resultSetException, x.writer());
            }
        }
    }

    static class VerifyCommand
    extends CheckResultCommand {
        VerifyCommand(List<String> lines) {
            super(lines, false);
        }

        @Override
        public List<String> getOutput(Command.Context x) throws Exception {
            if (x.refConnection() == null) {
                throw new IllegalArgumentException("no reference connection");
            }
            SqlCommand sqlCommand = x.previousSqlCommand();
            Statement statement = x.refConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(sqlCommand.sql);
            try {
                OutputFormat format = (OutputFormat)x.env().apply(Property.OUTPUTFORMAT.propertyName());
                ArrayList<String> headerLines = new ArrayList<String>();
                ArrayList<String> bodyLines = new ArrayList<String>();
                ArrayList<String> footerLines = new ArrayList<String>();
                format.format(resultSet, headerLines, bodyLines, footerLines, sqlCommand.sort);
                return ImmutableList.builder().addAll(headerLines).addAll(bodyLines).addAll(footerLines).build();
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("reference threw", e);
            }
        }
    }

    static class OkCommand
    extends CheckResultCommand {
        protected final ImmutableList<String> output;

        OkCommand(List<String> lines, ImmutableList<String> output) {
            super(lines, true);
            this.output = output;
        }

        @Override
        public List<String> getOutput(Command.Context x) {
            return this.output;
        }

        @Override
        public @Nullable Command merge(Command previousCommand) {
            if (previousCommand instanceof CommentCommand) {
                CommentCommand commentCommand = (CommentCommand)previousCommand;
                if (commentCommand.lines.equals((Object)ImmutableList.of((Object)""))) {
                    return new OkCommand((List<String>)this.lines, (ImmutableList<String>)ImmutableList.builder().addAll((Iterable)commentCommand.lines).addAll(this.output).build());
                }
            }
            return null;
        }
    }

    static abstract class CheckResultCommand
    extends SimpleCommand
    implements Command.ResultChecker {
        protected final boolean output;

        CheckResultCommand(List<String> lines, boolean output) {
            super(lines);
            this.output = output;
        }

        @Override
        public String describe(Command.Context x) {
            return this.commandName() + " [sql: " + x.previousSqlCommand().sql + "]";
        }

        @Override
        public void execute(Command.Context x, boolean execute) throws Exception {
            x.checkResult(execute, this.output, this);
            x.echo((List<String>)this.lines);
        }

        @Override
        public void checkResultSet(Command.Context x, Throwable resultSetException) {
            if (resultSetException != null) {
                x.stack(resultSetException, x.writer());
            }
        }
    }

    static class UseCommand
    extends SimpleCommand {
        private final String name;

        UseCommand(List<String> lines, String name) {
            super(lines);
            this.name = name;
        }

        @Override
        public void execute(Command.Context x, boolean execute) throws Exception {
            x.echo((List<String>)this.lines);
            x.use(this.name);
        }
    }

    static abstract class SimpleCommand
    extends AbstractCommand {
        protected final ImmutableList<String> lines;

        SimpleCommand(List<String> lines) {
            this.lines = ImmutableList.copyOf(lines);
        }
    }
}

