/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest.executors;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.hydromatic.sqllogictest.ISqlTestOperation;
import net.hydromatic.sqllogictest.OptionsParser;
import net.hydromatic.sqllogictest.SltSqlStatement;
import net.hydromatic.sqllogictest.SltTestFile;
import net.hydromatic.sqllogictest.SqlTestQuery;
import net.hydromatic.sqllogictest.SqlTestQueryOutputDescription;
import net.hydromatic.sqllogictest.TestStatistics;
import net.hydromatic.sqllogictest.executors.SqlSltTestExecutor;
import net.hydromatic.sqllogictest.util.Utilities;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class JdbcExecutor
extends SqlSltTestExecutor {
    protected final String username;
    protected final String password;
    public final String dbUrl;
    protected @Nullable Connection connection;

    public JdbcExecutor(OptionsParser.SuppliedOptions options, String dbUrl, String username, String password) {
        super(options);
        this.dbUrl = dbUrl;
        this.username = username;
        this.password = password;
        this.connection = null;
    }

    public Connection getConnection() {
        assert (this.connection != null);
        return this.connection;
    }

    public void statement(SltSqlStatement statement) throws SQLException {
        block12: {
            String stat = statement.statement;
            if (stat.toLowerCase().startsWith("drop view")) {
                if (!stat.toLowerCase().contains("if exists")) {
                    stat = stat.substring(0, 9) + " IF EXISTS " + stat.substring(10);
                }
                if (!stat.toLowerCase().contains("cascade")) {
                    stat = stat + " CASCADE";
                }
            }
            this.options.message(this.statementsExecuted + ": " + stat, 2);
            if (this.buggyOperations.contains(statement.statement) || this.options.doNotExecute) {
                this.options.message("Skipping " + statement.statement, 2);
            }
            try (Statement stmt = this.getConnection().createStatement();){
                stmt.execute(stat);
            }
            catch (SQLException ex) {
                if (!statement.shouldPass) break block12;
                this.options.error(ex);
                throw ex;
            }
        }
        ++this.statementsExecuted;
    }

    boolean query(SqlTestQuery query, TestStatistics statistics) throws SQLException, NoSuchAlgorithmException {
        if (this.buggyOperations.contains(query.getQuery()) || this.options.doNotExecute) {
            statistics.incIgnored();
            this.options.message("Skipping " + query.getQuery(), 2);
            return false;
        }
        try (Statement stmt = this.getConnection().createStatement();){
            boolean bl;
            block13: {
                ResultSet resultSet = stmt.executeQuery(query.getQuery());
                try {
                    boolean result = this.validate(query, resultSet, query.outputDescription, statistics);
                    this.options.message(statistics.totalTests() + ": " + query.getQuery(), 2);
                    bl = result;
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
    }

    Row getValue(ResultSet rs, String columnTypes) throws SQLException {
        Row row = new Row();
        block7: for (int i = 1; i <= columnTypes.length(); ++i) {
            char c = columnTypes.charAt(i - 1);
            switch (c) {
                case 'R': {
                    double d = rs.getDouble(i);
                    if (rs.wasNull()) {
                        row.add("NULL");
                        continue block7;
                    }
                    row.add(String.format("%.3f", d));
                    continue block7;
                }
                case 'I': {
                    try {
                        long integer = rs.getLong(i);
                        if (rs.wasNull()) {
                            row.add("NULL");
                            continue block7;
                        }
                        row.add(String.format("%d", integer));
                    }
                    catch (NumberFormatException | SQLDataException ignore) {
                        row.add("0");
                    }
                    continue block7;
                }
                case 'T': {
                    String s = rs.getString(i);
                    if (s == null) {
                        row.add("NULL");
                        continue block7;
                    }
                    StringBuilder result = new StringBuilder();
                    for (int j = 0; j < s.length(); ++j) {
                        char sc = s.charAt(j);
                        if (sc < ' ' || sc > '~') {
                            sc = '@';
                        }
                        result.append(sc);
                    }
                    row.add(result.toString());
                    continue block7;
                }
                default: {
                    throw new RuntimeException("Unexpected column type " + c);
                }
            }
        }
        return row;
    }

    public boolean validate(SqlTestQuery query, ResultSet rs, SqlTestQueryOutputDescription description, TestStatistics statistics) throws SQLException, NoSuchAlgorithmException {
        String q;
        String r;
        assert (description.columnTypes != null);
        Rows rows = new Rows();
        while (rs.next()) {
            Row row = this.getValue(rs, description.columnTypes);
            rows.add(row);
        }
        if (description.getValueCount() != rows.size() * description.columnTypes.length()) {
            return statistics.addFailure(new TestStatistics.FailedTestDescription(query, "Expected " + description.getValueCount() + " rows, got " + rows.size() * description.columnTypes.length(), "", null));
        }
        rows.sort(description.getOrder());
        if (description.getQueryResults() != null && !(r = rows.toString()).equals(q = String.join((CharSequence)System.lineSeparator(), description.getQueryResults()))) {
            return statistics.addFailure(new TestStatistics.FailedTestDescription(query, "Output differs from expected value", "computed" + System.lineSeparator() + r + System.lineSeparator() + "Expected:" + System.lineSeparator() + q + System.lineSeparator(), null));
        }
        if (description.hash != null) {
            MessageDigest md = MessageDigest.getInstance("MD5");
            String repr = rows + System.lineSeparator();
            md.update(repr.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            String hash = Utilities.toHex(digest);
            if (!description.hash.equals(hash)) {
                return statistics.addFailure(new TestStatistics.FailedTestDescription(query, "Hash of data does not match expected value", "expected:" + description.hash + " computed: " + hash + System.lineSeparator(), null));
            }
        }
        statistics.incPassed();
        return false;
    }

    List<String> getTableList() throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        DatabaseMetaData md = this.getConnection().getMetaData();
        ResultSet rs = md.getTables(null, null, "%", new String[]{"TABLE"});
        while (rs.next()) {
            String tableName = rs.getString(3);
            result.add(tableName);
        }
        rs.close();
        return result;
    }

    List<String> getViewList() throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        DatabaseMetaData md = this.getConnection().getMetaData();
        ResultSet rs = md.getTables(null, null, "%", new String[]{"VIEW"});
        while (rs.next()) {
            String tableName = rs.getString(3);
            result.add(tableName);
        }
        rs.close();
        return result;
    }

    public void dropAllTables() throws SQLException {
        List<String> tables = this.getTableList();
        for (String tableName : tables) {
            String del = "DROP TABLE " + tableName + " CASCADE";
            this.options.message(del, 2);
            Statement drop = this.getConnection().createStatement();
            try {
                drop.execute(del);
            }
            finally {
                if (drop == null) continue;
                drop.close();
            }
        }
    }

    public void dropAllViews() throws SQLException {
        List<String> tables = this.getViewList();
        for (String tableName : tables) {
            String del = "DROP VIEW IF EXISTS " + tableName + " CASCADE";
            this.options.message(del, 2);
            Statement drop = this.getConnection().createStatement();
            try {
                drop.execute(del);
            }
            finally {
                if (drop == null) continue;
                drop.close();
            }
        }
    }

    public void establishConnection() throws SQLException {
        this.connection = DriverManager.getConnection(this.dbUrl, this.username, this.password);
        assert (this.connection != null);
    }

    public void closeConnection() throws SQLException {
        this.getConnection().close();
    }

    @Override
    public TestStatistics execute(SltTestFile file, OptionsParser.SuppliedOptions options) throws SQLException {
        this.startTest();
        this.establishConnection();
        this.dropAllTables();
        TestStatistics result = new TestStatistics(options.stopAtFirstError, options.verbosity);
        result.incFiles();
        for (ISqlTestOperation operation : file.fileContents) {
            boolean stop;
            SltSqlStatement stat = operation.as(SltSqlStatement.class);
            if (stat != null) {
                try {
                    this.statement(stat);
                    if (stat.shouldPass) continue;
                    options.err.println("Statement should have failed: " + operation);
                    continue;
                }
                catch (SQLException ex) {
                    if (!stat.shouldPass) continue;
                    options.err.println("Error '" + ex.getMessage() + "' in SQL statement " + operation);
                    result.incFilesNotParsed();
                    return result;
                }
            }
            SqlTestQuery query = operation.to(options.err, SqlTestQuery.class);
            try {
                stop = this.query(query, result);
            }
            catch (Throwable ex) {
                options.message("Exception during query: " + ex.getMessage(), 1);
                stop = result.addFailure(new TestStatistics.FailedTestDescription(query, null, "", ex));
            }
            if (!stop) continue;
            break;
        }
        this.dropAllViews();
        this.dropAllTables();
        this.closeConnection();
        options.message(this.elapsedTime(file.getTestCount()), 1);
        return result;
    }

    static class RowComparator
    implements Comparator<Row> {
        RowComparator() {
        }

        @Override
        public int compare(Row o1, Row o2) {
            if (o1.values.size() != o2.values.size()) {
                throw new RuntimeException("Comparing rows of different lengths");
            }
            for (int i = 0; i < o1.values.size(); ++i) {
                int r = o1.values.get(i).compareTo(o2.values.get(i));
                if (r == 0) continue;
                return r;
            }
            return 0;
        }
    }

    static class Rows {
        List<Row> allRows = new ArrayList<Row>();

        Rows() {
        }

        void add(Row row) {
            this.allRows.add(row);
        }

        public String toString() {
            return String.join((CharSequence)System.lineSeparator(), Utilities.map(this.allRows, Row::toString));
        }

        public int size() {
            return this.allRows.size();
        }

        public void sort(SqlTestQueryOutputDescription.SortOrder order) {
            switch (order) {
                case NONE: {
                    break;
                }
                case ROW: {
                    this.allRows.sort(new RowComparator());
                    break;
                }
                case VALUE: {
                    this.allRows = Utilities.flatMap(this.allRows, r -> Utilities.map(r.values, r0 -> {
                        Row res = new Row();
                        res.add((String)r0);
                        return res;
                    }));
                    this.allRows.sort(new RowComparator());
                }
            }
        }
    }

    static class Row {
        public final List<String> values = new ArrayList<String>();

        Row() {
        }

        void add(String v) {
            this.values.add(v);
        }

        public String toString() {
            return String.join((CharSequence)System.lineSeparator(), this.values);
        }
    }
}

