/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest.executors;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;
import net.hydromatic.sqllogictest.util.ICastable;

public class SqlTestExecutor
implements ICastable {
    static final DecimalFormat DF = new DecimalFormat("#,###");
    protected final Set<String> buggyOperations = new HashSet<String>();
    private static long startTime = -1L;
    private static int totalTests = 0;
    private long lastTestStartTime;
    protected long statementsExecuted = 0L;

    protected SqlTestExecutor() {
    }

    static long seconds(long end, long start) {
        return (end - start) / 1000000000L;
    }

    public void avoid(Set<String> statementsToSkip) {
        this.buggyOperations.addAll(statementsToSkip);
    }

    protected String elapsedTime(int tests) {
        long end = System.nanoTime();
        return DF.format(tests) + " tests took " + DF.format(SqlTestExecutor.seconds(end, this.lastTestStartTime)) + "s, " + DF.format(totalTests += tests) + " took " + DF.format(SqlTestExecutor.seconds(end, startTime)) + "s";
    }

    protected void startTest() {
        this.lastTestStartTime = System.nanoTime();
        if (startTime == -1L) {
            startTime = this.lastTestStartTime;
        }
    }
}

