/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.android.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import net.i2p.android.lib.helper.R;
import net.i2p.android.router.service.IRouterState;
import net.i2p.android.router.service.State;

public class I2PAndroidHelper {
    public static final String URI_I2P_ANDROID = "net.i2p.android";
    public static final String URI_I2P_ANDROID_DONATE = "net.i2p.android.donate";
    public static final String URI_I2P_ANDROID_LEGACY = "net.i2p.android.router";
    public static final String URI_I2P_ANDROID_DEBUG = "net.i2p.android.debug";
    public static final int REQUEST_START_I2P = 9857;
    private static final String ROUTER_SERVICE_CLASS = "net.i2p.android.router.service.RouterService";
    private static final String LOG_TAG = "I2PHelperLib";
    private final Context mContext;
    private final boolean mUseDebug;
    private boolean mTriedBindState;
    private IRouterState mStateService;
    private Callback mCallback;
    private final ServiceConnection mStateConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            I2PAndroidHelper.this.mStateService = IRouterState.Stub.asInterface(service);
            Log.i((String)I2PAndroidHelper.LOG_TAG, (String)"Bound to I2P Android");
            if (I2PAndroidHelper.this.mCallback != null) {
                I2PAndroidHelper.this.mCallback.onI2PAndroidBound();
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            Log.w((String)I2PAndroidHelper.LOG_TAG, (String)"I2P Android disconnected unexpectedly");
            I2PAndroidHelper.this.mStateService = null;
        }
    };

    public I2PAndroidHelper(Context context) {
        this.mContext = context;
        this.mUseDebug = false;
    }

    public I2PAndroidHelper(Context context, boolean useDebug) {
        this.mContext = context;
        this.mUseDebug = useDebug;
    }

    public void bind(Callback callback) {
        this.mCallback = callback;
        this.bind();
    }

    public void bind() {
        Log.i((String)LOG_TAG, (String)"Binding to I2P Android");
        Intent i2pIntent = this.getI2PAndroidIntent();
        if (i2pIntent != null) {
            Log.i((String)LOG_TAG, (String)i2pIntent.toString());
            try {
                this.mTriedBindState = this.mContext.bindService(i2pIntent, this.mStateConnection, 1);
                if (!this.mTriedBindState) {
                    Log.w((String)LOG_TAG, (String)"Could not bind: bindService failed");
                }
            }
            catch (SecurityException e) {
                this.mStateService = null;
                this.mTriedBindState = false;
                Log.w((String)LOG_TAG, (String)"Could not bind: I2P Android version is too old");
            }
        } else {
            Log.w((String)LOG_TAG, (String)"Could not bind: I2P Android not installed");
        }
    }

    public boolean bind(ServiceConnection serviceConnection, int flags) {
        Log.i((String)LOG_TAG, (String)"Binding to I2P Android with provided ServiceConnection");
        Intent i2pIntent = this.getI2PAndroidIntent();
        if (i2pIntent != null) {
            Log.i((String)LOG_TAG, (String)i2pIntent.toString());
            try {
                boolean rv = this.mContext.bindService(i2pIntent, serviceConnection, flags);
                if (!rv) {
                    Log.w((String)LOG_TAG, (String)"Could not bind: bindService failed");
                }
                return rv;
            }
            catch (SecurityException e) {
                Log.w((String)LOG_TAG, (String)"Could not bind: I2P Android version is too old");
                return false;
            }
        }
        Log.w((String)LOG_TAG, (String)"Could not bind: I2P Android not installed");
        return false;
    }

    private Intent getI2PAndroidIntent() {
        Intent intent = new Intent("net.i2p.android.router.service.IRouterState");
        if (this.isAppInstalled(URI_I2P_ANDROID)) {
            intent.setClassName(URI_I2P_ANDROID, ROUTER_SERVICE_CLASS);
        } else if (this.isAppInstalled(URI_I2P_ANDROID_DONATE)) {
            intent.setClassName(URI_I2P_ANDROID_DONATE, ROUTER_SERVICE_CLASS);
        } else if (this.isAppInstalled(URI_I2P_ANDROID_LEGACY)) {
            intent.setClassName(URI_I2P_ANDROID_LEGACY, ROUTER_SERVICE_CLASS);
        } else {
            intent = null;
        }
        if (this.mUseDebug && this.isAppInstalled(URI_I2P_ANDROID_DEBUG)) {
            Log.w((String)LOG_TAG, (String)"Using debug build of I2P Android");
            intent.setClassName(URI_I2P_ANDROID_DEBUG, ROUTER_SERVICE_CLASS);
        }
        return intent;
    }

    public void unbind() {
        if (this.mTriedBindState) {
            this.mContext.unbindService(this.mStateConnection);
        }
        this.mTriedBindState = false;
        this.mCallback = null;
    }

    public boolean isI2PAndroidInstalled() {
        return this.mUseDebug && this.isAppInstalled(URI_I2P_ANDROID_DEBUG) || this.isAppInstalled(URI_I2P_ANDROID) || this.isAppInstalled(URI_I2P_ANDROID_DONATE) || this.isAppInstalled(URI_I2P_ANDROID_LEGACY);
    }

    private boolean isAppInstalled(String uri) {
        boolean installed;
        PackageManager pm = this.mContext.getPackageManager();
        try {
            pm.getPackageInfo(uri, 1);
            installed = true;
        }
        catch (PackageManager.NameNotFoundException e) {
            installed = false;
        }
        return installed;
    }

    public void promptToInstall(final Activity activity) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setTitle(R.string.install_i2p_android).setMessage(R.string.you_must_have_i2p_android).setPositiveButton(R.string.yes, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                String uriMarket = activity.getString(R.string.market_i2p_android);
                Uri uri = Uri.parse((String)uriMarket);
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                activity.startActivity(intent);
            }
        }).setNegativeButton(R.string.no, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        builder.show();
    }

    public boolean isI2PAndroidRunning() {
        if (this.mStateService == null) {
            return false;
        }
        try {
            return this.mStateService.isStarted();
        }
        catch (RemoteException e) {
            Log.w((String)LOG_TAG, (String)"Failed to communicate with I2P Android", (Throwable)e);
            return false;
        }
    }

    public void requestI2PAndroidStart(final Activity activity) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setTitle(R.string.start_i2p_android).setMessage(R.string.would_you_like_to_start_i2p_android).setPositiveButton(R.string.yes, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent i = new Intent("net.i2p.android.router.START_I2P");
                activity.startActivityForResult(i, 9857);
            }
        }).setNegativeButton(R.string.no, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        builder.show();
    }

    public boolean areTunnelsActive() {
        if (this.mStateService == null) {
            return false;
        }
        try {
            return this.mStateService.getState() == State.ACTIVE;
        }
        catch (RemoteException e) {
            Log.w((String)LOG_TAG, (String)"Failed to communicate with I2P Android", (Throwable)e);
            return false;
        }
    }

    public static interface Callback {
        public void onI2PAndroidBound();
    }
}

