/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.IncomingConnectionFilter;
import net.i2p.crypto.SigType;
import net.i2p.util.ByteArrayStream;
import net.i2p.util.Log;

public class I2PSocketManagerFactory {
    @Deprecated
    public static final String PROP_MANAGER = "i2p.streaming.manager";
    public static final String DEFAULT_MANAGER = "net.i2p.client.streaming.impl.I2PSocketManagerFull";

    public static I2PSocketManager createManager() {
        return I2PSocketManagerFactory.createManager(I2PSocketManagerFactory.getHost(), I2PSocketManagerFactory.getPort(), (Properties)System.getProperties().clone(), IncomingConnectionFilter.ALLOW);
    }

    public static I2PSocketManager createManager(IncomingConnectionFilter filter) {
        return I2PSocketManagerFactory.createManager(I2PSocketManagerFactory.getHost(), I2PSocketManagerFactory.getPort(), (Properties)System.getProperties().clone(), filter);
    }

    public static I2PSocketManager createManager(Properties opts) {
        return I2PSocketManagerFactory.createManager(I2PSocketManagerFactory.getHost(), I2PSocketManagerFactory.getPort(), opts, IncomingConnectionFilter.ALLOW);
    }

    public static I2PSocketManager createManager(Properties opts, IncomingConnectionFilter filter) {
        return I2PSocketManagerFactory.createManager(I2PSocketManagerFactory.getHost(), I2PSocketManagerFactory.getPort(), opts, filter);
    }

    public static I2PSocketManager createManager(String host, int port) {
        return I2PSocketManagerFactory.createManager(host, port, (Properties)System.getProperties().clone(), IncomingConnectionFilter.ALLOW);
    }

    public static I2PSocketManager createManager(String host, int port, IncomingConnectionFilter filter) {
        return I2PSocketManagerFactory.createManager(host, port, (Properties)System.getProperties().clone(), filter);
    }

    public static I2PSocketManager createManager(String i2cpHost, int i2cpPort, Properties opts) {
        return I2PSocketManagerFactory.createManager(i2cpHost, i2cpPort, opts, IncomingConnectionFilter.ALLOW);
    }

    public static I2PSocketManager createManager(String i2cpHost, int i2cpPort, Properties opts, IncomingConnectionFilter filter) {
        I2PClient client = I2PClientFactory.createClient();
        ByteArrayStream keyStream = new ByteArrayStream(1024);
        try {
            client.createDestination((OutputStream)keyStream, I2PSocketManagerFactory.getSigType(opts));
            ByteArrayInputStream in = keyStream.asInputStream();
            return I2PSocketManagerFactory.createManager(in, i2cpHost, i2cpPort, opts, filter);
        }
        catch (IOException ioe) {
            I2PSocketManagerFactory.getLog().error("Error creating the destination for socket manager", (Throwable)ioe);
            return null;
        }
        catch (I2PException ie) {
            I2PSocketManagerFactory.getLog().error("Error creating the destination for socket manager", (Throwable)ie);
            return null;
        }
    }

    public static I2PSocketManager createManager(InputStream myPrivateKeyStream) {
        return I2PSocketManagerFactory.createManager(myPrivateKeyStream, IncomingConnectionFilter.ALLOW);
    }

    public static I2PSocketManager createManager(InputStream myPrivateKeyStream, IncomingConnectionFilter filter) {
        return I2PSocketManagerFactory.createManager(myPrivateKeyStream, I2PSocketManagerFactory.getHost(), I2PSocketManagerFactory.getPort(), (Properties)System.getProperties().clone(), filter);
    }

    public static I2PSocketManager createManager(InputStream myPrivateKeyStream, Properties opts) {
        return I2PSocketManagerFactory.createManager(myPrivateKeyStream, opts, IncomingConnectionFilter.ALLOW);
    }

    public static I2PSocketManager createManager(InputStream myPrivateKeyStream, Properties opts, IncomingConnectionFilter filter) {
        return I2PSocketManagerFactory.createManager(myPrivateKeyStream, I2PSocketManagerFactory.getHost(), I2PSocketManagerFactory.getPort(), opts, filter);
    }

    public static I2PSocketManager createManager(InputStream myPrivateKeyStream, String i2cpHost, int i2cpPort, Properties opts) {
        return I2PSocketManagerFactory.createManager(myPrivateKeyStream, i2cpHost, i2cpPort, opts, IncomingConnectionFilter.ALLOW);
    }

    public static I2PSocketManager createManager(InputStream myPrivateKeyStream, String i2cpHost, int i2cpPort, Properties opts, IncomingConnectionFilter filter) {
        try {
            return I2PSocketManagerFactory.createManager(myPrivateKeyStream, i2cpHost, i2cpPort, opts, true, filter);
        }
        catch (I2PSessionException ise) {
            I2PSocketManagerFactory.getLog().error("Error creating session for socket manager", (Throwable)ise);
            return null;
        }
    }

    public static I2PSocketManager createDisconnectedManager(InputStream myPrivateKeyStream, String i2cpHost, int i2cpPort, Properties opts) throws I2PSessionException {
        return I2PSocketManagerFactory.createDisconnectedManager(myPrivateKeyStream, i2cpHost, i2cpPort, opts, IncomingConnectionFilter.ALLOW);
    }

    public static I2PSocketManager createDisconnectedManager(InputStream myPrivateKeyStream, String i2cpHost, int i2cpPort, Properties opts, IncomingConnectionFilter filter) throws I2PSessionException {
        if (myPrivateKeyStream == null) {
            I2PClient client = I2PClientFactory.createClient();
            ByteArrayStream keyStream = new ByteArrayStream(1024);
            try {
                client.createDestination((OutputStream)keyStream, I2PSocketManagerFactory.getSigType(opts));
            }
            catch (I2PException e) {
                throw new I2PSessionException("Error creating keys", (Throwable)e);
            }
            catch (IOException e) {
                throw new I2PSessionException("Error creating keys", (Throwable)e);
            }
            myPrivateKeyStream = keyStream.asInputStream();
        }
        return I2PSocketManagerFactory.createManager(myPrivateKeyStream, i2cpHost, i2cpPort, opts, false, filter);
    }

    private static I2PSocketManager createManager(InputStream myPrivateKeyStream, String i2cpHost, int i2cpPort, Properties opts, boolean connect, IncomingConnectionFilter filter) throws I2PSessionException {
        I2PClient client = I2PClientFactory.createClient();
        if (opts == null) {
            opts = new Properties();
        }
        Properties syscopy = (Properties)System.getProperties().clone();
        for (Map.Entry<Object, Object> e : syscopy.entrySet()) {
            String name = (String)e.getKey();
            if (opts.getProperty(name) != null) continue;
            opts.setProperty(name, (String)e.getValue());
        }
        if (opts.getProperty("i2cp.messageReliability") == null) {
            opts.setProperty("i2cp.messageReliability", "none");
        }
        if (i2cpHost != null) {
            opts.setProperty("i2cp.tcp.host", i2cpHost);
        }
        if (i2cpPort > 0) {
            opts.setProperty("i2cp.tcp.port", Integer.toString(i2cpPort));
        }
        I2PSession session = client.createSession(myPrivateKeyStream, opts);
        if (connect) {
            session.connect();
        }
        I2PSocketManager sockMgr = I2PSocketManagerFactory.createManager(session, opts, "manager", filter);
        return sockMgr;
    }

    private static I2PSocketManager createManager(I2PSession session, Properties opts, String name, IncomingConnectionFilter filter) {
        I2PAppContext context = I2PAppContext.getGlobalContext();
        String classname = DEFAULT_MANAGER;
        try {
            Class<?> cls = Class.forName(classname);
            if (!I2PSocketManager.class.isAssignableFrom(cls)) {
                throw new IllegalArgumentException(classname + " is not an I2PSocketManager");
            }
            Constructor<?> con = cls.getConstructor(I2PAppContext.class, I2PSession.class, Properties.class, String.class, IncomingConnectionFilter.class);
            I2PSocketManager mgr = (I2PSocketManager)con.newInstance(context, session, opts, name, filter);
            return mgr;
        }
        catch (Throwable t) {
            I2PSocketManagerFactory.getLog().log(50, "Error loading " + classname, t);
            throw new IllegalStateException(t);
        }
    }

    private static String getHost() {
        return System.getProperty("i2cp.tcp.host", "127.0.0.1");
    }

    private static int getPort() {
        int i2cpPort = 7654;
        String i2cpPortStr = System.getProperty("i2cp.tcp.port");
        if (i2cpPortStr != null) {
            try {
                i2cpPort = Integer.parseInt(i2cpPortStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return i2cpPort;
    }

    private static SigType getSigType(Properties opts) {
        String st;
        if (opts != null && (st = opts.getProperty("i2cp.destination.sigType")) != null) {
            SigType rv = SigType.parseSigType((String)st);
            if (rv != null && rv.isAvailable()) {
                return rv;
            }
            if (rv != null) {
                st = rv.toString();
            }
            I2PSocketManagerFactory.getLog().logAlways(30, "Tunnel configuration error: Unsupported sig type " + st + ", reverting to EdDSA_SHA512_Ed25519");
        }
        return SigType.EdDSA_SHA512_Ed25519;
    }

    private static Log getLog() {
        return I2PAppContext.getGlobalContext().logManager().getLog(I2PSocketManagerFactory.class);
    }
}

