/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import com.southernstorm.noise.protocol.ChaChaPolyCipherState;
import java.security.GeneralSecurityException;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.EncryptedBuildRecord;
import net.i2p.data.i2np.ShortEncryptedBuildRecord;

public class BuildResponseRecord {
    public static EncryptedBuildRecord create(I2PAppContext ctx, int status, SessionKey replyKey, byte[] replyIV, long responseMessageId) {
        byte[] rv = new byte[528];
        ctx.random().nextBytes(rv, 32, 495);
        rv[527] = (byte)status;
        ctx.sha().calculateHash(rv, 32, rv.length - 32, rv, 0);
        ctx.aes().encrypt(rv, 0, rv, 0, replyKey, replyIV, rv.length);
        return new EncryptedBuildRecord(rv);
    }

    public static EncryptedBuildRecord create(I2PAppContext ctx, int status, SessionKey replyKey, byte[] replyAD, Properties options) {
        int off;
        byte[] rv = new byte[528];
        try {
            off = DataHelper.toProperties((byte[])rv, (int)0, (Properties)options);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("options", e);
        }
        int sz = 528 - off - 1;
        if (sz > 0) {
            ctx.random().nextBytes(rv, off, sz);
        } else if (sz < 0) {
            throw new IllegalArgumentException("options");
        }
        rv[511] = (byte)status;
        boolean ok = BuildResponseRecord.encryptAEADBlock(replyAD, rv, replyKey);
        if (!ok) {
            throw new IllegalArgumentException("encrypt fail");
        }
        return new EncryptedBuildRecord(rv);
    }

    public static ShortEncryptedBuildRecord createShort(I2PAppContext ctx, int status, SessionKey replyKey, byte[] replyAD, Properties options, int slot) {
        int off;
        byte[] rv = new byte[218];
        try {
            off = DataHelper.toProperties((byte[])rv, (int)0, (Properties)options);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("options", e);
        }
        int sz = 218 - off - 1;
        if (sz > 0) {
            ctx.random().nextBytes(rv, off, sz);
        } else if (sz < 0) {
            throw new IllegalArgumentException("options");
        }
        rv[201] = (byte)status;
        boolean ok = BuildResponseRecord.encryptAEADBlock(replyAD, rv, replyKey, slot);
        if (!ok) {
            throw new IllegalArgumentException("encrypt fail");
        }
        return new ShortEncryptedBuildRecord(rv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean encryptAEADBlock(byte[] ad, byte[] data, SessionKey key) {
        if (data.length != 528) {
            throw new IllegalArgumentException();
        }
        ChaChaPolyCipherState chacha = new ChaChaPolyCipherState();
        chacha.initializeKey(key.getData(), 0);
        try {
            chacha.encryptWithAd(ad, data, 0, data, 0, data.length - 16);
        }
        catch (GeneralSecurityException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            chacha.destroy();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decrypt(EncryptedBuildRecord rec, SessionKey key, byte[] ad) {
        if (rec.length() != 528) {
            throw new IllegalArgumentException();
        }
        ChaChaPolyCipherState chacha = new ChaChaPolyCipherState();
        chacha.initializeKey(key.getData(), 0);
        try {
            byte[] data = rec.getData();
            chacha.decryptWithAd(ad, data, 0, data, 0, rec.length());
        }
        catch (GeneralSecurityException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            chacha.destroy();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean encryptAEADBlock(byte[] ad, byte[] data, SessionKey key, int nonce) {
        if (data.length != 218 || nonce < 0 || nonce > 7) {
            throw new IllegalArgumentException();
        }
        ChaChaPolyCipherState chacha = new ChaChaPolyCipherState();
        chacha.initializeKey(key.getData(), 0);
        chacha.setNonce(nonce);
        try {
            chacha.encryptWithAd(ad, data, 0, data, 0, data.length - 16);
        }
        catch (GeneralSecurityException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            chacha.destroy();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decrypt(EncryptedBuildRecord rec, SessionKey key, byte[] ad, int nonce) {
        if (rec.length() != 218 || nonce < 0 || nonce > 7) {
            throw new IllegalArgumentException();
        }
        ChaChaPolyCipherState chacha = new ChaChaPolyCipherState();
        chacha.initializeKey(key.getData(), 0);
        chacha.setNonce(nonce);
        try {
            byte[] data = rec.getData();
            chacha.decryptWithAd(ad, data, 0, data, 0, rec.length());
        }
        catch (GeneralSecurityException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            chacha.destroy();
        }
        return true;
    }
}

