/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import net.i2p.data.Destination;
import net.i2p.data.i2cp.AbuseReason;
import net.i2p.data.i2cp.AbuseSeverity;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.ReportAbuseMessage;
import net.i2p.data.i2cp.SessionId;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.util.Log;

class ReportAbuseJob
extends JobImpl {
    private final Log _log;
    private final ClientConnectionRunner _runner;
    private final Destination _dest;
    private final String _reason;
    private final int _severity;

    public ReportAbuseJob(RouterContext context, ClientConnectionRunner runner, Destination dest, String reason, int severity) {
        super(context);
        this._log = context.logManager().getLog(ReportAbuseJob.class);
        this._runner = runner;
        this._dest = dest;
        this._reason = reason;
        this._severity = severity;
    }

    @Override
    public String getName() {
        return "Report Abuse";
    }

    @Override
    public void runJob() {
        if (this._runner.isDead()) {
            return;
        }
        AbuseReason res = new AbuseReason();
        res.setReason(this._reason);
        AbuseSeverity sev = new AbuseSeverity();
        sev.setSeverity(this._severity);
        ReportAbuseMessage msg = new ReportAbuseMessage();
        msg.setReason(res);
        SessionId id = this._runner.getSessionId(this._dest.calculateHash());
        if (id == null) {
            return;
        }
        msg.setSessionId(id);
        msg.setSeverity(sev);
        try {
            this._runner.doSend((I2CPMessage)msg);
        }
        catch (I2CPMessageException ime) {
            this._log.error("Error reporting abuse", (Throwable)ime);
        }
    }
}

