/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.crypto.TagSetHandle;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.router.crypto.TransientSessionKeyManager;
import net.i2p.router.crypto.ratchet.RatchetEntry;
import net.i2p.router.crypto.ratchet.RatchetSKM;
import net.i2p.router.crypto.ratchet.RatchetSessionTag;

public class MuxedSKM
extends SessionKeyManager {
    private final TransientSessionKeyManager _elg;
    private final RatchetSKM _ec;
    private final AtomicInteger _elgCounter = new AtomicInteger();
    private final AtomicInteger _ecCounter = new AtomicInteger();
    private static final int ELG_SLOW_FACTOR = 5;
    private static final int RESTART_COUNTERS = 500;

    public MuxedSKM(TransientSessionKeyManager elg, RatchetSKM ec) {
        this._elg = elg;
        this._ec = ec;
    }

    public TransientSessionKeyManager getElgSKM() {
        return this._elg;
    }

    public RatchetSKM getECSKM() {
        return this._ec;
    }

    boolean preferRatchet() {
        int ec = this._ecCounter.get();
        int elg = this._elgCounter.get();
        if (ec > 50 && elg > 50 && ec + elg > 500) {
            this._ecCounter.set(0);
            this._elgCounter.set(0);
            return true;
        }
        return ec >= elg / 5;
    }

    void reportDecryptResult(boolean isRatchet, boolean success) {
        if (success) {
            if (isRatchet) {
                this._ecCounter.incrementAndGet();
            } else {
                this._elgCounter.incrementAndGet();
            }
        }
    }

    public SessionKey getCurrentKey(PublicKey target) {
        EncType type = target.getType();
        if (type == EncType.ELGAMAL_2048) {
            return this._elg.getCurrentKey(target);
        }
        return null;
    }

    public SessionKey getCurrentOrNewKey(PublicKey target) {
        EncType type = target.getType();
        if (type == EncType.ELGAMAL_2048) {
            return this._elg.getCurrentOrNewKey(target);
        }
        return null;
    }

    public void createSession(PublicKey target, SessionKey key) {
        EncType type = target.getType();
        if (type != EncType.ELGAMAL_2048) {
            throw new IllegalArgumentException();
        }
        this._elg.createSession(target, key);
    }

    public SessionKey createSession(PublicKey target) {
        EncType type = target.getType();
        if (type == EncType.ELGAMAL_2048) {
            return this._elg.createSession(target);
        }
        return null;
    }

    public SessionTag consumeNextAvailableTag(PublicKey target, SessionKey key) {
        EncType type = target.getType();
        if (type == EncType.ELGAMAL_2048) {
            return this._elg.consumeNextAvailableTag(target, key);
        }
        return null;
    }

    public RatchetEntry consumeNextAvailableTag(PublicKey target) {
        EncType type = target.getType();
        if (type == EncType.ECIES_X25519) {
            return this._ec.consumeNextAvailableTag(target);
        }
        return null;
    }

    public int getTagsToSend() {
        return 0;
    }

    public int getLowThreshold() {
        return 0;
    }

    public boolean shouldSendTags(PublicKey target, SessionKey key) {
        EncType type = target.getType();
        if (type == EncType.ELGAMAL_2048) {
            return this._elg.shouldSendTags(target, key);
        }
        return false;
    }

    public boolean shouldSendTags(PublicKey target, SessionKey key, int lowThreshold) {
        EncType type = target.getType();
        if (type == EncType.ELGAMAL_2048) {
            return this._elg.shouldSendTags(target, key, lowThreshold);
        }
        return false;
    }

    public int getAvailableTags(PublicKey target, SessionKey key) {
        EncType type = target.getType();
        if (type == EncType.ELGAMAL_2048) {
            return this._elg.getAvailableTags(target, key);
        }
        if (type == EncType.ECIES_X25519) {
            return this._ec.getAvailableTags(target, key);
        }
        return 0;
    }

    public long getAvailableTimeLeft(PublicKey target, SessionKey key) {
        EncType type = target.getType();
        if (type == EncType.ELGAMAL_2048) {
            return this._elg.getAvailableTimeLeft(target, key);
        }
        if (type == EncType.ECIES_X25519) {
            return this._ec.getAvailableTimeLeft(target, key);
        }
        return 0L;
    }

    public TagSetHandle tagsDelivered(PublicKey target, SessionKey key, Set<SessionTag> sessionTags) {
        EncType type = target.getType();
        if (type == EncType.ELGAMAL_2048) {
            return this._elg.tagsDelivered(target, key, sessionTags);
        }
        return null;
    }

    public void tagsReceived(SessionKey key, Set<SessionTag> sessionTags) {
        this._elg.tagsReceived(key, sessionTags);
    }

    public void tagsReceived(SessionKey key, Set<SessionTag> sessionTags, long expire) {
        this._elg.tagsReceived(key, sessionTags, expire);
    }

    public void tagsReceived(SessionKey key, RatchetSessionTag tag, long expire) {
        this._ec.tagsReceived(key, tag, expire);
    }

    public SessionKey consumeTag(SessionTag tag) {
        SessionKey rv = this._elg.consumeTag(tag);
        if (rv == null) {
            RatchetSessionTag rstag = new RatchetSessionTag(tag.getData());
            rv = this._ec.consumeTag(rstag);
        }
        return rv;
    }

    public void shutdown() {
        this._elg.shutdown();
        this._ec.shutdown();
    }

    public void renderStatusHTML(Writer out) throws IOException {
        this._elg.renderStatusHTML(out);
        this._ec.renderStatusHTML(out);
    }

    public void failTags(PublicKey target, SessionKey key, TagSetHandle ts) {
        EncType type = target.getType();
        if (type == EncType.ELGAMAL_2048) {
            this._elg.failTags(target, key, ts);
        }
    }

    public void tagsAcked(PublicKey target, SessionKey key, TagSetHandle ts) {
        EncType type = target.getType();
        if (type == EncType.ELGAMAL_2048) {
            this._elg.tagsAcked(target, key, ts);
        }
    }
}

