/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.IterativeFollowupJob;
import net.i2p.router.networkdb.kademlia.IterativeSearchJob;
import net.i2p.router.networkdb.kademlia.SingleSearchJob;
import net.i2p.util.Log;

class IterativeLookupJob
extends JobImpl {
    private final Log _log;
    private final DatabaseSearchReplyMessage _dsrm;
    private final IterativeSearchJob _search;

    public IterativeLookupJob(RouterContext ctx, DatabaseSearchReplyMessage dsrm, IterativeSearchJob search) {
        super(ctx);
        this._log = ctx.logManager().getLog(IterativeLookupJob.class);
        this._dsrm = dsrm;
        this._search = search;
    }

    @Override
    public void runJob() {
        long timeSent;
        Hash from = this._dsrm.getFromHash();
        if (!this._search.wasQueried(from)) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this._search.getJobId() + ": ILJ DSRM from unqueried peer: " + this._dsrm);
            }
            return;
        }
        int limit = Math.min(this._dsrm.getNumReplies(), 8);
        int newPeers = 0;
        int oldPeers = 0;
        int invalidPeers = 0;
        for (int i = 0; i < limit; ++i) {
            Hash peer = this._dsrm.getReply(i);
            if (peer.equals((Object)this.getContext().routerHash())) {
                ++oldPeers;
                continue;
            }
            if (peer.equals((Object)from)) {
                ++invalidPeers;
                continue;
            }
            if (this.getContext().banlist().isBanlistedForever(peer)) {
                ++oldPeers;
                continue;
            }
            RouterInfo ri = this.getContext().netDb().lookupRouterInfoLocally(peer);
            if (ri == null) {
                this._search.newPeerToTry(peer);
                if (this._search.getFromHash() == null) {
                    this.getContext().jobQueue().addJob(new SingleSearchJob(this.getContext(), peer, from));
                }
                ++newPeers;
                continue;
            }
            if (ri.getPublished() < this.getContext().clock().now() - 3600000L || !FloodfillNetworkDatabaseFacade.isFloodfill(ri)) {
                if (this._search.getFromHash() == null) {
                    this.getContext().jobQueue().addJob(new IterativeFollowupJob(this.getContext(), peer, peer, this._search));
                }
                ++oldPeers;
                continue;
            }
            this._search.newPeerToTry(peer);
            ++oldPeers;
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this._search.getJobId() + ": ILJ DSRM processed " + newPeers + '/' + oldPeers + '/' + invalidPeers + " new/old/invalid hashes");
        }
        if ((timeSent = this._search.timeSent(from)) > 0L) {
            this.getContext().profileManager().dbLookupReply(from, newPeers, oldPeers, invalidPeers, 0, this.getContext().clock().now() - timeSent);
        }
        this._search.failed(this._dsrm.getFromHash(), false);
    }

    @Override
    public String getName() {
        return "NetDb process DSRM";
    }
}

