/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;

class LocalHash
extends Hash {
    private Map<Hash, byte[]> _xorCache;
    private static final int MAX_CACHED_XOR = 1024;

    public LocalHash(Hash h) {
        super(h.getData());
    }

    public LocalHash(byte[] b) {
        super(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCache() {
        LocalHash localHash = this;
        synchronized (localHash) {
            if (this._xorCache == null) {
                this._xorCache = new HashMap<Hash, byte[]>(1024);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] cachedXor(Hash key) throws IllegalStateException {
        if (this._xorCache == null) {
            throw new IllegalStateException("To use the cache, you must first prepare it");
        }
        byte[] distance = this._xorCache.get(key);
        if (distance == null) {
            Map<Hash, byte[]> map = this._xorCache;
            synchronized (map) {
                int toRemove = this._xorCache.size() + 1 - 1024;
                if (toRemove > 0) {
                    HashSet<Hash> keys = new HashSet<Hash>(toRemove);
                    Iterator<Object> iter = this._xorCache.keySet().iterator();
                    for (int removed = 0; iter.hasNext() && removed < toRemove; ++removed) {
                        keys.add((Hash)iter.next());
                    }
                    iter = keys.iterator();
                    while (iter.hasNext()) {
                        this._xorCache.remove(iter.next());
                    }
                }
                distance = DataHelper.xor((byte[])key.getData(), (byte[])this.getData());
                this._xorCache.put(key, distance);
            }
        }
        return distance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearXorCache() {
        Map<Hash, byte[]> map = this._xorCache;
        synchronized (map) {
            this._xorCache.clear();
        }
    }
}

