/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;

class LookupThrottler {
    private final ObjectCounter<ReplyTunnel> counter = new ObjectCounter();
    private static final TunnelId DUMMY_ID = new TunnelId();
    private static final int MAX_LOOKUPS = 30;
    private static final long CLEAN_TIME = 180000L;

    LookupThrottler() {
        SimpleTimer2.getInstance().addPeriodicEvent((SimpleTimer.TimedEvent)new Cleaner(), 180000L);
    }

    boolean shouldThrottle(Hash key, TunnelId id) {
        return this.counter.increment((Object)new ReplyTunnel(key, id)) > 30;
    }

    private static class ReplyTunnel {
        public final Hash h;
        public final TunnelId id;

        ReplyTunnel(Hash h, TunnelId id) {
            this.h = h;
            this.id = id != null ? id : DUMMY_ID;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ReplyTunnel)) {
                return false;
            }
            return this.h.equals((Object)((ReplyTunnel)obj).h) && this.id.equals((Object)((ReplyTunnel)obj).id);
        }

        public int hashCode() {
            return this.h.hashCode() ^ this.id.hashCode();
        }
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        public void timeReached() {
            LookupThrottler.this.counter.clear();
        }
    }
}

