/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.ProfilePersistenceHelper;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class TunnelHistory {
    private final RouterContext _context;
    private final Log _log;
    private final AtomicLong _lifetimeAgreedTo = new AtomicLong();
    private final AtomicLong _lifetimeRejected = new AtomicLong();
    private volatile long _lastAgreedTo;
    private volatile long _lastRejectedCritical;
    private volatile long _lastRejectedBandwidth;
    private volatile long _lastRejectedTransient;
    private volatile long _lastRejectedProbabalistic;
    private final AtomicLong _lifetimeFailed = new AtomicLong();
    private volatile long _lastFailed;
    private RateStat _rejectRate;
    private RateStat _failRate;
    private final String _statGroup;
    public static final int TUNNEL_REJECT_PROBABALISTIC_REJECT = 10;
    public static final int TUNNEL_REJECT_TRANSIENT_OVERLOAD = 20;
    public static final int TUNNEL_REJECT_BANDWIDTH = 30;
    public static final int TUNNEL_REJECT_CRIT = 50;
    private static final String NL = System.getProperty("line.separator");

    public TunnelHistory(RouterContext context, String statGroup) {
        this._context = context;
        this._log = context.logManager().getLog(TunnelHistory.class);
        this._statGroup = statGroup;
        this.createRates(statGroup);
    }

    private void createRates(String statGroup) {
        this._rejectRate = new RateStat("tunnelHistory.rejectRate", "How often does this peer reject a tunnel request?", statGroup, new long[]{600000L, 1800000L, 3600000L, 86400000L});
        this._failRate = new RateStat("tunnelHistory.failRate", "How often do tunnels this peer accepts fail?", statGroup, new long[]{600000L, 1800000L, 3600000L, 86400000L});
    }

    public long getLifetimeAgreedTo() {
        return this._lifetimeAgreedTo.get();
    }

    public long getLifetimeRejected() {
        return this._lifetimeRejected.get();
    }

    public long getLifetimeFailed() {
        return this._lifetimeFailed.get();
    }

    public long getLastAgreedTo() {
        return this._lastAgreedTo;
    }

    public long getLastRejectedCritical() {
        return this._lastRejectedCritical;
    }

    public long getLastRejectedBandwidth() {
        return this._lastRejectedBandwidth;
    }

    public long getLastRejectedTransient() {
        return this._lastRejectedTransient;
    }

    public long getLastRejectedProbabalistic() {
        return this._lastRejectedProbabalistic;
    }

    public long getLastFailed() {
        return this._lastFailed;
    }

    public void incrementProcessed(int processedSuccessfully, int failedProcessing) {
    }

    public void incrementAgreedTo() {
        this._lifetimeAgreedTo.incrementAndGet();
        this._lastAgreedTo = this._context.clock().now();
    }

    public void incrementRejected(int severity) {
        this._lifetimeRejected.incrementAndGet();
        if (severity >= 50) {
            this._lastRejectedCritical = this._context.clock().now();
            this._rejectRate.addData(1L);
        } else if (severity >= 30) {
            this._lastRejectedBandwidth = this._context.clock().now();
            this._rejectRate.addData(1L);
        } else if (severity >= 20) {
            this._lastRejectedTransient = this._context.clock().now();
        } else if (severity >= 10) {
            this._lastRejectedProbabalistic = this._context.clock().now();
        }
    }

    public void incrementFailed(int pct) {
        this._lifetimeFailed.incrementAndGet();
        this._failRate.addData((long)pct);
        this._lastFailed = this._context.clock().now();
    }

    public RateStat getRejectionRate() {
        return this._rejectRate;
    }

    public RateStat getFailedRate() {
        return this._failRate;
    }

    public void coalesceStats() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Coallescing stats");
        }
        this._rejectRate.coalesceStats();
        this._failRate.coalesceStats();
    }

    public void store(OutputStream out) throws IOException {
        this.store(out, true);
    }

    public void store(OutputStream out, boolean addComments) throws IOException {
        StringBuilder buf = new StringBuilder(512);
        if (addComments) {
            buf.append(NL);
            buf.append("#################").append(NL);
            buf.append("# Tunnel history").append(NL);
            buf.append("###").append(NL);
        }
        TunnelHistory.addDate(buf, addComments, "lastAgreedTo", this._lastAgreedTo, "When did the peer last agree to participate in a tunnel?");
        TunnelHistory.addDate(buf, addComments, "lastFailed", this._lastFailed, "When was the last time a tunnel that the peer agreed to participate failed?");
        TunnelHistory.addDate(buf, addComments, "lastRejectedCritical", this._lastRejectedCritical, "When was the last time the peer refused to participate in a tunnel (Critical response code)?");
        TunnelHistory.addDate(buf, addComments, "lastRejectedBandwidth", this._lastRejectedBandwidth, "When was the last time the peer refused to participate in a tunnel (Bandwidth response code)?");
        TunnelHistory.addDate(buf, addComments, "lastRejectedTransient", this._lastRejectedTransient, "When was the last time the peer refused to participate in a tunnel (Transient load response code)?");
        TunnelHistory.addDate(buf, addComments, "lastRejectedProbabalistic", this._lastRejectedProbabalistic, "When was the last time the peer refused to participate in a tunnel (Probabalistic response code)?");
        TunnelHistory.add(buf, addComments, "lifetimeAgreedTo", this._lifetimeAgreedTo.get(), "How many tunnels has the peer ever agreed to participate in?");
        TunnelHistory.add(buf, addComments, "lifetimeFailed", this._lifetimeFailed.get(), "How many tunnels has the peer ever agreed to participate in that failed prematurely?");
        TunnelHistory.add(buf, addComments, "lifetimeRejected", this._lifetimeRejected.get(), "How many tunnels has the peer ever refused to participate in?");
        out.write(buf.toString().getBytes("UTF-8"));
        this._rejectRate.store(out, "tunnelHistory.rejectRate", addComments);
        this._failRate.store(out, "tunnelHistory.failRate", addComments);
    }

    private static void addDate(StringBuilder buf, boolean addComments, String name, long val, String description) {
        if (addComments) {
            String when = val > 0L ? new Date(val).toString() : "Never";
            TunnelHistory.add(buf, true, name, val, description + ' ' + when);
        } else {
            TunnelHistory.add(buf, false, name, val, description);
        }
    }

    private static void add(StringBuilder buf, boolean addComments, String name, long val, String description) {
        if (addComments) {
            buf.append("# ").append(name).append(NL).append("# ").append(description).append(NL);
        }
        buf.append("tunnels.").append(name).append('=').append(val).append(NL);
        if (addComments) {
            buf.append(NL);
        }
    }

    public void load(Properties props) {
        this._lastAgreedTo = TunnelHistory.getLong(props, "tunnels.lastAgreedTo");
        this._lastFailed = TunnelHistory.getLong(props, "tunnels.lastFailed");
        this._lastRejectedCritical = TunnelHistory.getLong(props, "tunnels.lastRejectedCritical");
        this._lastRejectedBandwidth = TunnelHistory.getLong(props, "tunnels.lastRejectedBandwidth");
        this._lastRejectedTransient = TunnelHistory.getLong(props, "tunnels.lastRejectedTransient");
        this._lastRejectedProbabalistic = TunnelHistory.getLong(props, "tunnels.lastRejectedProbabalistic");
        this._lifetimeAgreedTo.set(TunnelHistory.getLong(props, "tunnels.lifetimeAgreedTo"));
        this._lifetimeFailed.set(TunnelHistory.getLong(props, "tunnels.lifetimeFailed"));
        this._lifetimeRejected.set(TunnelHistory.getLong(props, "tunnels.lifetimeRejected"));
        try {
            this._rejectRate.load(props, "tunnelHistory.rejectRate", true);
            if (this._log.shouldLog(10)) {
                this._log.debug("Loading tunnelHistory.rejectRate");
            }
            this._failRate.load(props, "tunnelHistory.failRate", true);
            if (this._log.shouldLog(10)) {
                this._log.debug("Loading tunnelHistory.failRate");
            }
        }
        catch (IllegalArgumentException iae) {
            this._log.warn("TunnelHistory rates are corrupt, resetting", (Throwable)iae);
            this.createRates(this._statGroup);
        }
    }

    private static final long getLong(Properties props, String key) {
        return ProfilePersistenceHelper.getLong(props, key);
    }
}

