/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;

public class PortableWorkingDir {
    private static final String PROP_BASE_DIR = "i2p.dir.base";
    private static final String PROP_WORKING_DIR = "i2p.dir.config";
    private static final String PROP_WRAPPER_LOG = "wrapper.logfile";
    private static final String DEFAULT_WRAPPER_LOG = "wrapper.log";

    public static String getWorkingDir(Properties envProps) {
        String dir = null;
        if (envProps != null) {
            dir = envProps.getProperty(PROP_WORKING_DIR);
        }
        if (dir == null) {
            dir = System.getProperty(PROP_WORKING_DIR);
        }
        String cwd = null;
        if (envProps != null) {
            cwd = envProps.getProperty(PROP_BASE_DIR);
        }
        if (cwd == null && (cwd = System.getProperty(PROP_BASE_DIR)) == null) {
            cwd = System.getProperty("user.dir");
        }
        SecureDirectory dirf = new SecureDirectory(dir);
        File oldDirf = new File(cwd);
        File test = new File(oldDirf, "hosts.txt");
        if (!test.exists()) {
            PortableWorkingDir.setupSystemOut(cwd);
            System.err.println("ERROR - Cannot find I2P installation in " + cwd + " - Will probably be just a router with no apps or console at all!");
            return cwd;
        }
        if (!dirf.exists() && !dirf.mkdir()) {
            PortableWorkingDir.setupSystemOut(null);
            System.err.println("Wanted to use " + dirf.toString() + " for a working directory but could not create it");
            return cwd;
        }
        PortableWorkingDir.setupSystemOut(dirf.getAbsolutePath());
        return dirf.getAbsolutePath();
    }

    private static void setupSystemOut(String dir) {
        File logfile;
        if (SystemVersion.hasWrapper()) {
            return;
        }
        if (System.getProperty("I2P_DISABLE_OUTPUT_OVERRIDE") != null) {
            return;
        }
        String path = System.getProperty(PROP_WRAPPER_LOG);
        if (path != null) {
            logfile = new File(path);
        } else {
            logfile = new File(DEFAULT_WRAPPER_LOG);
            if (!logfile.exists()) {
                if (dir == null) {
                    dir = System.getProperty("java.io.tmpdir");
                }
                logfile = new File(dir, DEFAULT_WRAPPER_LOG);
            }
        }
        System.setProperty(PROP_WRAPPER_LOG, logfile.getAbsolutePath());
        try {
            PrintStream ps = new PrintStream((OutputStream)new SecureFileOutputStream(logfile, true), true, "UTF-8");
            System.setOut(ps);
            System.setErr(ps);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

