/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.sybil;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.i2p.data.DataHelper;

public class Points
implements Comparable<Points> {
    private double points;
    private final List<String> reasons = new ArrayList<String>(4);

    private Points() {
    }

    public Points(double d, String reason) {
        this();
        this.addPoints(d, reason);
    }

    public double getPoints() {
        return this.points;
    }

    public List<String> getReasons() {
        return this.reasons;
    }

    public void addPoints(double d, String reason) {
        this.points += d;
        DecimalFormat format = new DecimalFormat("#0.00");
        String rsn = format.format(d) + ": " + reason;
        this.reasons.add(rsn);
    }

    @Override
    public int compareTo(Points r) {
        return Double.compare(this.points, r.points);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        this.toString(buf);
        return buf.toString();
    }

    public void toString(StringBuilder buf) {
        buf.append(this.points);
        for (String r : this.reasons) {
            buf.append('%').append(r.replace("%", "&#x25;"));
        }
    }

    public static Points fromString(String s) {
        double d;
        String[] ss = DataHelper.split((String)s, (String)"%");
        if (ss.length < 2) {
            return null;
        }
        try {
            d = Double.parseDouble(ss[0]);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        Points rv = new Points();
        for (int i = 1; i < ss.length; ++i) {
            rv.reasons.add(ss[i]);
        }
        rv.points = d;
        return rv;
    }
}

