/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;

public class PersistRouterInfoJob
extends JobImpl {
    public PersistRouterInfoJob(RouterContext ctx) {
        super(ctx);
    }

    @Override
    public String getName() {
        return "Persist Updated Router Information";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runJob() {
        Log _log = this.getContext().logManager().getLog(PersistRouterInfoJob.class);
        if (_log.shouldLog(10)) {
            _log.debug("Persisting updated router info");
        }
        File infoFile = new File(this.getContext().getRouterDir(), "router.info");
        RouterInfo info = this.getContext().router().getRouterInfo();
        SecureFileOutputStream fos = null;
        Object object = this.getContext().router().routerInfoFileLock;
        synchronized (object) {
            try {
                fos = new SecureFileOutputStream(infoFile);
                info.writeBytes((OutputStream)fos);
            }
            catch (DataFormatException dfe) {
                _log.error("Error rebuilding the router information", (Throwable)dfe);
            }
            catch (IOException ioe) {
                _log.error("Error writing out the rebuilt router information", (Throwable)ioe);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException dfe) {}
                }
            }
        }
    }
}

