/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.time;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;

class Zones {
    private final I2PAppContext _context;
    private final Map<String, String> _countryToZone;
    private final Map<String, String> _continentToZone;
    private static final String CONTINENT_FILE_DEFAULT = "continents.txt";
    private static final String[] ZONES = new String[]{"AF", "africa", "AS", "asia", "EU", "europe", "NA", "north-america", "OC", "oceania", "SA", "south-america"};

    public Zones(I2PAppContext ctx) {
        this._context = ctx;
        this._countryToZone = new HashMap<String, String>(256);
        this._continentToZone = new HashMap<String, String>(8);
        for (int i = 0; i < ZONES.length; i += 2) {
            this._continentToZone.put(ZONES[i], ZONES[i + 1]);
        }
        this.readContinentFile();
    }

    public String getZone(String country) {
        return this._countryToZone.get(country.toLowerCase(Locale.US));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readContinentFile() {
        InputStream is = Zones.class.getResourceAsStream("/net/i2p/router/util/resources/continents.txt");
        if (is == null) {
            System.out.println("Continent file not found");
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                try {
                    String[] s;
                    String ucContinent;
                    String zone;
                    if (line.charAt(0) == '#' || (zone = this._continentToZone.get(ucContinent = (s = DataHelper.split((String)line, (String)","))[1].toUpperCase(Locale.US).trim())) == null) continue;
                    String lcCountry = s[0].toLowerCase(Locale.US).trim();
                    this._countryToZone.put(lcCountry, zone);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
        }
        catch (IOException ioe) {
            System.out.println("Error reading the continent file");
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

