/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Base64;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.udp.InboundEstablishState;
import net.i2p.router.transport.udp.InboundEstablishState2;
import net.i2p.router.transport.udp.MTU;
import net.i2p.router.transport.udp.OutboundEstablishState;
import net.i2p.router.transport.udp.OutboundEstablishState2;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PacketBuilder2;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.router.util.DecayingBloomFilter;
import net.i2p.router.util.DecayingHashSet;
import net.i2p.util.Addresses;
import net.i2p.util.I2PThread;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

class EstablishmentManager {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final PacketBuilder _builder;
    private final int _networkID;
    private final PacketBuilder2 _builder2;
    private final boolean _enableSSU2;
    private final Map<RemoteHostId, Token> _outboundTokens;
    private final Map<RemoteHostId, Token> _inboundTokens;
    private final ConcurrentHashMap<RemoteHostId, InboundEstablishState> _inboundStates;
    private final ConcurrentHashMap<RemoteHostId, OutboundEstablishState> _outboundStates;
    private final ConcurrentHashMap<RemoteHostId, List<OutNetMessage>> _queuedOutbound;
    private final ConcurrentHashMap<Long, OutboundEstablishState> _liveIntroductions;
    private final ConcurrentHashMap<RemoteHostId, OutboundEstablishState> _outboundByClaimedAddress;
    private final ConcurrentHashMap<Hash, OutboundEstablishState> _outboundByHash;
    private volatile boolean _alive;
    private final Object _activityLock;
    private int _activity;
    private final DecayingBloomFilter _replayFilter;
    private final int DEFAULT_MAX_CONCURRENT_ESTABLISH;
    private static final int DEFAULT_LOW_MAX_CONCURRENT_ESTABLISH = SystemVersion.isSlow() ? 20 : 40;
    private static final int DEFAULT_HIGH_MAX_CONCURRENT_ESTABLISH = 150;
    private static final String PROP_MAX_CONCURRENT_ESTABLISH = "i2np.udp.maxConcurrentEstablish";
    private static final int MAX_QUEUED_OUTBOUND = 50;
    private static final int MAX_QUEUED_PER_PEER = 16;
    private static final long MAX_NONCE = 0xFFFFFFFFL;
    private static final int MAX_OB_ESTABLISH_TIME = 35000;
    private static final int MAX_IB_ESTABLISH_TIME = 15000;
    public static final int OB_MESSAGE_TIMEOUT = 15000;
    private static final int DATA_MESSAGE_TIMEOUT = 10000;
    private static final String VERSION_ALLOW_EXTENDED_OPTIONS = "0.9.24";
    private static final String PROP_DISABLE_EXT_OPTS = "i2np.udp.disableExtendedOptions";
    private static final int MAX_TOKENS = 512;
    public static final long IB_TOKEN_EXPIRATION = 3600000L;
    public static final long MAX_TAG_VALUE = 0xFFFFFFFFL;

    public EstablishmentManager(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(EstablishmentManager.class);
        this._networkID = ctx.router().getNetworkID();
        this._transport = transport;
        this._builder = transport.getBuilder();
        this._builder2 = transport.getBuilder2();
        this._enableSSU2 = this._builder2 != null;
        this._inboundStates = new ConcurrentHashMap();
        this._outboundStates = new ConcurrentHashMap();
        this._queuedOutbound = new ConcurrentHashMap();
        this._liveIntroductions = new ConcurrentHashMap();
        this._outboundByClaimedAddress = new ConcurrentHashMap();
        this._outboundByHash = new ConcurrentHashMap();
        if (this._enableSSU2) {
            this._inboundTokens = new LHMCache(512);
            this._outboundTokens = new LHMCache(512);
        } else {
            this._inboundTokens = null;
            this._outboundTokens = null;
        }
        this._activityLock = new Object();
        this._replayFilter = new DecayingHashSet(ctx, 600000, 8, "SSU-DH-X");
        this.DEFAULT_MAX_CONCURRENT_ESTABLISH = Math.max(DEFAULT_LOW_MAX_CONCURRENT_ESTABLISH, Math.min(150, ctx.bandwidthLimiter().getOutboundKBytesPerSecond() / 2));
        this._context.statManager().createRateStat("udp.inboundEstablishTime", "How long it takes for a new inbound session to be established", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.outboundEstablishTime", "How long it takes for a new outbound session to be established", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendIntroRelayRequest", "How often we send a relay request to reach a peer", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendIntroRelayTimeout", "How often a relay request times out before getting a response (due to the target or intro peer being offline)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveIntroRelayResponse", "How long it took to receive a relay response", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishDropped", "Dropped an inbound establish message", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishRejected", "How many pending outbound connections are there when we refuse to add any more?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishOverflow", "How many messages were queued up on a pending connection when it was too much?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishBadIP", "Received IP or port was bad", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.congestionOccurred", "How large the cwin was when congestion occurred (duration == sendBps)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.congestedRTO", "retransmission timeout after congestion (duration == rtt dev)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendACKPartial", "Number of partial ACKs sent (duration == number of full ACKs in that ack packet)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.mtuIncrease", "How many retransmissions have there been to the peer when the MTU was increased", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.mtuDecrease", "How many retransmissions have there been to the peer when the MTU was decreased", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.rejectConcurrentActive", "How many messages are currently being sent to the peer when we reject it (period is how many concurrent packets we allow)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.allowConcurrentActive", "How many messages are currently being sent to the peer when we accept it (period is how many concurrent packets we allow)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.rejectConcurrentSequence", "How many consecutive concurrency rejections have we had when we stop rejecting (period is how many concurrent packets we are on)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.dupDHX", "Session request replay", "udp", new long[]{86400000L});
    }

    public synchronized void startup() {
        this._alive = true;
        I2PThread t = new I2PThread((Runnable)new Establisher(), "UDP Establisher", true);
        t.start();
    }

    public synchronized void shutdown() {
        this._alive = false;
        this.notifyActivity();
    }

    InboundEstablishState getInboundState(RemoteHostId from) {
        InboundEstablishState state = this._inboundStates.get(from);
        return state;
    }

    OutboundEstablishState getOutboundState(RemoteHostId from) {
        OutboundEstablishState state = this._outboundStates.get(from);
        if (state == null && (state = this._outboundByClaimedAddress.get(from)) != null && this._log.shouldLog(20)) {
            this._log.info("Found by claimed address: " + state);
        }
        return state;
    }

    private int getMaxConcurrentEstablish() {
        return this._context.getProperty(PROP_MAX_CONCURRENT_ESTABLISH, this.DEFAULT_MAX_CONCURRENT_ESTABLISH);
    }

    public void establish(OutNetMessage msg) {
        this.establish(msg, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establish(OutNetMessage msg, boolean queueIfMaxExceeded) {
        RouterInfo toRouterInfo = msg.getTarget();
        RouterAddress ra = this._transport.getTargetAddress(toRouterInfo);
        if (ra == null) {
            this._transport.failed(msg, "Remote peer has no address, cannot establish");
            return;
        }
        RouterIdentity toIdentity = toRouterInfo.getIdentity();
        Hash toHash = toIdentity.calculateHash();
        int id = toRouterInfo.getNetworkId();
        if (id != this._networkID) {
            if (id == -1) {
                this._context.banlist().banlistRouter(toHash, "No network specified", null, null, this._context.clock().now() + 2592000000L);
            } else {
                this._context.banlist().banlistRouterForever(toHash, "Not in our network: " + id);
            }
            if (this._log.shouldWarn()) {
                this._log.warn("Not in our network: " + (Object)((Object)toRouterInfo), (Throwable)new Exception());
            }
            this._transport.markUnreachable(toHash);
            this._transport.failed(msg, "Not in our network");
            return;
        }
        UDPAddress addr = new UDPAddress(ra);
        RemoteHostId maybeTo = null;
        InetAddress remAddr = addr.getHostAddress();
        int port = addr.getPort();
        if (remAddr != null && port > 0 && port <= 65535) {
            maybeTo = new RemoteHostId(remAddr.getAddress(), port);
            if (!this._transport.isValid(maybeTo.getIP()) || Arrays.equals(maybeTo.getIP(), this._transport.getExternalIP()) && !this._transport.allowLocal()) {
                this._transport.failed(msg, "Remote peer's IP isn't valid");
                this._transport.markUnreachable(toHash);
                this._context.statManager().addRateData("udp.establishBadIP", 1L);
                return;
            }
            InboundEstablishState inState = this._inboundStates.get(maybeTo);
            if (inState != null) {
                InboundEstablishState inboundEstablishState = inState;
                synchronized (inboundEstablishState) {
                    switch (inState.getState()) {
                        case IB_STATE_UNKNOWN: 
                        case IB_STATE_REQUEST_RECEIVED: 
                        case IB_STATE_CREATED_SENT: 
                        case IB_STATE_CONFIRMED_PARTIALLY: 
                        case IB_STATE_CONFIRMED_COMPLETELY: 
                        case IB_STATE_TOKEN_REQUEST_RECEIVED: 
                        case IB_STATE_REQUEST_BAD_TOKEN_RECEIVED: 
                        case IB_STATE_RETRY_SENT: {
                            inState.addMessage(msg);
                            if (!this._log.shouldLog(30)) break;
                            this._log.debug("OB msg queued to IES");
                            break;
                        }
                        case IB_STATE_COMPLETE: {
                            this._transport.sendIfEstablished(msg);
                            break;
                        }
                        case IB_STATE_FAILED: {
                            this._transport.failed(msg, "OB msg failed during IB establish");
                        }
                    }
                }
                return;
            }
        }
        boolean isIndirect = addr.getIntroducerCount() > 0 || maybeTo == null;
        RemoteHostId to = isIndirect ? new RemoteHostId(toHash) : maybeTo;
        OutboundEstablishState state = null;
        int deferred = 0;
        boolean rejected = false;
        int queueCount = 0;
        state = this._outboundStates.get(to);
        if (state == null && (state = this._outboundByHash.get(toHash)) != null && this._log.shouldLog(20)) {
            this._log.info("Found by hash: " + state);
        }
        if (state == null) {
            if (queueIfMaxExceeded && this._outboundStates.size() >= this.getMaxConcurrentEstablish()) {
                if (this._queuedOutbound.size() >= 50 && !this._queuedOutbound.containsKey(to)) {
                    rejected = true;
                } else {
                    ArrayList<OutNetMessage> newQueued = new ArrayList<OutNetMessage>(16);
                    ArrayList<OutNetMessage> queued = this._queuedOutbound.putIfAbsent(to, newQueued);
                    if (queued == null) {
                        queued = newQueued;
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Queueing outbound establish to " + to + ", increase " + PROP_MAX_CONCURRENT_ESTABLISH);
                        }
                    }
                    ArrayList<OutNetMessage> arrayList = queued;
                    synchronized (arrayList) {
                        queueCount = queued.size();
                        if (queueCount < 16) {
                            queued.add(msg);
                            ++queueCount;
                        } else {
                            rejected = true;
                        }
                        deferred = this._queuedOutbound.size();
                    }
                }
            } else {
                boolean isNew;
                SessionKey sessionKey;
                String siv;
                int version = this._transport.getSSUVersion(ra);
                Object keyBytes = version == 1 ? addr.getIntroKey() : (Object)((siv = ra.getOption("i")) != null ? Base64.decode((String)siv) : null);
                if (keyBytes == null) {
                    this._transport.markUnreachable(toHash);
                    this._transport.failed(msg, "Peer has no key, cannot establish");
                    return;
                }
                try {
                    sessionKey = new SessionKey(keyBytes);
                }
                catch (IllegalArgumentException iae) {
                    this._transport.markUnreachable(toHash);
                    this._transport.failed(msg, "Peer has bad key, cannot establish");
                    return;
                }
                if (version == 1) {
                    boolean allowExtendedOptions = VersionComparator.comp((String)toRouterInfo.getVersion(), (String)VERSION_ALLOW_EXTENDED_OPTIONS) >= 0 && !this._context.getBooleanProperty(PROP_DISABLE_EXT_OPTS);
                    boolean requestIntroduction = allowExtendedOptions && !isIndirect && this._transport.introducersMaybeRequired(TransportUtil.isIPv6(ra));
                    state = new OutboundEstablishState(this._context, maybeTo, to, toIdentity, allowExtendedOptions, requestIntroduction, sessionKey, addr, this._transport.getDHFactory());
                } else if (version == 2) {
                    boolean requestIntroduction = false;
                    state = new OutboundEstablishState2(this._context, this._transport, maybeTo, to, toIdentity, requestIntroduction, sessionKey, ra, addr);
                } else {
                    this._transport.failed(msg, "OB to bad addr? " + (Object)((Object)ra));
                    return;
                }
                OutboundEstablishState oldState = this._outboundStates.putIfAbsent(to, state);
                boolean bl = isNew = oldState == null;
                if (isNew) {
                    if (isIndirect && maybeTo != null) {
                        this._outboundByClaimedAddress.put(maybeTo, state);
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Adding new " + state);
                    }
                } else {
                    state = oldState;
                }
            }
        }
        if (state != null) {
            state.addMessage(msg);
            List<OutNetMessage> queued = this._queuedOutbound.remove(to);
            if (queued != null) {
                List<OutNetMessage> list = queued;
                synchronized (list) {
                    for (OutNetMessage m : queued) {
                        state.addMessage(m);
                    }
                }
            }
        }
        if (rejected) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Too many pending, rejecting outbound establish to " + to);
            }
            this._transport.failed(msg, "Too many pending outbound connections");
            this._context.statManager().addRateData("udp.establishRejected", (long)deferred);
            return;
        }
        if (queueCount >= 16) {
            this._transport.failed(msg, "Too many pending messages for the given peer");
            this._context.statManager().addRateData("udp.establishOverflow", (long)queueCount, (long)deferred);
            return;
        }
        if (deferred > 0) {
            msg.timestamp("too many deferred establishers");
        } else if (state != null) {
            msg.timestamp("establish state already waiting");
        }
        this.notifyActivity();
    }

    private int getMaxInboundEstablishers() {
        return this.getMaxConcurrentEstablish() / 2;
    }

    public boolean shouldAllowInboundEstablishment() {
        return this._inboundStates.size() < this.getMaxInboundEstablishers();
    }

    void receiveSessionRequest(RemoteHostId from, InboundEstablishState state, UDPPacketReader reader) {
        if (!TransportUtil.isValidPort(from.getPort()) || !this._transport.isValid(from.getIP())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Receive session request from invalid: " + from);
            }
            return;
        }
        boolean isNew = false;
        if (state == null) {
            state = this._inboundStates.get(from);
        }
        if (state == null) {
            if (!this.shouldAllowInboundEstablishment()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping inbound establish, increase i2np.udp.maxConcurrentEstablish");
                    if (this._log.shouldDebug()) {
                        StringBuilder buf = new StringBuilder(4096);
                        buf.append("Active: ").append(this._inboundStates.size()).append('\n');
                        for (InboundEstablishState ies : this._inboundStates.values()) {
                            buf.append(ies.toString()).append('\n');
                        }
                        this._log.debug(buf.toString());
                    }
                }
                this._context.statManager().addRateData("udp.establishDropped", 1L);
                return;
            }
            if (this._context.blocklist().isBlocklisted(from.getIP())) {
                if (this._log.shouldInfo()) {
                    this._log.info("Receive session request from blocklisted IP: " + from);
                }
                this._context.statManager().addRateData("udp.establishBadIP", 1L);
                return;
            }
            if (!this._transport.allowConnection()) {
                return;
            }
            byte[] fromIP = from.getIP();
            state = new InboundEstablishState(this._context, fromIP, from.getPort(), this._transport.getExternalPort(fromIP.length == 16), this._transport.getDHBuilder(), reader.getSessionRequestReader());
            if (this._replayFilter.add(state.getReceivedX(), 0, 8)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Duplicate X in session request from: " + from);
                }
                this._context.statManager().addRateData("udp.dupDHX", 1L);
                return;
            }
            InboundEstablishState oldState = this._inboundStates.putIfAbsent(from, state);
            boolean bl = isNew = oldState == null;
            if (!isNew) {
                state = oldState;
            }
        }
        if (isNew) {
            if (state.isIntroductionRequested() && state.getSentPort() >= 1024 && this._transport.canIntroduce(state.getSentIP().length == 16)) {
                long tag = 1L + this._context.random().nextLong(0xFFFFFFFFL);
                state.setSentRelayTag(tag);
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Received NEW session request " + state);
            }
        } else if (this._log.shouldDebug()) {
            this._log.debug("Receive DUP session request from: " + state);
        }
        this.notifyActivity();
    }

    void receiveSessionOrTokenRequest(RemoteHostId from, InboundEstablishState2 state, UDPPacket packet) {
        if (!TransportUtil.isValidPort(from.getPort()) || !this._transport.isValid(from.getIP())) {
            if (this._log.shouldWarn()) {
                this._log.warn("Receive session request from invalid: " + from);
            }
            return;
        }
        boolean isNew = false;
        if (state == null) {
            if (!this.shouldAllowInboundEstablishment()) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Dropping inbound establish, increase i2np.udp.maxConcurrentEstablish");
                }
                this._context.statManager().addRateData("udp.establishDropped", 1L);
                return;
            }
            if (this._context.blocklist().isBlocklisted(from.getIP())) {
                if (this._log.shouldInfo()) {
                    this._log.info("Receive session request from blocklisted IP: " + from);
                }
                this._context.statManager().addRateData("udp.establishBadIP", 1L);
                return;
            }
            if (!this._transport.allowConnection()) {
                return;
            }
            try {
                state = new InboundEstablishState2(this._context, this._transport, packet);
            }
            catch (GeneralSecurityException gse) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Corrupt Session/Token Request from: " + from, (Throwable)gse);
                }
                this._context.statManager().addRateData("udp.establishDropped", 1L);
                return;
            }
            InboundEstablishState oldState = this._inboundStates.putIfAbsent(from, state);
            boolean bl = isNew = oldState == null;
            if (!isNew && oldState.getVersion() == 2) {
                state = (InboundEstablishState2)oldState;
            }
        } else {
            try {
                state.receiveSessionRequestAfterRetry(packet);
            }
            catch (GeneralSecurityException gse) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Corrupt Session Request after Retry from: " + state, (Throwable)gse);
                }
                return;
            }
        }
        if (this._log.shouldDebug()) {
            if (isNew) {
                this._log.debug("Received NEW session/token request " + state);
            } else {
                this._log.debug("Receive DUP session/token request from: " + state);
            }
        }
        this.notifyActivity();
    }

    void receiveSessionConfirmed(RemoteHostId from, InboundEstablishState state, UDPPacketReader reader) {
        if (state == null) {
            state = this._inboundStates.get(from);
        }
        if (state != null) {
            state.receiveSessionConfirmed(reader.getSessionConfirmedReader());
            this.notifyActivity();
            if (this._log.shouldLog(10)) {
                this._log.debug("Receive session confirmed from: " + state);
            }
        } else if (this._log.shouldInfo()) {
            this._log.info("Receive (DUP?) session confirmed from: " + from);
        }
    }

    void receiveSessionConfirmed(InboundEstablishState2 state, UDPPacket packet) {
        try {
            state.receiveSessionConfirmed(packet);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldWarn()) {
                this._log.warn("Corrupt Session Confirmed on: " + state, (Throwable)gse);
            }
            state.fail();
            return;
        }
        InboundEstablishState.InboundState istate = state.getState();
        if (istate == InboundEstablishState.InboundState.IB_STATE_CONFIRMED_COMPLETELY || istate == InboundEstablishState.InboundState.IB_STATE_COMPLETE) {
            this.handleCompletelyEstablished(state);
        }
        this.notifyActivity();
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive session confirmed from: " + state);
        }
    }

    void receiveSessionCreated(RemoteHostId from, OutboundEstablishState state, UDPPacketReader reader) {
        if (state == null) {
            state = this._outboundStates.get(from);
        }
        if (state != null) {
            state.receiveSessionCreated(reader.getSessionCreatedReader());
            this.notifyActivity();
            if (this._log.shouldLog(10)) {
                this._log.debug("Receive session created from: " + state);
            }
        } else if (this._log.shouldInfo()) {
            this._log.info("Receive (DUP?) session created from: " + from);
        }
    }

    void receiveSessionCreated(OutboundEstablishState2 state, UDPPacket packet) {
        try {
            state.receiveSessionCreated(packet);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldWarn()) {
                this._log.warn("Corrupt Session Created on: " + state, (Throwable)gse);
            }
            state.fail();
            return;
        }
        this.notifyActivity();
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive session created from: " + state);
        }
    }

    void receiveRetry(OutboundEstablishState2 state, UDPPacket packet) {
        try {
            state.receiveRetry(packet);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldWarn()) {
                this._log.warn("Corrupt Retry from: " + state, (Throwable)gse);
            }
            state.fail();
            return;
        }
        this.notifyActivity();
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive retry with token " + state.getToken() + " from: " + state);
        }
    }

    void receiveSessionDestroy(RemoteHostId from, PeerState state) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive session destroy (EST) from: " + from);
        }
        this._transport.dropPeer(state, false, "received destroy message");
    }

    void receiveSessionDestroy(RemoteHostId from, OutboundEstablishState state) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive session destroy (OB) from: " + from);
        }
        this._outboundStates.remove(from);
        Hash peer = state.getRemoteIdentity().calculateHash();
        this._transport.dropPeer(peer, false, "received destroy message during OB establish");
    }

    void receiveSessionDestroy(RemoteHostId from) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Receive session destroy (none) from: " + from);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeerState receiveData(OutboundEstablishState state) {
        state.dataReceived();
        this._outboundStates.remove(state.getRemoteHostId());
        List<OutNetMessage> queued = this._queuedOutbound.remove(state.getRemoteHostId());
        if (queued != null) {
            List<OutNetMessage> list = queued;
            synchronized (list) {
                for (OutNetMessage m : queued) {
                    state.addMessage(m);
                }
            }
        }
        if (this._outboundStates.size() < this.getMaxConcurrentEstablish() && !this._queuedOutbound.isEmpty()) {
            this.locked_admitQueued();
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Outbound established: " + state);
        }
        PeerState peer = this.handleCompletelyEstablished(state);
        this.notifyActivity();
        return peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int locked_admitQueued() {
        if (this._queuedOutbound.isEmpty()) {
            return 0;
        }
        int admitted = 0;
        int max = this.getMaxConcurrentEstablish();
        Iterator<Map.Entry<RemoteHostId, List<OutNetMessage>>> iter = this._queuedOutbound.entrySet().iterator();
        while (iter.hasNext() && this._outboundStates.size() < max) {
            Map.Entry<RemoteHostId, List<OutNetMessage>> entry = iter.next();
            try {
                iter.remove();
            }
            catch (IllegalStateException ise) {
                continue;
            }
            List<OutNetMessage> allQueued = entry.getValue();
            ArrayList<OutNetMessage> queued = new ArrayList<OutNetMessage>();
            long now = this._context.clock().now();
            List<OutNetMessage> list = allQueued;
            synchronized (list) {
                for (OutNetMessage msg : allQueued) {
                    if (now - 60000L > msg.getExpiration()) {
                        this._transport.failed(msg, "Took too long in est. mgr OB queue");
                        continue;
                    }
                    queued.add(msg);
                }
            }
            if (queued.isEmpty()) continue;
            for (OutNetMessage m : queued) {
                m.timestamp("no longer deferred... establishing");
                this.establish(m, false);
            }
            ++admitted;
        }
        return admitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyActivity() {
        Object object = this._activityLock;
        synchronized (object) {
            ++this._activity;
            this._activityLock.notifyAll();
        }
    }

    private void handleCompletelyEstablished(InboundEstablishState state) {
        OutNetMessage msg;
        String smtu;
        RouterAddress addr;
        RouterInfo info;
        PeerState peer;
        if (state.isComplete()) {
            return;
        }
        RouterIdentity remote = state.getConfirmedIdentity();
        int version = state.getVersion();
        if (version == 1) {
            peer = new PeerState(this._context, this._transport, state.getSentIP(), state.getSentPort(), remote.calculateHash(), true, state.getRTT());
            peer.setCurrentCipherKey(state.getCipherKey());
            peer.setCurrentMACKey(state.getMACKey());
            peer.setWeRelayToThemAs(state.getSentRelayTag());
        } else {
            InboundEstablishState2 state2 = (InboundEstablishState2)state;
            peer = state2.getPeerState();
        }
        if (version == 1 && (info = this._context.netDb().lookupRouterInfoLocally(remote.calculateHash())) != null && (addr = this._transport.getTargetAddress(info)) != null && (smtu = addr.getOption("mtu")) != null) {
            try {
                boolean isIPv6 = state.getSentIP().length == 16;
                int mtu = MTU.rectify(isIPv6, Integer.parseInt(smtu));
                peer.setHisMTU(mtu);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle completely established (inbound): " + state + " - " + peer.getRemotePeer());
        }
        this._transport.addRemotePeerState(peer);
        boolean isIPv6 = state.getSentIP().length == 16;
        this._transport.inboundConnectionReceived(isIPv6);
        this._transport.setIP(remote.calculateHash(), state.getSentIP());
        this._context.statManager().addRateData("udp.inboundEstablishTime", state.getLifetime());
        this.sendInboundComplete(peer);
        while ((msg = state.getNextQueuedMessage()) != null) {
            if (this._context.clock().now() - 60000L > msg.getExpiration()) {
                msg.timestamp("took too long but established...");
                this._transport.failed(msg, "Took too long to establish, but it was established");
                continue;
            }
            msg.timestamp("session fully established and sent");
            this._transport.send(msg);
        }
        state.complete();
    }

    private void sendInboundComplete(PeerState peer) {
        DeliveryStatusMessage dsm;
        if (this._log.shouldDebug()) {
            this._log.debug("IB confirm: " + peer);
        }
        if (peer.getVersion() == 1) {
            dsm = new DeliveryStatusMessage(this._context);
            dsm.setArrival(this._networkID);
            dsm.setMessageExpiration(this._context.clock().now() + 10000L);
            dsm.setMessageId(this._context.random().nextLong(0xFFFFFFFFL));
        } else {
            dsm = null;
        }
        Hash hash = peer.getRemotePeer();
        if (hash != null && !this._context.banlist().isBanlisted(hash) && !this._transport.isUnreachable(hash)) {
            DatabaseStoreMessage dbsm = this.getOurInfo();
            ArrayList<I2NPMessage> msgs = new ArrayList<I2NPMessage>(2);
            if (dsm != null) {
                msgs.add(dsm);
            }
            msgs.add(dbsm);
            this._transport.send(msgs, peer);
        } else if (dsm != null) {
            this._transport.send(dsm, peer);
            if (this._log.shouldLog(30)) {
                this._log.warn("NOT publishing to the peer after confirm plus delay (WITH banlist): " + (hash != null ? hash.toString() : "unknown"));
            }
        }
    }

    private PeerState handleCompletelyEstablished(OutboundEstablishState state) {
        OutNetMessage msg;
        PeerState peer;
        RouterIdentity rem;
        if (state.complete() && (rem = state.getRemoteIdentity()) != null) {
            return this._transport.getPeerState(rem.getHash());
        }
        long now = this._context.clock().now();
        RouterIdentity remote = state.getRemoteIdentity();
        RemoteHostId claimed = state.getClaimedAddress();
        if (claimed != null) {
            this._outboundByClaimedAddress.remove(claimed, state);
        }
        this._outboundByHash.remove(remote.calculateHash(), state);
        int version = state.getVersion();
        if (version == 1) {
            peer = new PeerState(this._context, this._transport, state.getSentIP(), state.getSentPort(), remote.calculateHash(), false, state.getRTT());
            peer.setCurrentCipherKey(state.getCipherKey());
            peer.setCurrentMACKey(state.getMACKey());
            int mtu = state.getRemoteAddress().getMTU();
            if (mtu > 0) {
                peer.setHisMTU(mtu);
            }
        } else {
            OutboundEstablishState2 state2 = (OutboundEstablishState2)state;
            peer = state2.getPeerState();
        }
        peer.setTheyRelayToUsAs(state.getReceivedRelayTag());
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle completely established (outbound): " + state + " - " + peer.getRemotePeer());
        }
        this._transport.addRemotePeerState(peer);
        this._transport.setIP(remote.calculateHash(), state.getSentIP());
        this._context.statManager().addRateData("udp.outboundEstablishTime", state.getLifetime());
        DatabaseStoreMessage dbsm = null;
        if (version == 1 && !state.isFirstMessageOurDSM()) {
            dbsm = this.getOurInfo();
        }
        ArrayList<OutNetMessage> msgs = new ArrayList<OutNetMessage>(8);
        while ((msg = state.getNextQueuedMessage()) != null) {
            if (now - 60000L > msg.getExpiration()) {
                msg.timestamp("took too long but established...");
                this._transport.failed(msg, "Took too long to establish, but it was established");
                continue;
            }
            msg.timestamp("session fully established and sent");
            msgs.add(msg);
        }
        this._transport.send(dbsm, msgs, peer);
        return peer;
    }

    private DatabaseStoreMessage getOurInfo() {
        DatabaseStoreMessage m = new DatabaseStoreMessage(this._context);
        m.setEntry(this._context.router().getRouterInfo());
        m.setMessageExpiration(this._context.clock().now() + 10000L);
        return m;
    }

    private void sendCreated(InboundEstablishState state) {
        UDPPacket pkt;
        int version = state.getVersion();
        if (version == 1) {
            if (this._log.shouldDebug()) {
                this._log.debug("Send created to: " + state);
            }
            try {
                state.generateSessionKey();
            }
            catch (DHSessionKeyBuilder.InvalidPublicParameterException ippe) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Peer " + state + " sent us an invalid DH parameter", (Throwable)((Object)ippe));
                }
                this._inboundStates.remove(state.getRemoteHostId());
                state.fail();
                return;
            }
            pkt = this._builder.buildSessionCreatedPacket(state, this._transport.getExternalPort(state.getSentIP().length == 16), this._transport.getIntroKey());
        } else {
            InboundEstablishState2 state2 = (InboundEstablishState2)state;
            InboundEstablishState.InboundState istate = state2.getState();
            if (istate == InboundEstablishState.InboundState.IB_STATE_CREATED_SENT) {
                if (this._log.shouldInfo()) {
                    this._log.info("Retransmit created to: " + state);
                }
                pkt = state2.getRetransmitSessionCreatedPacket();
            } else if (istate == InboundEstablishState.InboundState.IB_STATE_REQUEST_RECEIVED) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Send created to: " + state);
                }
                pkt = this._builder2.buildSessionCreatedPacket(state2);
            } else if (istate == InboundEstablishState.InboundState.IB_STATE_TOKEN_REQUEST_RECEIVED || istate == InboundEstablishState.InboundState.IB_STATE_REQUEST_BAD_TOKEN_RECEIVED) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Send retry to: " + state);
                }
                pkt = this._builder2.buildRetryPacket(state2);
            } else {
                if (this._log.shouldWarn()) {
                    this._log.warn("Unhandled state " + (Object)((Object)istate) + " on " + state);
                }
                return;
            }
        }
        if (pkt == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Peer " + state + " sent us an invalid IP?");
            }
            this._inboundStates.remove(state.getRemoteHostId());
            state.fail();
            return;
        }
        this._transport.send(pkt);
        if (version == 1) {
            state.createdPacketSent();
        }
    }

    private void sendRequest(OutboundEstablishState state) {
        UDPPacket packet;
        int version = state.getVersion();
        if (version == 1) {
            if (this._log.shouldDebug()) {
                this._log.debug("Send Session Request to: " + state);
            }
            packet = this._builder.buildSessionRequestPacket(state);
        } else {
            OutboundEstablishState2 state2 = (OutboundEstablishState2)state;
            OutboundEstablishState.OutboundState ostate = state2.getState();
            if (ostate == OutboundEstablishState.OutboundState.OB_STATE_REQUEST_SENT || ostate == OutboundEstablishState.OutboundState.OB_STATE_REQUEST_SENT_NEW_TOKEN) {
                if (this._log.shouldInfo()) {
                    this._log.info("Retransmit Session Request to: " + state);
                }
                packet = state2.getRetransmitSessionRequestPacket();
            } else if (ostate == OutboundEstablishState.OutboundState.OB_STATE_NEEDS_TOKEN || ostate == OutboundEstablishState.OutboundState.OB_STATE_TOKEN_REQUEST_SENT) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Send Token Request to: " + state);
                }
                packet = this._builder2.buildTokenRequestPacket(state2);
            } else if (ostate == OutboundEstablishState.OutboundState.OB_STATE_UNKNOWN || ostate == OutboundEstablishState.OutboundState.OB_STATE_RETRY_RECEIVED) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Send Session Request to: " + state);
                }
                packet = this._builder2.buildSessionRequestPacket(state2);
            } else {
                if (this._log.shouldWarn()) {
                    this._log.warn("Unhandled state " + (Object)((Object)ostate) + " on " + state);
                }
                return;
            }
        }
        if (packet != null) {
            this._transport.send(packet);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Unable to build a session request packet for " + state);
        }
        if (version == 1) {
            state.requestSent();
        }
    }

    private void handlePendingIntro(OutboundEstablishState state) {
        long nonce = state.getIntroNonce();
        if (nonce < 0L) {
            OutboundEstablishState old;
            while ((old = this._liveIntroductions.putIfAbsent(nonce = this._context.random().nextLong(0xFFFFFFFFL), state)) != null) {
            }
            state.setIntroNonce(nonce);
        }
        this._context.statManager().addRateData("udp.sendIntroRelayRequest", 1L);
        List<UDPPacket> requests = this._builder.buildRelayRequest(this._transport, this, state, this._transport.getIntroKey());
        if (requests.isEmpty()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No valid introducers! " + state);
            }
            this.processExpired(state);
            return;
        }
        for (UDPPacket req : requests) {
            this._transport.send(req);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Send relay request for " + state + " with our intro key as " + this._transport.getIntroKey());
        }
        state.introSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveRelayResponse(RemoteHostId bob, UDPPacketReader reader) {
        long nonce = reader.getRelayResponseReader().readNonce();
        OutboundEstablishState state = this._liveIntroductions.remove(nonce);
        if (state == null) {
            if (this._log.shouldDebug()) {
                this._log.debug("Dup or unknown RelayResponse: " + nonce);
            }
            return;
        }
        int sz = reader.getRelayResponseReader().readCharlieIPSize();
        byte[] ip = new byte[sz];
        reader.getRelayResponseReader().readCharlieIP(ip, 0);
        int port = reader.getRelayResponseReader().readCharliePort();
        if (!this.isValid(ip, port) || !this.isValid(bob.getIP(), bob.getPort())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Bad relay resp from " + bob + " for " + Addresses.toString((byte[])ip, (int)port));
            }
            this._context.statManager().addRateData("udp.relayBadIP", 1L);
            return;
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Introducer for " + state + " (" + bob + ") sent us an invalid address for our target: " + Addresses.toString((byte[])ip, (int)port), (Throwable)uhe);
            }
            return;
        }
        this._context.statManager().addRateData("udp.receiveIntroRelayResponse", state.getLifetime());
        if (this._log.shouldDebug()) {
            this._log.debug("Received RelayResponse for " + state.getRemoteIdentity().calculateHash() + " - they are on " + addr.toString() + ":" + port + " (according to " + bob + ") nonce=" + nonce);
        }
        OutboundEstablishState outboundEstablishState = state;
        synchronized (outboundEstablishState) {
            RemoteHostId oldId = state.getRemoteHostId();
            state.introduced(ip, port);
            RemoteHostId newId = state.getRemoteHostId();
            this._outboundByHash.put(state.getRemoteIdentity().calculateHash(), state);
            RemoteHostId claimed = state.getClaimedAddress();
            if (!oldId.equals(newId)) {
                this._outboundStates.remove(oldId);
                this._outboundStates.put(newId, state);
                if (this._log.shouldLog(20)) {
                    this._log.info("RR replaced " + oldId + " with " + newId + ", claimed address was " + claimed);
                }
            }
            if (claimed != null) {
                this._outboundByClaimedAddress.remove(oldId, state);
            }
        }
        this.notifyActivity();
    }

    void receiveHolePunch(InetAddress from, int fromPort) {
        RemoteHostId id = new RemoteHostId(from.getAddress(), fromPort);
        OutboundEstablishState state = this._outboundStates.get(id);
        if (state != null) {
            boolean sendNow = state.receiveHolePunch();
            if (sendNow) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Hole punch from " + state + ", sending SessionRequest now");
                }
                this.notifyActivity();
            } else if (this._log.shouldLog(20)) {
                this._log.info("Hole punch from " + state + ", already sent SessionRequest");
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("No state found for hole punch from " + from + " port " + fromPort);
        }
    }

    boolean isValid(byte[] ip, int port) {
        return TransportUtil.isValidPort(port) && ip != null && this._transport.isValid(ip) && !this._transport.isTooClose(ip) && !this._context.blocklist().isBlocklisted(ip);
    }

    private void sendConfirmation(OutboundEstablishState state) {
        UDPPacket[] packets;
        boolean valid = state.validateSessionCreated();
        if (!valid) {
            if (this._log.shouldLog(30)) {
                this._log.warn("SessionCreated validate failed: " + state);
            }
            return;
        }
        if (!this._transport.isValid(state.getReceivedIP()) || !this._transport.isValid(state.getRemoteHostId().getIP())) {
            state.fail();
            return;
        }
        this._transport.externalAddressReceived(state.getRemoteIdentity().calculateHash(), state.getReceivedIP(), state.getReceivedPort());
        int version = state.getVersion();
        if (version == 1) {
            state.prepareSessionConfirmed();
            packets = this._builder.buildSessionConfirmedPackets(state, this._context.router().getRouterInfo().getIdentity());
        } else {
            OutboundEstablishState2 state2 = (OutboundEstablishState2)state;
            OutboundEstablishState.OutboundState ostate = state2.getState();
            if (ostate == OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY) {
                return;
            }
            packets = this._builder2.buildSessionConfirmedPackets(state2, this._context.router().getRouterInfo());
        }
        if (packets == null) {
            state.fail();
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Send confirm to: " + state);
        }
        for (int i = 0; i < packets.length; ++i) {
            this._transport.send(packets[i]);
        }
        if (version == 1) {
            state.confirmedPacketsSent();
        } else {
            OutboundEstablishState2 state2 = (OutboundEstablishState2)state;
            this.handleCompletelyEstablished(state2);
        }
    }

    private void sendDestroy(OutboundEstablishState state) {
        if (state.getVersion() > 1) {
            return;
        }
        UDPPacket packet = this._builder.buildSessionDestroyPacket(state);
        if (packet != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Send destroy to: " + state);
            }
            this._transport.send(packet);
        }
    }

    private void sendDestroy(InboundEstablishState state) {
        if (state.getVersion() > 1) {
            return;
        }
        UDPPacket packet = this._builder.buildSessionDestroyPacket(state);
        if (packet != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Send destroy to: " + state);
            }
            this._transport.send(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handleInbound() {
        long now = this._context.clock().now();
        long nextSendTime = Long.MAX_VALUE;
        InboundEstablishState inboundState = null;
        boolean expired = false;
        Iterator<InboundEstablishState> iter = this._inboundStates.values().iterator();
        while (iter.hasNext()) {
            InboundEstablishState cur = iter.next();
            InboundEstablishState.InboundState istate = cur.getState();
            if (istate == InboundEstablishState.InboundState.IB_STATE_CONFIRMED_COMPLETELY) {
                iter.remove();
                inboundState = cur;
                break;
            }
            if (cur.getLifetime() > 15000L) {
                iter.remove();
                inboundState = cur;
                if (this._log.shouldDebug()) {
                    this._log.debug("Expired: " + cur);
                }
                expired = true;
                break;
            }
            if (istate == InboundEstablishState.InboundState.IB_STATE_FAILED || istate == InboundEstablishState.InboundState.IB_STATE_COMPLETE) {
                iter.remove();
                continue;
            }
            long next = cur.getNextSendTime();
            if (next <= now) {
                inboundState = cur;
                break;
            }
            if (next >= nextSendTime) continue;
            nextSendTime = next;
        }
        if (inboundState != null) {
            InboundEstablishState inboundEstablishState = inboundState;
            synchronized (inboundEstablishState) {
                InboundEstablishState.InboundState istate = inboundState.getState();
                switch (istate) {
                    case IB_STATE_REQUEST_RECEIVED: 
                    case IB_STATE_TOKEN_REQUEST_RECEIVED: 
                    case IB_STATE_REQUEST_BAD_TOKEN_RECEIVED: {
                        if (expired) {
                            this.processExpired(inboundState);
                            break;
                        }
                        this.sendCreated(inboundState);
                        break;
                    }
                    case IB_STATE_CONFIRMED_PARTIALLY: {
                        if (!expired) break;
                        this.processExpired(inboundState);
                        break;
                    }
                    case IB_STATE_CREATED_SENT: 
                    case IB_STATE_RETRY_SENT: {
                        if (expired) {
                            this.sendDestroy(inboundState);
                            this.processExpired(inboundState);
                            break;
                        }
                        if (inboundState.getNextSendTime() > now) break;
                        if (istate == InboundEstablishState.InboundState.IB_STATE_RETRY_SENT) {
                            inboundState.fail();
                            this.processExpired(inboundState);
                            break;
                        }
                        this.sendCreated(inboundState);
                        break;
                    }
                    case IB_STATE_CONFIRMED_COMPLETELY: {
                        RouterIdentity remote = inboundState.getConfirmedIdentity();
                        if (remote != null) {
                            if (this._context.banlist().isBanlistedForever(remote.calculateHash())) {
                                if (this._log.shouldLog(30)) {
                                    this._log.warn("Dropping inbound connection from permanently banlisted peer: " + remote.calculateHash());
                                }
                                this._context.blocklist().add(inboundState.getSentIP());
                                inboundState.fail();
                                this.processExpired(inboundState);
                                break;
                            }
                            this.handleCompletelyEstablished(inboundState);
                            break;
                        }
                        if (this._log.shouldLog(30)) {
                            this._log.warn("confirmed with invalid? " + inboundState);
                        }
                        inboundState.fail();
                        this.processExpired(inboundState);
                        break;
                    }
                    case IB_STATE_COMPLETE: 
                    case IB_STATE_FAILED: {
                        break;
                    }
                    case IB_STATE_UNKNOWN: {
                        if (!this._log.shouldLog(40)) break;
                        this._log.error("hrm, state is unknown for " + inboundState);
                        break;
                    }
                    default: {
                        if (!this._log.shouldWarn()) break;
                        this._log.warn("Unhandled state on " + inboundState);
                    }
                }
            }
            nextSendTime = now;
        }
        return nextSendTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handleOutbound() {
        long now = this._context.clock().now();
        long nextSendTime = Long.MAX_VALUE;
        OutboundEstablishState outboundState = null;
        Iterator<OutboundEstablishState> iter = this._outboundStates.values().iterator();
        while (iter.hasNext()) {
            OutboundEstablishState cur = iter.next();
            OutboundEstablishState.OutboundState state = cur.getState();
            if (state == OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY || state == OutboundEstablishState.OutboundState.OB_STATE_VALIDATION_FAILED) {
                iter.remove();
                outboundState = cur;
                break;
            }
            if (cur.getLifetime() >= 35000L) {
                iter.remove();
                outboundState = cur;
                break;
            }
            long next = cur.getNextSendTime();
            if (next <= now) {
                outboundState = cur;
                break;
            }
            if (next >= nextSendTime) continue;
            nextSendTime = next;
        }
        if (outboundState != null) {
            OutboundEstablishState outboundEstablishState = outboundState;
            synchronized (outboundEstablishState) {
                boolean expired = outboundState.getLifetime() >= 35000L;
                switch (outboundState.getState()) {
                    case OB_STATE_UNKNOWN: 
                    case OB_STATE_INTRODUCED: 
                    case OB_STATE_NEEDS_TOKEN: {
                        if (expired) {
                            this.processExpired(outboundState);
                            break;
                        }
                        this.sendRequest(outboundState);
                        break;
                    }
                    case OB_STATE_REQUEST_SENT: 
                    case OB_STATE_TOKEN_REQUEST_SENT: 
                    case OB_STATE_RETRY_RECEIVED: 
                    case OB_STATE_REQUEST_SENT_NEW_TOKEN: {
                        long rtime = outboundState.getRequestSentTime();
                        if (expired || rtime > 0L && rtime + 15000L <= now) {
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.sendRequest(outboundState);
                        break;
                    }
                    case OB_STATE_CREATED_RECEIVED: {
                        if (expired) {
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.sendConfirmation(outboundState);
                        break;
                    }
                    case OB_STATE_CONFIRMED_PARTIALLY: {
                        long ctime = outboundState.getConfirmedSentTime();
                        if (expired || ctime > 0L && ctime + 15000L <= now) {
                            this.sendDestroy(outboundState);
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.sendConfirmation(outboundState);
                        break;
                    }
                    case OB_STATE_CONFIRMED_COMPLETELY: {
                        if (expired) {
                            this.processExpired(outboundState);
                            break;
                        }
                        this.handleCompletelyEstablished(outboundState);
                        break;
                    }
                    case OB_STATE_PENDING_INTRO: {
                        long itime = outboundState.getIntroSentTime();
                        if (expired || itime > 0L && itime + 15000L <= now) {
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.handlePendingIntro(outboundState);
                        break;
                    }
                    case OB_STATE_VALIDATION_FAILED: {
                        this.processExpired(outboundState);
                        break;
                    }
                    default: {
                        if (!this._log.shouldWarn()) break;
                        this._log.warn("Unhandled state on " + outboundState);
                    }
                }
            }
            nextSendTime = now;
        }
        return nextSendTime;
    }

    private void processExpired(OutboundEstablishState outboundState) {
        RemoteHostId claimed;
        boolean removed;
        long nonce = outboundState.getIntroNonce();
        if (nonce >= 0L && (removed = this._liveIntroductions.remove(nonce, outboundState))) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Relay request for " + outboundState + " timed out");
            }
            this._context.statManager().addRateData("udp.sendIntroRelayTimeout", 1L);
        }
        if ((claimed = outboundState.getClaimedAddress()) != null) {
            this._outboundByClaimedAddress.remove(claimed, outboundState);
        }
        this._outboundByHash.remove(outboundState.getRemoteIdentity().calculateHash(), outboundState);
        this._outboundStates.remove(outboundState.getRemoteHostId(), outboundState);
        if (outboundState.getState() != OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY) {
            OutNetMessage msg;
            if (this._log.shouldDebug()) {
                this._log.debug("Expired: " + outboundState + " Lifetime: " + outboundState.getLifetime());
            }
            while ((msg = outboundState.getNextQueuedMessage()) != null) {
                this._transport.failed(msg, "Expired during failed establish");
            }
            String err = "Took too long to establish OB connection, state = " + (Object)((Object)outboundState.getState());
            Hash peer = outboundState.getRemoteIdentity().calculateHash();
            this._transport.markUnreachable(peer);
            this._transport.dropPeer(peer, false, err);
            outboundState.fail();
        } else {
            OutNetMessage msg;
            while ((msg = outboundState.getNextQueuedMessage()) != null) {
                this._transport.send(msg);
            }
        }
    }

    private void processExpired(InboundEstablishState inboundState) {
        OutNetMessage msg;
        this._inboundStates.remove(inboundState.getRemoteHostId());
        while ((msg = inboundState.getNextQueuedMessage()) != null) {
            this._transport.failed(msg, "Expired during failed establish");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutboundToken(RemoteHostId peer, long token, long expires) {
        if (expires < this._context.clock().now()) {
            return;
        }
        Token tok = new Token(token, expires);
        Map<RemoteHostId, Token> map = this._outboundTokens;
        synchronized (map) {
            this._outboundTokens.put(peer, tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOutboundToken(RemoteHostId peer) {
        Token tok;
        Map<RemoteHostId, Token> map = this._outboundTokens;
        synchronized (map) {
            tok = this._outboundTokens.remove(peer);
        }
        if (tok == null) {
            return 0L;
        }
        if (tok.expires < this._context.clock().now()) {
            return 0L;
        }
        return tok.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ipChanged(boolean isIPv6) {
        Map.Entry<RemoteHostId, Token> e;
        Iterator<Map.Entry<RemoteHostId, Token>> iter;
        if (!this._enableSSU2) {
            return;
        }
        int len = isIPv6 ? 16 : 4;
        long now = this._context.clock().now();
        Map<RemoteHostId, Token> map = this._outboundTokens;
        synchronized (map) {
            iter = this._outboundTokens.entrySet().iterator();
            while (iter.hasNext()) {
                e = iter.next();
                if (e.getKey().getIP().length != len && e.getValue().expires >= now) continue;
                iter.remove();
            }
        }
        map = this._inboundTokens;
        synchronized (map) {
            iter = this._inboundTokens.entrySet().iterator();
            while (iter.hasNext()) {
                e = iter.next();
                if (e.getKey().getIP().length != len && e.getValue().expires >= now) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void portChanged() {
        if (!this._enableSSU2) {
            return;
        }
        Map<RemoteHostId, Token> map = this._outboundTokens;
        synchronized (map) {
            this._outboundTokens.clear();
        }
        map = this._inboundTokens;
        synchronized (map) {
            this._inboundTokens.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getInboundToken(RemoteHostId peer) {
        long token;
        while ((token = this._context.random().nextLong()) == 0L) {
        }
        long expires = this._context.clock().now() + 3600000L;
        Token tok = new Token(token, expires);
        Map<RemoteHostId, Token> map = this._inboundTokens;
        synchronized (map) {
            this._inboundTokens.put(peer, tok);
        }
        return tok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInboundTokenValid(RemoteHostId peer, long token) {
        Token tok;
        if (token == 0L) {
            return false;
        }
        Map<RemoteHostId, Token> map = this._inboundTokens;
        synchronized (map) {
            tok = this._inboundTokens.get(peer);
            if (tok == null) {
                return false;
            }
            if (tok.token != token) {
                return false;
            }
            this._inboundTokens.remove(peer);
        }
        return tok.expires >= this._context.clock().now();
    }

    private class Establisher
    implements Runnable {
        private long _lastFailsafe;
        private static final long FAILSAFE_INTERVAL = 180000L;
        private long _lastPrinted;
        private static final long PRINT_INTERVAL = 5000L;

        private Establisher() {
        }

        @Override
        public void run() {
            while (EstablishmentManager.this._alive) {
                try {
                    this.doPass();
                }
                catch (RuntimeException re) {
                    EstablishmentManager.this._log.error("Error in the establisher", (Throwable)re);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            EstablishmentManager.this._inboundStates.clear();
            EstablishmentManager.this._outboundStates.clear();
            EstablishmentManager.this._queuedOutbound.clear();
            EstablishmentManager.this._outboundByClaimedAddress.clear();
            EstablishmentManager.this._outboundByHash.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doPass() {
            long nextSendTime;
            long delay;
            long now = EstablishmentManager.this._context.clock().now();
            if (EstablishmentManager.this._log.shouldLog(10) && this._lastPrinted + 5000L < now) {
                this._lastPrinted = now;
                int iactive = EstablishmentManager.this._inboundStates.size();
                int oactive = EstablishmentManager.this._outboundStates.size();
                if (iactive > 0 || oactive > 0) {
                    int queued = EstablishmentManager.this._queuedOutbound.size();
                    int live = EstablishmentManager.this._liveIntroductions.size();
                    int claimed = EstablishmentManager.this._outboundByClaimedAddress.size();
                    int hash = EstablishmentManager.this._outboundByHash.size();
                    EstablishmentManager.this._log.debug("OB states: " + oactive + " IB states: " + iactive + " OB queued: " + queued + " intros: " + live + " OB claimed: " + claimed + " hash: " + hash);
                }
            }
            EstablishmentManager.this._activity = 0;
            if (this._lastFailsafe + 180000L < now) {
                this._lastFailsafe = now;
                this.doFailsafe();
            }
            if ((delay = (nextSendTime = Math.min(EstablishmentManager.this.handleInbound(), EstablishmentManager.this.handleOutbound())) - now) > 0L) {
                if (delay > 1000L) {
                    delay = 1000L;
                }
                try {
                    Object object = EstablishmentManager.this._activityLock;
                    synchronized (object) {
                        if (EstablishmentManager.this._activity > 0) {
                            return;
                        }
                        EstablishmentManager.this._activityLock.wait(delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private void doFailsafe() {
            OutboundEstablishState state;
            Iterator iter = EstablishmentManager.this._liveIntroductions.values().iterator();
            while (iter.hasNext()) {
                state = (OutboundEstablishState)iter.next();
                if (state.getLifetime() <= 105000L) continue;
                iter.remove();
                if (!EstablishmentManager.this._log.shouldLog(30)) continue;
                EstablishmentManager.this._log.warn("Failsafe remove LI " + state);
            }
            iter = EstablishmentManager.this._outboundByClaimedAddress.values().iterator();
            while (iter.hasNext()) {
                state = (OutboundEstablishState)iter.next();
                if (state.getLifetime() <= 105000L) continue;
                iter.remove();
                if (!EstablishmentManager.this._log.shouldLog(30)) continue;
                EstablishmentManager.this._log.warn("Failsafe remove OBBCA " + state);
            }
            iter = EstablishmentManager.this._outboundByHash.values().iterator();
            while (iter.hasNext()) {
                state = (OutboundEstablishState)iter.next();
                if (state.getLifetime() <= 105000L) continue;
                iter.remove();
                if (!EstablishmentManager.this._log.shouldLog(30)) continue;
                EstablishmentManager.this._log.warn("Failsafe remove OBBH " + state);
            }
        }
    }

    public static class Token {
        public final long token;
        public final long expires;

        public Token(long tok, long exp) {
            this.token = tok;
            this.expires = exp;
        }
    }
}

