/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import com.southernstorm.noise.protocol.ChaChaPolyCipherState;
import com.southernstorm.noise.protocol.HandshakeState;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import net.i2p.I2PAppContext;
import net.i2p.crypto.HKDF;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.OutboundEstablishState;
import net.i2p.router.transport.udp.PeerState2;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SSU2Payload;
import net.i2p.router.transport.udp.SSU2Util;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.HexDump;

class OutboundEstablishState2
extends OutboundEstablishState
implements SSU2Payload.PayloadCallback {
    private InetSocketAddress _bobSocketAddress;
    private final UDPTransport _transport;
    private final long _sendConnID;
    private final long _rcvConnID;
    private final RouterAddress _routerAddress;
    private long _token;
    private HandshakeState _handshakeState;
    private final byte[] _sendHeaderEncryptKey1;
    private final byte[] _rcvHeaderEncryptKey1;
    private byte[] _sendHeaderEncryptKey2;
    private byte[] _rcvHeaderEncryptKey2;
    private final byte[] _rcvRetryHeaderEncryptKey2;
    private int _mtu;
    private byte[] _sessReqForReTX;
    private byte[][] _sessConfForReTX;
    private long _timeReceived;
    private long _skew;
    private PeerState2 _pstate;
    private static final boolean SET_TOKEN = false;
    private static final long MAX_SKEW = 120000L;

    public OutboundEstablishState2(RouterContext ctx, UDPTransport transport, RemoteHostId claimedAddress, RemoteHostId remoteHostId, RouterIdentity remotePeer, boolean needIntroduction, SessionKey introKey, RouterAddress ra, UDPAddress addr) throws IllegalArgumentException {
        super(ctx, claimedAddress, remoteHostId, remotePeer, needIntroduction, introKey, addr);
        long rcid;
        int mtu;
        this._transport = transport;
        if (claimedAddress != null) {
            try {
                this._bobSocketAddress = new InetSocketAddress(InetAddress.getByAddress(this._bobIP), this._bobPort);
            }
            catch (UnknownHostException uhe) {
                throw new IllegalArgumentException("bad IP", uhe);
            }
        }
        mtu = (mtu = addr.getMTU()) == 0 ? (ra.getTransportStyle().equals("SSU2") ? 1500 : (this._bobIP.length == 16 ? 1280 : 1484)) : (ra.getTransportStyle().equals("SSU2") ? Math.min(Math.max(mtu, 1280), 1500) : (this._bobIP.length == 16 ? Math.min(Math.max(mtu, 1280), 1488) : Math.min(Math.max(mtu, 1292), 1484)));
        this._mtu = mtu;
        if (addr.getIntroducerCount() > 0) {
            if (this._log.shouldLog(10)) {
                this._log.debug("new outbound establish to " + remotePeer.calculateHash() + ", with address: " + addr);
            }
            this._currentState = OutboundEstablishState.OutboundState.OB_STATE_PENDING_INTRO;
        } else {
            this._currentState = OutboundEstablishState.OutboundState.OB_STATE_UNKNOWN;
        }
        this._sendConnID = ctx.random().nextLong();
        while (this._sendConnID == (rcid = ctx.random().nextLong())) {
        }
        this._rcvConnID = rcid;
        this._token = this._transport.getEstablisher().getOutboundToken(this._remoteHostId);
        this._routerAddress = ra;
        if (this._token != 0L) {
            this.createNewState(ra);
        } else {
            this._currentState = OutboundEstablishState.OutboundState.OB_STATE_NEEDS_TOKEN;
        }
        byte[] ik = introKey.getData();
        this._sendHeaderEncryptKey1 = ik;
        this._rcvHeaderEncryptKey1 = ik;
        this._sendHeaderEncryptKey2 = ik;
        this._rcvRetryHeaderEncryptKey2 = ik;
        if (this._log.shouldDebug()) {
            this._log.debug("New " + this);
        }
    }

    private void createNewState(RouterAddress addr) {
        String ss = addr.getOption("s");
        if (ss == null) {
            throw new IllegalArgumentException("no SSU2 S");
        }
        byte[] publicKey = Base64.decode((String)ss);
        if (publicKey == null) {
            throw new IllegalArgumentException("bad SSU2 S");
        }
        if (publicKey.length != 32) {
            throw new IllegalArgumentException("bad SSU2 S len");
        }
        try {
            this._handshakeState = new HandshakeState("XK-SSU2", 1, this._transport.getXDHFactory());
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException("bad proto", gse);
        }
        this._handshakeState.getRemotePublicKey().setPublicKey(publicKey, 0);
        this._handshakeState.getLocalKeyPair().setKeys(this._transport.getSSU2StaticPrivKey(), 0, this._transport.getSSU2StaticPubKey(), 0);
    }

    public synchronized void restart(long token) {
        this._token = token;
        HandshakeState old = this._handshakeState;
        if (old != null) {
            old.destroy();
        }
        this.createNewState(this._routerAddress);
        this._rcvHeaderEncryptKey2 = null;
    }

    private void processPayload(byte[] payload, int offset, int length, boolean isHandshake) throws GeneralSecurityException {
        try {
            int blocks = SSU2Payload.processPayload(this._context, this, payload, offset, length, isHandshake);
            if (this._log.shouldDebug()) {
                this._log.debug("Processed " + blocks + " blocks");
            }
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Session Created payload error", e);
        }
    }

    @Override
    public void gotDateTime(long time) {
        this._timeReceived = time;
    }

    @Override
    public void gotOptions(byte[] options, boolean isHandshake) {
        if (this._log.shouldDebug()) {
            this._log.debug("Got OPTIONS block");
        }
    }

    @Override
    public void gotRI(RouterInfo ri, boolean isHandshake, boolean flood) throws DataFormatException {
        throw new DataFormatException("RI in Sess Created");
    }

    @Override
    public void gotRIFragment(byte[] data, boolean isHandshake, boolean flood, boolean isGzipped, int frag, int totalFrags) {
        throw new IllegalStateException("RI in Sess Created");
    }

    @Override
    public void gotAddress(byte[] ip, int port) {
        if (this._log.shouldDebug()) {
            this._log.debug("Got Address: " + Addresses.toString((byte[])ip, (int)port));
        }
        this._aliceIP = ip;
        this._alicePort = port;
    }

    @Override
    public void gotRelayTagRequest() {
        throw new IllegalStateException("Relay tag req in Sess Created");
    }

    @Override
    public void gotRelayTag(long tag) {
    }

    @Override
    public void gotRelayRequest(byte[] data) {
    }

    @Override
    public void gotRelayResponse(int status, byte[] data) {
    }

    @Override
    public void gotRelayIntro(Hash aliceHash, byte[] data) {
    }

    @Override
    public void gotPeerTest(int msg, int status, Hash h, byte[] data) {
    }

    @Override
    public void gotToken(long token, long expires) {
        this._transport.getEstablisher().addOutboundToken(this._remoteHostId, token, expires);
    }

    @Override
    public void gotI2NP(I2NPMessage msg) {
        throw new IllegalStateException("I2NP in Sess Created");
    }

    @Override
    public void gotFragment(byte[] data, int off, int len, long messageId, int frag, boolean isLast) throws DataFormatException {
        throw new DataFormatException("I2NP in Sess Created");
    }

    @Override
    public void gotACK(long ackThru, int acks, byte[] ranges) {
        throw new IllegalStateException("ACK in Sess Created");
    }

    @Override
    public void gotTermination(int reason, long count) {
        if (this._log.shouldWarn()) {
            this._log.warn("Got TERMINATION block, reason: " + reason + " count: " + count);
        }
        this.fail();
        this._transport.getEstablisher().receiveSessionDestroy(this._remoteHostId, this);
    }

    @Override
    public synchronized boolean validateSessionCreated() {
        boolean rv = this._currentState == OutboundEstablishState.OutboundState.OB_STATE_CREATED_RECEIVED || this._currentState == OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY;
        return rv;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    public long getSendConnID() {
        return this._sendConnID;
    }

    public long getRcvConnID() {
        return this._rcvConnID;
    }

    public long getToken() {
        return this._token;
    }

    public EstablishmentManager.Token getNextToken() {
        return this._transport.getEstablisher().getInboundToken(this._remoteHostId);
    }

    public HandshakeState getHandshakeState() {
        return this._handshakeState;
    }

    public byte[] getSendHeaderEncryptKey1() {
        return this._sendHeaderEncryptKey1;
    }

    public byte[] getRcvHeaderEncryptKey1() {
        return this._rcvHeaderEncryptKey1;
    }

    public byte[] getSendHeaderEncryptKey2() {
        return this._sendHeaderEncryptKey2;
    }

    public byte[] getRcvHeaderEncryptKey2() {
        return this._rcvHeaderEncryptKey2;
    }

    public byte[] getRcvRetryHeaderEncryptKey2() {
        return this._rcvRetryHeaderEncryptKey2;
    }

    public InetSocketAddress getSentAddress() {
        return this._bobSocketAddress;
    }

    public int getMTU() {
        return this._mtu;
    }

    public synchronized void receiveRetry(UDPPacket packet) throws GeneralSecurityException {
        DatagramPacket pkt = packet.getPacket();
        SocketAddress from = pkt.getSocketAddress();
        if (!from.equals(this._bobSocketAddress)) {
            throw new GeneralSecurityException("Address mismatch: req: " + this._bobSocketAddress + " conf: " + from);
        }
        int off = pkt.getOffset();
        int len = pkt.getLength();
        byte[] data = pkt.getData();
        long rid = DataHelper.fromLong8((byte[])data, (int)off);
        if (rid != this._rcvConnID) {
            throw new GeneralSecurityException("Conn ID mismatch: 1: " + this._rcvConnID + " 2: " + rid);
        }
        long sid = DataHelper.fromLong8((byte[])data, (int)(off + 16));
        if (sid != this._sendConnID) {
            throw new GeneralSecurityException("Conn ID mismatch: 1: " + this._sendConnID + " 2: " + sid);
        }
        long token = DataHelper.fromLong8((byte[])data, (int)(off + 24));
        if (token == 0L) {
            throw new GeneralSecurityException("Bad token 0 in retry");
        }
        this._token = token;
        this._timeReceived = 0L;
        ChaChaPolyCipherState chacha = new ChaChaPolyCipherState();
        chacha.initializeKey(this._rcvHeaderEncryptKey1, 0);
        long n = DataHelper.fromLong((byte[])data, (int)(off + 8), (int)4);
        chacha.setNonce(n);
        try {
            chacha.decryptWithAd(data, off, 32, data, off + 32, data, off + 32, len - 32);
            this.processPayload(data, off + 32, len - 48, true);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldDebug()) {
                this._log.debug("Retry error", (Throwable)gse);
            }
            throw gse;
        }
        finally {
            chacha.destroy();
        }
        this.packetReceived();
        if (this._currentState == OutboundEstablishState.OutboundState.OB_STATE_VALIDATION_FAILED) {
            return;
        }
        if (this._timeReceived == 0L) {
            throw new GeneralSecurityException("No DateTime block in Session/Token Request");
        }
        this._skew = this._nextSend - this._timeReceived;
        if (this._skew > 120000L || this._skew < -120000L) {
            throw new GeneralSecurityException("Skew exceeded in Session/Token Request: " + this._skew);
        }
        this.createNewState(this._routerAddress);
        if (this._log.shouldDebug()) {
            this._log.debug("Received a retry on " + this);
        }
        this._currentState = OutboundEstablishState.OutboundState.OB_STATE_RETRY_RECEIVED;
    }

    public synchronized void receiveSessionCreated(UDPPacket packet) throws GeneralSecurityException {
        if (this._currentState == OutboundEstablishState.OutboundState.OB_STATE_VALIDATION_FAILED) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Session created already failed");
            }
            return;
        }
        DatagramPacket pkt = packet.getPacket();
        SocketAddress from = pkt.getSocketAddress();
        if (!from.equals(this._bobSocketAddress)) {
            throw new GeneralSecurityException("Address mismatch: req: " + this._bobSocketAddress + " created: " + from);
        }
        int off = pkt.getOffset();
        int len = pkt.getLength();
        byte[] data = pkt.getData();
        long rid = DataHelper.fromLong8((byte[])data, (int)off);
        if (rid != this._rcvConnID) {
            throw new GeneralSecurityException("Conn ID mismatch: 1: " + this._rcvConnID + " 2: " + rid);
        }
        long sid = DataHelper.fromLong8((byte[])data, (int)(off + 16));
        if (sid != this._sendConnID) {
            throw new GeneralSecurityException("Conn ID mismatch: 1: " + this._sendConnID + " 2: " + sid);
        }
        this._handshakeState.mixHash(data, off, 32);
        try {
            this._handshakeState.readMessage(data, off + 32, len - 32, data, off + 32);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldDebug()) {
                this._log.debug("Session create error, State at failure: " + this._handshakeState + '\n' + HexDump.dump((byte[])data, (int)off, (int)len), (Throwable)gse);
            }
            throw gse;
        }
        this._timeReceived = 0L;
        this.processPayload(data, off + 32, len - (32 + SSU2Util.KEY_LEN + 16), true);
        this.packetReceived();
        if (this._currentState == OutboundEstablishState.OutboundState.OB_STATE_VALIDATION_FAILED) {
            return;
        }
        if (this._timeReceived == 0L) {
            throw new GeneralSecurityException("No DateTime block in Session/Token Request");
        }
        this._skew = this._nextSend - this._timeReceived;
        if (this._skew > 120000L || this._skew < -120000L) {
            throw new GeneralSecurityException("Skew exceeded in Session/Token Request: " + this._skew);
        }
        this._sessReqForReTX = null;
        this._sendHeaderEncryptKey2 = SSU2Util.hkdf(this._context, this._handshakeState.getChainingKey(), "SessionConfirmed");
        this._currentState = OutboundEstablishState.OutboundState.OB_STATE_CREATED_RECEIVED;
        if (this._requestSentCount == 1) {
            this._rtt = (int)(this._nextSend - this._requestSentTime);
        }
    }

    public synchronized void tokenRequestSent(DatagramPacket packet) {
        OutboundEstablishState.OutboundState old = this._currentState;
        this.requestSent();
        if (old == OutboundEstablishState.OutboundState.OB_STATE_NEEDS_TOKEN) {
            this._currentState = OutboundEstablishState.OutboundState.OB_STATE_TOKEN_REQUEST_SENT;
        }
    }

    public synchronized void requestSent(DatagramPacket pkt) {
        OutboundEstablishState.OutboundState old = this._currentState;
        this.requestSent();
        if (this._sessReqForReTX == null) {
            byte[] data = pkt.getData();
            int off = pkt.getOffset();
            int len = pkt.getLength();
            this._sessReqForReTX = new byte[len];
            System.arraycopy(data, off, this._sessReqForReTX, 0, len);
            if (this._requestSentCount > 1) {
                this._requestSentCount = 1;
                this._nextSend = this._lastSend + 3000L;
            }
        }
        if (this._rcvHeaderEncryptKey2 == null) {
            this._rcvHeaderEncryptKey2 = SSU2Util.hkdf(this._context, this._handshakeState.getChainingKey(), "SessCreateHeader");
        }
        if (old == OutboundEstablishState.OutboundState.OB_STATE_RETRY_RECEIVED) {
            this._currentState = OutboundEstablishState.OutboundState.OB_STATE_REQUEST_SENT_NEW_TOKEN;
        }
    }

    public synchronized PeerState2 confirmedPacketsSent(UDPPacket[] packets) {
        if (this._sessConfForReTX == null) {
            this._sessConfForReTX = new byte[packets.length][];
            for (int i = 0; i < packets.length; ++i) {
                DatagramPacket pkt = packets[i].getPacket();
                byte[] data = pkt.getData();
                int off = pkt.getOffset();
                int len = pkt.getLength();
                byte[] save = new byte[len];
                System.arraycopy(data, off, save, 0, len);
                this._sessConfForReTX[i] = save;
            }
            if (this._rcvHeaderEncryptKey2 == null) {
                this._rcvHeaderEncryptKey2 = SSU2Util.hkdf(this._context, this._handshakeState.getChainingKey(), "SessCreateHeader");
            }
            byte[] ckd = this._handshakeState.getChainingKey();
            byte[] k_ab = new byte[32];
            byte[] k_ba = new byte[32];
            HKDF hkdf = new HKDF((I2PAppContext)this._context);
            hkdf.calculate(ckd, SSU2Util.ZEROLEN, k_ab, k_ba, 0);
            byte[] d_ab = new byte[32];
            byte[] h_ab = new byte[32];
            byte[] d_ba = new byte[32];
            byte[] h_ba = new byte[32];
            hkdf.calculate(k_ab, SSU2Util.ZEROLEN, "HKDFSSU2DataKeys", d_ab, h_ab, 0);
            hkdf.calculate(k_ba, SSU2Util.ZEROLEN, "HKDFSSU2DataKeys", d_ba, h_ba, 0);
            ChaChaPolyCipherState sender = new ChaChaPolyCipherState();
            sender.initializeKey(d_ab, 0);
            ChaChaPolyCipherState rcvr = new ChaChaPolyCipherState();
            rcvr.initializeKey(d_ba, 0);
            this._handshakeState.destroy();
            if (this._requestSentCount == 1) {
                this._rtt = (int)(this._context.clock().now() - this._lastSend);
            }
            this._pstate = new PeerState2(this._context, this._transport, this._bobSocketAddress, this._remotePeer.calculateHash(), false, this._rtt, sender, rcvr, this._sendConnID, this._rcvConnID, this._sendHeaderEncryptKey1, h_ab, h_ba);
            this._currentState = OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY;
            this._pstate.confirmedPacketsSent(this._sessConfForReTX);
            this._pstate.adjustClockSkew(this._skew - (long)(this._rtt / 2) - 100L);
            this._pstate.setHisMTU(this._mtu);
            this._pstate.setOurAddress(this._aliceIP, this._alicePort);
        }
        this.confirmedPacketsSent();
        return this._pstate;
    }

    public synchronized UDPPacket getRetransmitSessionRequestPacket() {
        if (this._sessReqForReTX == null) {
            return null;
        }
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        System.arraycopy(this._sessReqForReTX, 0, data, off, this._sessReqForReTX.length);
        pkt.setLength(this._sessReqForReTX.length);
        pkt.setSocketAddress(this._bobSocketAddress);
        packet.setMessageType(72);
        packet.setPriority(550);
        this.requestSent();
        return packet;
    }

    public synchronized PeerState2 getPeerState() {
        this._currentState = OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY;
        return this._pstate;
    }

    @Override
    public String toString() {
        return "OES2 " + this._remoteHostId + " lifetime: " + DataHelper.formatDuration((long)this.getLifetime()) + " Rcv ID: " + this._rcvConnID + " Send ID: " + this._sendConnID + ' ' + (Object)((Object)this._currentState);
    }
}

