/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.InboundEstablishState;
import net.i2p.router.transport.udp.InboundEstablishState2;
import net.i2p.router.transport.udp.InboundMessageFragments;
import net.i2p.router.transport.udp.IntroductionManager;
import net.i2p.router.transport.udp.OutboundEstablishState;
import net.i2p.router.transport.udp.OutboundEstablishState2;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerState2;
import net.i2p.router.transport.udp.PeerTestManager;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SSU2Header;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.router.util.CoDelBlockingQueue;
import net.i2p.util.I2PThread;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class PacketHandler {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final EstablishmentManager _establisher;
    private final InboundMessageFragments _inbound;
    private final PeerTestManager _testManager;
    private final IntroductionManager _introManager;
    private volatile boolean _keepReading;
    private final Handler[] _handlers;
    private final Map<RemoteHostId, Object> _failCache;
    private final BlockingQueue<UDPPacket> _inboundQueue;
    private static final Object DUMMY = new Object();
    private final boolean _enableSSU2;
    private final int _networkID;
    private static final int TYPE_POISON = -99999;
    private static final int MIN_QUEUE_SIZE = 16;
    private static final int MAX_QUEUE_SIZE = 192;
    private static final int MIN_NUM_HANDLERS = 1;
    private static final int MAX_NUM_HANDLERS = 1;
    private static final long GRACE_PERIOD = 90000L;
    private static final long MAX_SKEW = 7776000000L;

    PacketHandler(RouterContext ctx, UDPTransport transport, boolean enableSSU2, EstablishmentManager establisher, InboundMessageFragments inbound, PeerTestManager testManager, IntroductionManager introManager) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(PacketHandler.class);
        this._transport = transport;
        this._enableSSU2 = enableSSU2;
        this._establisher = establisher;
        this._inbound = inbound;
        this._testManager = testManager;
        this._introManager = introManager;
        this._failCache = new LHMCache(24);
        this._networkID = ctx.router().getNetworkID();
        long maxMemory = SystemVersion.getMaxMemory();
        int qsize = (int)Math.max(16L, Math.min(192L, maxMemory / 0x200000L));
        this._inboundQueue = new CoDelBlockingQueue<UDPPacket>(ctx, "UDP-Receiver", qsize);
        int num_handlers = maxMemory < 0x2000000L ? 1 : (maxMemory < 0x4000000L ? 2 : Math.max(1, Math.min(1, ctx.bandwidthLimiter().getInboundKBytesPerSecond() / 20)));
        this._handlers = new Handler[num_handlers];
        for (int i = 0; i < num_handlers; ++i) {
            this._handlers[i] = new Handler();
        }
        this._context.statManager().createRateStat("udp.receivePacketSkew", "How long ago after the packet was sent did we receive it", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidUnkown", "How old the packet we dropped due to invalidity (unkown type) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidReestablish", "How old the packet we dropped due to invalidity (doesn't use existing key, not an establishment) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidEstablish", "How old the packet we dropped due to invalidity (establishment, bad key) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidEstablish.inbound", "How old the packet we dropped due to invalidity (even though we have an active inbound establishment with the peer) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidEstablish.outbound", "How old the packet we dropped due to invalidity (even though we have an active outbound establishment with the peer) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidEstablish.new", "How old the packet we dropped due to invalidity (even though we do not have any active establishment with the peer) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidInboundEstablish", "How old the packet we dropped due to invalidity (inbound establishment, bad key) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidSkew", "How skewed the packet we dropped due to invalidity (valid except bad skew) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.destroyedInvalidSkew", "Destroyed session due to bad skew", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.dataKnown", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.dataKnownAck", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.dataUnknown", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.dataUnknownAck", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
    }

    public synchronized void startup() {
        this._keepReading = true;
        for (int i = 0; i < this._handlers.length; ++i) {
            I2PThread t = new I2PThread((Runnable)this._handlers[i], "UDP Packet handler " + (i + 1) + '/' + this._handlers.length, true);
            t.start();
        }
    }

    public synchronized void shutdown() {
        this._keepReading = false;
        this.stopQueue();
    }

    String getHandlerStatus() {
        StringBuilder rv = new StringBuilder();
        rv.append("Handlers: ").append(this._handlers.length);
        for (int i = 0; i < this._handlers.length; ++i) {
            Handler handler = this._handlers[i];
            rv.append(" handler ").append(i);
        }
        return rv.toString();
    }

    public void queueReceived(UDPPacket packet) throws InterruptedException {
        this._inboundQueue.put(packet);
    }

    private void stopQueue() {
        int i;
        this._inboundQueue.clear();
        for (i = 0; i < this._handlers.length; ++i) {
            UDPPacket poison = UDPPacket.acquire(this._context, false);
            poison.setMessageType(-99999);
            this._inboundQueue.offer(poison);
        }
        for (i = 1; i <= 5 && !this._inboundQueue.isEmpty(); ++i) {
            try {
                Thread.sleep(i * 50);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._inboundQueue.clear();
    }

    public UDPPacket receiveNext() {
        UDPPacket rv = null;
        while (this._keepReading && rv == null) {
            try {
                rv = this._inboundQueue.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (rv == null || rv.getMessageType() != -99999) continue;
            return null;
        }
        return rv;
    }

    private boolean validate(UDPPacket packet, SessionKey key) {
        return packet.validate(key, this._transport.getHMAC());
    }

    private void receiveSSU2Packet(UDPPacket packet, PeerState2 state) {
        state.receivePacket(packet);
    }

    private boolean receiveSSU2Packet(RemoteHostId from, UDPPacket packet, InboundEstablishState2 state) {
        int type;
        SSU2Header.Header header;
        byte[] k1 = this._transport.getSSU2StaticIntroKey();
        if (state == null) {
            byte[] k2 = k1;
            header = SSU2Header.trialDecryptHandshakeHeader(packet, k1, k2);
            if (header == null || header.getType() != 0 || header.getVersion() != 2 || header.getNetID() != this._networkID) {
                if (header != null && this._log.shouldInfo()) {
                    this._log.info("Does not decrypt as Session Request, attempt to decrypt as Token Request/Peer Test: " + header + " from " + from);
                }
                if ((header = SSU2Header.trialDecryptLongHeader(packet, k1, k2)) == null || header.getVersion() != 2 || header.getNetID() != this._networkID) {
                    return false;
                }
                type = header.getType();
            } else {
                type = 0;
            }
        } else {
            byte[] k2 = state.getRcvHeaderEncryptKey2();
            if (k2 == null) {
                k2 = k1;
                header = SSU2Header.trialDecryptHandshakeHeader(packet, k1, k2);
                if (header == null || header.getType() != 0 || header.getVersion() != 2 || header.getNetID() != this._networkID) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Failed decrypt Session Request after Retry: " + header + " on " + state);
                    }
                    return false;
                }
                if (header.getSrcConnID() != state.getSendConnID()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Bad Source Conn id " + header + " on " + state);
                    }
                    return false;
                }
                if (header.getDestConnID() != state.getRcvConnID()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Bad Dest Conn id " + header + " on " + state);
                    }
                    return false;
                }
                type = 0;
            } else {
                header = SSU2Header.trialDecryptShortHeader(packet, k1, k2);
                if (header == null) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Failed decrypt Session Confirmed on " + state);
                    }
                    return false;
                }
                if (header.getDestConnID() != state.getRcvConnID()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Bad Dest Conn id " + header + " on " + state);
                    }
                    return false;
                }
                if (header.getPacketNumber() != 0L || header.getType() != 2) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Queue possible data packet with header " + header + " on: " + state);
                    }
                    state.queuePossibleDataPacket(packet);
                    return true;
                }
                type = 2;
            }
        }
        SSU2Header.acceptTrialDecrypt(packet, header);
        if (type == 0) {
            if (this._log.shouldDebug()) {
                this._log.debug("Got a Session Request on " + state);
            }
            this._establisher.receiveSessionOrTokenRequest(from, state, packet);
        } else if (type == 10) {
            if (this._log.shouldDebug()) {
                this._log.debug("Got a Token Request on " + state);
            }
            this._establisher.receiveSessionOrTokenRequest(from, state, packet);
        } else if (type == 2) {
            if (this._log.shouldDebug()) {
                this._log.debug("Got a Session Confirmed on " + state);
            }
            this._establisher.receiveSessionConfirmed(state, packet);
        } else if (type == 7) {
            if (this._log.shouldDebug()) {
                this._log.debug("Got a Peer Test");
            }
        } else if (this._log.shouldWarn()) {
            this._log.warn("Got unknown message " + header + " on " + state);
        }
        return true;
    }

    private boolean receiveSSU2Packet(UDPPacket packet, OutboundEstablishState2 state) {
        int type;
        SSU2Header.Header header;
        byte[] k1 = state.getRcvHeaderEncryptKey1();
        byte[] k2 = state.getRcvHeaderEncryptKey2();
        if (k2 != null) {
            header = SSU2Header.trialDecryptHandshakeHeader(packet, k1, k2);
            if (header != null && header.getDestConnID() != state.getRcvConnID()) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad Dest Conn id " + header);
                }
                return false;
            }
        } else {
            header = null;
        }
        if (header == null || header.getType() != 1 || header.getVersion() != 2 || header.getNetID() != this._networkID) {
            if (this._log.shouldInfo()) {
                this._log.info("Does not decrypt as Session Created, attempt to decrypt as Retry: " + header);
            }
            if ((header = SSU2Header.trialDecryptLongHeader(packet, k1, k2 = state.getRcvRetryHeaderEncryptKey2())) == null || header.getType() != 9 || header.getVersion() != 2 || header.getNetID() != this._networkID) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Does not decrypt as Session Created or Retry: " + header + " on " + state);
                }
                return false;
            }
            type = 9;
        } else {
            type = 1;
        }
        if (header.getDestConnID() != state.getRcvConnID()) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad Dest Conn id " + header);
            }
            return false;
        }
        if (header.getSrcConnID() != state.getSendConnID()) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad Source Conn id " + header);
            }
            return false;
        }
        SSU2Header.acceptTrialDecrypt(packet, header);
        if (type == 1) {
            if (this._log.shouldDebug()) {
                this._log.debug("Got a Session Created on " + state);
            }
            this._establisher.receiveSessionCreated(state, packet);
        } else {
            if (this._log.shouldDebug()) {
                this._log.debug("Got a Retry on " + state);
            }
            this._establisher.receiveRetry(state, packet);
        }
        return true;
    }

    private static final String _x(String s) {
        return s;
    }

    private class Handler
    implements Runnable {
        private final UDPPacketReader _reader;

        public Handler() {
            this._reader = new UDPPacketReader(PacketHandler.this._context);
        }

        @Override
        public void run() {
            UDPPacket packet;
            while (PacketHandler.this._keepReading && (packet = PacketHandler.this.receiveNext()) != null) {
                block3: {
                    packet.received();
                    try {
                        this.handlePacket(this._reader, packet);
                    }
                    catch (RuntimeException e) {
                        if (!PacketHandler.this._log.shouldLog(40)) break block3;
                        PacketHandler.this._log.error("Internal error handling " + packet, (Throwable)e);
                    }
                }
                packet.release();
            }
        }

        private void handlePacket(UDPPacketReader reader, UDPPacket packet) {
            RemoteHostId rem = packet.getRemoteHost();
            PeerState state = PacketHandler.this._transport.getPeerState(rem);
            if (state == null) {
                InboundEstablishState est = PacketHandler.this._establisher.getInboundState(rem);
                if (est != null) {
                    if (PacketHandler.this._log.shouldLog(10)) {
                        PacketHandler.this._log.debug("Packet received IS for an inbound establishment");
                    }
                    if (est.getVersion() == 2) {
                        PacketHandler.this.receiveSSU2Packet(rem, packet, (InboundEstablishState2)est);
                    } else {
                        this.receivePacket(reader, packet, est);
                    }
                } else {
                    OutboundEstablishState oest = PacketHandler.this._establisher.getOutboundState(rem);
                    if (oest != null) {
                        if (PacketHandler.this._log.shouldLog(10)) {
                            PacketHandler.this._log.debug("Packet received IS for an outbound establishment");
                        }
                        if (oest.getVersion() == 2) {
                            PacketHandler.this.receiveSSU2Packet(packet, (OutboundEstablishState2)oest);
                        } else {
                            this.receivePacket(reader, packet, oest);
                        }
                    } else {
                        if (PacketHandler.this._log.shouldLog(10)) {
                            PacketHandler.this._log.debug("Packet received is not for an inbound or outbound establishment");
                        }
                        this.receivePacket(reader, packet, PeerType.NEW_PEER);
                    }
                }
            } else if (state.getVersion() == 2) {
                PacketHandler.this.receiveSSU2Packet(packet, (PeerState2)state);
            } else {
                this.receivePacket(reader, packet, state);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void receivePacket(UDPPacketReader reader, UDPPacket packet, PeerState state) {
            AuthType auth;
            block11: {
                auth = AuthType.NONE;
                boolean isValid = PacketHandler.this.validate(packet, state.getCurrentMACKey());
                if (!isValid) {
                    if (state.getNextMACKey() != null) {
                        isValid = PacketHandler.this.validate(packet, state.getNextMACKey());
                    }
                    if (!isValid) {
                        if (PacketHandler.this._log.shouldDebug()) {
                            PacketHandler.this._log.debug("Failed validation with existing con, trying as new con: " + packet);
                        }
                        if (isValid = PacketHandler.this.validate(packet, PacketHandler.this._transport.getIntroKey())) {
                            if (PacketHandler.this._log.shouldLog(10)) {
                                PacketHandler.this._log.debug("Validation with existing con failed, but validation as reestablish/stray passed");
                            }
                            packet.decrypt(PacketHandler.this._transport.getIntroKey());
                            auth = AuthType.INTRO;
                            break block11;
                        } else {
                            InboundEstablishState est = PacketHandler.this._establisher.getInboundState(packet.getRemoteHost());
                            if (est != null) {
                                if (PacketHandler.this._log.shouldLog(10)) {
                                    PacketHandler.this._log.debug("Packet from an existing peer IS for an inbound establishment");
                                }
                                this.receivePacket(reader, packet, est, false);
                                return;
                            }
                            if (PacketHandler.this._log.shouldLog(30)) {
                                PacketHandler.this._log.warn("Validation with existing con failed, and validation as reestablish failed too.  DROP " + packet);
                            }
                            PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidReestablish", packet.getLifetime());
                            return;
                        }
                    }
                    packet.decrypt(state.getNextCipherKey());
                    auth = AuthType.SESSION;
                } else {
                    packet.decrypt(state.getCurrentCipherKey());
                    auth = AuthType.SESSION;
                }
            }
            this.handlePacket(reader, packet, state, null, null, auth);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void receivePacket(UDPPacketReader reader, UDPPacket packet, PeerType peerType) {
            boolean isValid = PacketHandler.this.validate(packet, PacketHandler.this._transport.getIntroKey());
            if (!isValid) {
                boolean alreadyFailed;
                RemoteHostId remoteHost = packet.getRemoteHost();
                Map map = PacketHandler.this._failCache;
                synchronized (map) {
                    alreadyFailed = PacketHandler.this._failCache.get(remoteHost) != null;
                }
                if (!alreadyFailed) {
                    List<PeerState> peers;
                    if (PacketHandler.this._enableSSU2 && peerType == PeerType.NEW_PEER && packet.getPacket().getLength() >= 56) {
                        boolean handled = PacketHandler.this.receiveSSU2Packet(remoteHost, packet, null);
                        if (handled) {
                            return;
                        }
                        if (PacketHandler.this._log.shouldDebug()) {
                            PacketHandler.this._log.debug("Continuing with SSU1 fallback processing, wasn't an SSU2 packet from " + remoteHost);
                        }
                    }
                    if (!(peers = PacketHandler.this._transport.getPeerStatesByIP(remoteHost)).isEmpty()) {
                        StringBuilder buf = new StringBuilder(256);
                        buf.append("Established peers with this IP: ");
                        boolean foundSamePort = false;
                        PeerState state = null;
                        int newPort = remoteHost.getPort();
                        for (PeerState ps : peers) {
                            boolean valid = false;
                            if (PacketHandler.this._log.shouldLog(30)) {
                                long now = PacketHandler.this._context.clock().now();
                                buf.append(ps.getRemoteHostId().toString()).append(" last sent: ").append(now - ps.getLastSendTime()).append(" last rcvd: ").append(now - ps.getLastReceiveTime());
                            }
                            if (ps.getRemotePort() == newPort) {
                                foundSamePort = true;
                                continue;
                            }
                            if (PacketHandler.this.validate(packet, ps.getCurrentMACKey())) {
                                packet.decrypt(ps.getCurrentCipherKey());
                                reader.initialize(packet);
                                if (PacketHandler.this._log.shouldLog(30)) {
                                    buf.append(" VALID type ").append(reader.readPayloadType()).append("; ");
                                }
                                valid = true;
                                if (state != null) continue;
                                state = ps;
                                continue;
                            }
                            if (!PacketHandler.this._log.shouldLog(30)) continue;
                            buf.append(" INVALID; ");
                        }
                        if (state != null && !foundSamePort) {
                            PacketHandler.this._transport.changePeerPort(state, newPort);
                            if (PacketHandler.this._log.shouldLog(30)) {
                                buf.append(" CHANGED PORT TO ").append(newPort).append(" AND HANDLED");
                                PacketHandler.this._log.warn(buf.toString());
                            }
                            this.handlePacket(reader, packet, state, null, null, AuthType.SESSION);
                            return;
                        }
                        if (PacketHandler.this._log.shouldLog(30)) {
                            PacketHandler.this._log.warn(buf.toString());
                        }
                    }
                    Map map2 = PacketHandler.this._failCache;
                    synchronized (map2) {
                        PacketHandler.this._failCache.put(remoteHost, DUMMY);
                    }
                }
                if (PacketHandler.this._log.shouldLog(30)) {
                    PacketHandler.this._log.warn("Cannot validate rcvd pkt (path) wasCached? " + alreadyFailed + ": " + packet);
                }
                PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidEstablish", packet.getLifetime());
                switch (peerType) {
                    case INBOUND_FALLBACK: {
                        PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidEstablish.inbound", packet.getLifetime(), packet.getTimeSinceReceived());
                        break;
                    }
                    case OUTBOUND_FALLBACK: {
                        PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidEstablish.outbound", packet.getLifetime(), packet.getTimeSinceReceived());
                        break;
                    }
                    case NEW_PEER: {
                        PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidEstablish.new", packet.getLifetime(), packet.getTimeSinceReceived());
                    }
                }
                return;
            }
            if (PacketHandler.this._log.shouldLog(10)) {
                PacketHandler.this._log.debug("Valid introduction packet received: " + packet);
            }
            packet.decrypt(PacketHandler.this._transport.getIntroKey());
            this.handlePacket(reader, packet, null, null, null, AuthType.INTRO);
        }

        private void receivePacket(UDPPacketReader reader, UDPPacket packet, InboundEstablishState state) {
            this.receivePacket(reader, packet, state, true);
        }

        private void receivePacket(UDPPacketReader reader, UDPPacket packet, InboundEstablishState state, boolean allowFallback) {
            if (PacketHandler.this._log.shouldLog(10)) {
                StringBuilder buf = new StringBuilder(128);
                buf.append("Attempting to receive a packet on a known inbound state: ");
                buf.append(state);
                buf.append(" MAC key: ").append(state.getMACKey());
                buf.append(" intro key: ").append(PacketHandler.this._transport.getIntroKey());
                PacketHandler.this._log.debug(buf.toString());
            }
            boolean isValid = false;
            if (state.getMACKey() != null) {
                isValid = PacketHandler.this.validate(packet, state.getMACKey());
                if (isValid) {
                    if (PacketHandler.this._log.shouldDebug()) {
                        PacketHandler.this._log.debug("Valid introduction packet received for inbound con: " + packet);
                    }
                    packet.decrypt(state.getCipherKey());
                    this.handlePacket(reader, packet, null, null, null, AuthType.SESSION);
                    return;
                }
                if (PacketHandler.this._log.shouldLog(30)) {
                    PacketHandler.this._log.warn("Invalid introduction packet received for inbound con, falling back: " + packet);
                }
            }
            if (allowFallback) {
                this.receivePacket(reader, packet, PeerType.INBOUND_FALLBACK);
            } else {
                PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidInboundEstablish", packet.getLifetime());
            }
        }

        private void receivePacket(UDPPacketReader reader, UDPPacket packet, OutboundEstablishState state) {
            if (PacketHandler.this._log.shouldLog(10)) {
                StringBuilder buf = new StringBuilder(128);
                buf.append("Attempting to receive a packet on a known outbound state: ");
                buf.append(state);
                buf.append(" MAC key: ").append(state.getMACKey());
                buf.append(" intro key: ").append(state.getIntroKey());
                PacketHandler.this._log.debug(buf.toString());
            }
            boolean isValid = false;
            if (state.getMACKey() != null && (isValid = PacketHandler.this.validate(packet, state.getMACKey()))) {
                if (PacketHandler.this._log.shouldDebug()) {
                    PacketHandler.this._log.debug("Valid introduction packet received for outbound established con: " + packet);
                }
                packet.decrypt(state.getCipherKey());
                this.handlePacket(reader, packet, null, state, null, AuthType.SESSION);
                return;
            }
            isValid = PacketHandler.this.validate(packet, state.getIntroKey());
            if (isValid) {
                if (PacketHandler.this._log.shouldDebug()) {
                    PacketHandler.this._log.debug("Valid packet received for " + state + " with Bob's intro key: " + packet);
                }
                packet.decrypt(state.getIntroKey());
                this.handlePacket(reader, packet, null, state, null, AuthType.BOBINTRO);
                return;
            }
            if (PacketHandler.this._log.shouldLog(30)) {
                PacketHandler.this._log.warn("Invalid introduction packet received for outbound established con with old intro key, falling back: " + packet);
            }
            this.receivePacket(reader, packet, PeerType.OUTBOUND_FALLBACK);
        }

        private void handlePacket(UDPPacketReader reader, UDPPacket packet, PeerState state, OutboundEstablishState outState, InboundEstablishState inState, AuthType auth) {
            boolean skewOK;
            reader.initialize(packet);
            long recvOn = packet.getBegin();
            long sendOn = reader.readTimestamp() * 1000L;
            long skew = recvOn - sendOn;
            int type = reader.readPayloadType();
            boolean typeOK = type <= 8;
            boolean bl = skewOK = skew < 7776000000L && skew > -7776000000L && typeOK;
            if (state != null) {
                if (PacketHandler.this._log.shouldLog(10)) {
                    PacketHandler.this._log.debug("Received packet from " + state.getRemoteHostId().toString() + " with skew " + skew);
                }
                if (auth == AuthType.SESSION && typeOK && (skewOK || state.getMessagesReceived() <= 0)) {
                    state.adjustClockSkew(skew);
                }
            }
            PacketHandler.this._context.statManager().addRateData("udp.receivePacketSkew", skew);
            if (skewOK && !PacketHandler.this._context.clock().getUpdatedSuccessfully()) {
                PacketHandler.this._context.clock().setOffset(0L - skew, true);
                if (skew != 0L) {
                    PacketHandler.this._log.logAlways(30, "NTP failure, UDP adjusting clock by " + DataHelper.formatDuration((long)Math.abs(skew)));
                    skew = 0L;
                }
            }
            if (skew > 90000L) {
                PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidSkew", skew);
                if (state != null && skew > 360000L && state.getPacketsReceived() <= 0) {
                    PacketHandler.this._transport.sendDestroy(state);
                    PacketHandler.this._transport.dropPeer(state, true, "Clock skew");
                    if (state.getRemotePort() == 65520) {
                        PacketHandler.this._context.banlist().banlistRouterForever(state.getRemotePeer(), PacketHandler._x("Excessive clock skew: {0}"), DataHelper.formatDuration((long)skew));
                    } else {
                        PacketHandler.this._context.banlist().banlistRouter(DataHelper.formatDuration((long)skew), state.getRemotePeer(), PacketHandler._x("Excessive clock skew: {0}"));
                    }
                    PacketHandler.this._context.statManager().addRateData("udp.destroyedInvalidSkew", skew);
                    if (PacketHandler.this._log.shouldWarn()) {
                        PacketHandler.this._log.warn("Dropped conn, packet too far in the past: " + new Date(sendOn) + ": " + packet + " PeerState: " + state);
                    }
                } else if (PacketHandler.this._log.shouldWarn()) {
                    PacketHandler.this._log.warn("Packet too far in the past: " + new Date(sendOn) + ": " + packet + " PeerState: " + state);
                }
                return;
            }
            if (skew < -90000L) {
                PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidSkew", 0L - skew);
                if (state != null && skew < -360000L && state.getPacketsReceived() <= 0) {
                    PacketHandler.this._transport.sendDestroy(state);
                    PacketHandler.this._transport.dropPeer(state, true, "Clock skew");
                    if (state.getRemotePort() == 65520) {
                        PacketHandler.this._context.banlist().banlistRouterForever(state.getRemotePeer(), PacketHandler._x("Excessive clock skew: {0}"), DataHelper.formatDuration((long)(0L - skew)));
                    } else {
                        PacketHandler.this._context.banlist().banlistRouter(DataHelper.formatDuration((long)(0L - skew)), state.getRemotePeer(), PacketHandler._x("Excessive clock skew: {0}"));
                    }
                    PacketHandler.this._context.statManager().addRateData("udp.destroyedInvalidSkew", 0L - skew);
                    if (PacketHandler.this._log.shouldWarn()) {
                        PacketHandler.this._log.warn("Dropped conn, packet too far in the future: " + new Date(sendOn) + ": " + packet + " PeerState: " + state);
                    }
                } else if (PacketHandler.this._log.shouldWarn()) {
                    PacketHandler.this._log.warn("Packet too far in the future: " + new Date(sendOn) + ": " + packet + " PeerState: " + state);
                }
                return;
            }
            RemoteHostId from = packet.getRemoteHost();
            switch (type) {
                case 0: {
                    if (auth == AuthType.BOBINTRO) {
                        if (!PacketHandler.this._log.shouldLog(30)) break;
                        PacketHandler.this._log.warn("Dropping type " + type + " auth " + (Object)((Object)auth) + ": " + packet);
                        break;
                    }
                    PacketHandler.this._establisher.receiveSessionRequest(from, inState, reader);
                    break;
                }
                case 2: {
                    if (auth != AuthType.SESSION) {
                        if (!PacketHandler.this._log.shouldLog(30)) break;
                        PacketHandler.this._log.warn("Dropping type " + type + " auth " + (Object)((Object)auth) + ": " + packet);
                        break;
                    }
                    PacketHandler.this._establisher.receiveSessionConfirmed(from, inState, reader);
                    break;
                }
                case 1: {
                    if (auth != AuthType.BOBINTRO && auth != AuthType.SESSION) {
                        if (!PacketHandler.this._log.shouldLog(30)) break;
                        PacketHandler.this._log.warn("Dropping type " + type + " auth " + (Object)((Object)auth) + ": " + packet);
                        break;
                    }
                    PacketHandler.this._establisher.receiveSessionCreated(from, outState, reader);
                    break;
                }
                case 6: {
                    if (auth != AuthType.SESSION) {
                        if (!PacketHandler.this._log.shouldLog(30)) break;
                        PacketHandler.this._log.warn("Dropping type " + type + " auth " + (Object)((Object)auth) + ": " + packet);
                        break;
                    }
                    if (outState != null) {
                        state = PacketHandler.this._establisher.receiveData(outState);
                    }
                    if (PacketHandler.this._log.shouldLog(10)) {
                        PacketHandler.this._log.debug("Received new DATA packet from " + state + ": " + packet);
                    }
                    UDPPacketReader.DataReader dr = reader.getDataReader();
                    if (state != null) {
                        if (PacketHandler.this._log.shouldLog(10)) {
                            StringBuilder msg = new StringBuilder(512);
                            msg.append("Receive ").append(System.identityHashCode(packet));
                            msg.append(" from ").append(state.getRemotePeer().toBase64()).append(" ").append(state.getRemoteHostId());
                            try {
                                int count = dr.readFragmentCount();
                                for (int i = 0; i < count; ++i) {
                                    msg.append(" msg ").append(dr.readMessageId(i));
                                    msg.append(":").append(dr.readMessageFragmentNum(i));
                                    if (!dr.readMessageIsLast(i)) continue;
                                    msg.append("*");
                                }
                            }
                            catch (DataFormatException dataFormatException) {
                                // empty catch block
                            }
                            msg.append(": ").append(dr.toString());
                            PacketHandler.this._log.debug(msg.toString());
                        }
                        PacketHandler.this._inbound.receiveData(state, dr);
                        PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.dataKnown", (long)packet.getPacket().getLength(), packet.getLifetime());
                    } else {
                        PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.dataUnknown", (long)packet.getPacket().getLength(), packet.getLifetime());
                    }
                    try {
                        if (dr.readFragmentCount() > 0) break;
                        PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.dataUnknownAck", (long)packet.getPacket().getLength(), packet.getLifetime());
                    }
                    catch (DataFormatException dataFormatException) {}
                    break;
                }
                case 7: {
                    if (auth == AuthType.BOBINTRO) {
                        if (!PacketHandler.this._log.shouldLog(30)) break;
                        PacketHandler.this._log.warn("Dropping type " + type + " auth " + (Object)((Object)auth) + ": " + packet);
                        break;
                    }
                    if (PacketHandler.this._log.shouldLog(10)) {
                        PacketHandler.this._log.debug("Received test packet: " + reader + " from " + from);
                    }
                    PacketHandler.this._testManager.receiveTest(from, state, auth == AuthType.SESSION, reader);
                    break;
                }
                case 3: {
                    if (auth == AuthType.BOBINTRO) {
                        if (!PacketHandler.this._log.shouldLog(30)) break;
                        PacketHandler.this._log.warn("Dropping type " + type + " auth " + (Object)((Object)auth) + ": " + packet);
                        break;
                    }
                    if (PacketHandler.this._log.shouldDebug()) {
                        PacketHandler.this._log.debug("Received relay request packet: " + reader + " from " + from);
                    }
                    PacketHandler.this._introManager.receiveRelayRequest(from, reader);
                    break;
                }
                case 5: {
                    if (auth != AuthType.SESSION) {
                        if (!PacketHandler.this._log.shouldLog(30)) break;
                        PacketHandler.this._log.warn("Dropping type " + type + " auth " + (Object)((Object)auth) + ": " + packet);
                        break;
                    }
                    if (PacketHandler.this._log.shouldDebug()) {
                        PacketHandler.this._log.debug("Received relay intro packet: " + reader + " from " + from);
                    }
                    PacketHandler.this._introManager.receiveRelayIntro(from, reader);
                    break;
                }
                case 4: {
                    if (auth == AuthType.BOBINTRO) {
                        if (!PacketHandler.this._log.shouldLog(30)) break;
                        PacketHandler.this._log.warn("Dropping type " + type + " auth " + (Object)((Object)auth) + ": " + packet);
                        break;
                    }
                    if (PacketHandler.this._log.shouldDebug()) {
                        PacketHandler.this._log.debug("Received relay response packet: " + reader + " from " + from);
                    }
                    PacketHandler.this._establisher.receiveRelayResponse(from, reader);
                    break;
                }
                case 8: {
                    if (auth == AuthType.BOBINTRO) {
                        if (!PacketHandler.this._log.shouldLog(30)) break;
                        PacketHandler.this._log.warn("Dropping type " + type + " auth " + (Object)((Object)auth) + ": " + packet);
                        break;
                    }
                    if (auth != AuthType.SESSION) {
                        PacketHandler.this._establisher.receiveSessionDestroy(from);
                        break;
                    }
                    if (outState != null) {
                        PacketHandler.this._establisher.receiveSessionDestroy(from, outState);
                        break;
                    }
                    if (state != null) {
                        PacketHandler.this._establisher.receiveSessionDestroy(from, state);
                        break;
                    }
                    PacketHandler.this._establisher.receiveSessionDestroy(from);
                    break;
                }
                default: {
                    if (PacketHandler.this._log.shouldLog(30)) {
                        PacketHandler.this._log.warn("Dropping type " + type + " auth " + (Object)((Object)auth) + ": " + packet);
                    }
                    PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidUnknown", packet.getLifetime());
                    return;
                }
            }
        }
    }

    private static enum PeerType {
        OUTBOUND_FALLBACK,
        INBOUND_FALLBACK,
        NEW_PEER;

    }

    private static enum AuthType {
        NONE,
        INTRO,
        BOBINTRO,
        SESSION;

    }
}

