/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import com.southernstorm.noise.protocol.CipherState;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.InboundMessageState;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.SSU2Bitfield;
import net.i2p.router.transport.udp.SSU2Header;
import net.i2p.router.transport.udp.SSU2Payload;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.HexDump;
import net.i2p.util.SimpleTimer2;

public class PeerState2
extends PeerState
implements SSU2Payload.PayloadCallback,
SSU2Bitfield.Callback {
    private final long _sendConnID;
    private final long _rcvConnID;
    private final AtomicInteger _packetNumber = new AtomicInteger();
    private final AtomicInteger _lastAckHashCode = new AtomicInteger(-1);
    private final CipherState _sendCha;
    private final CipherState _rcvCha;
    private final byte[] _sendHeaderEncryptKey1;
    private final byte[] _rcvHeaderEncryptKey1;
    private final byte[] _sendHeaderEncryptKey2;
    private final byte[] _rcvHeaderEncryptKey2;
    private final SSU2Bitfield _receivedMessages;
    private final SSU2Bitfield _ackedMessages;
    private final ConcurrentHashMap<Long, List<PacketBuilder.Fragment>> _sentMessages;
    private long _sentMessagesLastExpired;
    private byte[] _ourIP;
    private int _ourPort;
    private byte[][] _sessConfForReTX;
    private long _sessConfSentTime;
    private int _sessConfSentCount;
    public static final int MIN_SSU_IPV4_MTU = 1292;
    public static final int MAX_SSU_IPV4_MTU = 1484;
    public static final int DEFAULT_SSU_IPV4_MTU = 1484;
    public static final int MIN_SSU_IPV6_MTU = 1280;
    public static final int MAX_SSU_IPV6_MTU = 1488;
    public static final int DEFAULT_SSU_IPV6_MTU = 1280;
    public static final int MIN_MTU = 1280;
    public static final int MAX_MTU = 1500;
    public static final int DEFAULT_MTU = 1500;
    private static final int BITFIELD_SIZE = 512;
    private static final int MAX_SESS_CONF_RETX = 6;
    private static final int SESS_CONF_RETX_TIME = 1000;
    private static final long SENT_MESSAGES_CLEAN_TIME = 60000L;

    public PeerState2(RouterContext ctx, UDPTransport transport, InetSocketAddress remoteAddress, Hash remotePeer, boolean isInbound, int rtt, CipherState sendCha, CipherState rcvCha, long sendID, long rcvID, byte[] sendHdrKey1, byte[] sendHdrKey2, byte[] rcvHdrKey2) {
        super(ctx, transport, remoteAddress, remotePeer, isInbound, rtt);
        this._sendConnID = sendID;
        this._rcvConnID = rcvID;
        this._sendCha = sendCha;
        this._rcvCha = rcvCha;
        this._sendHeaderEncryptKey1 = sendHdrKey1;
        this._rcvHeaderEncryptKey1 = transport.getSSU2StaticIntroKey();
        this._sendHeaderEncryptKey2 = sendHdrKey2;
        this._rcvHeaderEncryptKey2 = rcvHdrKey2;
        this._receivedMessages = new SSU2Bitfield(512, 0L);
        this._ackedMessages = new SSU2Bitfield(512, 0L);
        this._sentMessages = new ConcurrentHashMap(32);
        this._sentMessagesLastExpired = this._keyEstablishedTime;
        if (isInbound) {
            this._receivedMessages.set(0L);
            UDPPacket ack = transport.getBuilder2().buildACK(this);
            transport.send(ack);
        } else {
            this._packetNumber.set(1);
        }
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    int fragmentSize() {
        return this._mtu - (this._remoteIP.length == 4 ? 60 : 80) - 8;
    }

    @Override
    int fragmentOverhead() {
        return (this._remoteIP.length == 4 ? 60 : 80) + 3 + 5;
    }

    @Override
    void clearWantedACKSendSince() {
        if (this._sentMessages.isEmpty()) {
            this._wantACKSendSince = 0L;
        }
    }

    @Override
    protected synchronized void messagePartiallyReceived(long now) {
        if (this._wantACKSendSince <= 0L) {
            this._wantACKSendSince = now;
            new ACKTimer();
        }
    }

    @Override
    int finishMessages(long now) {
        if (now >= this._sentMessagesLastExpired + 60000L) {
            this._sentMessagesLastExpired = now;
            if (!this._sentMessages.isEmpty()) {
                if (this._log.shouldDebug()) {
                    this._log.debug("finishMessages() over " + this._sentMessages.size() + " pending acks");
                }
                Iterator<List<PacketBuilder.Fragment>> iter = this._sentMessages.values().iterator();
                block0: while (iter.hasNext()) {
                    List<PacketBuilder.Fragment> frags = iter.next();
                    for (PacketBuilder.Fragment f : frags) {
                        OutboundMessageState state = f.state;
                        if (state.isComplete() || state.isExpired(now)) continue;
                        continue block0;
                    }
                    iter.remove();
                    if (!this._log.shouldWarn()) continue;
                    this._log.warn("Cleaned from sentMessages: " + frags);
                }
            }
        }
        return super.finishMessages(now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<OutboundMessageState> allocateSend(long now) {
        if (!this._isInbound && this._ackedMessages.getOffset() == 0L && !this._ackedMessages.get(0L)) {
            UDPPacket[] packets = null;
            PeerState2 peerState2 = this;
            synchronized (peerState2) {
                if (this._sessConfForReTX != null && this._sessConfSentTime + (long)(1000 << this._sessConfSentCount - 1) < now) {
                    if (this._sessConfSentCount >= 6) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Fail, no Sess Conf ACK rcvd on " + this);
                        }
                        this._transport.dropPeer(this, false, "No Sess Conf ACK rcvd");
                        this._sessConfForReTX = null;
                        return null;
                    }
                    ++this._sessConfSentCount;
                    packets = this.getRetransmitSessionConfirmedPackets();
                }
            }
            if (packets != null) {
                if (this._log.shouldInfo()) {
                    this._log.info("ReTX Sess Conf on " + this);
                }
                for (int i = 0; i < packets.length; ++i) {
                    this._transport.send((UDPPacket)packets[i]);
                }
            }
        }
        return super.allocateSend(now);
    }

    @Override
    void setCurrentMACKey(SessionKey key) {
        throw new UnsupportedOperationException();
    }

    @Override
    void setCurrentCipherKey(SessionKey key) {
        throw new UnsupportedOperationException();
    }

    @Override
    List<Long> getCurrentFullACKs() {
        throw new UnsupportedOperationException();
    }

    @Override
    List<Long> getCurrentResendACKs() {
        throw new UnsupportedOperationException();
    }

    @Override
    void removeACKMessage(Long messageId) {
        throw new UnsupportedOperationException();
    }

    @Override
    void fetchPartialACKs(List<ACKBitfield> rv) {
        throw new UnsupportedOperationException();
    }

    long getNextPacketNumber() {
        return this._packetNumber.getAndIncrement();
    }

    long getSendConnID() {
        return this._sendConnID;
    }

    long getRcvConnID() {
        return this._rcvConnID;
    }

    CipherState getSendCipher() {
        return this._sendCha;
    }

    byte[] getSendHeaderEncryptKey1() {
        return this._sendHeaderEncryptKey1;
    }

    byte[] getRcvHeaderEncryptKey1() {
        return this._rcvHeaderEncryptKey1;
    }

    byte[] getSendHeaderEncryptKey2() {
        return this._sendHeaderEncryptKey2;
    }

    byte[] getRcvHeaderEncryptKey2() {
        return this._rcvHeaderEncryptKey2;
    }

    void setOurAddress(byte[] ip, int port) {
        this._ourIP = ip;
        this._ourPort = port;
    }

    byte[] getOurIP() {
        return this._ourIP;
    }

    int getOurPort() {
        return this._ourPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSU2Bitfield getReceivedMessages() {
        PeerState2 peerState2 = this;
        synchronized (peerState2) {
            this._wantACKSendSince = 0L;
            this._lastACKSend = this._context.clock().now();
        }
        return this._receivedMessages;
    }

    SSU2Bitfield getAckedMessages() {
        return this._ackedMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receivePacket(UDPPacket packet) {
        block19: {
            DatagramPacket dpacket = packet.getPacket();
            byte[] data = dpacket.getData();
            int off = dpacket.getOffset();
            int len = dpacket.getLength();
            try {
                SSU2Header.Header header = SSU2Header.trialDecryptShortHeader(packet, this._rcvHeaderEncryptKey1, this._rcvHeaderEncryptKey2);
                if (header == null) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Inbound packet too short " + len + " on " + this);
                    }
                    return;
                }
                if (header.getDestConnID() != this._rcvConnID) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("bad Dest Conn id " + header.getDestConnID() + " size " + len + " on " + this);
                    }
                    return;
                }
                if (header.getType() != 6) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("bad data pkt type " + (header.getType() & 0xFF) + " size " + len + " on " + this);
                    }
                    return;
                }
                long n = header.getPacketNumber();
                SSU2Header.acceptTrialDecrypt(packet, header);
                Object object = this._rcvCha;
                synchronized (object) {
                    this._rcvCha.setNonce(n);
                    this._rcvCha.decryptWithAd(header.data, data, off + 16, data, off + 16, len - 16);
                }
                if (this._receivedMessages.set(n)) {
                    object = this;
                    synchronized (object) {
                        ++this._packetsReceivedDuplicate;
                    }
                    if (this._log.shouldWarn()) {
                        this._log.warn("dup pkt rcvd: " + n + " on " + this);
                    }
                    return;
                }
                int payloadLen = len - 32;
                if (this._log.shouldDebug()) {
                    this._log.debug("New " + len + " byte pkt " + n + " rcvd on " + this);
                }
                this.processPayload(data, off + 16, payloadLen);
                this.packetReceived(payloadLen);
            }
            catch (GeneralSecurityException gse) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad encrypted packet:\n" + HexDump.dump((byte[])data, (int)off, (int)len), (Throwable)gse);
                }
            }
            catch (IndexOutOfBoundsException ioobe) {
                if (!this._log.shouldWarn()) break block19;
                this._log.warn("Bad encrypted packet:\n" + HexDump.dump((byte[])data, (int)off, (int)len), (Throwable)ioobe);
            }
        }
    }

    private void processPayload(byte[] payload, int offset, int length) throws GeneralSecurityException {
        try {
            int n = SSU2Payload.processPayload(this._context, this, payload, offset, length, false);
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Data payload error", e);
        }
    }

    @Override
    public void gotDateTime(long time) {
        this.adjustClockSkew(this._context.clock().now() - time - 100L);
    }

    @Override
    public void gotOptions(byte[] options, boolean isHandshake) {
    }

    @Override
    public void gotRI(RouterInfo ri, boolean isHandshake, boolean flood) throws DataFormatException {
        block9: {
            if (this._log.shouldDebug()) {
                this._log.debug("Got updated RI");
            }
            try {
                Hash h = ri.getHash();
                if (h.equals((Object)this._context.routerHash())) {
                    return;
                }
                RouterInfo old = this._context.netDb().store(h, ri);
                if (flood && !ri.equals((Object)old)) {
                    FloodfillNetworkDatabaseFacade fndf = (FloodfillNetworkDatabaseFacade)this._context.netDb();
                    if ((old == null || ri.getPublished() > old.getPublished()) && fndf.floodConditional(ri)) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("Flooded the RI: " + h);
                        }
                    } else if (this._log.shouldInfo()) {
                        this._log.info("Flood request but we didn't: " + h);
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldWarn()) break block9;
                this._log.warn("RI store fail: " + (Object)((Object)ri), (Throwable)iae);
            }
        }
    }

    @Override
    public void gotRIFragment(byte[] data, boolean isHandshake, boolean flood, boolean isGzipped, int frag, int totalFrags) {
        throw new IllegalStateException("RI fragment in Data phase");
    }

    @Override
    public void gotAddress(byte[] ip, int port) {
        this._ourIP = ip;
        this._ourPort = port;
    }

    @Override
    public void gotRelayTagRequest() {
    }

    @Override
    public void gotRelayTag(long tag) {
    }

    @Override
    public void gotRelayRequest(byte[] data) {
    }

    @Override
    public void gotRelayResponse(int status, byte[] data) {
    }

    @Override
    public void gotRelayIntro(Hash aliceHash, byte[] data) {
    }

    @Override
    public void gotPeerTest(int msg, int status, Hash h, byte[] data) {
    }

    @Override
    public void gotToken(long token, long expires) {
        this._transport.getEstablisher().addOutboundToken(this._remoteHostId, token, expires);
    }

    @Override
    public void gotI2NP(I2NPMessage msg) {
        if (this._log.shouldDebug()) {
            this._log.debug("Got I2NP block: " + msg);
        }
        int size = msg.getMessageSize() - 7;
        long messageId = msg.getUniqueId();
        this.messageFullyReceived(messageId, size);
        if (this._transport.getInboundFragments().messageReceived(messageId)) {
            this._context.statManager().addRateData("udp.ignoreRecentDuplicate", 1L);
            if (this._log.shouldInfo()) {
                this._log.info("Got dup msg: " + messageId + " on " + this);
            }
            return;
        }
        this._transport.messageReceived(msg, null, this._remotePeer, 0L, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gotFragment(byte[] data, int off, int len, long messageId, int frag, boolean isLast) throws DataFormatException {
        boolean messageDup;
        InboundMessageState state;
        if (this._log.shouldDebug()) {
            this._log.debug("Got FRAGMENT block: " + messageId + " fragment " + frag + " isLast? " + isLast);
        }
        boolean messageComplete = false;
        boolean messageExpired = false;
        Object object = this._inboundMessages;
        synchronized (object) {
            state = (InboundMessageState)this._inboundMessages.get(messageId);
            if (state == null) {
                messageDup = this._transport.getInboundFragments().wasRecentlyReceived(messageId);
                if (messageDup) {
                    state = null;
                } else {
                    state = new InboundMessageState(this._context, messageId, this._remotePeer, data, off, len, frag, isLast);
                    this._inboundMessages.put(messageId, state);
                }
            } else {
                messageDup = state.hasFragment(frag);
                if (!messageDup) {
                    boolean fragmentOK = state.receiveFragment(data, off, len, frag, isLast);
                    if (!fragmentOK) {
                        return;
                    }
                    if (state.isComplete()) {
                        messageComplete = true;
                        this._inboundMessages.remove(messageId);
                    } else if (state.isExpired()) {
                        messageExpired = true;
                        this._inboundMessages.remove(messageId);
                    }
                }
            }
        }
        if (messageDup) {
            this.messagePartiallyReceived();
            if (frag == 0) {
                this._context.statManager().addRateData("udp.ignoreRecentDuplicate", 1L);
            }
            object = this;
            synchronized (object) {
                ++this._packetsReceivedDuplicate;
            }
            if (this._log.shouldInfo()) {
                if (state != null) {
                    this._log.info("dup fragment rcvd: " + frag + " for " + state);
                } else {
                    this._log.info("dup fragment rcvd: " + messageId + ' ' + frag + " on " + this);
                }
            }
            return;
        }
        if (messageComplete) {
            this.messageFullyReceived(messageId, state.getCompleteSize());
            if (this._transport.getInboundFragments().messageReceived(messageId)) {
                this._context.statManager().addRateData("udp.ignoreRecentDuplicate", 1L);
                if (this._log.shouldInfo()) {
                    this._log.info("Got dup msg: " + messageId + " on " + this);
                }
                return;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Message received completely!  " + state);
            }
            this._context.statManager().addRateData("udp.receivedCompleteTime", state.getLifetime(), state.getLifetime());
            this._context.statManager().addRateData("udp.receivedCompleteFragments", (long)state.getFragmentCount(), state.getLifetime());
            this.receiveMessage(state);
        } else if (messageExpired) {
            this.messagePartiallyReceived();
            if (this._log.shouldWarn()) {
                this._log.warn("Message expired while only being partially read: " + state);
            }
            this._context.messageHistory().droppedInboundMessage(state.getMessageId(), state.getFrom(), "expired while partially read: " + state.toString());
            state.releaseResources();
        } else {
            this.messagePartiallyReceived();
        }
    }

    @Override
    public void gotACK(long ackThru, int acks, byte[] ranges) {
        int hc = (int)ackThru << 8 ^ acks << 24 ^ DataHelper.hashCode((byte[])ranges);
        if (this._lastAckHashCode.getAndSet(hc) == hc) {
            if (this._log.shouldDebug()) {
                this._log.debug("Got dup ACK block: " + SSU2Bitfield.toString(ackThru, acks, ranges, ranges != null ? ranges.length / 2 : 0));
            }
            return;
        }
        SSU2Bitfield ackbf = SSU2Bitfield.fromACKBlock(ackThru, acks, ranges, ranges != null ? ranges.length / 2 : 0);
        if (this._log.shouldDebug()) {
            this._log.debug("Got new ACK block: " + SSU2Bitfield.toString(ackThru, acks, ranges, ranges != null ? ranges.length / 2 : 0));
        }
        ackbf.forEachAndNot(this._ackedMessages, this);
    }

    @Override
    public void gotTermination(int reason, long count) {
        if (this._log.shouldWarn()) {
            this._log.warn("Got TERMINATION block, reason: " + reason + " count: " + count);
        }
        this._transport.getEstablisher().receiveSessionDestroy(this._remoteHostId, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveMessage(InboundMessageState state) {
        int sz = state.getCompleteSize();
        try {
            byte[] buf = new byte[sz];
            int numFragments = state.getFragmentCount();
            ByteArray[] fragments = state.getFragments();
            int off = 0;
            for (int i = 0; i < numFragments; ++i) {
                ByteArray ba = fragments[i];
                int len = ba.getValid();
                System.arraycopy(ba.getData(), 0, buf, off, len);
                off += len;
            }
            if (off != sz) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Hmm, offset of the fragments = " + off + " while the state says " + sz);
                }
                return;
            }
            I2NPMessage msg = I2NPMessageImpl.fromRawByteArrayNTCP2(this._context, buf, 0, sz, null);
            this._transport.messageReceived(msg, null, this._remotePeer, state.getLifetime(), sz);
        }
        catch (I2NPMessageException ime) {
            if (this._log.shouldWarn()) {
                this._log.warn("Message invalid: " + state + " PeerState: " + this, (Throwable)((Object)ime));
            }
        }
        catch (RuntimeException e) {
            if (this._log.shouldWarn()) {
                this._log.warn("Error handling a message: " + state, (Throwable)e);
            }
        }
        finally {
            state.releaseResources();
        }
    }

    void fragmentsSent(long pktNum, List<PacketBuilder.Fragment> fragments) {
        List<PacketBuilder.Fragment> old = this._sentMessages.putIfAbsent(pktNum, fragments);
        if (old != null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Dup send of pkt " + pktNum + " on " + this);
            }
        } else if (this._log.shouldDebug()) {
            this._log.debug("New data pkt " + pktNum + " sent with " + fragments.size() + " fragments on " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bitSet(long pktNum) {
        if (pktNum == 0L && !this._isInbound) {
            PeerState2 peerState2 = this;
            synchronized (peerState2) {
                this._sessConfForReTX = null;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("New ACK of Session Confirmed on " + this);
            }
            return;
        }
        List<PacketBuilder.Fragment> fragments = this._sentMessages.remove(pktNum);
        if (fragments == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("New ACK of pkt " + pktNum + " not found on " + this);
            }
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("New ACK of pkt " + pktNum + " containing " + fragments.size() + " fragments on " + this);
        }
        long highest = -1L;
        for (PacketBuilder.Fragment f : fragments) {
            long sn;
            OutboundMessageState state = f.state;
            if (this.acked(f)) {
                if (this._log.shouldDebug()) {
                    this._log.debug("New ACK of fragment " + f.num + " of " + state);
                }
            } else if (this._log.shouldWarn()) {
                this._log.warn("Dup ACK of fragment " + f.num + " of " + state);
            }
            if ((sn = state.getSeqNum()) <= highest) continue;
            highest = sn;
        }
        if (highest >= 0L) {
            this.highestSeqNumAcked(highest);
        }
    }

    synchronized void confirmedPacketsSent(byte[][] data) {
        if (this._sessConfForReTX == null) {
            this._sessConfForReTX = data;
        }
        this._sessConfSentTime = this._context.clock().now();
        ++this._sessConfSentCount;
    }

    private synchronized UDPPacket[] getRetransmitSessionConfirmedPackets() {
        if (this._sessConfForReTX == null) {
            return null;
        }
        UDPPacket[] rv = new UDPPacket[this._sessConfForReTX.length];
        InetAddress addr = this.getRemoteIPAddress();
        for (int i = 0; i < rv.length; ++i) {
            UDPPacket packet;
            rv[i] = packet = UDPPacket.acquire(this._context, false);
            DatagramPacket pkt = packet.getPacket();
            byte[] data = pkt.getData();
            int off = pkt.getOffset();
            System.arraycopy(this._sessConfForReTX[i], 0, data, off, this._sessConfForReTX[i].length);
            pkt.setLength(this._sessConfForReTX.length);
            pkt.setAddress(addr);
            pkt.setPort(this._remotePort);
            packet.setMessageType(71);
            packet.setPriority(550);
        }
        return rv;
    }

    private class ACKTimer
    extends SimpleTimer2.TimedEvent {
        public ACKTimer() {
            super(PeerState2.this._context.simpleTimer2());
            long delta = Math.max(10, Math.min(PeerState2.this._rtt / 6, 150));
            if (PeerState2.this._log.shouldDebug()) {
                PeerState2.this._log.debug("Sending delayed ack in " + delta + ": " + PeerState2.this);
            }
            this.schedule(delta);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            PeerState2 peerState2 = PeerState2.this;
            synchronized (peerState2) {
                if (PeerState2.this._wantACKSendSince <= 0L) {
                    if (PeerState2.this._log.shouldDebug()) {
                        PeerState2.this._log.debug("Already acked:" + PeerState2.this);
                    }
                    return;
                }
                PeerState2.this._wantACKSendSince = 0L;
            }
            UDPPacket ack = PeerState2.this._transport.getBuilder2().buildACK(PeerState2.this);
            if (PeerState2.this._log.shouldDebug()) {
                PeerState2.this._log.debug("ACKTimer sending acks to " + PeerState2.this);
            }
            PeerState2.this._transport.send(ack);
        }
    }
}

