/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.udp.SocketListener;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPReceiver;
import net.i2p.router.transport.udp.UDPSender;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class UDPEndpoint
implements SocketListener {
    private final RouterContext _context;
    private final Log _log;
    private int _listenPort;
    private final UDPTransport _transport;
    private UDPSender _sender;
    private UDPReceiver _receiver;
    private DatagramSocket _socket;
    private final InetAddress _bindAddress;
    private final boolean _isIPv4;
    private final boolean _isIPv6;
    private static final AtomicInteger _counter = new AtomicInteger();
    private static final int MIN_SOCKET_BUFFER = 262144;
    private static final int MAX_PORT_RETRIES = 20;

    public UDPEndpoint(RouterContext ctx, UDPTransport transport, int listenPort, InetAddress bindAddress) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UDPEndpoint.class);
        this._transport = transport;
        this._bindAddress = bindAddress;
        this._listenPort = listenPort;
        this._isIPv4 = bindAddress == null || bindAddress instanceof Inet4Address;
        this._isIPv6 = bindAddress == null || bindAddress instanceof Inet6Address;
    }

    public synchronized void startup() throws SocketException {
        if (this._log.shouldLog(10)) {
            this._log.debug("Starting up the UDP endpoint");
        }
        this.shutdown();
        this._socket = this.getSocket();
        if (this._socket == null) {
            this._log.log(50, "UDP Unable to open a port");
            throw new SocketException("SSU Unable to bind to a port on " + this._bindAddress);
        }
        int count = _counter.incrementAndGet();
        this._sender = new UDPSender(this._context, this._socket, "UDPSender " + count, this);
        this._sender.startup();
        if (this._transport != null) {
            this._receiver = new UDPReceiver(this._context, this._transport, this._socket, "UDPReceiver " + count, this);
            this._receiver.startup();
        }
    }

    public synchronized void shutdown() {
        if (this._sender != null) {
            this._sender.shutdown();
            this._receiver.shutdown();
        }
        if (this._socket != null) {
            this._socket.close();
        }
    }

    public void setListenPort(int newPort) {
        this._listenPort = newPort;
    }

    private DatagramSocket getSocket() {
        DatagramSocket socket = null;
        int port = this._listenPort;
        if (port > 0 && !TransportUtil.isValidPort(port)) {
            TransportUtil.logInvalidPort(this._log, "UDP", port);
            port = -1;
        }
        for (int i = 0; i < 20; ++i) {
            if (port <= 0) {
                port = TransportUtil.selectRandomPort(this._context, "SSU");
            }
            try {
                socket = this._bindAddress == null ? new DatagramSocket(port) : new DatagramSocket(port, this._bindAddress);
                if (SystemVersion.isAndroid()) break;
                if (socket.getSendBufferSize() < 262144) {
                    socket.setSendBufferSize(262144);
                }
                if (socket.getReceiveBufferSize() >= 262144) break;
                socket.setReceiveBufferSize(262144);
                break;
            }
            catch (SocketException se) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Binding to port " + port + " failed", (Throwable)se);
                }
                port = -1;
                continue;
            }
        }
        if (socket == null) {
            this._log.log(50, "SSU Unable to bind to a port on " + this._bindAddress);
        } else if (port != this._listenPort) {
            if (this._listenPort > 0) {
                this._log.error("SSU Unable to bind to requested port " + this._listenPort + ", using random port " + port);
            } else {
                this._log.logAlways(20, "UDP selected random port " + port);
            }
        }
        this._listenPort = port;
        return socket;
    }

    public int getListenPort() {
        return this._listenPort;
    }

    public UDPSender getSender() {
        return this._sender;
    }

    public void send(UDPPacket packet) {
        this._sender.add(packet);
    }

    public UDPPacket receive() {
        UDPPacket packet = UDPPacket.acquire(this._context, true);
        try {
            this._socket.receive(packet.getPacket());
            return packet;
        }
        catch (IOException ioe) {
            packet.release();
            return null;
        }
    }

    public void clearOutbound() {
        if (this._sender != null) {
            this._sender.clear();
        }
    }

    public boolean isIPv4() {
        return this._isIPv4;
    }

    public boolean isIPv6() {
        return this._isIPv6;
    }

    @Override
    public void fail() {
        this.shutdown();
        this._transport.fail(this);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("UDP Socket ");
        if (this._bindAddress != null) {
            buf.append(this._bindAddress.toString()).append(' ');
        }
        buf.append("port ").append(this._listenPort);
        return buf.toString();
    }
}

