/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.TunnelId;

public class HopConfig {
    private TunnelId _receiveTunnel;
    private Hash _receiveFrom;
    private TunnelId _sendTunnel;
    private Hash _sendTo;
    private SessionKey _layerKey;
    private SessionKey _ivKey;
    private long _creation = -1L;
    private long _expiration = -1L;
    private int _messagesProcessed;
    private int _oldMessagesProcessed;

    public long getReceiveTunnelId() {
        return this._receiveTunnel != null ? this._receiveTunnel.getTunnelId() : 0L;
    }

    public TunnelId getReceiveTunnel() {
        return this._receiveTunnel;
    }

    public void setReceiveTunnelId(TunnelId id) {
        this._receiveTunnel = id;
    }

    public void setReceiveTunnelId(long id) {
        this._receiveTunnel = new TunnelId(id);
    }

    public Hash getReceiveFrom() {
        return this._receiveFrom;
    }

    public void setReceiveFrom(Hash from) {
        this._receiveFrom = from;
    }

    public long getSendTunnelId() {
        return this._sendTunnel != null ? this._sendTunnel.getTunnelId() : 0L;
    }

    public TunnelId getSendTunnel() {
        return this._sendTunnel;
    }

    public void setSendTunnelId(TunnelId id) {
        this._sendTunnel = id;
    }

    public void setSendTunnelId(long id) {
        this._sendTunnel = new TunnelId(id);
    }

    public Hash getSendTo() {
        return this._sendTo;
    }

    public void setSendTo(Hash to) {
        this._sendTo = to;
    }

    public SessionKey getLayerKey() {
        return this._layerKey;
    }

    public void setLayerKey(SessionKey key) {
        this._layerKey = key;
    }

    public SessionKey getIVKey() {
        return this._ivKey;
    }

    public void setIVKey(SessionKey key) {
        this._ivKey = key;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public void setExpiration(long when) {
        this._expiration = when;
    }

    public long getCreation() {
        return this._creation;
    }

    public void setCreation(long when) {
        this._creation = when;
    }

    public synchronized void incrementProcessedMessages() {
        ++this._messagesProcessed;
    }

    public synchronized int getProcessedMessagesCount() {
        return this._messagesProcessed;
    }

    public synchronized int getRecentMessagesCount() {
        return this._messagesProcessed - this._oldMessagesProcessed;
    }

    synchronized int getAndResetRecentMessagesCount() {
        int rv = this._messagesProcessed - this._oldMessagesProcessed;
        this._oldMessagesProcessed = this._messagesProcessed;
        return rv;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        if (this._receiveTunnel != null) {
            buf.append("recv on ");
            buf.append(this._receiveTunnel.getTunnelId());
        }
        if (this._sendTo != null) {
            buf.append(" send to ").append(this._sendTo.toBase64().substring(0, 4)).append(":");
            if (this._sendTunnel != null) {
                buf.append(this._sendTunnel.getTunnelId());
            }
        }
        buf.append(" layer key: ").append(this._layerKey);
        buf.append(" IV key: ").append(this._ivKey);
        buf.append(" exp. ").append(DataHelper.formatTime((long)this._expiration));
        int messagesProcessed = this.getProcessedMessagesCount();
        if (messagesProcessed > 0) {
            buf.append(" used ").append(messagesProcessed).append("KB");
        }
        return buf.toString();
    }
}

