/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.protocol;

import com.southernstorm.noise.crypto.x25519.Curve25519;
import com.southernstorm.noise.protocol.DHState;
import com.southernstorm.noise.protocol.Noise;
import java.util.Arrays;
import net.i2p.crypto.KeyFactory;
import net.i2p.crypto.KeyPair;
import net.i2p.router.crypto.ratchet.Elg2KeyPair;

class Curve25519DHState
implements DHState,
Cloneable {
    private final byte[] publicKey = new byte[32];
    private final byte[] privateKey = new byte[32];
    private int mode = 0;
    private final KeyFactory _xdh;
    private byte[] encodedPublicKey;

    public Curve25519DHState(KeyFactory xdh) {
        this._xdh = xdh;
    }

    @Override
    public void destroy() {
        this.clearKey();
    }

    @Override
    public String getDHName() {
        return "25519";
    }

    @Override
    public int getPublicKeyLength() {
        return 32;
    }

    @Override
    public int getPrivateKeyLength() {
        return 32;
    }

    @Override
    public int getSharedKeyLength() {
        return 32;
    }

    @Override
    public void generateKeyPair() {
        KeyPair kp = this._xdh.getKeys();
        System.arraycopy(kp.getPrivate().getData(), 0, this.privateKey, 0, 32);
        System.arraycopy(kp.getPublic().getData(), 0, this.publicKey, 0, 32);
        if (kp instanceof Elg2KeyPair) {
            Elg2KeyPair ekp = (Elg2KeyPair)kp;
            this.encodedPublicKey = new byte[32];
            System.arraycopy(ekp.getEncoded(), 0, this.encodedPublicKey, 0, 32);
        }
        this.mode = 3;
    }

    @Override
    public void getPublicKey(byte[] key, int offset) {
        System.arraycopy(this.publicKey, 0, key, offset, 32);
    }

    @Override
    public void setPublicKey(byte[] key, int offset) {
        System.arraycopy(key, offset, this.publicKey, 0, 32);
        Arrays.fill(this.privateKey, (byte)0);
        this.mode = 1;
    }

    @Override
    public void getPrivateKey(byte[] key, int offset) {
        System.arraycopy(this.privateKey, 0, key, offset, 32);
    }

    @Override
    @Deprecated
    public void setPrivateKey(byte[] key, int offset) {
        System.arraycopy(key, offset, this.privateKey, 0, 32);
        Curve25519.eval((byte[])this.publicKey, (int)0, (byte[])this.privateKey, null);
        this.mode = 3;
    }

    @Override
    public void setKeys(byte[] privkey, int privoffset, byte[] pubkey, int puboffset) {
        System.arraycopy(privkey, privoffset, this.privateKey, 0, 32);
        System.arraycopy(pubkey, puboffset, this.publicKey, 0, 32);
        this.mode = 3;
    }

    @Override
    public void setToNullPublicKey() {
        Arrays.fill(this.publicKey, (byte)0);
        Arrays.fill(this.privateKey, (byte)0);
        if (this.encodedPublicKey != null) {
            Arrays.fill(this.encodedPublicKey, (byte)0);
            this.encodedPublicKey = null;
        }
        this.mode = 1;
    }

    @Override
    public void clearKey() {
        Noise.destroy(this.publicKey);
        Noise.destroy(this.privateKey);
        if (this.encodedPublicKey != null) {
            Noise.destroy(this.encodedPublicKey);
            this.encodedPublicKey = null;
        }
        this.mode = 0;
    }

    @Override
    public boolean hasPublicKey() {
        return (this.mode & 1) != 0;
    }

    @Override
    public boolean hasPrivateKey() {
        return (this.mode & 2) != 0;
    }

    @Override
    public boolean isNullPublicKey() {
        if ((this.mode & 1) == 0) {
            return false;
        }
        int temp = 0;
        for (int index = 0; index < 32; ++index) {
            temp |= this.publicKey[index];
        }
        return temp == 0;
    }

    @Override
    public boolean hasEncodedPublicKey() {
        return this.encodedPublicKey != null;
    }

    @Override
    public void getEncodedPublicKey(byte[] key, int offset) {
        if (this.encodedPublicKey == null) {
            throw new IllegalStateException();
        }
        System.arraycopy(this.encodedPublicKey, 0, key, offset, 32);
    }

    @Override
    public void calculate(byte[] sharedKey, int offset, DHState publicDH) {
        if (!(publicDH instanceof Curve25519DHState)) {
            throw new IllegalArgumentException("Incompatible DH algorithms");
        }
        Curve25519.eval((byte[])sharedKey, (int)offset, (byte[])this.privateKey, (byte[])((Curve25519DHState)publicDH).publicKey);
    }

    @Override
    public void copyFrom(DHState other) {
        if (!(other instanceof Curve25519DHState)) {
            throw new IllegalStateException("Mismatched DH key objects");
        }
        if (other == this) {
            return;
        }
        Curve25519DHState dh = (Curve25519DHState)other;
        System.arraycopy(dh.privateKey, 0, this.privateKey, 0, 32);
        System.arraycopy(dh.publicKey, 0, this.publicKey, 0, 32);
        this.mode = dh.mode;
    }

    @Override
    public Curve25519DHState clone() throws CloneNotSupportedException {
        return (Curve25519DHState)super.clone();
    }
}

