/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.router;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.KeysAndCert;
import net.i2p.data.Signature;
import net.i2p.data.SimpleDataStructure;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.SortHelper;
import net.i2p.util.Clock;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;

public class RouterInfo
extends DatabaseEntry {
    private RouterIdentity _identity;
    private volatile long _published;
    private final List<RouterAddress> _addresses = new ArrayList<RouterAddress>(2);
    private Set<Hash> _peers;
    private final Properties _options = new OrderedProperties();
    private volatile boolean _validated;
    private volatile boolean _isValid;
    private volatile byte[] _byteified;
    private volatile int _hashCode;
    private volatile boolean _hashCodeInitialized;
    private boolean _shouldCache;
    private static final boolean CACHE_ALL = false;
    public static final String PROP_NETWORK_ID = "netId";
    public static final String PROP_CAPABILITIES = "caps";
    public static final char CAPABILITY_HIDDEN = 'H';
    private static final int MAX_ADDRESSES = 16;
    public static final int MAX_UNCOMPRESSED_SIZE = 4096;
    public static final String BW_CAPABILITY_CHARS = "XPONMLK";

    public RouterInfo() {
    }

    public RouterInfo(RouterInfo old) {
        this();
        this.setIdentity(old.getIdentity());
        this.setPeers(old.getPeers());
    }

    public long getDate() {
        return this._published;
    }

    public KeysAndCert getKeysAndCert() {
        return this._identity;
    }

    public int getType() {
        return 0;
    }

    public RouterIdentity getIdentity() {
        return this._identity;
    }

    public void setIdentity(RouterIdentity ident) {
        if (this._signature != null) {
            throw new IllegalStateException();
        }
        this._identity = ident;
        this._shouldCache = true;
    }

    public long getPublished() {
        return this._published;
    }

    public void setPublished(long published) {
        if (this._signature != null) {
            throw new IllegalStateException();
        }
        this._published = published;
    }

    public int getAddressCount() {
        return this._addresses.size();
    }

    public Collection<RouterAddress> getAddresses() {
        return Collections.unmodifiableList(this._addresses);
    }

    public void setAddresses(Collection<RouterAddress> addresses) {
        if (this._signature != null || !this._addresses.isEmpty()) {
            throw new IllegalStateException();
        }
        if (addresses != null) {
            if (addresses.size() > 16) {
                throw new IllegalArgumentException("too many addresses");
            }
            this._addresses.addAll(addresses);
        }
    }

    @Deprecated
    public Set<Hash> getPeers() {
        if (this._peers == null) {
            return Collections.emptySet();
        }
        return this._peers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setPeers(Set<Hash> peers) {
        if (this._signature != null) {
            throw new IllegalStateException();
        }
        if (peers == null || peers.isEmpty()) {
            this._peers = null;
            return;
        }
        if (this._peers == null) {
            this._peers = new HashSet<Hash>(2);
        }
        Set<Hash> set = this._peers;
        synchronized (set) {
            this._peers.clear();
            this._peers.addAll(peers);
        }
    }

    @Deprecated
    public Properties getOptions() {
        return this._options;
    }

    public Map<Object, Object> getOptionsMap() {
        return Collections.unmodifiableMap(this._options);
    }

    public String getOption(String opt) {
        return this._options.getProperty(opt);
    }

    public String getVersion() {
        String rv = this._options.getProperty("router.version");
        return rv != null ? rv : "0";
    }

    public void setOptions(Properties options) {
        if (this._signature != null) {
            throw new IllegalStateException();
        }
        this._options.clear();
        if (options != null) {
            this._options.putAll((Map<?, ?>)options);
        }
    }

    protected byte[] getBytes() throws DataFormatException {
        if (this._byteified != null) {
            return this._byteified;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
        try {
            this.writeDataBytes(out);
        }
        catch (IOException ioe) {
            throw new DataFormatException("IO Error getting bytes", (Throwable)ioe);
        }
        byte[] data = out.toByteArray();
        if (this._shouldCache) {
            this._byteified = data;
        }
        return data;
    }

    private void writeDataBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._identity == null) {
            throw new DataFormatException("Missing identity");
        }
        if (this._published < 0L) {
            throw new DataFormatException("Invalid published date: " + this._published);
        }
        this._identity.writeBytes(out);
        DataHelper.writeLong((OutputStream)out, (int)8, (long)this._published);
        int sz = this._addresses.size();
        out.write((byte)sz);
        if (sz > 0) {
            for (RouterAddress addr : this._addresses) {
                addr.writeBytes(out);
            }
        }
        int psz = this._peers == null ? 0 : this._peers.size();
        out.write((byte)psz);
        if (psz > 0) {
            Collection<Hash> peers = this._peers;
            if (psz > 1) {
                peers = SortHelper.sortStructures(peers);
            }
            for (Hash peerHash : peers) {
                peerHash.writeBytes(out);
            }
        }
        DataHelper.writeProperties((OutputStream)out, (Properties)this._options);
    }

    public boolean isValid() {
        if (!this._validated) {
            this.doValidate();
        }
        return this._isValid;
    }

    public boolean verifySignature() {
        return this.isValid();
    }

    public int getNetworkId() {
        String id = this._options.getProperty(PROP_NETWORK_ID);
        if ("2".equals(id)) {
            return 2;
        }
        if (id != null) {
            try {
                return Integer.parseInt(id);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public String getCapabilities() {
        String capabilities = this._options.getProperty(PROP_CAPABILITIES);
        if (capabilities != null) {
            return capabilities;
        }
        return "";
    }

    public boolean isHidden() {
        return this.getCapabilities().indexOf(72) >= 0 || this._identity != null && this._identity.isHidden();
    }

    public String getBandwidthTier() {
        String bwTiers = BW_CAPABILITY_CHARS;
        String bwTier = "Unknown";
        String capabilities = this.getCapabilities();
        for (int i = 0; i < capabilities.length(); ++i) {
            if (bwTiers.indexOf(capabilities.charAt(i)) == -1) continue;
            bwTier = String.valueOf(capabilities.charAt(i));
            break;
        }
        return bwTier;
    }

    public boolean isCurrent(long maxAgeMs) {
        long earliestExpire = Clock.getInstance().now() - maxAgeMs;
        return this._published >= earliestExpire;
    }

    public RouterAddress getTargetAddress(String transportStyle) {
        for (RouterAddress addr : this._addresses) {
            if (!addr.getTransportStyle().equals(transportStyle)) continue;
            return addr;
        }
        return null;
    }

    public List<RouterAddress> getTargetAddresses(String transportStyle) {
        ArrayList<RouterAddress> ret = new ArrayList<RouterAddress>(this._addresses.size());
        for (RouterAddress addr : this._addresses) {
            if (!addr.getTransportStyle().equals(transportStyle)) continue;
            ret.add(addr);
        }
        return ret;
    }

    public List<RouterAddress> getTargetAddresses(String transportStyle1, String transportStyle2) {
        ArrayList<RouterAddress> ret = new ArrayList<RouterAddress>(this._addresses.size());
        for (RouterAddress addr : this._addresses) {
            String style = addr.getTransportStyle();
            if (!style.equals(transportStyle1) && !style.equals(transportStyle2)) continue;
            ret.add(addr);
        }
        return ret;
    }

    private void doValidate() {
        Log log;
        this._isValid = super.verifySignature();
        this._validated = true;
        if (!this._isValid && (log = I2PAppContext.getGlobalContext().logManager().getLog(RouterInfo.class)).shouldWarn()) {
            log.warn("Sig verify fail: " + this.toString(), (Throwable)new Exception("from"));
        }
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this.readBytes(in, false);
    }

    public void readBytes(InputStream in, boolean verifySig) throws DataFormatException, IOException {
        InputStream din;
        MessageDigest digest;
        if (this._signature != null) {
            throw new IllegalStateException();
        }
        this._identity = new RouterIdentity();
        this._identity.readBytes(in);
        SigType type = this._identity.getSigningPublicKey().getType();
        if (type == null) {
            throw new DataFormatException("unknown sig type");
        }
        if (verifySig) {
            if (type != SigType.EdDSA_SHA512_Ed25519) {
                digest = type.getDigestInstance();
                digest.update(this._identity.toByteArray());
                din = new DigestInputStream(in, digest);
            } else {
                digest = null;
                din = in;
            }
        } else {
            digest = null;
            din = in;
        }
        this._published = DataHelper.readLong((InputStream)din, (int)8);
        int numAddresses = din.read();
        if (numAddresses > 16) {
            throw new DataFormatException("too many addresses");
        }
        for (int i = 0; i < numAddresses; ++i) {
            RouterAddress address = new RouterAddress();
            address.readBytes(din);
            this._addresses.add(address);
        }
        int numPeers = din.read();
        if (numPeers <= 0) {
            this._peers = null;
        } else {
            this._peers = new HashSet<Hash>(numPeers);
            for (int i = 0; i < numPeers; ++i) {
                Hash peerIdentityHash = new Hash();
                peerIdentityHash.readBytes(din);
                this._peers.add(peerIdentityHash);
            }
        }
        DataHelper.readProperties((InputStream)din, (Properties)this._options);
        this._signature = new Signature(type);
        this._signature.readBytes(in);
        if (verifySig) {
            if (type != SigType.EdDSA_SHA512_Ed25519) {
                SimpleDataStructure hash = type.getHashInstance();
                hash.setData(digest.digest());
                this._isValid = DSAEngine.getInstance().verifySignature(this._signature, hash, this._identity.getSigningPublicKey());
                this._validated = true;
            } else {
                this.doValidate();
            }
            if (!this._isValid) {
                throw new DataFormatException("Bad RouterInfo signature");
            }
        }
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._signature == null) {
            throw new DataFormatException("Signature is null");
        }
        this.writeDataBytes(out);
        this._signature.writeBytes(out);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof RouterInfo)) {
            return false;
        }
        RouterInfo info = (RouterInfo)((Object)object);
        return this._published == info.getPublished() && DataHelper.eq((Object)this._signature, (Object)info.getSignature()) && DataHelper.eq((Object)((Object)this._identity), (Object)((Object)info.getIdentity()));
    }

    public int hashCode() {
        if (!this._hashCodeInitialized) {
            this._hashCode = DataHelper.hashCode((Object)((Object)this._identity)) + (int)this._published;
            this._hashCodeInitialized = true;
        }
        return this._hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("[RouterInfo: ");
        buf.append("\n\tIdentity: ").append((Object)this._identity);
        buf.append("\n\tSignature: ").append(this._signature);
        buf.append("\n\tPublished: ").append(new Date(this._published));
        if (this._peers != null) {
            buf.append("\n\tPeers (").append(this._peers.size()).append("):");
            for (Hash hash : this._peers) {
                buf.append("\n\t\tPeer hash: ").append(hash);
            }
        }
        buf.append("\n\tOptions (").append(this._options.size()).append("):");
        for (Map.Entry entry : this._options.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            buf.append("\n\t\t[").append(key).append("] = [").append(val).append("]");
        }
        if (!this._addresses.isEmpty()) {
            buf.append("\n\tAddresses (").append(this._addresses.size()).append("):");
            for (RouterAddress routerAddress : this._addresses) {
                buf.append("\n\t").append((Object)routerAddress);
            }
        }
        buf.append("]");
        String rv = buf.toString();
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length <= 0) {
            System.err.println("Usage: RouterInfo file ...");
            System.exit(1);
        }
        boolean fail = false;
        for (int i = 0; i < args.length; ++i) {
            RouterInfo ri = new RouterInfo();
            FileInputStream is = null;
            try {
                is = new FileInputStream(args[i]);
                ri.readBytes(is);
                if (ri.isValid()) {
                    System.out.println(ri.toString());
                    continue;
                }
                System.err.println("Router info " + args[i] + " is invalid");
                fail = true;
                continue;
            }
            catch (IOException e) {
                System.err.println("Error reading " + args[i] + ": " + e);
                fail = true;
                continue;
            }
            catch (DataFormatException e) {
                System.err.println("Error reading " + args[i] + ": " + (Object)((Object)e));
                fail = true;
                continue;
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (fail) {
            System.exit(1);
        }
    }
}

