/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.crypto.eddsa.math.Curve;
import net.i2p.crypto.eddsa.math.Field;
import net.i2p.crypto.eddsa.math.bigint.BigIntegerLittleEndianEncoding;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.data.PublicKey;
import net.i2p.util.NativeBigInteger;

class Elligator2 {
    private final I2PAppContext _context;
    private static final BigInteger p;
    private static final BigInteger divide_plus_p_3_8;
    private static final BigInteger divide_minus_p_1_2;
    private static final BigInteger divide_minus_p_1_4;
    private static final BigInteger square_root_negative_1;
    private static final long Aint = 486662L;
    private static final BigInteger A;
    private static final BigInteger negative_A;
    private static final BigInteger u;
    private static final BigInteger inverted_u;
    private static final BigInteger TWO;
    private static final int POINT_LENGTH = 32;
    private static final int REPRESENTATIVE_LENGTH = 32;
    private static final EdDSANamedCurveSpec SPEC;
    private static final Curve CURVE;
    private static final Field FIELD;
    private static final BigIntegerLittleEndianEncoding ENCODING;
    private static final boolean DISABLE = false;

    public Elligator2(I2PAppContext ctx) {
        this._context = ctx;
    }

    public byte[] encode(PublicKey point) {
        byte[] random = new byte[1];
        this._context.random().nextBytes(random);
        byte rand = random[0];
        return Elligator2.encode(point, (rand & 1) == 0, rand);
    }

    @Deprecated
    protected static byte[] encode(PublicKey point, boolean alternative) {
        return Elligator2.encode(point, alternative, (byte)0);
    }

    private static byte[] encode(PublicKey point, boolean alternative, byte highBits) {
        BigInteger r;
        BigInteger x = ENCODING.toBigInteger(point.getData());
        if (x.signum() == 0) {
            alternative = false;
        }
        BigInteger negative_plus_x_A = x.add(A).negate();
        BigInteger negative_multiply3_u_x_plus_x_A = u.multiply(x);
        negative_multiply3_u_x_plus_x_A = negative_multiply3_u_x_plus_x_A.mod(p);
        negative_multiply3_u_x_plus_x_A = negative_multiply3_u_x_plus_x_A.multiply(negative_plus_x_A);
        if (Elligator2.legendre(negative_multiply3_u_x_plus_x_A = negative_multiply3_u_x_plus_x_A.mod(p)) == -1) {
            return null;
        }
        if (alternative) {
            r = x.modInverse(p);
            r = r.multiply(negative_plus_x_A);
        } else {
            r = negative_plus_x_A.modInverse(p);
            r = r.multiply(x);
        }
        r = r.mod(p);
        r = r.multiply(inverted_u);
        r = r.mod(p);
        r = Elligator2.square_root(r);
        byte[] rv = ENCODING.encode(r);
        rv[31] = (byte)(rv[31] | highBits & 0xFFFFFFC0);
        return rv;
    }

    public static PublicKey decode(byte[] representative) {
        return Elligator2.decode(null, representative);
    }

    public static PublicKey decode(AtomicBoolean alternative, byte[] representative) {
        BigInteger x;
        if (representative.length != 32) {
            throw new IllegalArgumentException("must be 32 bytes");
        }
        representative[31] = (byte)(representative[31] & 0x3F);
        BigInteger r = ENCODING.toBigInteger(representative);
        if (r.compareTo(divide_minus_p_1_2) >= 0) {
            return null;
        }
        BigInteger v = r.multiply(r);
        v = v.mod(p);
        v = v.multiply(u);
        v = v.add(BigInteger.ONE);
        v = v.mod(p);
        v = v.modInverse(p);
        v = v.multiply(negative_A);
        v = v.mod(p);
        BigInteger plus_v_A = v.add(A);
        BigInteger t = v.multiply(v);
        t = t.mod(p);
        t = t.multiply(plus_v_A);
        t = t.add(v);
        int e = Elligator2.legendre(t = t.mod(p));
        if (e == 1) {
            x = v;
        } else {
            x = p.subtract(v);
            x = x.subtract(A);
            x = x.mod(p);
        }
        if (alternative != null) {
            alternative.set(e == 1);
        }
        byte[] dec = ENCODING.encode(x);
        return new PublicKey(EncType.ECIES_X25519, dec);
    }

    private static BigInteger square_root(BigInteger x) {
        if (!(x instanceof NativeBigInteger)) {
            x = new NativeBigInteger(x);
        }
        BigInteger t = x.modPow(divide_minus_p_1_4, p);
        BigInteger result = x.modPow(divide_plus_p_3_8, p);
        if ((t = t.add(BigInteger.ONE)).compareTo(p) == 0) {
            result = result.multiply(square_root_negative_1);
            result = result.mod(p);
        }
        if (result.compareTo(divide_minus_p_1_2) > 0) {
            result = p.subtract(result);
        }
        return result;
    }

    private static int legendre(BigInteger a) {
        BigInteger mp;
        int cmp;
        if (a.signum() == 0) {
            return 0;
        }
        if (!(a instanceof NativeBigInteger)) {
            a = new NativeBigInteger(a);
        }
        if ((cmp = (mp = a.modPow(divide_minus_p_1_2, p)).compareTo(BigInteger.ONE)) == 0) {
            return 1;
        }
        return -1;
    }

    static {
        A = new BigInteger(Long.toString(486662L));
        TWO = new NativeBigInteger("2");
        SPEC = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");
        CURVE = SPEC.getCurve();
        FIELD = CURVE.getField();
        ENCODING = new BigIntegerLittleEndianEncoding();
        ENCODING.setField(FIELD);
        p = TWO.pow(255).subtract(new BigInteger("19"));
        divide_plus_p_3_8 = p.add(new BigInteger("3")).divide(new BigInteger("8"));
        divide_minus_p_1_2 = p.subtract(BigInteger.ONE).divide(TWO);
        divide_minus_p_1_4 = divide_minus_p_1_2.divide(TWO);
        square_root_negative_1 = TWO.modPow(divide_minus_p_1_4, p);
        negative_A = p.subtract(A);
        u = TWO;
        inverted_u = u.modInverse(p);
    }
}

