/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import net.i2p.crypto.EncType;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.PrivateKey;
import net.i2p.data.i2np.GarlicClove;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.ratchet.MuxedSKM;
import net.i2p.router.crypto.ratchet.RatchetSKM;
import net.i2p.router.message.CloveSet;
import net.i2p.util.Log;

public class GarlicMessageParser {
    private final Log _log;
    private final RouterContext _context;
    private static final int MAX_CLOVES = 32;

    public GarlicMessageParser(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(GarlicMessageParser.class);
    }

    CloveSet getGarlicCloves(GarlicMessage message, PrivateKey encryptionKey, SessionKeyManager skm) {
        byte[] decrData;
        byte[] encData = message.getData();
        try {
            EncType type;
            if (this._log.shouldLog(10)) {
                this._log.debug("Decrypting with private key " + encryptionKey);
            }
            if ((type = encryptionKey.getType()) != EncType.ELGAMAL_2048) {
                if (type == EncType.ECIES_X25519) {
                    RatchetSKM rskm;
                    if (skm instanceof RatchetSKM) {
                        rskm = (RatchetSKM)skm;
                    } else if (skm instanceof MuxedSKM) {
                        rskm = ((MuxedSKM)skm).getECSKM();
                    } else {
                        if (this._log.shouldWarn()) {
                            this._log.warn("No SKM to decrypt ECIES");
                        }
                        return null;
                    }
                    CloveSet rv = this._context.eciesEngine().decrypt(encData, encryptionKey, rskm);
                    if (rv != null) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("ECIES decrypt success, cloves: " + rv.getCloveCount());
                        }
                        return rv;
                    }
                    if (this._log.shouldWarn()) {
                        this._log.warn("ECIES decrypt fail");
                    }
                    return null;
                }
                if (this._log.shouldWarn()) {
                    this._log.warn("Can't decrypt with key type " + type);
                }
                return null;
            }
            decrData = this._context.elGamalAESEngine().decrypt(encData, encryptionKey, skm);
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error decrypting", (Throwable)dfe);
            }
            return null;
        }
        if (decrData == null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Decryption of garlic message failed", (Throwable)new Exception("Decrypt fail"));
            }
            return null;
        }
        try {
            CloveSet rv = this.readCloveSet(decrData, 0);
            if (this._log.shouldDebug()) {
                this._log.debug("Got cloves: " + rv.getCloveCount());
            }
            return rv;
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to read cloveSet", (Throwable)dfe);
            }
            return null;
        }
    }

    CloveSet getGarlicCloves(GarlicMessage message, PrivateKey elgKey, PrivateKey ecKey, SessionKeyManager skm) {
        CloveSet rv;
        byte[] encData = message.getData();
        try {
            if (skm instanceof MuxedSKM) {
                MuxedSKM mskm = (MuxedSKM)skm;
                rv = this._context.eciesEngine().decrypt(encData, elgKey, ecKey, mskm);
            } else if (skm instanceof RatchetSKM) {
                RatchetSKM rskm = (RatchetSKM)skm;
                rv = this._context.eciesEngine().decrypt(encData, ecKey, rskm);
            } else {
                byte[] decrData = this._context.elGamalAESEngine().decrypt(encData, elgKey, skm);
                rv = decrData != null ? this.readCloveSet(decrData, 0) : null;
            }
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Muxed decrypt fail", (Throwable)dfe);
            }
            rv = null;
        }
        if (rv == null && this._log.shouldWarn()) {
            this._log.warn("Muxed decrypt fail");
        }
        return rv;
    }

    public CloveSet readCloveSet(byte[] data, int offset) throws DataFormatException {
        int numCloves = data[offset] & 0xFF;
        ++offset;
        if (numCloves <= 0 || numCloves > 32) {
            throw new DataFormatException("bad clove count " + numCloves);
        }
        GarlicClove[] cloves = new GarlicClove[numCloves];
        for (int i = 0; i < numCloves; ++i) {
            GarlicClove clove = new GarlicClove(this._context);
            offset += clove.readBytes(data, offset);
            cloves[i] = clove;
        }
        Certificate cert = Certificate.create((byte[])data, (int)offset);
        long msgId = DataHelper.fromLong((byte[])data, (int)(offset += cert.size()), (int)4);
        long expiration = DataHelper.fromLong((byte[])data, (int)(offset += 4), (int)8);
        CloveSet set = new CloveSet(cloves, cert, msgId, expiration);
        return set;
    }
}

