/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.ratchet.RatchetSessionTag;
import net.i2p.router.message.SendMessageDirectJob;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.util.Log;

public class HandleDatabaseLookupMessageJob
extends JobImpl {
    private final Log _log;
    private final DatabaseLookupMessage _message;
    private boolean _replyKeyConsumed;
    private final Hash _us;
    private final long _msgIDBloomXor;
    private static final int MAX_ROUTERS_RETURNED = 3;
    private static final int CLOSENESS_THRESHOLD = 8;
    private static final int REPLY_TIMEOUT = 60000;
    private static final int MESSAGE_PRIORITY = 300;
    public static final long EXPIRE_DELAY = 3600000L;

    public HandleDatabaseLookupMessageJob(RouterContext ctx, DatabaseLookupMessage receivedMessage, RouterIdentity from, Hash fromHash, long msgIDBloomXor) {
        super(ctx);
        this._log = ctx.logManager().getLog(HandleDatabaseLookupMessageJob.class);
        this._message = receivedMessage;
        this._us = ctx.routerHash();
        this._msgIDBloomXor = msgIDBloomXor;
    }

    protected boolean answerAllQueries() {
        return false;
    }

    @Override
    public void runJob() {
        int type;
        Hash fromKey = this._message.getFrom();
        TunnelId toTunnel = this._message.getReplyTunnel();
        Hash searchKey = this._message.getSearchKey();
        if (toTunnel == null && fromKey.equals((Object)this._us)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping dbLookup for " + searchKey + " with replies going to us");
            }
            return;
        }
        if (this.getContext().router().isHidden() && !searchKey.equals((Object)this._us)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Uninvited dbLookup received with replies going to " + fromKey + " (tunnel " + toTunnel + ")");
            }
            return;
        }
        if (searchKey.equals((Object)Hash.FAKE_HASH)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Zero lookup", (Throwable)new Exception());
            }
            this.getContext().statManager().addRateData("netDb.DLMAllZeros", 1L);
            return;
        }
        if (this._log.shouldLog(10)) {
            if (toTunnel != null) {
                this._log.debug("Handling database lookup message for " + searchKey + " with replies going to " + fromKey + " (tunnel " + toTunnel + ")");
            } else {
                this._log.debug("Handling database lookup message for " + searchKey + " with replies going to " + fromKey);
            }
        }
        DatabaseLookupMessage.Type lookupType = this._message.getSearchType();
        DatabaseEntry dbe = this.getContext().netDb().lookupLocally(searchKey);
        int n = type = dbe != null ? dbe.getType() : -1;
        if (DatabaseEntry.isLeaseSet((int)type) && (lookupType == DatabaseLookupMessage.Type.ANY || lookupType == DatabaseLookupMessage.Type.LS)) {
            LeaseSet ls = (LeaseSet)dbe;
            if (ls.getReceivedAsPublished()) {
                if (this._log.shouldLog(20)) {
                    this._log.info("We have the published LS " + searchKey + ", answering query");
                }
                this.getContext().statManager().addRateData("netDb.lookupsMatchedReceivedPublished", 1L);
                this.sendData(searchKey, (DatabaseEntry)ls, fromKey, toTunnel);
            }
        } else if (type == 0 && lookupType != DatabaseLookupMessage.Type.LS) {
            RouterInfo info = (RouterInfo)dbe;
            if (searchKey.equals((Object)this._us)) {
                this.sendData(searchKey, info, fromKey, toTunnel);
            } else if (info.isCurrent(3600000L)) {
                if (info.isHidden()) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Not answering a query for a hidden peer");
                    }
                    Set<Hash> us = Collections.singleton(this._us);
                    this.sendClosest(searchKey, us, fromKey, toTunnel);
                } else {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("We do have key " + searchKey + " locally as a router info.  sending to " + fromKey);
                    }
                    this.sendData(searchKey, info, fromKey, toTunnel);
                }
            } else {
                Set<Hash> routerHashSet = this.getNearestRouters(lookupType);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Expired " + searchKey + " locally.  sending back " + routerHashSet.size() + " peers to " + fromKey);
                }
                this.sendClosest(searchKey, routerHashSet, fromKey, toTunnel);
            }
        } else {
            Set<Hash> routerHashSet = this.getNearestRouters(lookupType);
            if (this._log.shouldLog(10)) {
                this._log.debug("We do not have key " + searchKey + " locally.  sending back " + routerHashSet.size() + " peers to " + fromKey);
            }
            this.sendClosest(searchKey, routerHashSet, fromKey, toTunnel);
        }
    }

    private Set<Hash> getNearestRouters(DatabaseLookupMessage.Type lookupType) {
        Set<Hash> dontInclude = this._message.getDontIncludePeers();
        if (dontInclude == null && lookupType == DatabaseLookupMessage.Type.EXPL) {
            dontInclude = new HashSet<Hash>(2);
            dontInclude.add(this._us);
            dontInclude.add(Hash.FAKE_HASH);
        } else if (dontInclude == null) {
            dontInclude = Collections.singleton(this._us);
        } else if (lookupType == DatabaseLookupMessage.Type.EXPL) {
            dontInclude.add(this._us);
            dontInclude.add(Hash.FAKE_HASH);
        } else {
            dontInclude.add(this._us);
        }
        return this.getContext().netDb().findNearestRouters(this._message.getSearchKey(), 3, dontInclude);
    }

    private void sendData(Hash key, DatabaseEntry data, Hash toPeer, TunnelId replyTunnel) {
        if (!key.equals((Object)data.getHash())) {
            this._log.error("Hash mismatch HDLMJ");
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending data matching key " + key + " to peer " + toPeer + " tunnel " + replyTunnel);
        }
        DatabaseStoreMessage msg = new DatabaseStoreMessage(this.getContext());
        if (data.isLeaseSet()) {
            this.getContext().statManager().addRateData("netDb.lookupsMatchedLeaseSet", 1L);
        }
        msg.setEntry(data);
        this.getContext().statManager().addRateData("netDb.lookupsMatched", 1L);
        this.getContext().statManager().addRateData("netDb.lookupsHandled", 1L);
        this.sendMessage(msg, toPeer, replyTunnel);
    }

    protected void sendClosest(Hash key, Set<Hash> routerHashes, Hash toPeer, TunnelId replyTunnel) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending closest routers to key " + key + ": # peers = " + routerHashes.size() + " tunnel " + replyTunnel);
        }
        DatabaseSearchReplyMessage msg = new DatabaseSearchReplyMessage(this.getContext());
        msg.setFromHash(this._us);
        msg.setSearchKey(key);
        int i = 0;
        for (Hash h : routerHashes) {
            msg.addReply(h);
            if (++i < 3) continue;
            break;
        }
        this.getContext().statManager().addRateData("netDb.lookupsHandled", 1L);
        this.sendMessage(msg, toPeer, replyTunnel);
    }

    protected void sendMessage(I2NPMessage message, Hash toPeer, TunnelId replyTunnel) {
        if (replyTunnel != null) {
            this.sendThroughTunnel(message, toPeer, replyTunnel);
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending reply directly to " + toPeer);
            }
            SendMessageDirectJob send = new SendMessageDirectJob(this.getContext(), message, toPeer, 60000, 300, this._msgIDBloomXor);
            send.runJob();
        }
    }

    private void sendThroughTunnel(I2NPMessage message, Hash toPeer, TunnelId replyTunnel) {
        if (this._us.equals((Object)toPeer)) {
            TunnelGatewayMessage m = new TunnelGatewayMessage(this.getContext());
            m.setMessage(message);
            m.setTunnelId(replyTunnel);
            m.setMessageExpiration(message.getMessageExpiration());
            this.getContext().tunnelDispatcher().dispatch(m);
        } else {
            SessionKey replyKey;
            if (!this._replyKeyConsumed && (replyKey = this._message.getReplyKey()) != null) {
                SessionTag tag = this._message.getReplyTag();
                if (tag != null) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Sending AES reply to " + toPeer + ' ' + replyKey + ' ' + tag);
                    }
                    message = MessageWrapper.wrap(this.getContext(), message, replyKey, tag);
                } else {
                    RatchetSessionTag rtag = this._message.getRatchetReplyTag();
                    if (this._log.shouldLog(20)) {
                        this._log.info("Sending AEAD reply to " + toPeer + ' ' + replyKey + ' ' + rtag);
                    }
                    message = MessageWrapper.wrap(this.getContext(), message, replyKey, rtag);
                }
                if (message == null) {
                    this._log.error("DLM reply encryption error");
                    return;
                }
                this._replyKeyConsumed = true;
            }
            TunnelGatewayMessage m = new TunnelGatewayMessage(this.getContext());
            m.setMessage(message);
            m.setMessageExpiration(message.getMessageExpiration());
            m.setTunnelId(replyTunnel);
            SendMessageDirectJob j = new SendMessageDirectJob(this.getContext(), m, toPeer, 10000, 300, this._msgIDBloomXor);
            j.runJob();
        }
    }

    @Override
    public String getName() {
        return "Handle Database Lookup Message";
    }

    @Override
    public void dropped() {
        this.getContext().messageHistory().messageProcessingError(this._message.getUniqueId(), this._message.getClass().getName(), "Dropped due to overload");
    }
}

