/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SigType;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.kademlia.KBucketSet;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.LeaseSetKeys;
import net.i2p.router.OutNetMessage;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.StoreMessageSelector;
import net.i2p.router.networkdb.kademlia.StoreState;
import net.i2p.router.tunnel.pool.ConnectChecker;
import net.i2p.util.Log;
import net.i2p.util.VersionComparator;

abstract class StoreJob
extends JobImpl {
    protected final Log _log;
    private final KademliaNetworkDatabaseFacade _facade;
    protected final StoreState _state;
    private final Job _onSuccess;
    private final Job _onFailure;
    private final long _timeoutMs;
    private final long _expiration;
    private final PeerSelector _peerSelector;
    private final ConnectChecker _connectChecker;
    private final int _connectMask;
    private static final int PARALLELIZATION = 4;
    private static final int REDUNDANCY = 4;
    private static final int STORE_PRIORITY = 460;
    private static final int MAX_PEERS_SENT = 10;
    private static final int MAX_DIRECT_EXPIRATION = 15000;
    public static final String MIN_STORE_VERSION = "0.9.59";
    public static final String MIN_STORE_LS2_VERSION = "0.9.59";
    public static final String MIN_STORE_ENCLS2_VERSION = "0.9.59";

    public StoreJob(RouterContext context, KademliaNetworkDatabaseFacade facade, Hash key, DatabaseEntry data, Job onSuccess, Job onFailure, long timeoutMs) {
        this(context, facade, key, data, onSuccess, onFailure, timeoutMs, null);
    }

    public StoreJob(RouterContext context, KademliaNetworkDatabaseFacade facade, Hash key, DatabaseEntry data, Job onSuccess, Job onFailure, long timeoutMs, Set<Hash> toSkip) {
        super(context);
        this._log = context.logManager().getLog(StoreJob.class);
        this._facade = facade;
        this._state = new StoreState(this.getContext(), key, data, toSkip);
        this._onSuccess = onSuccess;
        this._onFailure = onFailure;
        this._timeoutMs = timeoutMs;
        this._expiration = context.clock().now() + timeoutMs;
        this._peerSelector = facade.getPeerSelector();
        if (data.isLeaseSet()) {
            this._connectChecker = null;
            this._connectMask = 0;
        } else {
            this._connectChecker = new ConnectChecker(context);
            RouterInfo us = context.router().getRouterInfo();
            this._connectMask = us != null ? this._connectChecker.getOutboundMask(us) : 19;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": New store job (dbid: " + this._facade + ") for\n" + data, (Throwable)new Exception("I did it"));
        }
    }

    @Override
    public String getName() {
        return "Kademlia NetDb Store";
    }

    @Override
    public void runJob() {
        this.sendNext();
    }

    private boolean isExpired() {
        return this.getContext().clock().now() >= this._expiration;
    }

    private void sendNext() {
        if (this._state.completed()) {
            if (this._log.shouldLog(20)) {
                this._log.info("Already completed");
            }
            return;
        }
        if (this.isExpired()) {
            this._state.complete(true);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Expired: " + this._timeoutMs);
            }
            this.fail();
        } else if (this._state.getAttemptedCount() > 10) {
            this._state.complete(true);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Max sent");
            }
            this.fail();
        } else {
            this.continueSending();
        }
    }

    protected int getParallelization() {
        return 4;
    }

    protected int getRedundancy() {
        return 4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized void continueSending() {
        List<Hash> closestHashes;
        if (this._state.completed()) {
            return;
        }
        int toCheck = this.getParallelization() - this._state.getPendingCount();
        if (toCheck <= 0) {
            if (!this._log.shouldLog(10)) return;
            this._log.debug(this.getJobId() + ": Too many store messages pending");
            return;
        }
        if (toCheck > this.getParallelization()) {
            toCheck = this.getParallelization();
        }
        if ((closestHashes = this.getClosestFloodfillRouters(this._state.getTarget(), toCheck, this._state.getAttempted())) == null || closestHashes.isEmpty()) {
            if (this._state.getPendingCount() > 0) {
                if (!this._log.shouldLog(20)) return;
                this._log.info(this.getJobId() + ": No more peers left but some are pending, so keep waiting");
                return;
            }
            if (this._log.shouldLog(20)) {
                this._log.info("JobId: " + this.getJobId() + " (dbid: " + this._facade + "): No more peers left and none pending");
            }
            this.fail();
            return;
        }
        int queued = 0;
        int skipped = 0;
        int type = this._state.getData().getType();
        boolean isls = DatabaseEntry.isLeaseSet((int)type);
        boolean isls2 = isls && type != 1;
        SigType lsSigType = isls && type != 5 ? this._state.getData().getKeysAndCert().getSigningPublicKey().getType() : null;
        for (Hash peer : closestHashes) {
            DatabaseEntry ds = this._facade.isClientDb() ? ((FloodfillNetworkDatabaseFacade)this.getContext().netDb()).getDataStore().get(peer) : this._facade.getDataStore().get(peer);
            if (ds == null || ds.getType() != 0) {
                if (this._log.shouldLog(20)) {
                    this._log.info("JobId: " + this.getJobId() + " (for dbid: " + this._facade + "): Error selecting closest hash that wasnt a router! " + peer + " : " + ds);
                }
                this._state.addSkipped(peer);
                ++skipped;
                continue;
            }
            if (!StoreJob.shouldStoreTo((RouterInfo)ds)) {
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getJobId() + ": Skipping old router " + peer);
                }
                this._state.addSkipped(peer);
                ++skipped;
                continue;
            }
            if (!(type != 5 && lsSigType != SigType.RedDSA_SHA512_Ed25519 || StoreJob.shouldStoreEncLS2To((RouterInfo)ds))) {
                if (this._log.shouldInfo()) {
                    this._log.info(this.getJobId() + ": Skipping router that doesn't support EncLS2/RedDSA " + peer);
                }
                this._state.addSkipped(peer);
                ++skipped;
                continue;
            }
            int peerTimeout = this._facade.getPeerTimeout(peer);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + "(dbid: " + this._facade + "): Continue sending key " + this._state.getTarget() + " after " + this._state.getAttemptedCount() + " tries to " + closestHashes);
            }
            this._state.addPending(peer);
            this.sendStore((RouterInfo)ds, peerTimeout);
            ++queued;
        }
        if (queued != 0) return;
        if (this._state.getPendingCount() > 0) return;
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + "(dbid: " + this._facade + "): No more peers left after skipping " + skipped + " and none pending");
        }
        this.getContext().jobQueue().addJob(new WaitJob(this.getContext()));
    }

    private List<Hash> getClosestFloodfillRouters(Hash key, int numClosest, Set<Hash> alreadyChecked) {
        Hash rkey = this.getContext().routingKeyGenerator().getRoutingKey(key);
        KBucketSet<Hash> ks = this._facade.getKBuckets();
        if (ks == null) {
            return new ArrayList<Hash>();
        }
        List<Hash> rv = ((FloodfillPeerSelector)this._peerSelector).selectFloodfillParticipants(rkey, numClosest, alreadyChecked, ks);
        return rv;
    }

    private void sendStore(RouterInfo router, int responseTime) {
        if (!this._state.getTarget().equals((Object)this._state.getData().getHash())) {
            this._log.error("Hash mismatch StoreJob");
            return;
        }
        if (router.getIdentity().equals((Object)this.getContext().router().getRouterInfo().getIdentity())) {
            this._log.error(this.getJobId() + ": Dont send store to ourselves - why did we try?");
            return;
        }
        DatabaseStoreMessage msg = new DatabaseStoreMessage(this.getContext());
        int type = this._state.getData().getType();
        if (type == 0) {
            if (responseTime > 15000) {
                responseTime = 15000;
            }
        } else if (!DatabaseEntry.isLeaseSet((int)type)) {
            throw new IllegalArgumentException("Storing an unknown data type! " + this._state.getData());
        }
        msg.setEntry(this._state.getData());
        long now = this.getContext().clock().now();
        msg.setMessageExpiration(now + this._timeoutMs);
        long token = 1L + this.getContext().random().nextLong(0xFFFFFFFFL);
        msg.setReplyToken(token);
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": send(dbStore) w/ token expected " + msg.getReplyToken() + " msg exp. " + this._timeoutMs + " resp exp. " + responseTime);
        }
        this.sendStore(msg, router, now + (long)responseTime);
    }

    private void sendStore(DatabaseStoreMessage msg, RouterInfo peer, long expiration) {
        RouterContext ctx = this.getContext();
        if (msg.getEntry().isLeaseSet()) {
            ctx.statManager().addRateData("netDb.storeLeaseSetSent", 1L);
            if (this._facade.isClientDb()) {
                this.sendStoreThroughClient(msg, peer, expiration);
            } else if (ctx.keyRing().get((Object)msg.getKey()) != null) {
                this.sendStoreThroughExploratory(msg, peer, expiration);
            } else if (msg.getEntry().getType() == 7) {
                this.sendWrappedStoreThroughExploratory(msg, peer, expiration);
            } else {
                this.sendStoreThroughClient(msg, peer, expiration);
            }
        } else {
            ctx.statManager().addRateData("netDb.storeRouterInfoSent", 1L);
            Hash h = peer.getIdentity().getHash();
            if (this._facade.isClientDb()) {
                this.sendStoreThroughExploratory(msg, peer, expiration);
                if (this._log.shouldLog(30)) {
                    this._log.warn("[JobId: " + this.getJobId() + "; dbid: " + this._facade + "]: Sending RI store (though exploratory tunnels) in a client context to " + peer.getIdentity().getHash() + " with message " + msg);
                }
            } else if (ctx.commSystem().isEstablished(h) || !ctx.commSystem().wasUnreachable(h) && this._connectChecker.canConnect(this._connectMask, peer)) {
                this.sendDirect(msg, peer, expiration);
            } else {
                this.sendStoreThroughExploratory(msg, peer, expiration);
            }
        }
    }

    private void sendDirect(DatabaseStoreMessage msg, RouterInfo peer, long expiration) {
        if (this._facade.isClientDb()) {
            this._log.error("Error! Direct DatabaseStoreMessage attempted in client context! Message: " + msg);
            return;
        }
        msg.setReplyGateway(this.getContext().routerHash());
        Hash to = peer.getIdentity().getHash();
        this._state.addPending(to);
        SendSuccessJob onReply = new SendSuccessJob(this.getContext(), peer);
        FailedJob onFail = new FailedJob(this.getContext(), peer, this.getContext().clock().now());
        StoreMessageSelector selector = new StoreMessageSelector(this.getContext(), this.getJobId(), peer, msg.getReplyToken(), expiration);
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": sending store directly to " + to);
        }
        OutNetMessage m = new OutNetMessage(this.getContext(), msg, expiration, 460, peer);
        m.setOnFailedReplyJob(onFail);
        m.setOnFailedSendJob(onFail);
        m.setOnReplyJob(onReply);
        m.setReplySelector(selector);
        this.getContext().messageRegistry().registerPending(m);
        this.getContext().commSystem().processMessage(m);
    }

    private void sendStoreThroughExploratory(DatabaseStoreMessage msg, RouterInfo peer, long expiration) {
        Hash to = peer.getIdentity().getHash();
        TunnelInfo replyTunnel = this._state.getAttemptedCount() <= 1 ? this.getContext().tunnelManager().selectInboundExploratoryTunnel(to) : this.getContext().tunnelManager().selectInboundTunnel();
        if (replyTunnel == null) {
            this._log.warn("No reply inbound tunnels available!");
            return;
        }
        TunnelId replyTunnelId = replyTunnel.getReceiveTunnelId(0);
        msg.setReplyTunnel(replyTunnelId);
        msg.setReplyGateway(replyTunnel.getPeer(0));
        this._state.addPending(to);
        TunnelInfo outTunnel = this._state.getAttemptedCount() <= 1 ? this.getContext().tunnelManager().selectOutboundExploratoryTunnel(to) : this.getContext().tunnelManager().selectOutboundTunnel();
        if (outTunnel != null) {
            SendSuccessJob onReply = new SendSuccessJob(this.getContext(), peer, outTunnel, msg.getMessageSize());
            FailedJob onFail = new FailedJob(this.getContext(), peer, this.getContext().clock().now());
            StoreMessageSelector selector = new StoreMessageSelector(this.getContext(), this.getJobId(), peer, msg.getReplyToken(), expiration);
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": sending store to " + to + " through " + outTunnel + ": " + msg);
            }
            this.getContext().messageRegistry().registerPending(selector, onReply, onFail);
            this.getContext().tunnelDispatcher().dispatchOutbound(msg, outTunnel.getSendTunnelId(0), null, to);
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("No outbound tunnels to send a dbStore out!");
            }
            this.fail();
        }
    }

    private void sendStoreThroughClient(DatabaseStoreMessage msg, RouterInfo peer, long expiration) {
        TunnelId replyTunnelId;
        Hash replyGW;
        RouterContext ctx = this.getContext();
        int dstype = msg.getEntry().getType();
        Hash client = dstype == 5 ? ((LeaseSet)msg.getEntry()).getDestination().calculateHash() : msg.getKey();
        RouterIdentity ident = peer.getIdentity();
        Hash to = ident.getHash();
        if (dstype == 3 || dstype == 1) {
            LeaseSet ls = (LeaseSet)msg.getEntry();
            Lease lease = this.pickReplyTunnel(ls, this._state.getAttemptedCount(), to);
            replyGW = lease.getGateway();
            replyTunnelId = lease.getTunnelId();
        } else {
            TunnelInfo replyTunnel = this._state.getAttemptedCount() <= 1 ? ctx.tunnelManager().selectInboundTunnel(client, to) : ctx.tunnelManager().selectInboundTunnel(client);
            if (replyTunnel == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("No reply inbound tunnels available!");
                }
                this.fail();
                return;
            }
            replyTunnelId = replyTunnel.getReceiveTunnelId(0);
            replyGW = replyTunnel.getPeer(0);
        }
        msg.setReplyTunnel(replyTunnelId);
        msg.setReplyGateway(replyGW);
        TunnelInfo outTunnel = this._state.getAttemptedCount() <= 1 ? ctx.tunnelManager().selectOutboundTunnel(client, to) : ctx.tunnelManager().selectOutboundTunnel(client);
        if (outTunnel != null) {
            FastI2NPMessageImpl sent;
            LeaseSetKeys lsk = ctx.keyManager().getKeys(client);
            EncType type = ident.getPublicKey().getType();
            if (type == EncType.ELGAMAL_2048 && (lsk == null || lsk.isSupported(EncType.ELGAMAL_2048))) {
                MessageWrapper.WrappedMessage wm = MessageWrapper.wrap(ctx, (I2NPMessage)msg, client, peer);
                if (wm == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Fail garlic encrypting from: " + client);
                    }
                    this.fail();
                    return;
                }
                sent = wm.getMessage();
                this._state.addPending(to, wm);
            } else if (type == EncType.ECIES_X25519 || lsk.isSupported(EncType.ECIES_X25519)) {
                sent = MessageWrapper.wrap(ctx, (I2NPMessage)msg, peer);
                if (sent == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Fail garlic encrypting from: " + client);
                    }
                    this.fail();
                    return;
                }
                this._state.addPending(to);
            } else {
                sent = msg;
                this._state.addPending(to);
            }
            SendSuccessJob onReply = new SendSuccessJob(ctx, peer, outTunnel, sent.getMessageSize());
            FailedJob onFail = new FailedJob(ctx, peer, ctx.clock().now());
            StoreMessageSelector selector = new StoreMessageSelector(ctx, this.getJobId(), peer, msg.getReplyToken(), expiration);
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + "(dbid: " + this._facade + "): sending encrypted store through client tunnel to " + to + " through " + outTunnel + ": " + sent + " with reply to " + replyGW + ' ' + replyTunnelId);
            }
            ctx.messageRegistry().registerPending(selector, onReply, onFail);
            ctx.tunnelDispatcher().dispatchOutbound(sent, outTunnel.getSendTunnelId(0), null, to);
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("No outbound tunnels to send a dbStore out - delaying...");
            }
            this._state.replyTimeout(to);
            WaitJob waiter = new WaitJob(ctx);
            waiter.getTiming().setStartAfter(ctx.clock().now() + 3000L);
            ctx.jobQueue().addJob(waiter);
        }
    }

    private Lease pickReplyTunnel(LeaseSet ls, int attempts, Hash to) {
        int c = ls.getLeaseCount();
        if (c <= 0) {
            throw new IllegalStateException();
        }
        if (c == 1) {
            return ls.getLease(0);
        }
        if (attempts > 1) {
            return ls.getLease(this.getContext().random().nextInt(c));
        }
        Lease[] leases = new Lease[c];
        for (int i = 0; i < c; ++i) {
            leases[i] = ls.getLease(i);
        }
        Arrays.sort(leases, new LeaseComparator(to));
        return leases[0];
    }

    private void sendWrappedStoreThroughExploratory(DatabaseStoreMessage msg, RouterInfo peer, long expiration) {
        RouterContext ctx = this.getContext();
        Hash to = peer.getIdentity().getHash();
        TunnelInfo replyTunnel = this._state.getAttemptedCount() <= 1 ? ctx.tunnelManager().selectInboundExploratoryTunnel(to) : ctx.tunnelManager().selectInboundTunnel();
        if (replyTunnel == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No inbound expl. tunnels for reply - delaying...");
            }
            this._state.replyTimeout(to);
            WaitJob waiter = new WaitJob(ctx);
            waiter.getTiming().setStartAfter(ctx.clock().now() + 3000L);
            ctx.jobQueue().addJob(waiter);
            return;
        }
        TunnelId replyTunnelId = replyTunnel.getReceiveTunnelId(0);
        msg.setReplyTunnel(replyTunnelId);
        msg.setReplyGateway(replyTunnel.getPeer(0));
        TunnelInfo outTunnel = this._state.getAttemptedCount() <= 1 ? ctx.tunnelManager().selectOutboundExploratoryTunnel(to) : ctx.tunnelManager().selectOutboundTunnel();
        if (outTunnel != null) {
            GarlicMessage sent;
            EncType ptype = peer.getIdentity().getPublicKey().getType();
            EncType mtype = ctx.keyManager().getPublicKey().getType();
            if (ptype == EncType.ELGAMAL_2048 && mtype == EncType.ELGAMAL_2048) {
                MessageWrapper.WrappedMessage wm = MessageWrapper.wrap(ctx, (I2NPMessage)msg, null, peer);
                if (wm == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Fail garlic encrypting");
                    }
                    this.fail();
                    return;
                }
                sent = wm.getMessage();
                this._state.addPending(to, wm);
            } else {
                sent = MessageWrapper.wrap(ctx, (I2NPMessage)msg, peer);
                this._state.addPending(to);
            }
            SendSuccessJob onReply = new SendSuccessJob(ctx, peer, outTunnel, sent.getMessageSize());
            FailedJob onFail = new FailedJob(ctx, peer, ctx.clock().now());
            StoreMessageSelector selector = new StoreMessageSelector(ctx, this.getJobId(), peer, msg.getReplyToken(), expiration);
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": sending encrypted store to " + to + " through " + outTunnel + ": " + sent);
            }
            ctx.messageRegistry().registerPending(selector, onReply, onFail);
            ctx.tunnelDispatcher().dispatchOutbound(sent, outTunnel.getSendTunnelId(0), null, to);
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("No outbound expl. tunnels to send a dbStore out - delaying...");
            }
            this._state.replyTimeout(to);
            WaitJob waiter = new WaitJob(ctx);
            waiter.getTiming().setStartAfter(ctx.clock().now() + 3000L);
            ctx.jobQueue().addJob(waiter);
        }
    }

    static boolean shouldStoreTo(RouterInfo ri) {
        String v = ri.getVersion();
        if (VersionComparator.comp((String)v, (String)"0.9.59") < 0) {
            return false;
        }
        RouterIdentity ident = ri.getIdentity();
        if (ident.getSigningPublicKey().getType() == SigType.DSA_SHA1) {
            return false;
        }
        EncType type = ident.getPublicKey().getType();
        return LeaseSetKeys.SET_BOTH.contains(type);
    }

    static boolean shouldStoreLS2To(RouterInfo ri) {
        String v = ri.getVersion();
        return VersionComparator.comp((String)v, (String)"0.9.59") >= 0;
    }

    static boolean shouldStoreEncLS2To(RouterInfo ri) {
        String v = ri.getVersion();
        return VersionComparator.comp((String)v, (String)"0.9.59") >= 0;
    }

    protected void succeed() {
        if (this._log.shouldDebug()) {
            this._log.debug(this.getJobId() + ": State of successful send: " + this._state);
        }
        if (this._onSuccess != null) {
            this.getContext().jobQueue().addJob(this._onSuccess);
        }
        this._state.complete(true);
        this.getContext().statManager().addRateData("netDb.storePeers", (long)this._state.getAttemptedCount());
    }

    protected void fail() {
        if (this._log.shouldInfo()) {
            this._log.info(this.getJobId() + ": Failed sending key " + this._state.getTarget());
            if (this._log.shouldDebug()) {
                this._log.debug(this.getJobId() + ": State of failed send: " + this._state, (Throwable)new Exception("Who failed me?"));
            }
        }
        if (this._onFailure != null) {
            this.getContext().jobQueue().addJob(this._onFailure);
        }
        this._state.complete(true);
        this.getContext().statManager().addRateData("netDb.storeFailedPeers", (long)this._state.getAttemptedCount());
    }

    private class FailedJob
    extends JobImpl {
        private final RouterInfo _peer;
        private final long _sendOn;
        private final AtomicBoolean _wasRun;

        public FailedJob(RouterContext enclosingContext, RouterInfo peer, long sendOn) {
            super(enclosingContext);
            this._wasRun = new AtomicBoolean();
            this._peer = peer;
            this._sendOn = sendOn;
        }

        @Override
        public void runJob() {
            MessageWrapper.WrappedMessage wm;
            if (!this._wasRun.compareAndSet(false, true)) {
                return;
            }
            Hash hash = this._peer.getIdentity().getHash();
            if (StoreJob.this._log.shouldLog(20)) {
                StoreJob.this._log.info(StoreJob.this.getJobId() + ": Peer " + hash.toBase64() + " timed out sending " + StoreJob.this._state.getTarget());
            }
            if ((wm = StoreJob.this._state.getPendingMessage(hash)) != null) {
                wm.fail();
            }
            StoreJob.this._state.replyTimeout(hash);
            this.getContext().profileManager().dbStoreFailed(hash);
            this.getContext().statManager().addRateData("netDb.replyTimeout", this.getContext().clock().now() - this._sendOn);
            StoreJob.this.sendNext();
        }

        @Override
        public String getName() {
            return "Kademlia Store Send Failed";
        }
    }

    private class SendSuccessJob
    extends JobImpl
    implements ReplyJob {
        private final RouterInfo _peer;
        private final TunnelInfo _sendThrough;
        private final int _msgSize;

        public SendSuccessJob(RouterContext enclosingContext, RouterInfo peer) {
            this(enclosingContext, peer, null, 0);
        }

        public SendSuccessJob(RouterContext enclosingContext, RouterInfo peer, TunnelInfo sendThrough, int size) {
            super(enclosingContext);
            this._peer = peer;
            this._sendThrough = sendThrough;
            this._msgSize = size <= 0 ? 0 : (size + 1023) / 1024 * 1024;
        }

        @Override
        public String getName() {
            return "Kademlia Store Send Success";
        }

        @Override
        public void runJob() {
            Hash hash = this._peer.getIdentity().getHash();
            MessageWrapper.WrappedMessage wm = StoreJob.this._state.getPendingMessage(hash);
            if (wm != null) {
                wm.acked();
            }
            long howLong = StoreJob.this._state.confirmed(hash);
            if (StoreJob.this._log.shouldLog(20)) {
                StoreJob.this._log.info(StoreJob.this.getJobId() + ": Marking store of " + StoreJob.this._state.getTarget() + " to " + hash.toBase64() + " successful after " + howLong);
            }
            this.getContext().profileManager().dbStoreSent(hash, howLong);
            this.getContext().statManager().addRateData("netDb.ackTime", howLong, howLong);
            if (this._sendThrough != null && this._msgSize > 0) {
                if (StoreJob.this._log.shouldDebug()) {
                    StoreJob.this._log.debug(StoreJob.this.getJobId() + ": sent a " + this._msgSize + " byte netDb message through tunnel " + this._sendThrough + " after " + howLong);
                }
                for (int i = 0; i < this._sendThrough.getLength(); ++i) {
                    this.getContext().profileManager().tunnelDataPushed(this._sendThrough.getPeer(i), howLong, this._msgSize);
                }
                this._sendThrough.incrementVerifiedBytesTransferred(this._msgSize);
            }
            if (this._sendThrough == null) {
                this.getContext().commSystem().mayDisconnect(this._peer.getHash());
            }
            if (StoreJob.this._state.getCompleteCount() >= StoreJob.this.getRedundancy()) {
                StoreJob.this.succeed();
            } else {
                StoreJob.this.sendNext();
            }
        }

        @Override
        public void setMessage(I2NPMessage message) {
        }
    }

    private class WaitJob
    extends JobImpl {
        public WaitJob(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        @Override
        public void runJob() {
            StoreJob.this.sendNext();
        }

        @Override
        public String getName() {
            return "Kademlia Store Send Delay";
        }
    }

    private static class LeaseComparator
    implements Comparator<Lease>,
    Serializable {
        private final byte[] _base;

        public LeaseComparator(Hash target) {
            this._base = target.getData();
        }

        @Override
        public int compare(Lease lhs, Lease rhs) {
            byte[] lhsb = lhs.getGateway().getData();
            byte[] rhsb = rhs.getGateway().getData();
            for (int i = 0; i < this._base.length; ++i) {
                int ld = (lhsb[i] ^ this._base[i]) & 0xFF;
                int rd = (rhsb[i] ^ this._base[i]) & 0xFF;
                if (ld < rd) {
                    return -1;
                }
                if (ld <= rd) continue;
                return 1;
            }
            return (int)(rhs.getEndTime() - lhs.getEndTime());
        }
    }
}

