/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Properties;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.ProfilePersistenceHelper;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class DBHistory {
    private final Log _log;
    private final RouterContext _context;
    private final RateStat _failedLookupRate;
    private final RateStat _invalidReplyRate;
    private long _lastLookupSuccessful;
    private long _lastLookupFailed;
    private long _lastStoreSuccessful;
    private long _lastStoreFailed;
    private long _unpromptedDbStoreNew;
    private long _unpromptedDbStoreOld;
    private final String _statGroup;
    private static final String NL = System.getProperty("line.separator");

    public DBHistory(RouterContext context, String statGroup) {
        this._context = context;
        this._log = context.logManager().getLog(DBHistory.class);
        this._statGroup = statGroup;
        this._failedLookupRate = new RateStat("dbHistory.failedLookupRate", "How often does this peer to respond to a lookup?", statGroup, new long[]{600000L, 3600000L, 86400000L});
        this._invalidReplyRate = new RateStat("dbHistory.invalidReplyRate", "How often does this peer give us a bad (nonexistant, forged, etc) peer?", statGroup, new long[]{1800000L});
    }

    public long getLastLookupSuccessful() {
        return this._lastLookupSuccessful;
    }

    public long getLastLookupFailed() {
        return this._lastLookupFailed;
    }

    public long getLastStoreSuccessful() {
        return this._lastStoreSuccessful;
    }

    public long getLastStoreFailed() {
        return this._lastStoreFailed;
    }

    public long getUnpromptedDbStoreNew() {
        return this._unpromptedDbStoreNew;
    }

    public long getUnpromptedDbStoreOld() {
        return this._unpromptedDbStoreOld;
    }

    public RateStat getFailedLookupRate() {
        return this._failedLookupRate;
    }

    public RateStat getInvalidReplyRate() {
        return this._invalidReplyRate;
    }

    public void lookupSuccessful() {
        this._failedLookupRate.addData(0L);
        this._context.statManager().addRateData("peer.failedLookupRate", 0L);
        this._lastLookupSuccessful = this._context.clock().now();
    }

    public void lookupFailed() {
        this._failedLookupRate.addData(1L);
        this._context.statManager().addRateData("peer.failedLookupRate", 1L);
        this._lastLookupFailed = this._context.clock().now();
    }

    public void storeSuccessful() {
        this._failedLookupRate.addData(0L);
        this._context.statManager().addRateData("peer.failedLookupRate", 0L);
        this._lastStoreSuccessful = this._context.clock().now();
    }

    public void storeFailed() {
        this._failedLookupRate.addData(1L);
        this._lastStoreFailed = this._context.clock().now();
    }

    public void lookupReply(int newPeers, int oldPeers, int invalid, int duplicate) {
        if (invalid > 0) {
            this._invalidReplyRate.addData((long)invalid);
        }
    }

    public void unpromptedStoreReceived(boolean wasNew) {
        if (wasNew) {
            ++this._unpromptedDbStoreNew;
        } else {
            ++this._unpromptedDbStoreOld;
        }
    }

    public void setUnpromptedDbStoreNew(long num) {
        this._unpromptedDbStoreNew = num;
    }

    public void setUnpromptedDbStoreOld(long num) {
        this._unpromptedDbStoreOld = num;
    }

    public void coalesceStats() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Coallescing stats");
        }
        this._failedLookupRate.coalesceStats();
        this._invalidReplyRate.coalesceStats();
    }

    public void store(OutputStream out) throws IOException {
        this.store(out, true);
    }

    public void store(OutputStream out, boolean addComments) throws IOException {
        StringBuilder buf = new StringBuilder(512);
        if (addComments) {
            buf.append(NL);
            buf.append("#################").append(NL);
            buf.append("# DB history").append(NL);
            buf.append("###").append(NL);
        }
        DBHistory.add(buf, addComments, "unpromptedDbStoreNew", this._unpromptedDbStoreNew, "How times have they sent us something we didn't ask for and hadn't seen before?");
        DBHistory.add(buf, addComments, "unpromptedDbStoreOld", this._unpromptedDbStoreOld, "How times have they sent us something we didn't ask for but have seen before?");
        DBHistory.add(buf, addComments, "lastLookupSuccessful", this._lastLookupSuccessful, "When was the last time a lookup from them succeeded?  (milliseconds since the epoch)");
        DBHistory.add(buf, addComments, "lastLookupFailed", this._lastLookupFailed, "When was the last time a lookup from them failed?  (milliseconds since the epoch)");
        DBHistory.add(buf, addComments, "lastStoreSuccessful", this._lastStoreSuccessful, "When was the last time a store to them succeeded?  (milliseconds since the epoch)");
        DBHistory.add(buf, addComments, "lastStoreFailed", this._lastStoreFailed, "When was the last time a store to them failed?  (milliseconds since the epoch)");
        out.write(buf.toString().getBytes("UTF-8"));
        this._failedLookupRate.store(out, "dbHistory.failedLookupRate", addComments);
        this._invalidReplyRate.store(out, "dbHistory.invalidReplyRate", addComments);
    }

    private static void add(StringBuilder buf, boolean addComments, String name, long val, String description) {
        if (addComments) {
            buf.append("# ").append(name.toUpperCase(Locale.US)).append(NL).append("# ").append(description).append(NL);
        }
        buf.append("dbHistory.").append(name).append('=').append(val).append(NL);
        if (addComments) {
            buf.append(NL);
        }
    }

    public void load(Properties props) {
        this._unpromptedDbStoreNew = DBHistory.getLong(props, "dbHistory.unpromptedDbStoreNew");
        this._unpromptedDbStoreOld = DBHistory.getLong(props, "dbHistory.unpromptedDbStoreOld");
        this._lastLookupSuccessful = DBHistory.getLong(props, "dbHistory.lastLookupSuccessful");
        this._lastLookupFailed = DBHistory.getLong(props, "dbHistory.lastLookupFailed");
        this._lastStoreSuccessful = DBHistory.getLong(props, "dbHistory.lastStoreSuccessful");
        this._lastStoreFailed = DBHistory.getLong(props, "dbHistory.lastStoreFailed");
        try {
            this._failedLookupRate.load(props, "dbHistory.failedLookupRate", true);
            this._log.debug("Loading dbHistory.failedLookupRate");
        }
        catch (IllegalArgumentException iae) {
            this._log.warn("DB History failed lookup rate is corrupt, resetting", (Throwable)iae);
        }
        try {
            this._invalidReplyRate.load(props, "dbHistory.invalidReplyRate", true);
        }
        catch (IllegalArgumentException iae) {
            this._log.warn("DB History invalid reply rate is corrupt", (Throwable)iae);
        }
    }

    private static final long getLong(Properties props, String key) {
        return ProfilePersistenceHelper.getLong(props, key);
    }
}

