/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.CapacityCalculator;
import net.i2p.router.peermanager.DBHistory;
import net.i2p.router.peermanager.IntegrationCalculator;
import net.i2p.router.peermanager.SpeedCalculator;
import net.i2p.router.peermanager.TunnelHistory;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class PeerProfile {
    private final Log _log;
    private final RouterContext _context;
    private final Hash _peer;
    private long _firstHeardAbout;
    private long _lastHeardAbout;
    private long _lastSentToSuccessfully;
    private long _lastFailedSend;
    private long _lastHeardFrom;
    private float _tunnelTestResponseTimeAvg;
    private RateStat _dbResponseTime;
    private RateStat _tunnelCreateResponseTime;
    private RateStat _tunnelTestResponseTime;
    private RateStat _dbIntroduction;
    private int _speedBonus;
    private int _capacityBonus;
    private int _integrationBonus;
    private float _speedValue;
    private float _capacityValue;
    private float _integrationValue;
    private float _speedValueNew;
    private float _capacityValueNew;
    private boolean _coalescing;
    private TunnelHistory _tunnelHistory;
    private DBHistory _dbHistory;
    private boolean _expanded;
    private boolean _expandedDB;
    private final int _distance;
    private static final int THROUGHPUT_COUNT = 3;
    private final float[] _peakThroughput = new float[3];
    private volatile long _peakThroughputCurrentTotal;
    private final float[] _peakTunnelThroughput = new float[3];
    private final float[] _peakTunnel1mThroughput = new float[3];
    private static final int DEGRADES_PER_DAY = 4;
    private static final int DEGRADE_PROBABILITY = 61;
    private static final double TOTAL_DEGRADE_PER_DAY = 0.5;
    private static final float DEGRADE_FACTOR = (float)Math.pow(0.5, 0.25);
    static final boolean ENABLE_TUNNEL_TEST_RESPONSE_TIME = false;
    private long _lastCoalesceDate = System.currentTimeMillis();
    private static final Set<String> _bigCountries = new HashSet<String>();

    public PeerProfile(RouterContext context, Hash peer) {
        this(context, peer, true);
    }

    private PeerProfile(RouterContext context, Hash peer, boolean expand) {
        Hash us;
        if (peer == null) {
            throw new NullPointerException();
        }
        this._context = context;
        this._log = context.logManager().getLog(PeerProfile.class);
        this._peer = peer;
        this._firstHeardAbout = this._context.clock().now();
        if (expand) {
            this.expandProfile();
        }
        this._distance = (us = this._context.routerHash()) != null ? (this._peer.getData()[0] & 0xFF ^ us.getData()[0] & 0xFF) - 127 : 0;
    }

    public Hash getPeer() {
        return this._peer;
    }

    public boolean getIsExpanded() {
        return this._expanded;
    }

    public boolean getIsExpandedDB() {
        return this._expandedDB;
    }

    public boolean getIsActive() {
        return this.getIsActive(300000L, this._context.clock().now());
    }

    public boolean getIsActive(long now) {
        return this.getIsActive(300000L, now);
    }

    boolean isEstablished() {
        CommSystemFacade cs = this._context.commSystem();
        if (cs == null) {
            return false;
        }
        return cs.isEstablished(this._peer);
    }

    boolean wasUnreachable() {
        CommSystemFacade cs = this._context.commSystem();
        if (cs == null) {
            return false;
        }
        return cs.wasUnreachable(this._peer);
    }

    boolean isSameCountry() {
        CommSystemFacade cs = this._context.commSystem();
        if (cs == null) {
            return false;
        }
        String us = cs.getOurCountry();
        return us != null && (_bigCountries.contains(us) || this._context.getProperty("profileOrganizer.sameCountryBonus") != null) && us.equals(cs.getCountry(this._peer));
    }

    int getXORDistance() {
        return this._distance;
    }

    public boolean getIsActive(long period, long now) {
        long before = now - period;
        return this.getLastHeardFrom() < before || this.getLastSendSuccessful() < before || this.isEstablished();
    }

    public synchronized long getFirstHeardAbout() {
        return this._firstHeardAbout;
    }

    synchronized void setFirstHeardAbout(long when) {
        if (when < this._firstHeardAbout) {
            this._firstHeardAbout = when;
        }
    }

    public synchronized long getLastHeardAbout() {
        return this._lastHeardAbout;
    }

    public synchronized void setLastHeardAbout(long when) {
        if (when > this._lastHeardAbout) {
            this._lastHeardAbout = when;
        }
        if (when < this._firstHeardAbout) {
            this._firstHeardAbout = when;
        }
    }

    public long getLastSendSuccessful() {
        return this._lastSentToSuccessfully;
    }

    public void setLastSendSuccessful(long when) {
        this._lastSentToSuccessfully = when;
    }

    public long getLastSendFailed() {
        return this._lastFailedSend;
    }

    public void setLastSendFailed(long when) {
        this._lastFailedSend = when;
    }

    public long getLastHeardFrom() {
        return this._lastHeardFrom;
    }

    public void setLastHeardFrom(long when) {
        this._lastHeardFrom = when;
    }

    public TunnelHistory getTunnelHistory() {
        return this._tunnelHistory;
    }

    public void setTunnelHistory(TunnelHistory history) {
        this._tunnelHistory = history;
    }

    public DBHistory getDBHistory() {
        return this._dbHistory;
    }

    public void setDBHistory(DBHistory hist) {
        this._dbHistory = hist;
    }

    public RateStat getDbResponseTime() {
        return this._dbResponseTime;
    }

    public RateStat getTunnelCreateResponseTime() {
        return this._tunnelCreateResponseTime;
    }

    @Deprecated
    public RateStat getTunnelTestResponseTime() {
        return this._tunnelTestResponseTime;
    }

    public RateStat getDbIntroduction() {
        return this._dbIntroduction;
    }

    public int getSpeedBonus() {
        return this._speedBonus;
    }

    public void setSpeedBonus(int bonus) {
        this._speedBonus = bonus;
    }

    public int getCapacityBonus() {
        return this._capacityBonus;
    }

    public void setCapacityBonus(int bonus) {
        this._capacityBonus = bonus;
    }

    public int getIntegrationBonus() {
        return this._integrationBonus;
    }

    public void setIntegrationBonus(int bonus) {
        this._integrationBonus = bonus;
    }

    public float getSpeedValue() {
        return this._speedValue;
    }

    public float getCapacityValue() {
        return this._capacityValue;
    }

    public float getIntegrationValue() {
        return this._integrationValue;
    }

    @Deprecated
    public boolean getIsFailing() {
        return false;
    }

    @Deprecated
    public float getTunnelTestTimeAverage() {
        return this._tunnelTestResponseTimeAvg;
    }

    @Deprecated
    void setTunnelTestTimeAverage(float avg) {
    }

    @Deprecated
    void updateTunnelTestTimeAverage(long ms) {
    }

    public float getPeakThroughputKBps() {
        float rv = 0.0f;
        for (int i = 0; i < 3; ++i) {
            rv += this._peakThroughput[i];
        }
        return rv /= 184320.0f;
    }

    void setPeakThroughputKBps(float kBps) {
        float speed = kBps * 61440.0f;
        for (int i = 0; i < 3; ++i) {
            this._peakThroughput[i] = speed;
        }
    }

    void dataPushed(int size) {
        this._peakThroughputCurrentTotal += (long)size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void tunnelDataTransferred(long tunnelByteLifetime) {
        float lowPeak = this._peakTunnelThroughput[2];
        if (!((float)tunnelByteLifetime > lowPeak)) return;
        float[] fArray = this._peakTunnelThroughput;
        synchronized (this._peakTunnelThroughput) {
            for (int i = 0; i < 3; ++i) {
                if (!((float)tunnelByteLifetime > this._peakTunnelThroughput[i])) continue;
                for (int j = 2; j > i; --j) {
                    this._peakTunnelThroughput[j] = this._peakTunnelThroughput[j - 1];
                }
                this._peakTunnelThroughput[i] = tunnelByteLifetime;
                break;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    public float getPeakTunnelThroughputKBps() {
        float rv = 0.0f;
        for (int i = 0; i < 3; ++i) {
            rv += this._peakTunnelThroughput[i];
        }
        return rv /= 1843200.0f;
    }

    void setPeakTunnelThroughputKBps(float kBps) {
        float speed = kBps * 614400.0f;
        for (int i = 0; i < 3; ++i) {
            this._peakTunnelThroughput[i] = speed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void dataPushed1m(int size) {
        float lowPeak = this._peakTunnel1mThroughput[2];
        if (!((float)size > lowPeak)) return;
        float[] fArray = this._peakTunnel1mThroughput;
        synchronized (this._peakTunnel1mThroughput) {
            int i;
            for (i = 0; i < 3; ++i) {
                if (!((float)size > this._peakTunnel1mThroughput[i])) continue;
                for (int j = 2; j > i; --j) {
                    this._peakTunnel1mThroughput[j] = this._peakTunnel1mThroughput[j - 1];
                }
                this._peakTunnel1mThroughput[i] = size;
                break;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (!this._log.shouldLog(10)) return;
            StringBuilder buf = new StringBuilder(128);
            buf.append("Updating 1m throughput after ").append(size).append(" to ");
            for (i = 0; i < 3; ++i) {
                buf.append(this._peakTunnel1mThroughput[i]).append(',');
            }
            buf.append(" for ").append(this._peer.toBase64());
            this._log.debug(buf.toString());
            return;
        }
    }

    public float getPeakTunnel1mThroughputKBps() {
        float rv = 0.0f;
        for (int i = 0; i < 3; ++i) {
            rv += this._peakTunnel1mThroughput[i];
        }
        return rv /= 184320.0f;
    }

    void setPeakTunnel1mThroughputKBps(float kBps) {
        float speed = kBps * 61440.0f;
        for (int i = 0; i < 3; ++i) {
            this._peakTunnel1mThroughput[i] = speed;
        }
    }

    public synchronized void expandProfile() {
        String group;
        String string = group = null == this._peer ? "profileUnknown" : this._peer.toBase64().substring(0, 6);
        if (this._tunnelCreateResponseTime == null) {
            this._tunnelCreateResponseTime = new RateStat("tunnelCreateResponseTime", "how long it takes to get a tunnel create response from the peer (ms)", group, TunnelHistory.RATES);
        }
        if (this._tunnelHistory == null) {
            this._tunnelHistory = new TunnelHistory(this._context, group);
        }
        this._expanded = true;
    }

    public synchronized void expandDBProfile() {
        String group;
        String string = group = null == this._peer ? "profileUnknown" : this._peer.toBase64().substring(0, 6);
        if (this._dbResponseTime == null) {
            this._dbResponseTime = new RateStat("dbResponseTime", "how long it takes to get a db response from the peer (in milliseconds)", group, new long[]{600000L, 3600000L, 86400000L});
        }
        if (this._dbIntroduction == null) {
            this._dbIntroduction = new RateStat("dbIntroduction", "how many new peers we get from dbSearchReplyMessages or dbStore messages", group, new long[]{3600000L, 21600000L, 86400000L});
        }
        if (this._dbHistory == null) {
            this._dbHistory = new DBHistory(this._context, group);
        }
        this._expandedDB = true;
    }

    private void coalesceThroughput(boolean decay) {
        long now = System.currentTimeMillis();
        long measuredPeriod = now - this._lastCoalesceDate;
        if (measuredPeriod >= 60000L) {
            int i;
            boolean shouldDecay = decay && this._context.random().nextInt(61) <= 0;
            long tot = this._peakThroughputCurrentTotal;
            float lowPeak = this._peakThroughput[2];
            if ((float)tot > lowPeak) {
                for (i = 0; i < 3; ++i) {
                    if (!((float)tot > this._peakThroughput[i])) continue;
                    for (int j = 2; j > i; --j) {
                        this._peakThroughput[j] = this._peakThroughput[j - 1];
                    }
                    this._peakThroughput[i] = tot;
                    break;
                }
            } else if (shouldDecay) {
                i = 0;
                while (i < 3) {
                    int n = i++;
                    this._peakThroughput[n] = this._peakThroughput[n] * DEGRADE_FACTOR;
                }
            }
            if (shouldDecay) {
                i = 0;
                while (i < 3) {
                    int n = i;
                    this._peakTunnelThroughput[n] = this._peakTunnelThroughput[n] * DEGRADE_FACTOR;
                    int n2 = i++;
                    this._peakTunnel1mThroughput[n2] = this._peakTunnel1mThroughput[n2] * DEGRADE_FACTOR;
                }
            }
            this._peakThroughputCurrentTotal = 0L;
            this._lastCoalesceDate = now;
        }
    }

    void coalesceStats() {
        if (!this._expanded) {
            return;
        }
        this.coalesceOnly(false);
        this.updateValues();
        if (this._log.shouldLog(10)) {
            this._log.debug("Coalesced: speed [" + this._speedValue + "] capacity [" + this._capacityValue + "] integration [" + this._integrationValue + ']');
        }
    }

    void coalesceOnly(boolean shouldDecay) {
        this._coalescing = true;
        this._tunnelCreateResponseTime.coalesceStats();
        if (this._tunnelTestResponseTime != null) {
            this._tunnelTestResponseTime.coalesceStats();
        }
        this._tunnelHistory.coalesceStats();
        if (this._expandedDB) {
            this._dbIntroduction.coalesceStats();
            this._dbResponseTime.coalesceStats();
            this._dbHistory.coalesceStats();
        }
        this.coalesceThroughput(shouldDecay);
        this._speedValueNew = this.calculateSpeed();
        this._capacityValueNew = this.calculateCapacity();
        this._integrationValue = this.calculateIntegration();
    }

    void updateValues() {
        if (!this._coalescing) {
            this.coalesceOnly(false);
        }
        this._coalescing = false;
        this._speedValue = this._speedValueNew;
        this._capacityValue = this._capacityValueNew;
    }

    private float calculateSpeed() {
        return (float)SpeedCalculator.calc(this);
    }

    private float calculateCapacity() {
        return (float)CapacityCalculator.calc(this);
    }

    private float calculateIntegration() {
        return (float)IntegrationCalculator.calc(this);
    }

    @Deprecated
    void setIsFailing(boolean val) {
    }

    RouterContext getContext() {
        return this._context;
    }

    public int hashCode() {
        return this._peer.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PeerProfile)) {
            return false;
        }
        PeerProfile prof = (PeerProfile)obj;
        return this._peer.equals((Object)prof._peer);
    }

    public String toString() {
        return "Profile: " + this._peer;
    }

    static {
        String[] big = new String[]{"fr", "de", "ru", "au", "us", "ca", "gb", "jp", "nl"};
        _bigCountries.addAll(Arrays.asList(big));
    }
}

