/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.SigType;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.data.router.RouterPrivateKeyFile;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.FamilyKeyCrypto;
import net.i2p.router.networkdb.kademlia.PersistentDataStore;
import net.i2p.router.startup.BootCommSystemJob;
import net.i2p.router.startup.CreateRouterInfoJob;
import net.i2p.router.startup.RebuildRouterInfoJob;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class LoadRouterInfoJob
extends JobImpl {
    private final Log _log;
    private RouterInfo _us;
    private static final AtomicBoolean _keyLengthChecked = new AtomicBoolean();
    private static final int REKEY_PROBABILITY = 1;

    public LoadRouterInfoJob(RouterContext ctx) {
        super(ctx);
        this._log = ctx.logManager().getLog(LoadRouterInfoJob.class);
    }

    @Override
    public String getName() {
        return "Load Router Info";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runJob() {
        Object object = this.getContext().router().routerInfoFileLock;
        synchronized (object) {
            this.loadRouterInfo();
        }
        if (this._us == null) {
            RebuildRouterInfoJob r = new RebuildRouterInfoJob(this.getContext());
            r.rebuildRouterInfo(false);
            this.getContext().jobQueue().addJob(this);
            return;
        }
        this.getContext().router().setRouterInfo(this._us);
        this.getContext().messageHistory().initialize(true);
        this.getContext().jobQueue().addJob(new BootCommSystemJob(this.getContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRouterInfo() {
        block51: {
            RouterInfo info = null;
            File rif = new File(this.getContext().getRouterDir(), "router.info");
            boolean infoExists = rif.exists();
            File rkf = new File(this.getContext().getRouterDir(), "router.keys");
            boolean keysExist = rkf.exists();
            File rkf2 = new File(this.getContext().getRouterDir(), "router.keys.dat");
            boolean keys2Exist = rkf2.exists();
            InputStream fis1 = null;
            try {
                boolean encTypeChanged;
                if (infoExists && (keys2Exist || keysExist)) {
                    String oldFamily;
                    fis1 = new BufferedInputStream(new FileInputStream(rif));
                    info = new RouterInfo();
                    info.readBytes(fis1);
                    if (!info.isValid()) {
                        throw new DataFormatException("Our RouterInfo has a bad signature");
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Reading in routerInfo from " + rif.getAbsolutePath() + " and it has " + info.getAddresses().size() + " addresses");
                    }
                    if ((oldFamily = info.getOption("family")) == null) {
                        this._us = info;
                    } else if (oldFamily.equals(this.getContext().getProperty("netdb.family.name"))) {
                        FamilyKeyCrypto fkc = this.getContext().router().getFamilyKeyCrypto();
                        if (fkc != null && fkc.verifyOurFamily(info)) {
                            this._us = info;
                        } else {
                            this._log.logAlways(30, "NetDb family keys are invalid");
                            try {
                                fis1.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            fis1 = null;
                            rif.delete();
                        }
                    } else {
                        this._log.logAlways(30, "NetDb family name changed");
                        try {
                            fis1.close();
                        }
                        catch (IOException fkc) {
                            // empty catch block
                        }
                        fis1 = null;
                        rif.delete();
                    }
                    if (this._us != null) {
                        long now = this.getContext().clock().now();
                        long riTime = this._us.getPublished();
                        if (riTime > now || now - riTime > 2700000L) {
                            this._us = null;
                            try {
                                fis1.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            fis1 = null;
                            rif.delete();
                        }
                    }
                }
                if (!keys2Exist && !keysExist) break block51;
                KeyData kd = LoadRouterInfoJob.readKeyData(rkf, rkf2);
                PublicKey pubkey = kd.routerIdentity.getPublicKey();
                SigningPublicKey signingPubKey = kd.routerIdentity.getSigningPublicKey();
                PrivateKey privkey = kd.privateKey;
                SigningPrivateKey signingPrivKey = kd.signingPrivateKey;
                SigType stype = signingPubKey.getType();
                EncType etype = pubkey.getType();
                SigType cstype = CreateRouterInfoJob.getSigTypeConfig(this.getContext());
                boolean sigTypeChanged = stype != cstype;
                EncType cetype = CreateRouterInfoJob.getEncTypeConfig(this.getContext());
                boolean bl = encTypeChanged = etype != cetype;
                if ((sigTypeChanged && this.getContext().getProperty("router.sigType") == null || encTypeChanged && this.getContext().getProperty("router.encType") == null) && !SystemVersion.isSlow() && this.getContext().random().nextInt(1) > 0) {
                    sigTypeChanged = false;
                    encTypeChanged = false;
                    if (this._log.shouldWarn()) {
                        this._log.warn("Deferring RI rekey from " + stype + '/' + etype + " to " + cstype + '/' + cetype);
                    }
                }
                if (sigTypeChanged || encTypeChanged || this.shouldRebuild(privkey)) {
                    if (this._us != null) {
                        Hash h = this._us.getIdentity().getHash();
                        this._log.logAlways(30, "Deleting old router identity " + h.toBase64());
                        File f = PersistentDataStore.getRouterInfoFile(this.getContext(), h);
                        f.delete();
                        this.getContext().banlist().banlistRouterForever(h, "Our previous identity");
                        this._us = null;
                    }
                    if (sigTypeChanged) {
                        this._log.logAlways(30, "Rebuilding RouterInfo with new signature type " + cstype);
                    }
                    if (encTypeChanged) {
                        this._log.logAlways(30, "Rebuilding RouterInfo with new encryption type " + cetype);
                    }
                    if (fis1 != null) {
                        try {
                            fis1.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        fis1 = null;
                    }
                    rif.delete();
                    rkf.delete();
                    rkf2.delete();
                    return;
                }
                this.getContext().keyManager().setKeys(pubkey, privkey, signingPubKey, signingPrivKey);
            }
            catch (IOException ioe) {
                this._log.log(50, "Error reading the router info from " + rif.getAbsolutePath() + " and the keys from " + rkf.getAbsolutePath(), (Throwable)ioe);
                this._us = null;
                if (fis1 != null) {
                    try {
                        fis1.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    fis1 = null;
                }
                rif.delete();
                rkf.delete();
                rkf2.delete();
            }
            catch (DataFormatException dfe) {
                this._log.log(50, "Corrupt router info or keys at " + rif.getAbsolutePath() + " / " + rkf.getAbsolutePath(), (Throwable)dfe);
                this._us = null;
                if (fis1 != null) {
                    try {
                        fis1.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    fis1 = null;
                }
                rif.delete();
                rkf.delete();
                rkf2.delete();
            }
            finally {
                if (fis1 != null) {
                    try {
                        fis1.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    private boolean shouldRebuild(PrivateKey privkey) {
        boolean uselong;
        if (privkey.getType() != EncType.ELGAMAL_2048) {
            return false;
        }
        if (!_keyLengthChecked.compareAndSet(false, true)) {
            return false;
        }
        byte[] pkd = privkey.getData();
        boolean haslong = false;
        for (int i = 0; i < 8; ++i) {
            if (pkd[i] == 0) continue;
            haslong = true;
            break;
        }
        if ((uselong = this.getContext().keyGenerator().useLongElGamalExponent()) && !haslong) {
            this._log.logAlways(30, "Rebuilding RouterInfo with longer key");
        }
        if (!uselong && haslong) {
            this._log.logAlways(30, "Rebuilding RouterInfo with faster key");
        }
        return uselong != haslong;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyData readKeyData(File rkf1, File rkf2) throws DataFormatException, IOException {
        SigningPrivateKey signingPrivKey;
        PrivateKey privkey;
        RouterIdentity ri;
        if (rkf2.exists()) {
            RouterPrivateKeyFile pkf = new RouterPrivateKeyFile(rkf2);
            ri = pkf.getRouterIdentity();
            if (!pkf.validateKeyPairs()) {
                throw new DataFormatException("Key pairs invalid");
            }
            privkey = pkf.getPrivKey();
            signingPrivKey = pkf.getSigningPrivKey();
        } else {
            InputStream fis = null;
            try {
                fis = new BufferedInputStream(new FileInputStream(rkf1));
                privkey = new PrivateKey();
                privkey.readBytes(fis);
                signingPrivKey = new SigningPrivateKey();
                signingPrivKey.readBytes(fis);
                PublicKey pubkey = new PublicKey();
                pubkey.readBytes(fis);
                SigningPublicKey signingPubKey = new SigningPublicKey();
                signingPubKey.readBytes(fis);
                try {
                    if (!pubkey.equals((Object)KeyGenerator.getPublicKey((PrivateKey)privkey))) {
                        throw new DataFormatException("Key pairs invalid");
                    }
                    if (!signingPubKey.equals((Object)KeyGenerator.getSigningPublicKey((SigningPrivateKey)signingPrivKey))) {
                        throw new DataFormatException("Key pairs invalid");
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw new DataFormatException("Key pairs invalid", (Throwable)iae);
                }
                ri = new RouterIdentity();
                ri.setPublicKey(pubkey);
                ri.setSigningPublicKey(signingPubKey);
                ri.setCertificate(Certificate.NULL_CERT);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return new KeyData(ri, privkey, signingPrivKey);
    }

    public static class KeyData {
        public final RouterIdentity routerIdentity;
        public final PrivateKey privateKey;
        public final SigningPrivateKey signingPrivateKey;

        public KeyData(RouterIdentity ri, PrivateKey pk, SigningPrivateKey spk) {
            this.routerIdentity = ri;
            this.privateKey = pk;
            this.signingPrivateKey = spk;
        }
    }
}

