/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.IOException;
import java.io.Writer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManagerImpl;
import net.i2p.app.ClientAppState;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class RouterAppManager
extends ClientAppManagerImpl {
    private final RouterContext _context;
    private final Log _log;
    private final ConcurrentHashMap<ClientApp, String[]> _clients;

    public RouterAppManager(RouterContext ctx) {
        super((I2PAppContext)ctx);
        this._context = ctx;
        this._log = ctx.logManager().getLog(RouterAppManager.class);
        this._clients = new ConcurrentHashMap(16);
        ctx.addShutdownTask(new Shutdown());
    }

    public boolean addAndStart(ClientApp app, String[] args) {
        String[] old;
        if (this._log.shouldLog(20)) {
            this._log.info("Client " + app.getDisplayName() + " ADDED");
        }
        if ((old = this._clients.putIfAbsent(app, args)) != null) {
            throw new IllegalArgumentException("already added");
        }
        try {
            app.startup();
            return true;
        }
        catch (Throwable t) {
            this._clients.remove(app);
            this._log.error("Client " + app + " failed to start", t);
            return false;
        }
    }

    public ClientApp getClientApp(String className, String[] args) {
        for (Map.Entry<ClientApp, String[]> e : this._clients.entrySet()) {
            if (!e.getKey().getClass().getName().equals(className) || !Arrays.equals(e.getValue(), args)) continue;
            return e.getKey();
        }
        if (className.equals("net.i2p.jetty.JettyStart") && args.length > 0) {
            for (ClientApp app : this._registered.values()) {
                if (!app.getClass().getName().equals(className)) continue;
                String dname = app.getDisplayName();
                int idx = 0;
                boolean match = true;
                for (String arg : args) {
                    if ((idx = dname.indexOf(arg, idx)) >= 0) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return app;
            }
        }
        return null;
    }

    public void notify(ClientApp app, ClientAppState state, String message, Exception e) {
        switch (state) {
            case UNINITIALIZED: 
            case INITIALIZED: {
                if (!this._log.shouldLog(30)) break;
                this._log.warn("Client " + app.getDisplayName() + " is now " + state);
                break;
            }
            case STARTING: 
            case RUNNING: {
                if (!this._log.shouldLog(20)) break;
                this._log.info("Client " + app.getDisplayName() + " is now " + state);
                break;
            }
            case FORKED: 
            case STOPPING: 
            case STOPPED: {
                this._clients.remove(app);
                boolean removed = this._registered.remove(app.getName(), app);
                if (removed && this._log.shouldInfo()) {
                    this._log.info("Client " + app.getDisplayName() + " UNREGISTERED AS " + app.getName());
                }
                if (message == null) {
                    message = "";
                }
                if (!this._log.shouldLog(20)) break;
                this._log.info("Client " + app.getDisplayName() + " is now " + state + ' ' + message, (Throwable)e);
                break;
            }
            case CRASHED: 
            case START_FAILED: {
                this._clients.remove(app);
                boolean removed2 = this._registered.remove(app.getName(), app);
                if (removed2 && this._log.shouldInfo()) {
                    this._log.info("Client " + app.getDisplayName() + " UNREGISTERED AS " + app.getName());
                }
                if (message == null) {
                    message = "";
                }
                this._log.log(50, "Client " + app.getDisplayName() + ' ' + state + ' ' + message, (Throwable)e);
            }
        }
    }

    public boolean register(ClientApp app) {
        if (!this._clients.containsKey(app) && this._log.shouldLog(20)) {
            this._log.info("Registering untracked client " + app.getName());
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Client " + app.getDisplayName() + " REGISTERED AS " + app.getName());
        }
        return super.register(app);
    }

    public void unregister(ClientApp app) {
        if (this._log.shouldInfo() && this.getRegisteredApp(app.getName()) != null) {
            this._log.info("Client " + app.getDisplayName() + " UNREGISTERED AS " + app.getName());
        }
        super.unregister(app);
    }

    public synchronized void shutdown() {
        HashSet apps = new HashSet(this._clients.keySet());
        for (ClientApp app : apps) {
            ClientAppState state = app.getState();
            if (state != ClientAppState.RUNNING && state != ClientAppState.STARTING) continue;
            try {
                if (this._log.shouldWarn()) {
                    this._log.warn("Shutting down client " + app.getDisplayName());
                }
                app.shutdown(null);
            }
            catch (Throwable throwable) {}
        }
    }

    public void renderStatusHTML(Writer out) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<h2>App Manager</h2>");
        buf.append("<h3>Tracked</h3>");
        buf.append("<div class=\"debug_container\">");
        this.toString1(buf);
        buf.append("</div>");
        buf.append("<h3>Registered</h3>");
        buf.append("<div class=\"debug_container\">");
        this.toString2(buf);
        buf.append("</div>");
        out.write(buf.toString());
    }

    private void toString1(StringBuilder buf) {
        ArrayList<String> list = new ArrayList<String>(this._clients.size());
        for (Map.Entry<ClientApp, String[]> entry : this._clients.entrySet()) {
            ClientApp key = entry.getKey();
            Object[] val = entry.getValue();
            list.add("<b>" + key.getName() + "</b>: " + key.getClass().getName() + ' ' + Arrays.toString(val) + " <i>" + key.getState() + "</i><br>");
        }
        Collections.sort(list, Collator.getInstance());
        for (String e : list) {
            buf.append(e);
        }
    }

    private void toString2(StringBuilder buf) {
        ArrayList<String> list = new ArrayList<String>(this._registered.size());
        for (Map.Entry entry : this._registered.entrySet()) {
            String key = (String)entry.getKey();
            ClientApp val = (ClientApp)entry.getValue();
            list.add("<b>" + key + ":</b> " + val.getClass().getName() + "<br>");
        }
        Collections.sort(list, Collator.getInstance());
        for (String e : list) {
            buf.append(e);
        }
    }

    public class Shutdown
    implements Runnable {
        @Override
        public void run() {
            RouterAppManager.this.shutdown();
        }
    }
}

