/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import net.i2p.data.DataHelper;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.stat.StatManager;
import net.i2p.util.SimpleTimer;

public class CoalesceStatsEvent
implements SimpleTimer.TimedEvent {
    private final RouterContext _ctx;
    private final long _maxMemory;
    private static final long LOW_MEMORY_THRESHOLD = 0x500000L;

    public CoalesceStatsEvent(RouterContext ctx) {
        this._ctx = ctx;
        StatManager sm = ctx.statManager();
        sm.createRequiredRateStat("bw.receiveBps", CoalesceStatsEvent._x("Message receive rate (bytes/sec)"), "Bandwidth", new long[]{60000L, 300000L, 3600000L});
        sm.createRequiredRateStat("bw.sendBps", CoalesceStatsEvent._x("Message send rate (bytes/sec)"), "Bandwidth", new long[]{60000L, 300000L, 3600000L});
        sm.createRequiredRateStat("bw.sendRate", CoalesceStatsEvent._x("Low-level send rate (bytes/sec)"), "Bandwidth", new long[]{60000L, 300000L, 3600000L});
        sm.createRequiredRateStat("bw.recvRate", CoalesceStatsEvent._x("Low-level receive rate (bytes/sec)"), "Bandwidth", new long[]{60000L, 300000L, 3600000L});
        sm.createRequiredRateStat("router.activePeers", CoalesceStatsEvent._x("How many peers we are actively talking with"), "Throttle", new long[]{60000L});
        sm.createRequiredRateStat("router.highCapacityPeers", "How many high capacity peers we know", "Throttle", new long[]{60000L});
        sm.createRateStat("router.activeSendPeers", "How many peers we've sent to this minute", "Throttle", new long[]{60000L});
        sm.createRequiredRateStat("router.fastPeers", CoalesceStatsEvent._x("Known fast peers"), "Throttle", new long[]{60000L});
        sm.createRateStat("router.integratedPeers", "Known integrated (floodfill) peers", "NetworkDatabase", new long[]{60000L});
        sm.createRateStat("router.knownPeers", "Known peers", "NetworkDatabase", new long[]{60000L});
        sm.createRequiredRateStat("router.tunnelBacklog", CoalesceStatsEvent._x("Size of tunnel acceptor backlog"), "Tunnels", new long[]{3600000L});
        sm.createRateStat("tunnel.buildClientSuccessRate", "Percent success", "Tunnels", new long[]{60000L});
        sm.createRateStat("tunnel.buildExploratorySuccessRate", "Percent success", "Tunnels", new long[]{60000L});
        this._maxMemory = Runtime.getRuntime().maxMemory();
        String legend = "(Bytes)";
        if (this._maxMemory < Long.MAX_VALUE) {
            legend = legend + " Max is " + DataHelper.formatSize((long)this._maxMemory) + 'B';
        }
        sm.createRequiredRateStat("router.memoryUsed", legend, "Router", new long[]{60000L});
    }

    public void timeReached() {
        Rate rate;
        RateStat sendRate;
        Rate rate2;
        StatManager sm = this._ctx.statManager();
        int active = this._ctx.commSystem().countActivePeers();
        sm.addRateData("router.activePeers", (long)active);
        int fast = this._ctx.profileOrganizer().countFastPeers();
        sm.addRateData("router.fastPeers", (long)fast);
        int highCap = this._ctx.profileOrganizer().countHighCapacityPeers();
        sm.addRateData("router.highCapacityPeers", (long)highCap);
        sm.addRateData("bw.sendRate", (long)this._ctx.bandwidthLimiter().getSendBps());
        sm.addRateData("bw.recvRate", (long)this._ctx.bandwidthLimiter().getReceiveBps());
        sm.addRateData("router.tunnelBacklog", (long)this._ctx.tunnelManager().getInboundBuildQueueSize());
        long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        sm.addRateData("router.memoryUsed", used);
        if (this._maxMemory - used < 0x500000L) {
            Router.clearCaches();
        }
        this._ctx.tunnelDispatcher().updateParticipatingStats(50000);
        sm.coalesceStats();
        RateStat receiveRate = sm.getRate("transport.receiveMessageSize");
        if (receiveRate != null && (rate2 = receiveRate.getRate(60000L)) != null) {
            double bytes = rate2.getLastTotalValue();
            double bps = bytes * 1000.0 / (double)rate2.getPeriod();
            sm.addRateData("bw.receiveBps", (long)bps, 60000L);
        }
        if ((sendRate = sm.getRate("transport.sendMessageSize")) != null && (rate = sendRate.getRate(60000L)) != null) {
            double bytes = rate.getLastTotalValue();
            double bps = bytes * 1000.0 / (double)rate.getPeriod();
            sm.addRateData("bw.sendBps", (long)bps, 60000L);
        }
        if (this._ctx.getBooleanProperty("stat.full")) {
            long s;
            long t;
            Rate r3;
            Rate r2;
            Rate r1;
            int activeSend = this._ctx.commSystem().countActiveSendPeers();
            sm.addRateData("router.activeSendPeers", (long)activeSend);
            int integrated = this._ctx.peerManager().countPeersByCapability('f');
            sm.addRateData("router.integratedPeers", (long)integrated);
            sm.addRateData("router.knownPeers", (long)this._ctx.netDb().getKnownRouters());
            RateStat s1 = sm.getRate("tunnel.buildExploratorySuccess");
            RateStat s2 = sm.getRate("tunnel.buildExploratoryExpire");
            RateStat s3 = sm.getRate("tunnel.buildExploratoryReject");
            if (s1 != null && s2 != null && s3 != null) {
                r1 = s1.getRate(600000L);
                r2 = s2.getRate(600000L);
                r3 = s3.getRate(600000L);
                if (r1 != null && r2 != null && r3 != null && (t = (s = r1.getCurrentEventCount() + r1.getLastEventCount()) + r2.getCurrentEventCount() + r2.getLastEventCount() + r3.getCurrentEventCount() + r3.getLastEventCount()) > 0L) {
                    sm.addRateData("tunnel.buildExploratorySuccessRate", 100L * s / t, 60000L);
                }
            }
            s1 = sm.getRate("tunnel.buildClientSuccess");
            s2 = sm.getRate("tunnel.buildClientExpire");
            s3 = sm.getRate("tunnel.buildClientReject");
            if (s1 != null && s2 != null && s3 != null) {
                r1 = s1.getRate(600000L);
                r2 = s2.getRate(600000L);
                r3 = s3.getRate(600000L);
                if (r1 != null && r2 != null && r3 != null && (t = (s = r1.getCurrentEventCount() + r1.getLastEventCount()) + r2.getCurrentEventCount() + r2.getLastEventCount() + r3.getCurrentEventCount() + r3.getLastEventCount()) > 0L) {
                    sm.addRateData("tunnel.buildClientSuccessRate", 100L * s / t, 60000L);
                }
            }
        }
    }

    private static final String _x(String s) {
        return s;
    }
}

