/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import com.southernstorm.noise.protocol.CipherState;
import java.io.Closeable;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.crypto.SipHashInline;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.ntcp.EstablishBase;
import net.i2p.router.transport.ntcp.EstablishState;
import net.i2p.router.transport.ntcp.EventPumper;
import net.i2p.router.transport.ntcp.InboundEstablishState;
import net.i2p.router.transport.ntcp.NTCP2Options;
import net.i2p.router.transport.ntcp.NTCP2Payload;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.router.transport.ntcp.OutboundNTCP2State;
import net.i2p.router.util.PriBlockingQueue;
import net.i2p.util.ByteCache;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

public class NTCPConnection
implements Closeable {
    private final RouterContext _context;
    private final Log _log;
    private volatile SocketChannel _chan;
    private volatile SelectionKey _conKey;
    private final FIFOBandwidthLimiter.CompleteListener _inboundListener;
    private final FIFOBandwidthLimiter.CompleteListener _outboundListener;
    private final Queue<ByteBuffer> _readBufs;
    private final Queue<ByteBuffer> _writeBufs;
    private final Set<FIFOBandwidthLimiter.Request> _bwInRequests;
    private final Set<FIFOBandwidthLimiter.Request> _bwOutRequests;
    private long _establishedOn;
    private volatile EstablishState _establishState;
    private final NTCPTransport _transport;
    private final boolean _isInbound;
    private final AtomicBoolean _closed = new AtomicBoolean();
    private final RouterAddress _remAddr;
    private RouterIdentity _remotePeer;
    private long _clockSkew;
    private final PriBlockingQueue<OutNetMessage> _outbound;
    private final List<OutNetMessage> _currentOutbound;
    private SessionKey _sessionKey;
    private byte[] _prevWriteEnd;
    private ReadState _curReadState;
    private final AtomicInteger _messagesRead = new AtomicInteger();
    private final AtomicInteger _messagesWritten = new AtomicInteger();
    private long _lastSendTime;
    private long _lastReceiveTime;
    private long _lastRateUpdated;
    private final long _created;
    private long _nextMetaTime = Long.MAX_VALUE;
    private final AtomicInteger _consecutiveZeroReads = new AtomicInteger();
    private final Object _readLock = new Object();
    private final Object _writeLock = new Object();
    private final Object _statLock = new Object();
    private static final int BLOCK_SIZE = 16;
    private static final int META_SIZE = 16;
    private boolean _sendingMeta;
    private long _nextInfoTime;
    private boolean _mayDisconnect;
    private static final long STAT_UPDATE_TIME_MS = 30000L;
    private static final int META_FREQUENCY = 2700000;
    private static final int INFO_FREQUENCY = 3000000;
    static final int BUFFER_SIZE = 16384;
    private static final int MAX_DATA_READ_BUFS = 16;
    private static final ByteCache _dataReadBufs = ByteCache.getInstance((int)16, (int)16384);
    private static final int INFO_PRIORITY = 150;
    private static final String FIXED_RI_VERSION = "0.9.12";
    private static final AtomicLong __connID = new AtomicLong();
    private final long _connID = __connID.incrementAndGet();
    static final int NTCP2_MAX_MSG_SIZE = 65516;
    private static final int PADDING_RAND_MIN = 16;
    private static final int PADDING_MAX = 64;
    private static final int SIP_IV_LENGTH = 8;
    private static final int NTCP2_FAIL_READ = 1024;
    private static final long NTCP2_FAIL_TIMEOUT = 10000L;
    private static final long NTCP2_TERMINATION_CLOSE_DELAY = 50L;
    private static final int NTCP2_PREFERRED_PAYLOAD_MAX = 5200;
    static final int REASON_UNSPEC = 0;
    static final int REASON_TERMINATION = 1;
    static final int REASON_TIMEOUT = 2;
    static final int REASON_AEAD = 4;
    static final int REASON_OPTIONS = 5;
    static final int REASON_SIGTYPE = 6;
    static final int REASON_SKEW = 7;
    static final int REASON_PADDING = 8;
    static final int REASON_FRAMING = 9;
    static final int REASON_PAYLOAD = 10;
    static final int REASON_MSG1 = 11;
    static final int REASON_MSG2 = 12;
    static final int REASON_MSG3 = 13;
    static final int REASON_FRAME_TIMEOUT = 14;
    static final int REASON_SIGFAIL = 15;
    static final int REASON_S_MISMATCH = 16;
    static final int REASON_BANNED = 17;
    static final int PADDING_MIN_DEFAULT_INT = 0;
    static final int PADDING_MAX_DEFAULT_INT = 1;
    private static final float PADDING_MIN_DEFAULT = 0.0f;
    private static final float PADDING_MAX_DEFAULT = 0.0625f;
    static final int DUMMY_DEFAULT = 0;
    static final int DELAY_DEFAULT = 0;
    private static final NTCP2Options OUR_PADDING = new NTCP2Options(0.0f, 0.0625f, 0.0f, 0.0625f, 0, 0, 0, 0);
    private static final int MIN_PADDING_RANGE = 16;
    private static final int MAX_PADDING_RANGE = 128;
    private NTCP2Options _paddingConfig = OUR_PADDING;
    private int _version;
    private CipherState _sender;
    private long _sendSipk1;
    private long _sendSipk2;
    private byte[] _sendSipIV;
    private long _bytesReceived;
    private long _bytesSent;
    private long _lastBytesReceived;
    private long _lastBytesSent;
    private float _sendBps;
    private float _recvBps;
    private static final int MAX_HANDLERS = 4;
    private static final LinkedBlockingQueue<I2NPMessageHandler> _i2npHandlers = new LinkedBlockingQueue(4);

    public NTCPConnection(RouterContext ctx, NTCPTransport transport, SocketChannel chan, SelectionKey key) {
        this(ctx, transport, null, true);
        this._chan = chan;
        this._version = 1;
        this._conKey = key;
        this._establishState = new InboundEstablishState(ctx, transport, this);
    }

    public NTCPConnection(RouterContext ctx, NTCPTransport transport, RouterIdentity remotePeer, RouterAddress remAddr, int version) throws DataFormatException {
        this(ctx, transport, remAddr, false);
        this._remotePeer = remotePeer;
        this._version = version;
        if (version != 2) {
            throw new IllegalArgumentException("bad version " + version);
        }
        try {
            this._establishState = new OutboundNTCP2State(ctx, transport, this);
        }
        catch (IllegalArgumentException iae) {
            throw new DataFormatException("bad address? " + (Object)((Object)remAddr), (Throwable)iae);
        }
    }

    private NTCPConnection(RouterContext ctx, NTCPTransport transport, RouterAddress remAddr, boolean isIn) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._created = ctx.clock().now();
        this._transport = transport;
        this._remAddr = remAddr;
        this._lastSendTime = this._created;
        this._lastReceiveTime = this._created;
        this._lastRateUpdated = this._created;
        this._readBufs = new ConcurrentLinkedQueue<ByteBuffer>();
        this._writeBufs = new ConcurrentLinkedQueue<ByteBuffer>();
        this._bwInRequests = new ConcurrentHashSet(2);
        this._bwOutRequests = new ConcurrentHashSet(8);
        this._outbound = new PriBlockingQueue(ctx, "NTCP-Connection", 32);
        this._currentOutbound = new ArrayList<OutNetMessage>(1);
        this._isInbound = isIn;
        this._inboundListener = new InboundListener();
        this._outboundListener = new OutboundListener();
    }

    public SocketChannel getChannel() {
        return this._chan;
    }

    public SelectionKey getKey() {
        return this._conKey;
    }

    public void setChannel(SocketChannel chan) {
        this._chan = chan;
    }

    public void setKey(SelectionKey key) {
        this._conKey = key;
    }

    public boolean isInbound() {
        return this._isInbound;
    }

    public boolean isEstablished() {
        return this._establishState.isComplete();
    }

    public boolean isIPv6() {
        return this._chan != null && this._chan.socket().getInetAddress() instanceof Inet6Address;
    }

    public byte[] getRemoteIP() {
        if (this._chan == null) {
            return null;
        }
        InetAddress addr = this._chan.socket().getInetAddress();
        if (addr == null) {
            return null;
        }
        return addr.getAddress();
    }

    EstablishState getEstablishState() {
        return this._establishState;
    }

    public RouterAddress getRemoteAddress() {
        return this._remAddr;
    }

    public RouterIdentity getRemotePeer() {
        return this._remotePeer;
    }

    public void setRemotePeer(RouterIdentity ident) {
        this._remotePeer = ident;
    }

    public long getClockSkew() {
        return this._clockSkew;
    }

    public long getUptime() {
        if (!this.isEstablished()) {
            return this.getTimeSinceCreated();
        }
        return this._context.clock().now() - this._establishedOn;
    }

    public long getEstablishedOn() {
        if (!this.isEstablished()) {
            return 0L;
        }
        return this._establishedOn;
    }

    public int getMessagesSent() {
        return this._messagesWritten.get();
    }

    public int getMessagesReceived() {
        return this._messagesRead.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutboundQueueSize() {
        int queued = this._outbound.size();
        Object object = this._writeLock;
        synchronized (object) {
        }
        return queued += this._currentOutbound.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasCurrentOutbound() {
        Object object = this._writeLock;
        synchronized (object) {
            return !this._currentOutbound.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int drainOutboundTo(Queue<OutNetMessage> to) {
        int rv = 0;
        Object object = this._writeLock;
        synchronized (object) {
            rv = this._currentOutbound.size();
            if (rv > 0) {
                to.addAll(this._currentOutbound);
                this._currentOutbound.clear();
            }
        }
        return rv += this._outbound.drainTo(to);
    }

    public long getTimeSinceSend() {
        return this._context.clock().now() - this._lastSendTime;
    }

    public long getTimeSinceSend(long now) {
        return now - this._lastSendTime;
    }

    public long getTimeSinceReceive() {
        return this._context.clock().now() - this._lastReceiveTime;
    }

    public long getTimeSinceReceive(long now) {
        return now - this._lastReceiveTime;
    }

    public long getTimeSinceCreated() {
        return this._context.clock().now() - this._created;
    }

    public long getTimeSinceCreated(long now) {
        return now - this._created;
    }

    public long getCreated() {
        return this._created;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int ver) {
        this._version = ver;
    }

    public void setMayDisconnect() {
        this._mayDisconnect = true;
    }

    public boolean getMayDisconnect() {
        return this._mayDisconnect;
    }

    void clearZeroRead() {
        this._consecutiveZeroReads.set(0);
    }

    int gotZeroRead() {
        return this._consecutiveZeroReads.incrementAndGet();
    }

    public boolean isClosed() {
        return this._closed.get();
    }

    @Override
    public void close() {
        this.close(false);
    }

    public void close(boolean allowRequeue) {
        NTCPConnection toClose;
        if (!this._closed.compareAndSet(false, true)) {
            this._log.logCloseLoop(new Object[]{"NTCPConnection", this});
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Closing connection " + this.toString(), (Throwable)new Exception("cause"));
        }
        if ((toClose = this.locked_close(allowRequeue)) != null && toClose != this) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Multiple connections on remove, closing " + toClose + " (already closed " + this + ")");
            }
            this._context.statManager().addRateData("ntcp.multipleCloseOnRemove", toClose.getUptime());
            toClose.close();
        }
    }

    void closeOnTimeout(String cause, Exception e) {
        EstablishState es = this._establishState;
        this.close();
        es.close(cause, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized NTCPConnection locked_close(boolean allowRequeue) {
        if (this._chan != null) {
            try {
                this._chan.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this._conKey != null) {
            this._conKey.cancel();
        }
        this._establishState = EstablishBase.FAILED;
        NTCPConnection old = this._transport.removeCon(this);
        this._transport.getReader().connectionClosed(this);
        this._transport.getWriter().connectionClosed(this);
        for (FIFOBandwidthLimiter.Request req : this._bwInRequests) {
            req.abort();
        }
        this._bwInRequests.clear();
        for (FIFOBandwidthLimiter.Request req : this._bwOutRequests) {
            req.abort();
        }
        this._bwOutRequests.clear();
        ArrayList<OutNetMessage> pending = new ArrayList<OutNetMessage>();
        Object object = this._writeLock;
        synchronized (object) {
            this._writeBufs.clear();
            this._outbound.drainTo(pending);
            if (!this._currentOutbound.isEmpty()) {
                pending.addAll(this._currentOutbound);
            }
            this._currentOutbound.clear();
            if (this._sender != null) {
                this._sender.destroy();
                this._sender = null;
            }
            this._sendSipk1 = 0L;
            this._sendSipk2 = 0L;
            if (this._sendSipIV != null) {
                Arrays.fill(this._sendSipIV, (byte)0);
                this._sendSipIV = null;
            }
        }
        for (OutNetMessage msg : pending) {
            this._transport.afterSend(msg, false, allowRequeue, msg.getLifetime());
        }
        object = this._readLock;
        synchronized (object) {
            ByteBuffer bb;
            while ((bb = this._readBufs.poll()) != null) {
                EventPumper.releaseBuf(bb);
            }
            if (this._curReadState != null) {
                this._curReadState.destroy();
                this._curReadState = null;
            }
        }
        return old;
    }

    public void send(OutNetMessage msg) {
        if (!this._outbound.offer(msg)) {
            if (this._log.shouldWarn()) {
                this._log.warn("outbound queue full on " + this + ", dropping message " + msg);
            }
            this._transport.afterSend(msg, false, false, msg.getLifetime());
            return;
        }
        if (this.isEstablished() && !this.hasCurrentOutbound()) {
            this._transport.getWriter().wantsWrite(this, "enqueued");
        }
    }

    public boolean isBacklogged() {
        return this._outbound.isBacklogged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tooBacklogged() {
        if (this.getUptime() < 10000L) {
            return false;
        }
        if (this._outbound.isBacklogged()) {
            int size = this._outbound.size();
            if (this._log.shouldLog(30)) {
                long seq;
                boolean currentOutboundSet;
                int writeBufs = this._writeBufs.size();
                Object object = this._writeLock;
                synchronized (object) {
                    currentOutboundSet = !this._currentOutbound.isEmpty();
                    seq = currentOutboundSet ? this._currentOutbound.get(0).getSeqNum() : -1L;
                }
                try {
                    this._log.warn("Too backlogged: size is " + size + ", wantsWrite? " + (0 != (this._conKey.interestOps() & 4)) + ", currentOut set? " + currentOutboundSet + ", id: " + seq + ", writeBufs: " + writeBufs + " on " + this.toString());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    void enqueueInfoMessage() {
        if (this._isInbound) {
            this.sendOurRouterInfo(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareNextWrite(PrepBuffer prep) {
        if (this._closed.get()) {
            return;
        }
        if (!this.isEstablished()) {
            return;
        }
        Object object = this._writeLock;
        synchronized (object) {
            this.prepareNextWriteNTCP2(prep);
        }
    }

    private void prepareNextWriteNTCP2(PrepBuffer buf) {
        int availForPad;
        RouterInfo ri;
        NTCP2Payload.RIBlock block;
        int sz;
        OutNetMessage msg;
        int size = 16;
        ArrayList<NTCP2Payload.Block> blocks = new ArrayList<NTCP2Payload.Block>(4);
        long now = this._context.clock().now();
        if (!this._currentOutbound.isEmpty()) {
            if (this._log.shouldLog(20)) {
                this._log.info("attempt for multiple outbound messages with " + this._currentOutbound.size() + " already waiting and " + this._outbound.size() + " queued");
            }
            return;
        }
        while (true) {
            if ((msg = (OutNetMessage)this._outbound.poll()) == null) {
                return;
            }
            if (msg.getExpiration() >= now) break;
            if (this._log.shouldWarn()) {
                this._log.warn("dropping message expired on queue: " + msg + " on " + this);
            }
            this._transport.afterSend(msg, false, false, msg.getLifetime());
        }
        this._currentOutbound.add(msg);
        I2NPMessage m = msg.getMessage();
        NTCP2Payload.Block block2 = new NTCP2Payload.I2NPBlock(m);
        blocks.add(block2);
        if ((size += block2.getTotalLength()) < 5200) {
            OutNetMessage msg2;
            int msz;
            while ((msg = (OutNetMessage)this._outbound.peek()) != null && size + (msz = (m = msg.getMessage()).getMessageSize() - 7) <= 5200 && (msg2 = (OutNetMessage)this._outbound.poll()) != null) {
                if (msg2 != msg) {
                    this._outbound.offer(msg2);
                    break;
                }
                if (msg.getExpiration() >= now) {
                    this._currentOutbound.add(msg);
                    block2 = new NTCP2Payload.I2NPBlock(m);
                    blocks.add(block2);
                    size += 3 + msz;
                    continue;
                }
                if (this._log.shouldWarn()) {
                    this._log.warn("dropping message expired on queue: " + msg + " on " + this);
                }
                this._transport.afterSend(msg, false, false, msg.getLifetime());
            }
        }
        if (this._nextMetaTime <= now && size + 7 <= 16384) {
            NTCP2Payload.DateTimeBlock block3 = new NTCP2Payload.DateTimeBlock(this._context);
            blocks.add(block3);
            size += block3.getTotalLength();
            this._nextMetaTime = now + 1350000L + (long)this._context.random().nextInt(1350000);
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending NTCP2 datetime block");
            }
        }
        if (this._nextInfoTime <= now && size + 1024 <= 16384 && size + (sz = (block = new NTCP2Payload.RIBlock(ri = this._context.router().getRouterInfo(), false)).getTotalLength()) <= 16384) {
            blocks.add(block);
            size += sz;
            this._nextInfoTime = now + 1500000L + (long)this._context.random().nextInt(3000000);
            if (this._log.shouldDebug()) {
                this._log.debug("SENDING NTCP2 RI block");
            }
        }
        if ((availForPad = 16384 - (size + 3)) > 0) {
            int padlen = this.getPaddingSize(size, availForPad);
            block2 = new NTCP2Payload.PaddingBlock(padlen);
            blocks.add(block2);
            size += block2.getTotalLength();
        }
        byte[] tmp = size <= 16384 ? buf.unencrypted : new byte[size];
        this.sendNTCP2(tmp, blocks);
    }

    private int getPaddingSize(int dataSize, int availForPad) {
        if (dataSize < 256) {
            dataSize = 256;
        }
        int minSend = (int)((float)dataSize * this._paddingConfig.getSendMin());
        int maxSend = (int)((float)dataSize * this._paddingConfig.getSendMax());
        int min = Math.min(minSend, availForPad);
        int max = Math.min(maxSend, availForPad);
        int range = max - min;
        if (range < 16) {
            min = Math.max(0, min - (16 - range));
            range = max - min;
        } else if (range > 128) {
            range = 128;
        }
        int padlen = min;
        if (range > 0) {
            padlen += this._context.random().nextInt(1 + range);
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Padding params: data size: " + dataSize + " avail: " + availForPad + " minSend: " + minSend + " maxSend: " + maxSend + " min: " + min + " max: " + max + " range: " + range + " padlen: " + padlen);
        }
        return padlen;
    }

    void sendOurRouterInfo(boolean shouldFlood) {
        RouterInfo ri = this._context.router().getRouterInfo();
        if (ri == null) {
            return;
        }
        this.sendRouterInfo(ri, shouldFlood);
    }

    private void sendRouterInfo(RouterInfo ri, boolean shouldFlood) {
        if (this._log.shouldDebug()) {
            this._log.debug("Sending router info for: " + ri.getHash() + " flood? " + shouldFlood);
        }
        ArrayList<NTCP2Payload.Block> blocks = new ArrayList<NTCP2Payload.Block>(2);
        NTCP2Payload.Block block = new NTCP2Payload.RIBlock(ri, shouldFlood);
        int size = block.getTotalLength();
        if (size + 3 > 16384) {
            if (this._log.shouldWarn()) {
                this._log.warn("RI too big: " + (Object)((Object)ri));
            }
            return;
        }
        blocks.add(block);
        int availForPad = 16384 - (size + 3);
        if (availForPad > 0) {
            int padlen = this.getPaddingSize(size, availForPad);
            block = new NTCP2Payload.PaddingBlock(padlen);
            blocks.add(block);
        }
        ByteArray dataBuf = NTCPConnection.acquireReadBuf();
        this.sendNTCP2(dataBuf.getData(), blocks);
        NTCPConnection.releaseReadBuf(dataBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendTerminationAndClose() {
        ReadState rs = null;
        if (this._version == 2 && this.isEstablished()) {
            Object object = this._readLock;
            synchronized (object) {
                rs = this._curReadState;
            }
        }
        if (rs != null) {
            this.sendTermination(2, rs.getFramesReceived());
        } else {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTermination(int reason, int validFramesRcvd) {
        this._lastSendTime = this._context.clock().now();
        if (this._log.shouldInfo()) {
            this._log.info("Sending termination, reason: " + reason + ", vaild frames rcvd: " + validFramesRcvd + " on " + this);
        }
        ArrayList<NTCP2Payload.Block> blocks = new ArrayList<NTCP2Payload.Block>(2);
        NTCP2Payload.Block block = new NTCP2Payload.TerminationBlock(reason, validFramesRcvd);
        int plen = block.getTotalLength();
        blocks.add(block);
        int padlen = this.getPaddingSize(plen, 64);
        if (padlen > 0) {
            block = new NTCP2Payload.PaddingBlock(padlen);
            blocks.add(block);
        }
        ByteArray dataBuf = NTCPConnection.acquireReadBuf();
        Object object = this._writeLock;
        synchronized (object) {
            if (this._sender != null) {
                this.sendNTCP2(dataBuf.getData(), blocks);
                if (this._sender != null) {
                    this._sender.destroy();
                    this._sender = null;
                    new DelayedCloser();
                }
            }
        }
        NTCPConnection.releaseReadBuf(dataBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNTCP2(byte[] tmp, List<NTCP2Payload.Block> blocks) {
        int payloadlen = NTCP2Payload.writePayload(tmp, 0, blocks);
        int framelen = payloadlen + 16;
        byte[] enc = new byte[2 + framelen];
        Object object = this._writeLock;
        synchronized (object) {
            if (this._sender == null) {
                if (this._log.shouldInfo()) {
                    this._log.info("sender gone", (Throwable)new Exception());
                }
                return;
            }
            try {
                this._sender.encryptWithAd(null, tmp, 0, enc, 2, payloadlen);
            }
            catch (GeneralSecurityException gse) {
                this._log.error("data enc", (Throwable)gse);
                return;
            }
            long sipIV = SipHashInline.hash24((long)this._sendSipk1, (long)this._sendSipk2, (byte[])this._sendSipIV);
            NTCPConnection.toLong8LE(this._sendSipIV, 0, sipIV);
            enc[0] = (byte)((long)(framelen >> 8) ^ sipIV >> 8);
            enc[1] = (byte)((long)framelen ^ sipIV);
            this.wantsWrite(enc);
        }
        if (this._log.shouldDebug()) {
            StringBuilder buf = new StringBuilder(256);
            buf.append("Sending ").append(blocks.size()).append(" blocks in ").append(framelen).append(" byte NTCP2 frame:");
            for (int i = 0; i < blocks.size(); ++i) {
                buf.append("\n    ").append(i).append(": ").append(blocks.get(i).toString());
            }
            this._log.debug(buf.toString());
        }
    }

    synchronized void outboundConnected() {
        if (this._establishState == EstablishBase.FAILED) {
            this._conKey.cancel();
            try {
                this._chan.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            EventPumper.setInterest(this._conKey, 1);
        }
        catch (CancelledKeyException cke) {
            try {
                this._chan.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        this._transport.getWriter().wantsWrite(this, "outbound connected");
    }

    private void removeIBRequest(FIFOBandwidthLimiter.Request req) {
        this._bwInRequests.remove(req);
    }

    private void addIBRequest(FIFOBandwidthLimiter.Request req) {
        this._bwInRequests.add(req);
    }

    private void removeOBRequest(FIFOBandwidthLimiter.Request req) {
        this._bwOutRequests.remove(req);
    }

    private void addOBRequest(FIFOBandwidthLimiter.Request req) {
        this._bwOutRequests.add(req);
    }

    void wantsWrite(byte[] data) {
        this.wantsWrite(data, 0, data.length);
    }

    void wantsWrite(byte[] data, int off, int len) {
        ByteBuffer buf = ByteBuffer.wrap(data, off, len);
        FIFOBandwidthLimiter.Request req = this._context.bandwidthLimiter().requestOutbound(len, 0, "NTCP write");
        if (req.getPendingRequested() > 0) {
            if (this._log.shouldInfo()) {
                this._log.info("queued write on " + this.toString() + " for " + len);
            }
            this._context.statManager().addRateData("ntcp.wantsQueuedWrite", 1L);
            this.queuedWrite(buf, req);
        } else {
            this.write(buf);
        }
    }

    void queuedRecv(ByteBuffer buf, FIFOBandwidthLimiter.Request req) {
        req.attach(buf);
        req.setCompleteListener(this._inboundListener);
        this.addIBRequest(req);
    }

    private void queuedWrite(ByteBuffer buf, FIFOBandwidthLimiter.Request req) {
        req.attach(buf);
        req.setCompleteListener(this._outboundListener);
        this.addOBRequest(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recv(ByteBuffer buf) {
        if (this.isClosed()) {
            if (this._log.shouldWarn()) {
                this._log.warn("recv() on closed con");
            }
            return;
        }
        Object object = this._statLock;
        synchronized (object) {
            this._bytesReceived += (long)buf.remaining();
            this.updateStats();
        }
        this._readBufs.offer(buf);
        this._transport.getReader().wantsRead(this);
    }

    Object getWriteLock() {
        return this._writeLock;
    }

    private void write(ByteBuffer buf) {
        this._writeBufs.offer(buf);
        EventPumper pumper = this._transport.getPumper();
        if (this._isInbound || this.isEstablished()) {
            if (!pumper.processWrite(this, this.getKey())) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Async write not completed, pending bufs: " + this._writeBufs.size() + " on " + this);
                }
                pumper.wantsWrite(this);
            }
        } else {
            pumper.wantsWrite(this);
        }
    }

    ByteBuffer getNextReadBuf() {
        return this._readBufs.poll();
    }

    boolean isWriteBufEmpty() {
        return this._writeBufs.isEmpty();
    }

    ByteBuffer getNextWriteBuf() {
        return this._writeBufs.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWriteBuf(ByteBuffer buf) {
        boolean clearMessage = this.isEstablished();
        Object object = this._statLock;
        synchronized (object) {
            this._bytesSent += (long)buf.capacity();
            if (this._sendingMeta && buf.capacity() == 16) {
                this._sendingMeta = false;
                clearMessage = false;
            }
            this.updateStats();
        }
        this._writeBufs.remove(buf);
        if (clearMessage) {
            ArrayList<OutNetMessage> msgs = null;
            if (!this._currentOutbound.isEmpty()) {
                msgs = new ArrayList<OutNetMessage>(this._currentOutbound);
                this._currentOutbound.clear();
            }
            if (!this._outbound.isEmpty()) {
                this._transport.getWriter().wantsWrite(this, "write completed");
            }
            if (msgs != null) {
                this._lastSendTime = this._context.clock().now();
                this._context.statManager().addRateData("ntcp.sendTime", ((OutNetMessage)msgs.get(0)).getSendTime());
                for (OutNetMessage msg : msgs) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("I2NP message " + this._messagesWritten + "/" + msg.getMessageId() + " sent after " + msg.getSendTime() + "/" + msg.getLifetime() + " with " + buf.capacity() + " bytes (uid=" + System.identityHashCode(msg) + " on " + this.toString() + ")");
                    }
                    this._transport.sendComplete(msg);
                }
                this._messagesWritten.addAndGet(msgs.size());
            }
        } else {
            if (!this._outbound.isEmpty()) {
                this._transport.getWriter().wantsWrite(this, "write completed");
            }
            if (this._log.shouldDebug()) {
                this._log.debug("I2NP meta message sent completely");
            }
            this._messagesWritten.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getSendRate() {
        Object object = this._statLock;
        synchronized (object) {
            return this._sendBps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getRecvRate() {
        Object object = this._statLock;
        synchronized (object) {
            return this._recvBps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStats() {
        Object object = this._statLock;
        synchronized (object) {
            long now = this._context.clock().now();
            long time = now - this._lastRateUpdated;
            if (time >= 30000L) {
                long totS = this._bytesSent;
                long totR = this._bytesReceived;
                long sent = totS - this._lastBytesSent;
                long recv = totR - this._lastBytesReceived;
                this._lastBytesSent = totS;
                this._lastBytesReceived = totR;
                this._lastRateUpdated = now;
                this._sendBps = 0.9f * this._sendBps + 0.1f * ((float)sent * 1000.0f) / (float)time;
                this._recvBps = 0.9f * this._recvBps + 0.1f * ((float)recv * 1000.0f) / (float)time;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recvEncryptedI2NP(ByteBuffer buf) {
        Object object = this._readLock;
        synchronized (object) {
            if (this._curReadState == null) {
                throw new IllegalStateException("not established");
            }
            this._curReadState.receive(buf);
        }
    }

    private void receiveTimestamp(long ts) {
        long ourTs = (this._context.clock().now() + 500L) / 1000L;
        long newSkew = ourTs - ts;
        if (Math.abs(newSkew * 1000L) > 60000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Peer's skew jumped too far (from " + this._clockSkew + " s to " + newSkew + " s): " + this.toString());
            }
            this._context.statManager().addRateData("ntcp.corruptSkew", newSkew);
            this.close();
            return;
        }
        this._context.statManager().addRateData("ntcp.receiveMeta", newSkew);
        if (this._log.shouldLog(10)) {
            this._log.debug("Received NTCP metadata, old skew of " + this._clockSkew + " s, new skew of " + newSkew + "s.");
        }
        this._clockSkew = newSkew;
    }

    private static final I2NPMessageHandler acquireHandler(RouterContext ctx) {
        I2NPMessageHandler rv = _i2npHandlers.poll();
        if (rv == null) {
            rv = new I2NPMessageHandler(ctx);
        }
        return rv;
    }

    private static void releaseHandler(I2NPMessageHandler handler) {
        _i2npHandlers.offer(handler);
    }

    private static ByteArray acquireReadBuf() {
        return (ByteArray)_dataReadBufs.acquire();
    }

    private static void releaseReadBuf(ByteArray buf) {
        _dataReadBufs.release(buf, false);
    }

    static void releaseResources() {
        _i2npHandlers.clear();
    }

    synchronized void finishOutboundEstablishment(CipherState sender, CipherState receiver, byte[] sip_ab, byte[] sip_ba, long clockSkew) {
        this.finishEstablishment(sender, receiver, sip_ab, sip_ba, clockSkew);
        this._transport.markReachable(this.getRemotePeer().calculateHash(), false);
        if (!this._outbound.isEmpty()) {
            this._transport.getWriter().wantsWrite(this, "outbound established");
        }
    }

    synchronized void finishInboundEstablishment(CipherState sender, CipherState receiver, byte[] sip_ba, byte[] sip_ab, long clockSkew, NTCP2Options hisPadding) {
        NTCPConnection toClose;
        this.finishEstablishment(sender, receiver, sip_ba, sip_ab, clockSkew);
        if (hisPadding != null) {
            this._paddingConfig = OUR_PADDING.merge(hisPadding);
            if (this._log.shouldDebug()) {
                this._log.debug("Got padding options:\nhis padding options: " + hisPadding + "\nour padding options: " + OUR_PADDING + "\nmerged config is:    " + this._paddingConfig);
            }
        }
        if ((toClose = this._transport.inboundEstablished(this)) != null && toClose != this) {
            int drained = toClose.drainOutboundTo(this._outbound);
            if (this._log.shouldWarn()) {
                this._log.warn("Old connection closed: " + toClose + " replaced by " + this + "; drained " + drained);
            }
            this._context.statManager().addRateData("ntcp.inboundEstablishedDuplicate", toClose.getUptime());
            toClose.close();
        }
    }

    synchronized void failInboundEstablishment(CipherState sender, byte[] sip_ba, int reason) {
        byte[] ip = this.getRemoteIP();
        this._sender = sender;
        this._sendSipk1 = NTCPConnection.fromLong8LE(sip_ba, 0);
        this._sendSipk2 = NTCPConnection.fromLong8LE(sip_ba, 8);
        this._sendSipIV = new byte[8];
        System.arraycopy(sip_ba, 16, this._sendSipIV, 0, 8);
        this._establishState = EstablishBase.VERIFIED;
        this._establishedOn = this._context.clock().now();
        this._nextMetaTime = Long.MAX_VALUE;
        this._nextInfoTime = Long.MAX_VALUE;
        this._paddingConfig = OUR_PADDING;
        this.sendTermination(reason, 0);
        this._transport.getPumper().blockIP(ip);
    }

    private synchronized void finishEstablishment(CipherState sender, CipherState receiver, byte[] sip_send, byte[] sip_recv, long clockSkew) {
        if (this._establishState == EstablishBase.VERIFIED) {
            IllegalStateException ise = new IllegalStateException("Already finished on " + this);
            this._log.error("Already finished", (Throwable)ise);
            throw ise;
        }
        this._sender = sender;
        this._sendSipk1 = NTCPConnection.fromLong8LE(sip_send, 0);
        this._sendSipk2 = NTCPConnection.fromLong8LE(sip_send, 8);
        this._sendSipIV = new byte[8];
        System.arraycopy(sip_send, 16, this._sendSipIV, 0, 8);
        if (this._log.shouldDebug()) {
            this._log.debug("Send SipHash keys: " + this._sendSipk1 + ' ' + this._sendSipk2 + ' ' + Base64.encode((byte[])this._sendSipIV));
        }
        this._clockSkew = clockSkew;
        this._establishState = EstablishBase.VERIFIED;
        this._establishedOn = this._context.clock().now();
        this._nextMetaTime = this._establishedOn + 1350000L + (long)this._context.random().nextInt(2700000);
        this._nextInfoTime = this._establishedOn + 1500000L + (long)this._context.random().nextInt(3000000);
        this._curReadState = new NTCP2ReadState(receiver, sip_recv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayedClose(ByteBuffer buf, int validFramesRcvd) {
        int toRead = 18 + this._context.random().nextInt(1024);
        int remaining = toRead - buf.remaining();
        if (remaining > 0) {
            if (this._log.shouldWarn()) {
                this._log.warn("delayed close, AEAD failure after " + validFramesRcvd + " good frames, to read: " + toRead + " on " + this, (Throwable)new Exception("I did it"));
            }
            Object object = this._readLock;
            synchronized (object) {
                this._curReadState = new NTCP2FailState(toRead, validFramesRcvd);
                this._curReadState.receive(buf);
            }
        } else {
            if (this._log.shouldWarn()) {
                this._log.warn("immediate close, AEAD failure after " + validFramesRcvd + " good frames and reading " + toRead + " on " + this, (Throwable)new Exception("I did it"));
            }
            this.sendTermination(4, validFramesRcvd);
        }
    }

    private static void xor16(byte[] a, byte[] b) {
        for (int i = 0; i < 16; ++i) {
            int n = i;
            b[n] = (byte)(b[n] ^ a[i]);
        }
    }

    private static long fromLong8LE(byte[] src, int offset) {
        long rv = 0L;
        for (int i = offset + 7; i >= offset; --i) {
            rv <<= 8;
            rv |= (long)(src[i] & 0xFF);
        }
        return rv;
    }

    private static void toLong8LE(byte[] target, int offset, long value) {
        int limit = offset + 8;
        for (int i = offset; i < limit; ++i) {
            target[i] = (byte)value;
            value >>= 8;
        }
    }

    public String toString() {
        InetAddress addr;
        String fromIP = this._isInbound ? ((addr = this._chan.socket().getInetAddress()) != null ? addr.getHostAddress() : "unknown") : null;
        return "NTCP" + this._version + " conn " + this._connID + (this._isInbound ? " from " + fromIP + " port " + this._chan.socket().getPort() + ' ' : " to " + this._remAddr.getHost() + " port " + this._remAddr.getPort() + ' ') + (this._remotePeer == null ? "unknown" : this._remotePeer.calculateHash().toBase64().substring(0, 6)) + (this.isEstablished() ? "" : " not established") + " created " + DataHelper.formatDuration((long)this.getTimeSinceCreated()) + " ago, last send " + DataHelper.formatDuration((long)this.getTimeSinceSend()) + " ago, last recv " + DataHelper.formatDuration((long)this.getTimeSinceReceive()) + " ago, sent " + this._messagesWritten + ',' + " rcvd " + this._messagesRead;
    }

    private class DelayedCloser
    extends SimpleTimer2.TimedEvent {
        public DelayedCloser() {
            super(NTCPConnection.this._context.simpleTimer2());
            this.schedule(50L);
        }

        public void timeReached() {
            NTCPConnection.this.close();
        }
    }

    private class NTCP2FailState
    extends SimpleTimer2.TimedEvent
    implements ReadState {
        private final int _toRead;
        private final int _validFramesRcvd;
        private int _read;

        public NTCP2FailState(int toRead, int validFramesRcvd) {
            super(NTCPConnection.this._context.simpleTimer2());
            this._toRead = toRead;
            this._validFramesRcvd = validFramesRcvd;
            this.schedule(10000L);
        }

        @Override
        public void receive(ByteBuffer buf) {
            this._read += buf.remaining();
            if (this._read >= this._toRead) {
                this.cancel();
                this._read = Integer.MIN_VALUE;
                if (NTCPConnection.this._log.shouldWarn()) {
                    NTCPConnection.this._log.warn("close after AEAD failure and reading " + this._toRead + " on " + NTCPConnection.this);
                }
                NTCPConnection.this.sendTermination(4, this._validFramesRcvd);
            }
        }

        @Override
        public void destroy() {
            this.cancel();
        }

        public void timeReached() {
            this._read = Integer.MIN_VALUE;
            if (NTCPConnection.this._log.shouldWarn()) {
                NTCPConnection.this._log.warn("timeout after AEAD failure waiting for more data on " + NTCPConnection.this);
            }
            NTCPConnection.this.sendTermination(4, this._validFramesRcvd);
        }

        @Override
        public int getFramesReceived() {
            return 0;
        }
    }

    private class NTCP2ReadState
    implements ReadState,
    NTCP2Payload.PayloadCallback {
        private final byte[] _recvLen = new byte[2];
        private final long _sipk1;
        private final long _sipk2;
        private final byte[] _sipIV = new byte[8];
        private final CipherState _rcvr;
        private int _framelen;
        private int _received = -2;
        private ByteArray _dataBuf;
        private int _frameCount;
        private int _blockCount;
        private boolean _terminated;

        public NTCP2ReadState(CipherState rcvr, byte[] keyData) {
            this._rcvr = rcvr;
            this._sipk1 = NTCPConnection.fromLong8LE(keyData, 0);
            this._sipk2 = NTCPConnection.fromLong8LE(keyData, 8);
            System.arraycopy(keyData, 16, this._sipIV, 0, 8);
            if (NTCPConnection.this._log.shouldDebug()) {
                NTCPConnection.this._log.debug("Recv SipHash keys: " + this._sipk1 + ' ' + this._sipk2 + ' ' + Base64.encode((byte[])this._sipIV));
            }
        }

        @Override
        public void receive(ByteBuffer buf) {
            if (this._terminated) {
                if (NTCPConnection.this._log.shouldWarn()) {
                    NTCPConnection.this._log.warn("Got " + buf.remaining() + " after termination on " + NTCPConnection.this);
                }
                return;
            }
            while (buf.hasRemaining()) {
                boolean ok;
                byte[] data;
                int remaining;
                if (this._received == -2) {
                    this._recvLen[0] = buf.get();
                    ++this._received;
                }
                if (this._received == -1 && buf.hasRemaining()) {
                    this._recvLen[1] = buf.get();
                    ++this._received;
                    long sipIV = SipHashInline.hash24((long)this._sipk1, (long)this._sipk2, (byte[])this._sipIV);
                    this._recvLen[0] = (byte)(this._recvLen[0] ^ (byte)(sipIV >> 8));
                    this._recvLen[1] = (byte)(this._recvLen[1] ^ (byte)sipIV);
                    NTCPConnection.toLong8LE(this._sipIV, 0, sipIV);
                    this._framelen = (int)DataHelper.fromLong((byte[])this._recvLen, (int)0, (int)2);
                    if (this._framelen < 16) {
                        if (NTCPConnection.this._log.shouldWarn()) {
                            NTCPConnection.this._log.warn("Short frame length: " + this._framelen + " on " + NTCPConnection.this);
                        }
                        this.destroy();
                        NTCPConnection.this.delayedClose(buf, this._frameCount);
                        return;
                    }
                }
                if ((remaining = buf.remaining()) <= 0) {
                    return;
                }
                if (this._received == 0 && remaining >= this._framelen) {
                    data = buf.array();
                    int pos = buf.position();
                    ok = this.decryptAndProcess(data, pos);
                    buf.position(pos + this._framelen);
                    if (ok) continue;
                    NTCPConnection.this.delayedClose(buf, this._frameCount);
                    return;
                }
                if (this._received == 0 && (this._dataBuf == null || this._dataBuf.getData().length < this._framelen)) {
                    if (this._dataBuf != null && this._dataBuf.getData().length == 16384) {
                        NTCPConnection.releaseReadBuf(this._dataBuf);
                    }
                    if (this._framelen > 16384) {
                        if (NTCPConnection.this._log.shouldInfo()) {
                            NTCPConnection.this._log.info("Allocating big ByteArray: " + this._framelen);
                        }
                        data = new byte[this._framelen];
                        this._dataBuf = new ByteArray(data);
                    } else {
                        this._dataBuf = NTCPConnection.acquireReadBuf();
                    }
                }
                int toGet = Math.min(buf.remaining(), this._framelen - this._received);
                byte[] data2 = this._dataBuf.getData();
                buf.get(data2, this._received, toGet);
                this._received += toGet;
                if (this._received < this._framelen) {
                    return;
                }
                ok = this.decryptAndProcess(data2, 0);
                if (ok && buf.remaining() >= 2) continue;
                if (!ok) {
                    NTCPConnection.this.delayedClose(buf, this._frameCount);
                }
                if (this._dataBuf != null) {
                    if (this._dataBuf.getData().length == 16384) {
                        NTCPConnection.releaseReadBuf(this._dataBuf);
                    }
                    this._dataBuf = null;
                }
                if (ok) continue;
                return;
            }
        }

        private boolean decryptAndProcess(byte[] data, int off) {
            if (NTCPConnection.this._log.shouldDebug()) {
                NTCPConnection.this._log.debug("Decrypting frame " + this._frameCount + " with " + this._framelen + " bytes");
            }
            try {
                this._rcvr.decryptWithAd(null, data, off, data, off, this._framelen);
            }
            catch (GeneralSecurityException gse) {
                if (NTCPConnection.this._log.shouldWarn()) {
                    NTCPConnection.this._log.warn("Bad AEAD data phase frame " + this._frameCount + " with " + this._framelen + " bytes on " + NTCPConnection.this, (Throwable)gse);
                }
                this.destroy();
                return false;
            }
            try {
                int blocks = NTCP2Payload.processPayload(NTCPConnection.this._context, this, data, off, this._framelen - 16, false);
                if (NTCPConnection.this._log.shouldDebug()) {
                    NTCPConnection.this._log.debug("Processed " + blocks + " blocks in frame");
                }
                this._blockCount += blocks;
            }
            catch (IOException ioe) {
                if (NTCPConnection.this._log.shouldWarn()) {
                    NTCPConnection.this._log.warn("Fail payload " + NTCPConnection.this, (Throwable)ioe);
                }
            }
            catch (DataFormatException dfe) {
                if (NTCPConnection.this._log.shouldWarn()) {
                    NTCPConnection.this._log.warn("Fail payload " + NTCPConnection.this, (Throwable)dfe);
                }
            }
            catch (I2NPMessageException ime) {
                if (NTCPConnection.this._log.shouldWarn()) {
                    NTCPConnection.this._log.warn("Error parsing I2NP message on " + NTCPConnection.this, (Throwable)((Object)ime));
                }
                NTCPConnection.this._context.statManager().addRateData("ntcp.corruptI2NPIME", 1L);
            }
            this._received = -2;
            ++this._frameCount;
            return true;
        }

        @Override
        public void destroy() {
            if (NTCPConnection.this._log.shouldInfo()) {
                NTCPConnection.this._log.info("NTCP2 read state destroy() on " + NTCPConnection.this, (Throwable)new Exception("I did it"));
            }
            if (this._dataBuf != null && this._dataBuf.getData().length == 16384) {
                NTCPConnection.releaseReadBuf(this._dataBuf);
            }
            this._dataBuf = null;
            this._rcvr.destroy();
            this._terminated = true;
        }

        @Override
        public int getFramesReceived() {
            return this._frameCount;
        }

        @Override
        public void gotRI(RouterInfo ri, boolean isHandshake, boolean flood) throws DataFormatException {
            block11: {
                if (NTCPConnection.this._log.shouldDebug()) {
                    NTCPConnection.this._log.debug("Got updated RI");
                }
                NTCPConnection.this._messagesRead.incrementAndGet();
                Hash h = ri.getHash();
                Hash ph = NTCPConnection.this._remotePeer.calculateHash();
                if (!h.equals((Object)ph)) {
                    if (h.equals((Object)NTCPConnection.this._context.routerHash())) {
                        return;
                    }
                    DatabaseStoreMessage dbsm = new DatabaseStoreMessage(NTCPConnection.this._context);
                    dbsm.setEntry(ri);
                    dbsm.setMessageExpiration(NTCPConnection.this._context.clock().now() + 10000L);
                    NTCPConnection.this._transport.messageReceived(dbsm, null, ph, 0L, 1000);
                    return;
                }
                try {
                    if (h.equals((Object)NTCPConnection.this._context.routerHash())) {
                        return;
                    }
                    RouterInfo old = NTCPConnection.this._context.netDb().store(h, ri);
                    if (flood && !ri.equals((Object)old)) {
                        FloodfillNetworkDatabaseFacade fndf = (FloodfillNetworkDatabaseFacade)NTCPConnection.this._context.netDb();
                        if ((old == null || ri.getPublished() > old.getPublished()) && fndf.floodConditional(ri)) {
                            if (NTCPConnection.this._log.shouldDebug()) {
                                NTCPConnection.this._log.debug("Flooded the RI: " + h);
                            }
                        } else if (NTCPConnection.this._log.shouldInfo()) {
                            NTCPConnection.this._log.info("Flood request but we didn't: " + h);
                        }
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (!NTCPConnection.this._log.shouldWarn()) break block11;
                    NTCPConnection.this._log.warn("RI store fail: " + (Object)((Object)ri), (Throwable)iae);
                }
            }
        }

        @Override
        public void gotDateTime(long time) {
            if (NTCPConnection.this._log.shouldDebug()) {
                NTCPConnection.this._log.debug("Got updated datetime block");
            }
            NTCPConnection.this.receiveTimestamp((time + 500L) / 1000L);
        }

        @Override
        public void gotI2NP(I2NPMessage msg) {
            if (NTCPConnection.this._log.shouldDebug()) {
                NTCPConnection.this._log.debug("Got I2NP msg: " + msg);
            }
            long timeToRecv = 0L;
            int size = 100;
            NTCPConnection.this._transport.messageReceived(msg, NTCPConnection.this._remotePeer, null, timeToRecv, size);
            NTCPConnection.this._lastReceiveTime = NTCPConnection.this._context.clock().now();
            NTCPConnection.this._messagesRead.incrementAndGet();
        }

        @Override
        public void gotOptions(byte[] options, boolean isHandshake) {
            NTCP2Options hisPadding = NTCP2Options.fromByteArray(options);
            if (hisPadding == null) {
                if (NTCPConnection.this._log.shouldWarn()) {
                    NTCPConnection.this._log.warn("Got options length " + options.length + " on: " + this);
                }
                return;
            }
            NTCPConnection.this._paddingConfig = OUR_PADDING.merge(hisPadding);
            if (NTCPConnection.this._log.shouldDebug()) {
                NTCPConnection.this._log.debug("Got padding options:\nhis padding options: " + hisPadding + "\nour padding options: " + OUR_PADDING + "\nmerged config is:    " + NTCPConnection.this._paddingConfig);
            }
        }

        @Override
        public void gotTermination(int reason, long lastReceived) {
            if (NTCPConnection.this._log.shouldInfo()) {
                NTCPConnection.this._log.info("Got Termination: " + reason + " total rcvd: " + lastReceived + " on " + NTCPConnection.this);
            }
            NTCPConnection.this.close();
            if (reason == 17 && NTCPConnection.this._remotePeer != null) {
                NTCPConnection.this._context.banlist().banlistRouter(NTCPConnection.this._remotePeer.calculateHash(), "They banned us", null, null, NTCPConnection.this._context.clock().now() + 0x6DDD00L);
            }
        }

        @Override
        public void gotUnknown(int type, int len) {
            if (NTCPConnection.this._log.shouldWarn()) {
                NTCPConnection.this._log.warn("Got unknown block type " + type + " length " + len + " on " + NTCPConnection.this);
            }
        }

        @Override
        public void gotPadding(int paddingLength, int frameLength) {
            if (NTCPConnection.this._log.shouldDebug()) {
                NTCPConnection.this._log.debug("Got " + paddingLength + " bytes padding in " + frameLength + " byte frame; ratio: " + (float)paddingLength / (float)frameLength + " configured min: " + NTCPConnection.this._paddingConfig.getRecvMin() + " configured max: " + NTCPConnection.this._paddingConfig.getRecvMax());
            }
        }
    }

    private static interface ReadState {
        public void receive(ByteBuffer var1);

        public void destroy();

        public int getFramesReceived();
    }

    private class OutboundListener
    implements FIFOBandwidthLimiter.CompleteListener {
        private OutboundListener() {
        }

        @Override
        public void complete(FIFOBandwidthLimiter.Request req) {
            NTCPConnection.this.removeOBRequest(req);
            ByteBuffer buf = (ByteBuffer)req.attachment();
            if (!NTCPConnection.this._closed.get()) {
                NTCPConnection.this._context.statManager().addRateData("ntcp.throttledWriteComplete", NTCPConnection.this._context.clock().now() - req.getRequestTime());
                NTCPConnection.this.write(buf);
            }
        }
    }

    private class InboundListener
    implements FIFOBandwidthLimiter.CompleteListener {
        private InboundListener() {
        }

        @Override
        public void complete(FIFOBandwidthLimiter.Request req) {
            NTCPConnection.this.removeIBRequest(req);
            ByteBuffer buf = (ByteBuffer)req.attachment();
            if (NTCPConnection.this._closed.get()) {
                EventPumper.releaseBuf(buf);
                return;
            }
            NTCPConnection.this._context.statManager().addRateData("ntcp.throttledReadComplete", NTCPConnection.this._context.clock().now() - req.getRequestTime());
            NTCPConnection.this.recv(buf);
            NTCPConnection.this._transport.getPumper().wantsRead(NTCPConnection.this);
        }
    }

    static class PrepBuffer {
        final byte[] unencrypted = new byte[16384];

        public void init() {
        }
    }
}

