/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import com.southernstorm.noise.protocol.ChaChaPolyCipherState;
import com.southernstorm.noise.protocol.CipherState;
import com.southernstorm.noise.protocol.HandshakeState;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.InboundEstablishState2;
import net.i2p.router.transport.udp.OutboundEstablishState2;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerState2;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SSU2Bitfield;
import net.i2p.router.transport.udp.SSU2Header;
import net.i2p.router.transport.udp.SSU2Payload;
import net.i2p.router.transport.udp.SSU2Sender;
import net.i2p.router.transport.udp.SSU2Util;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.HexDump;
import net.i2p.util.Log;

class PacketBuilder2 {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    static final int TYPE_FIRST = 62;
    static final int TYPE_ACK = 62;
    static final int TYPE_PUNCH = 63;
    static final int TYPE_RESP = 64;
    static final int TYPE_INTRO = 65;
    static final int TYPE_RREQ = 66;
    static final int TYPE_TCB = 67;
    static final int TYPE_TBC = 68;
    static final int TYPE_TTA = 69;
    static final int TYPE_TFA = 70;
    static final int TYPE_CONF = 71;
    static final int TYPE_SREQ = 72;
    static final int TYPE_CREAT = 73;
    static final int TYPE_DESTROY = 74;
    public static final int IP_HEADER_SIZE = 20;
    public static final int UDP_HEADER_SIZE = 8;
    public static final int MIN_DATA_PACKET_OVERHEAD = 60;
    public static final int IPV6_HEADER_SIZE = 40;
    public static final int MIN_IPV6_DATA_PACKET_OVERHEAD = 80;
    private static final int ABSOLUTE_MAX_ACK_RANGES = 512;
    static final int PRIORITY_HIGH = 550;
    private static final int PRIORITY_LOW = 100;
    private static final int DATETIME_SEND_FREQUENCY = 256;

    public PacketBuilder2(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._transport = transport;
        this._log = ctx.logManager().getLog(PacketBuilder2.class);
    }

    public static int getMaxAdditionalFragmentSize(PeerState peer, int numFragments, int curDataSize) {
        int available = peer.getMTU() - curDataSize;
        available = peer.isIPv6() ? (available -= 80) : (available -= 60);
        return available -= numFragments * 3;
    }

    public UDPPacket buildPacket(OutboundMessageState state, int fragment, PeerState2 peer) throws IOException {
        List<PacketBuilder.Fragment> frags = Collections.singletonList(new PacketBuilder.Fragment(state, fragment));
        return this.buildPacket(frags, peer);
    }

    public UDPPacket buildPacket(List<PacketBuilder.Fragment> fragments, PeerState2 peer) throws IOException {
        return this.buildPacket(fragments, null, (SSU2Sender)peer);
    }

    public UDPPacket buildPacket(List<PacketBuilder.Fragment> fragments, List<SSU2Payload.Block> otherBlocks, SSU2Sender peer) throws IOException {
        int sz;
        SSU2Payload.Block block;
        int ipHeaderSize;
        int numFragments = fragments.size();
        int dataSize = 0;
        int priority = 100;
        for (int i = 0; i < numFragments; ++i) {
            PacketBuilder.Fragment frag = fragments.get(i);
            OutboundMessageState state = frag.state;
            int pri = state.getPriority();
            if (pri > priority) {
                priority = pri;
            }
            int fragment = frag.num;
            int sz2 = state.fragmentSize(fragment);
            dataSize += sz2;
            dataSize += 3;
            if (fragment <= 0) continue;
            dataSize += 5;
        }
        int currentMTU = peer.getMTU();
        int availableForAcks = currentMTU - dataSize;
        if (peer.isIPv6()) {
            availableForAcks -= 80;
            ipHeaderSize = 48;
        } else {
            availableForAcks -= 60;
            ipHeaderSize = 28;
        }
        if (otherBlocks != null) {
            for (SSU2Payload.Block block2 : otherBlocks) {
                availableForAcks -= block2.getTotalLength();
            }
        }
        long pktNum = peer.getNextPacketNumber();
        UDPPacket packet = this.buildShortPacketHeader(peer.getSendConnID(), pktNum, (byte)6);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 16;
        int bcnt = fragments.size() + 2;
        if (otherBlocks != null) {
            bcnt += otherBlocks.size();
        }
        ArrayList<SSU2Payload.Block> blocks = new ArrayList<SSU2Payload.Block>(bcnt);
        int sizeWritten = 0;
        if (availableForAcks >= 8) {
            int maxRanges = Math.min((availableForAcks - 8) / 2, 512);
            block = peer.getReceivedMessages().toAckBlock(maxRanges);
            if (block != null) {
                blocks.add(block);
                sz = block.getTotalLength();
                off += sz;
                sizeWritten += sz;
                if (this._log.shouldDebug()) {
                    this._log.debug("Sending acks " + block + " to " + peer);
                }
            }
        } else if (this._log.shouldDebug()) {
            this._log.debug("No room for acks, MTU: " + currentMTU + " data: " + dataSize + " available: " + availableForAcks);
        }
        for (int i = 0; i < numFragments; ++i) {
            PacketBuilder.Fragment frag = fragments.get(i);
            OutboundMessageState state = frag.state;
            int fragment = frag.num;
            int count = state.getFragmentCount();
            SSU2Payload.Block block3 = fragment == 0 ? (count == 1 ? new SSU2Payload.I2NPBlock(state) : new SSU2Payload.FirstFragBlock(state)) : new SSU2Payload.FollowFragBlock(state, fragment);
            blocks.add(block3);
            int sz3 = block3.getTotalLength();
            off += sz3;
            sizeWritten += sz3;
        }
        boolean hasTermination = false;
        if (otherBlocks != null) {
            for (SSU2Payload.Block block4 : otherBlocks) {
                blocks.add(block4);
                int sz4 = block4.getTotalLength();
                off += sz4;
                sizeWritten += sz4;
                if (block4.getType() != 6) continue;
                hasTermination = true;
            }
        }
        if (!hasTermination && (pktNum & 0xFFL) == 255L && ipHeaderSize + 16 + sizeWritten + 7 + 16 <= currentMTU) {
            block = new SSU2Payload.DateTimeBlock(this._context);
            blocks.add(block);
            off += 7;
            sizeWritten += 7;
        }
        if ((block = this.getPadding(ipHeaderSize + 16 + sizeWritten + 16, currentMTU)) != null) {
            blocks.add(block);
            sz = block.getTotalLength();
            off += sz;
            sizeWritten += sz;
        }
        SSU2Payload.writePayload(data, 16, blocks);
        pkt.setLength(off);
        int length = off + ipHeaderSize;
        if (numFragments > 0) {
            data[13] = peer.getFlags();
        }
        this.encryptDataPacket(packet, peer.getSendCipher(), pktNum, peer.getSendHeaderEncryptKey1(), peer.getSendHeaderEncryptKey2());
        PacketBuilder2.setTo(packet, peer.getRemoteIPAddress(), peer.getRemotePort());
        if (this._log.shouldWarn()) {
            int maxMTU = 1500;
            if ((off += 16) + ipHeaderSize > currentMTU) {
                this._log.warn("Size is " + off + " for " + packet + " data size " + dataSize + " pkt size " + (off + ipHeaderSize) + " MTU " + currentMTU + " Fragments: " + DataHelper.toString(fragments));
            }
        }
        packet.setPriority(priority);
        if (fragments.isEmpty()) {
            SSU2Bitfield acked = peer.getAckedMessages();
            if (acked != null) {
                try {
                    acked.set(pktNum);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            packet.markType(1);
            packet.setFragmentCount(-1);
            packet.setMessageType(62);
        } else {
            fragments = fragments.size() == 1 ? Collections.singletonList(fragments.get(0)) : new ArrayList<PacketBuilder.Fragment>(fragments);
            peer.fragmentsSent(pktNum, length, fragments);
        }
        return packet;
    }

    public UDPPacket buildPing(PeerState2 peer) throws IOException {
        long pktNum = peer.getNextPacketNumber();
        UDPPacket packet = this.buildShortPacketHeader(peer.getSendConnID(), pktNum, (byte)6);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 16;
        SSU2Payload.Block block = this.getPadding(0, 1280);
        List<SSU2Payload.Block> blocks = Collections.singletonList(block);
        SSU2Payload.writePayload(data, 16, blocks);
        pkt.setLength(off += block.getTotalLength());
        this.encryptDataPacket(packet, peer.getSendCipher(), pktNum, peer.getSendHeaderEncryptKey1(), peer.getSendHeaderEncryptKey2());
        PacketBuilder2.setTo(packet, peer.getRemoteIPAddress(), peer.getRemotePort());
        packet.setPriority(100);
        try {
            peer.getAckedMessages().set(pktNum);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return packet;
    }

    public UDPPacket buildACK(PeerState2 peer) throws IOException {
        return this.buildPacket(Collections.emptyList(), peer);
    }

    public UDPPacket buildSessionDestroyPacket(int reason, SSU2Sender peer) throws IOException {
        if (this._log.shouldDebug()) {
            this._log.debug("Sending termination " + reason + " to : " + peer);
        }
        peer.setDestroyReason(reason);
        ArrayList<SSU2Payload.Block> blocks = new ArrayList<SSU2Payload.Block>(2);
        if (peer.isIPv6() || !this._transport.isSymNatted()) {
            EstablishmentManager.Token token = this._transport.getEstablisher().getInboundToken(peer.getRemoteHostId());
            SSU2Payload.NewTokenBlock block = new SSU2Payload.NewTokenBlock(token);
            blocks.add(block);
        }
        SSU2Payload.TerminationBlock block = new SSU2Payload.TerminationBlock(reason, peer.getReceivedMessages().getHighestSet());
        blocks.add(block);
        UDPPacket packet = this.buildPacket(Collections.emptyList(), blocks, peer);
        packet.setMessageType(74);
        return packet;
    }

    public UDPPacket buildTokenRequestPacket(OutboundEstablishState2 state) {
        long n = (long)this._context.random().signedNextInt() & 0xFFFFFFFFL;
        UDPPacket packet = this.buildLongPacketHeader(state.getSendConnID(), n, (byte)10, state.getRcvConnID(), 0L);
        DatagramPacket pkt = packet.getPacket();
        pkt.setLength(32);
        byte[] introKey = state.getSendHeaderEncryptKey1();
        this.encryptTokenRequest(packet, introKey, n, introKey, introKey);
        pkt.setSocketAddress(state.getSentAddress());
        packet.setMessageType(72);
        packet.setPriority(550);
        state.tokenRequestSent(pkt);
        return packet;
    }

    public UDPPacket buildSessionRequestPacket(OutboundEstablishState2 state) {
        long n = (long)this._context.random().signedNextInt() & 0xFFFFFFFFL;
        UDPPacket packet = this.buildLongPacketHeader(state.getSendConnID(), n, (byte)0, state.getRcvConnID(), state.getToken());
        DatagramPacket pkt = packet.getPacket();
        pkt.setLength(32);
        byte[] introKey = state.getSendHeaderEncryptKey1();
        this.encryptSessionRequest(packet, state.getHandshakeState(), introKey, introKey, state.needIntroduction());
        pkt.setSocketAddress(state.getSentAddress());
        packet.setMessageType(72);
        packet.setPriority(550);
        state.requestSent(pkt);
        return packet;
    }

    public UDPPacket buildSessionCreatedPacket(InboundEstablishState2 state) {
        long n = (long)this._context.random().signedNextInt() & 0xFFFFFFFFL;
        UDPPacket packet = this.buildLongPacketHeader(state.getSendConnID(), n, (byte)1, state.getRcvConnID(), 0L);
        DatagramPacket pkt = packet.getPacket();
        byte[] sentIP = state.getSentIP();
        pkt.setLength(32);
        int port = state.getSentPort();
        this.encryptSessionCreated(packet, state.getHandshakeState(), state.getSendHeaderEncryptKey1(), state.getSendHeaderEncryptKey2(), state.getSentRelayTag(), null, sentIP, port);
        pkt.setSocketAddress(state.getSentAddress());
        packet.setMessageType(73);
        packet.setPriority(550);
        state.createdPacketSent(pkt);
        return packet;
    }

    public UDPPacket buildRetryPacket(InboundEstablishState2 state, int terminationCode) {
        long n = (long)this._context.random().signedNextInt() & 0xFFFFFFFFL;
        long token = terminationCode == 0 ? state.getToken() : 0L;
        UDPPacket packet = this.buildLongPacketHeader(state.getSendConnID(), n, (byte)9, state.getRcvConnID(), token);
        DatagramPacket pkt = packet.getPacket();
        byte[] sentIP = state.getSentIP();
        pkt.setLength(32);
        int port = state.getSentPort();
        byte[] introKey = state.getSendHeaderEncryptKey1();
        this.encryptRetry(packet, introKey, n, introKey, introKey, sentIP, port, terminationCode);
        pkt.setSocketAddress(state.getSentAddress());
        packet.setMessageType(73);
        packet.setPriority(550);
        state.retryPacketSent();
        return packet;
    }

    public UDPPacket buildRetryPacket(RemoteHostId to, SocketAddress toAddr, long destID, long srcID, int terminationCode) {
        long n = (long)this._context.random().signedNextInt() & 0xFFFFFFFFL;
        UDPPacket packet = this.buildLongPacketHeader(destID, n, (byte)9, srcID, 0L);
        DatagramPacket pkt = packet.getPacket();
        pkt.setLength(32);
        byte[] introKey = this._transport.getSSU2StaticIntroKey();
        this.encryptRetry(packet, introKey, n, introKey, introKey, to.getIP(), to.getPort(), terminationCode);
        pkt.setSocketAddress(toAddr);
        packet.setMessageType(73);
        packet.setPriority(100);
        return packet;
    }

    public UDPPacket[] buildSessionConfirmedPackets(OutboundEstablishState2 state, RouterInfo ourInfo) {
        byte[] gzipped;
        byte[] toIP;
        int overhead;
        int mtu;
        int max;
        boolean gzip = false;
        byte[] info = ourInfo.toByteArray();
        int numFragments = info.length / (max = (mtu = state.getMTU()) - (overhead = ((toIP = state.getSentIP()).length == 16 ? 40 : 20) + 8 + 16 + SSU2Util.KEY_LEN + 16 + 16 + 3 + 2));
        if (numFragments * max != info.length) {
            ++numFragments;
        }
        if ((numFragments > 1 || info.length > 1000) && (gzipped = DataHelper.compress((byte[])info, (int)0, (int)info.length, (int)9)).length < info.length) {
            if (this._log.shouldInfo()) {
                this._log.info("Gzipping RI, max is " + max + " size was " + info.length + " size now " + gzipped.length);
            }
            gzip = true;
            info = gzipped;
            numFragments = info.length / max;
            if (numFragments * max != info.length) {
                ++numFragments;
            }
        }
        if (numFragments > 1) {
            if (numFragments > 15) {
                throw new IllegalArgumentException();
            }
            if (this._log.shouldInfo()) {
                this._log.info("RI size " + info.length + " requires " + numFragments + " packets");
            }
            int len = max;
        } else {
            int len = info.length;
        }
        SSU2Payload.RIBlock block = new SSU2Payload.RIBlock(info, 0, info.length, false, gzip, 0, 1);
        UDPPacket[] packets = numFragments > 1 ? this.buildSessionConfirmedPackets(state, block) : new UDPPacket[]{this.buildSessionConfirmedPacket(state, block)};
        state.confirmedPacketsSent(packets);
        return packets;
    }

    private UDPPacket buildSessionConfirmedPacket(OutboundEstablishState2 state, SSU2Payload.RIBlock block) {
        UDPPacket packet = this.buildShortPacketHeader(state.getSendConnID(), 0L, (byte)2);
        DatagramPacket pkt = packet.getPacket();
        pkt.setLength(16);
        boolean isIPv6 = state.getSentIP().length == 16;
        this.encryptSessionConfirmed(packet, state.getHandshakeState(), state.getMTU(), 1, 0, isIPv6, state.getSendHeaderEncryptKey1(), state.getSendHeaderEncryptKey2(), block, null);
        pkt.setSocketAddress(state.getSentAddress());
        packet.setMessageType(71);
        packet.setPriority(550);
        return packet;
    }

    private UDPPacket[] buildSessionConfirmedPackets(OutboundEstablishState2 state, SSU2Payload.RIBlock block) {
        int i;
        int addPadding;
        UDPPacket packet0 = this.buildShortPacketHeader(state.getSendConnID(), 0L, (byte)2);
        DatagramPacket pkt = packet0.getPacket();
        byte[] data0 = pkt.getData();
        int off = pkt.getOffset();
        boolean isIPv6 = state.getSentIP().length == 16;
        int ipOverhead = (isIPv6 ? 40 : 20) + 8;
        int overhead = ipOverhead + 16 + SSU2Util.KEY_LEN + 16 + 16;
        int mtu = state.getMTU();
        int blockSize = block.getTotalLength();
        int first = mtu - overhead;
        int maxAddl = mtu - (ipOverhead + 16);
        int remaining = blockSize - first;
        int max = mtu - ipOverhead;
        int lastPktSize = remaining % max;
        if (lastPktSize < 24) {
            addPadding = 27 - lastPktSize;
            remaining += addPadding;
        } else {
            addPadding = 0;
        }
        int count = 1 + (remaining + maxAddl - 1) / maxAddl;
        byte[] jumbo = new byte[overhead + addPadding + block.getTotalLength()];
        System.arraycopy(data0, off, jumbo, 0, 16);
        pkt.setData(jumbo);
        pkt.setLength(16);
        byte[] hdrKey1 = state.getSendHeaderEncryptKey1();
        byte[] hdrKey2 = state.getSendHeaderEncryptKey2();
        this.encryptSessionConfirmed(packet0, state.getHandshakeState(), state.getMTU(), count, addPadding, isIPv6, hdrKey1, hdrKey2, block, state.getNextToken());
        int total = pkt.getLength();
        if (this._log.shouldInfo()) {
            this._log.info("Building " + count + " fragmented session confirmed packets max data: " + max + " RI block size: " + blockSize + " total data size: " + total);
        }
        System.arraycopy(jumbo, 0, data0, off, max);
        pkt.setData(data0);
        pkt.setLength(max);
        pkt.setSocketAddress(state.getSentAddress());
        SSU2Header.encryptShortHeader(packet0, hdrKey1, hdrKey2);
        packet0.setMessageType(71);
        packet0.setPriority(550);
        ArrayList<UDPPacket> rv = new ArrayList<UDPPacket>(4);
        rv.add(packet0);
        int pktnum = 0;
        for (i = max; i < total; i += max - 16) {
            UDPPacket packet = this.buildShortPacketHeader(state.getSendConnID(), 0L, (byte)2);
            pkt = packet.getPacket();
            byte[] data = pkt.getData();
            off = pkt.getOffset();
            int len = Math.min(max - 16, total - i);
            System.arraycopy(jumbo, i, data, off + 16, len);
            data[off + 13] = (byte)(++pktnum << 4 | count);
            if (len < 24) {
                this._log.error("FIXME " + len);
            }
            pkt.setLength(len + 16);
            SSU2Header.encryptShortHeader(packet, hdrKey1, hdrKey2);
            pkt.setSocketAddress(state.getSentAddress());
            packet0.setMessageType(71);
            packet0.setPriority(550);
            rv.add(packet);
        }
        if (this._log.shouldInfo()) {
            for (i = 0; i < rv.size(); ++i) {
                this._log.info("pkt " + i + " size " + ((UDPPacket)rv.get(i)).getPacket().getLength());
            }
        }
        if (rv.size() != count) {
            throw new IllegalStateException("Count " + count + " != size " + rv.size());
        }
        return rv.toArray(new UDPPacket[count]);
    }

    public UDPPacket buildPeerTestFromAlice(byte[] signedData, PeerState2 bob) throws IOException {
        SSU2Payload.PeerTestBlock block = new SSU2Payload.PeerTestBlock(1, 0, null, signedData);
        UDPPacket rv = this.buildPacket(Collections.emptyList(), Collections.singletonList(block), (SSU2Sender)bob);
        rv.setMessageType(70);
        return rv;
    }

    public UDPPacket buildPeerTestFromAlice(InetAddress toIP, int toPort, SessionKey introKey, long sendID, long rcvID, byte[] signedData) {
        long n = (long)this._context.random().signedNextInt() & 0xFFFFFFFFL;
        long token = this._context.random().nextLong();
        UDPPacket packet = this.buildLongPacketHeader(sendID, n, (byte)7, rcvID, token);
        SSU2Payload.PeerTestBlock block = new SSU2Payload.PeerTestBlock(6, 0, null, signedData);
        byte[] ik = introKey.getData();
        packet.getPacket().setLength(32);
        this.encryptPeerTest(packet, ik, n, ik, ik, toIP.getAddress(), toPort, block);
        PacketBuilder2.setTo(packet, toIP, toPort);
        packet.setMessageType(70);
        packet.setPriority(100);
        return packet;
    }

    public UDPPacket buildPeerTestToAlice(int code, Hash charlieHash, byte[] signedData, PeerState2 alice) throws IOException {
        return this.buildPeerTestToAlice(code, charlieHash, signedData, null, alice);
    }

    public UDPPacket buildPeerTestToAlice(int code, Hash charlieHash, byte[] signedData, SSU2Payload.Block riBlock, PeerState2 alice) throws IOException {
        List<SSU2Payload.Block> blocks;
        SSU2Payload.PeerTestBlock block = new SSU2Payload.PeerTestBlock(4, code, charlieHash, signedData);
        if (riBlock != null) {
            blocks = new ArrayList<SSU2Payload.PeerTestBlock>(2);
            blocks.add((SSU2Payload.PeerTestBlock)riBlock);
            blocks.add(block);
        } else {
            blocks = Collections.singletonList(block);
        }
        UDPPacket rv = this.buildPacket(Collections.emptyList(), blocks, (SSU2Sender)alice);
        rv.setMessageType(69);
        return rv;
    }

    public UDPPacket buildPeerTestToAlice(InetAddress aliceIP, int alicePort, SessionKey introKey, boolean firstSend, long sendID, long rcvID, byte[] signedData) {
        long n = (long)this._context.random().signedNextInt() & 0xFFFFFFFFL;
        long token = this._context.random().nextLong();
        UDPPacket packet = this.buildLongPacketHeader(sendID, n, (byte)7, rcvID, token);
        int msgNum = firstSend ? 5 : 7;
        SSU2Payload.PeerTestBlock block = new SSU2Payload.PeerTestBlock(msgNum, 0, null, signedData);
        byte[] ik = introKey.getData();
        packet.getPacket().setLength(32);
        this.encryptPeerTest(packet, ik, n, ik, ik, aliceIP.getAddress(), alicePort, block);
        PacketBuilder2.setTo(packet, aliceIP, alicePort);
        packet.setMessageType(69);
        packet.setPriority(100);
        return packet;
    }

    public UDPPacket buildPeerTestToCharlie(Hash aliceHash, byte[] signedData, SSU2Payload.Block riBlock, PeerState2 charlie) throws IOException {
        List<SSU2Payload.Block> blocks;
        SSU2Payload.PeerTestBlock block = new SSU2Payload.PeerTestBlock(2, 0, aliceHash, signedData);
        if (riBlock != null) {
            blocks = new ArrayList<SSU2Payload.PeerTestBlock>(2);
            blocks.add((SSU2Payload.PeerTestBlock)riBlock);
            blocks.add(block);
        } else {
            blocks = Collections.singletonList(block);
        }
        UDPPacket rv = this.buildPacket(Collections.emptyList(), blocks, (SSU2Sender)charlie);
        rv.setMessageType(68);
        return rv;
    }

    public UDPPacket buildPeerTestToBob(int code, byte[] signedData, PeerState2 bob) throws IOException {
        SSU2Payload.PeerTestBlock block = new SSU2Payload.PeerTestBlock(3, code, null, signedData);
        UDPPacket rv = this.buildPacket(Collections.emptyList(), Collections.singletonList(block), (SSU2Sender)bob);
        rv.setMessageType(67);
        return rv;
    }

    UDPPacket buildRelayRequest(byte[] signedData, PeerState2 bob) throws IOException {
        SSU2Payload.RelayRequestBlock block = new SSU2Payload.RelayRequestBlock(signedData);
        UDPPacket rv = this.buildPacket(Collections.emptyList(), Collections.singletonList(block), (SSU2Sender)bob);
        rv.setMessageType(66);
        rv.setPriority(550);
        return rv;
    }

    UDPPacket buildRelayIntro(byte[] signedData, SSU2Payload.Block riBlock, PeerState2 charlie) throws IOException {
        List<SSU2Payload.Block> blocks;
        SSU2Payload.RelayIntroBlock block = new SSU2Payload.RelayIntroBlock(signedData);
        if (riBlock != null) {
            blocks = new ArrayList<SSU2Payload.RelayIntroBlock>(2);
            blocks.add((SSU2Payload.RelayIntroBlock)riBlock);
            blocks.add(block);
        } else {
            blocks = Collections.singletonList(block);
        }
        UDPPacket rv = this.buildPacket(Collections.emptyList(), blocks, (SSU2Sender)charlie);
        rv.setMessageType(65);
        return rv;
    }

    UDPPacket buildRelayResponse(byte[] signedData, PeerState2 state) throws IOException {
        SSU2Payload.RelayResponseBlock block = new SSU2Payload.RelayResponseBlock(signedData);
        UDPPacket rv = this.buildPacket(Collections.emptyList(), Collections.singletonList(block), (SSU2Sender)state);
        rv.setMessageType(64);
        return rv;
    }

    public UDPPacket buildHolePunch(InetAddress to, int port, SessionKey introKey, long sendID, long rcvID, byte[] signedData) {
        long n = (long)this._context.random().signedNextInt() & 0xFFFFFFFFL;
        long token = this._context.random().nextLong();
        UDPPacket packet = this.buildLongPacketHeader(sendID, n, (byte)11, rcvID, token);
        SSU2Payload.RelayResponseBlock block = new SSU2Payload.RelayResponseBlock(signedData);
        if (this._log.shouldLog(20)) {
            this._log.info("Sending relay hole punch to " + to + ":" + port);
        }
        byte[] ik = introKey.getData();
        packet.getPacket().setLength(32);
        this.encryptPeerTest(packet, ik, n, ik, ik, to.getAddress(), port, block);
        PacketBuilder2.setTo(packet, to, port);
        packet.setMessageType(63);
        packet.setPriority(550);
        return packet;
    }

    private UDPPacket buildLongPacketHeader(long destID, long pktNum, byte type, long srcID, long token) {
        UDPPacket packet = this.buildShortPacketHeader(destID, pktNum, type);
        byte[] data = packet.getPacket().getData();
        data[13] = 2;
        data[14] = (byte)this._context.router().getNetworkID();
        DataHelper.toLong8((byte[])data, (int)16, (long)srcID);
        DataHelper.toLong8((byte[])data, (int)24, (long)token);
        return packet;
    }

    private UDPPacket buildShortPacketHeader(long destID, long pktNum, byte type) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        DataHelper.toLong8((byte[])data, (int)0, (long)destID);
        DataHelper.toLong((byte[])data, (int)8, (int)4, (long)pktNum);
        data[12] = type;
        return packet;
    }

    private static void setTo(UDPPacket packet, InetAddress ip, int port) {
        DatagramPacket pkt = packet.getPacket();
        pkt.setAddress(ip);
        pkt.setPort(port);
    }

    private void encryptSessionRequest(UDPPacket packet, HandshakeState state, byte[] hdrKey1, byte[] hdrKey2, boolean needIntro) {
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        try {
            if (this._log.shouldDebug()) {
                this._log.debug("After start: " + state);
            }
            ArrayList<SSU2Payload.Block> blocks = new ArrayList<SSU2Payload.Block>(3);
            SSU2Payload.Block block = new SSU2Payload.DateTimeBlock(this._context);
            int len = block.getTotalLength();
            blocks.add(block);
            if (needIntro) {
                block = new SSU2Payload.RelayTagRequestBlock();
                len += block.getTotalLength();
                blocks.add(block);
            }
            block = this.getPadding(len, 1280, 32);
            len += block.getTotalLength();
            blocks.add(block);
            SSU2Payload.writePayload(data, off + 32 + SSU2Util.KEY_LEN, blocks);
            state.start();
            if (this._log.shouldDebug()) {
                this._log.debug("State after start: " + state);
            }
            state.mixHash(data, off, 32);
            if (this._log.shouldDebug()) {
                this._log.debug("State after mixHash 1: " + state);
            }
            state.writeMessage(data, off + 32, data, off + 32 + SSU2Util.KEY_LEN, len);
            pkt.setLength(pkt.getLength() + SSU2Util.KEY_LEN + len + 16);
        }
        catch (RuntimeException re) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad msg 1 out", (Throwable)re);
            }
            throw re;
        }
        catch (GeneralSecurityException gse) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad msg 1 out", (Throwable)gse);
            }
            throw new RuntimeException("Bad msg 1 out", gse);
        }
        if (this._log.shouldDebug()) {
            this._log.debug("After msg 1: " + state + '\n' + HexDump.dump((byte[])data, (int)off, (int)pkt.getLength()));
        }
        SSU2Header.encryptHandshakeHeader(packet, hdrKey1, hdrKey2);
        if (this._log.shouldDebug()) {
            this._log.debug("Hdr key 1: " + Base64.encode((byte[])hdrKey1) + " Hdr key 2: " + Base64.encode((byte[])hdrKey2));
        }
    }

    private void encryptSessionCreated(UDPPacket packet, HandshakeState state, byte[] hdrKey1, byte[] hdrKey2, long relayTag, EstablishmentManager.Token token, byte[] ip, int port) {
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        try {
            ArrayList<SSU2Payload.Block> blocks = new ArrayList<SSU2Payload.Block>(4);
            SSU2Payload.Block block = new SSU2Payload.DateTimeBlock(this._context);
            int len = block.getTotalLength();
            blocks.add(block);
            block = new SSU2Payload.AddressBlock(ip, port);
            len += block.getTotalLength();
            blocks.add(block);
            if (relayTag > 0L) {
                block = new SSU2Payload.RelayTagBlock(relayTag);
                len += block.getTotalLength();
                blocks.add(block);
            }
            if (token != null) {
                block = new SSU2Payload.NewTokenBlock(token);
                len += block.getTotalLength();
                blocks.add(block);
            }
            block = this.getPadding(len, 1280, 64);
            len += block.getTotalLength();
            blocks.add(block);
            SSU2Payload.writePayload(data, off + 32 + SSU2Util.KEY_LEN, blocks);
            state.mixHash(data, off, 32);
            if (this._log.shouldDebug()) {
                this._log.debug("State after mixHash 2: " + state);
            }
            state.writeMessage(data, off + 32, data, off + 32 + SSU2Util.KEY_LEN, len);
            pkt.setLength(pkt.getLength() + SSU2Util.KEY_LEN + len + 16);
        }
        catch (RuntimeException re) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad msg 2 out", (Throwable)re);
            }
            throw re;
        }
        catch (GeneralSecurityException gse) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad msg 2 out", (Throwable)gse);
            }
            throw new RuntimeException("Bad msg 2 out", gse);
        }
        if (this._log.shouldDebug()) {
            this._log.debug("After msg 2: " + state);
        }
        SSU2Header.encryptHandshakeHeader(packet, hdrKey1, hdrKey2);
    }

    private void encryptRetry(UDPPacket packet, byte[] chachaKey, long n, byte[] hdrKey1, byte[] hdrKey2, byte[] ip, int port, int terminationCode) {
        SSU2Payload.TerminationBlock block = terminationCode != 0 ? new SSU2Payload.TerminationBlock(terminationCode, 0L) : null;
        this.encryptPeerTest(packet, chachaKey, n, hdrKey1, hdrKey2, ip, port, block);
    }

    private void encryptPeerTest(UDPPacket packet, byte[] chachaKey, long n, byte[] hdrKey1, byte[] hdrKey2, byte[] ip, int port, SSU2Payload.Block ptBlock) {
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        try {
            ArrayList<SSU2Payload.Block> blocks = new ArrayList<SSU2Payload.Block>(4);
            SSU2Payload.Block block = new SSU2Payload.DateTimeBlock(this._context);
            int len = block.getTotalLength();
            blocks.add(block);
            block = new SSU2Payload.AddressBlock(ip, port);
            len += block.getTotalLength();
            blocks.add(block);
            if (ptBlock != null) {
                len += ptBlock.getTotalLength();
                blocks.add(ptBlock);
            }
            block = this.getPadding(len, 1280);
            len += block.getTotalLength();
            blocks.add(block);
            SSU2Payload.writePayload(data, off + 32, blocks);
            ChaChaPolyCipherState chacha = new ChaChaPolyCipherState();
            chacha.initializeKey(chachaKey, 0);
            chacha.setNonce(n);
            chacha.encryptWithAd(data, off, 32, data, off + 32, data, off + 32, len);
            pkt.setLength(pkt.getLength() + len + 16);
        }
        catch (RuntimeException re) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad retry/test/holepunch msg out", (Throwable)re);
            }
            throw re;
        }
        catch (GeneralSecurityException gse) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad retry/test/holepunch msg out", (Throwable)gse);
            }
            throw new RuntimeException("Bad retry/test/holepunch msg out", gse);
        }
        SSU2Header.encryptLongHeader(packet, hdrKey1, hdrKey2);
    }

    private void encryptTokenRequest(UDPPacket packet, byte[] chachaKey, long n, byte[] hdrKey1, byte[] hdrKey2) {
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        try {
            ArrayList<SSU2Payload.Block> blocks = new ArrayList<SSU2Payload.Block>(2);
            SSU2Payload.Block block = new SSU2Payload.DateTimeBlock(this._context);
            int len = block.getTotalLength();
            blocks.add(block);
            block = this.getPadding(len, 1280);
            len += block.getTotalLength();
            blocks.add(block);
            SSU2Payload.writePayload(data, off + 32, blocks);
            ChaChaPolyCipherState chacha = new ChaChaPolyCipherState();
            chacha.initializeKey(chachaKey, 0);
            chacha.setNonce(n);
            chacha.encryptWithAd(data, off, 32, data, off + 32, data, off + 32, len);
            pkt.setLength(pkt.getLength() + len + 16);
        }
        catch (RuntimeException re) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad token req msg out", (Throwable)re);
            }
            throw re;
        }
        catch (GeneralSecurityException gse) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad token req msg out", (Throwable)gse);
            }
            throw new RuntimeException("Bad token req msg out", gse);
        }
        SSU2Header.encryptLongHeader(packet, hdrKey1, hdrKey2);
    }

    private void encryptSessionConfirmed(UDPPacket packet, HandshakeState state, int mtu, int numFragments, int addPadding, boolean isIPv6, byte[] hdrKey1, byte[] hdrKey2, SSU2Payload.RIBlock riblock, EstablishmentManager.Token token) {
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        data[off + 13] = (byte)numFragments;
        mtu -= 8;
        mtu -= isIPv6 ? 40 : 20;
        try {
            SSU2Payload.Block block;
            ArrayList<SSU2Payload.Block> blocks = new ArrayList<SSU2Payload.Block>(3);
            int len = riblock.getTotalLength();
            blocks.add(riblock);
            if (token != null && mtu - (16 + SSU2Util.KEY_LEN + 16 + len + 16) >= 15) {
                block = new SSU2Payload.NewTokenBlock(token);
                len += block.getTotalLength();
                blocks.add(block);
            }
            if (addPadding > 0) {
                block = new SSU2Payload.PaddingBlock(addPadding - 3);
                len += addPadding;
                blocks.add(block);
            } else {
                block = this.getPadding(len, mtu - (16 + SSU2Util.KEY_LEN + 16 + 16));
                if (block != null) {
                    len += block.getTotalLength();
                    blocks.add(block);
                }
            }
            SSU2Payload.writePayload(data, off + 16 + SSU2Util.KEY_LEN + 16, blocks);
            state.mixHash(data, off, 16);
            if (this._log.shouldDebug()) {
                this._log.debug("State after mixHash 3: " + state);
            }
            state.writeMessage(data, off + 16, data, off + 16 + SSU2Util.KEY_LEN + 16, len);
            pkt.setLength(pkt.getLength() + SSU2Util.KEY_LEN + 16 + len + 16);
            if (this._log.shouldDebug()) {
                this._log.debug("Session confirmed packet length is: " + pkt.getLength());
            }
        }
        catch (RuntimeException re) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad msg 3 out", (Throwable)re);
            }
            throw re;
        }
        catch (GeneralSecurityException gse) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad msg 3 out", (Throwable)gse);
            }
            throw new RuntimeException("Bad msg 1 out", gse);
        }
        if (this._log.shouldDebug()) {
            this._log.debug("After msg 3: " + state);
        }
        if (numFragments <= 1) {
            SSU2Header.encryptShortHeader(packet, hdrKey1, hdrKey2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encryptDataPacket(UDPPacket packet, CipherState chacha, long n, byte[] hdrKey1, byte[] hdrKey2) {
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        int len = pkt.getLength();
        CipherState cipherState = chacha;
        synchronized (cipherState) {
            chacha.setNonce(n);
            try {
                chacha.encryptWithAd(data, off, 16, data, off + 16, data, off + 16, len - 16);
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException("Bad data msg", e);
            }
        }
        pkt.setLength(len += 16);
        if (len < 40) {
            this._log.error("Packet too short " + len, (Throwable)new Exception());
        }
        SSU2Header.encryptShortHeader(packet, hdrKey1, hdrKey2);
    }

    private SSU2Payload.Block getPadding(int len, int max) {
        return this.getPadding(len, max, 32);
    }

    private SSU2Payload.Block getPadding(int len, int max, int maxPadding) {
        int padlen;
        int maxpadlen = Math.min(max - len, maxPadding) - 3;
        if (maxpadlen < 0) {
            return null;
        }
        if (maxpadlen == 0) {
            padlen = 0;
        } else {
            padlen = this._context.random().nextInt(maxpadlen + 1);
            if (len == 0) {
                padlen += 5;
            }
        }
        return new SSU2Payload.PaddingBlock(padlen);
    }
}

