/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.data.i2np.UnknownI2NPMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.InboundMessageDistributor;
import net.i2p.router.tunnel.OutboundMessageDistributor;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.router.tunnel.TunnelGateway;

class TunnelGatewayZeroHop
extends TunnelGateway {
    private final TunnelCreatorConfig _config;
    private OutboundMessageDistributor _outDistributor;
    private InboundMessageDistributor _inDistributor;

    public TunnelGatewayZeroHop(RouterContext context, TunnelCreatorConfig config) {
        super(context, null, null, null);
        this._config = config;
        if (config.isInbound()) {
            this._inDistributor = new InboundMessageDistributor(context, config.getDestination());
        } else {
            this._outDistributor = new OutboundMessageDistributor(context, 425);
        }
    }

    @Override
    public void add(TunnelGatewayMessage msg) {
        I2NPMessage imsg = msg.getMessage();
        if (this._config.isInbound() && imsg instanceof UnknownI2NPMessage) {
            try {
                UnknownI2NPMessage umsg = (UnknownI2NPMessage)imsg;
                imsg = umsg.convert();
            }
            catch (I2NPMessageException ime) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to convert to std. msg. class at zero-hop IBGW", (Throwable)((Object)ime));
                }
                return;
            }
        }
        this.add(imsg, null, null);
    }

    @Override
    public void add(I2NPMessage msg, Hash toRouter, TunnelId toTunnel) {
        if (this._log.shouldLog(10)) {
            this._log.debug("zero hop gateway: distribute " + (this._config.isInbound() ? "inbound" : " outbound") + " to " + (toRouter != null ? toRouter.toBase64().substring(0, 4) : "") + "." + (toTunnel != null ? toTunnel.getTunnelId() + "" : "") + ": " + msg);
        }
        if (this._config.isInbound()) {
            this._inDistributor.distribute(msg, toRouter, toTunnel);
        } else {
            this._outDistributor.distribute(msg, toRouter, toTunnel);
        }
        this._config.incrementProcessedMessages();
    }
}

