/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.router.RouterContext;
import net.i2p.util.KeyRing;

public class PersistentKeyRing
extends KeyRing {
    private static final long serialVersionUID = 1L;
    private final transient RouterContext _ctx;
    private static final String PROP_PFX = "router.keyring.key.";

    public PersistentKeyRing(RouterContext ctx) {
        this._ctx = ctx;
        this.addFromProperties();
    }

    public SessionKey put(Hash h, SessionKey sk) {
        SessionKey old = (SessionKey)super.put((Object)h, (Object)sk);
        if (!sk.equals((Object)old)) {
            this._ctx.router().saveConfig(PROP_PFX + h.toBase64().replace("=", "$"), sk.toBase64());
        }
        return old;
    }

    public SessionKey remove(Object o) {
        SessionKey rv = (SessionKey)super.remove(o);
        if (rv != null && o instanceof Hash) {
            Hash h = (Hash)o;
            this._ctx.router().saveConfig(PROP_PFX + h.toBase64().replace("=", "$"), null);
        }
        return rv;
    }

    private void addFromProperties() {
        for (String prop : this._ctx.getPropertyNames()) {
            String key;
            if (!prop.startsWith(PROP_PFX) || (key = this._ctx.getProperty(prop)) == null || key.length() != 44) continue;
            String hb = prop.substring(PROP_PFX.length());
            hb = hb.replace("$", "=");
            Hash dest = new Hash();
            SessionKey sk = new SessionKey();
            try {
                dest.fromBase64(hb);
                sk.fromBase64(key);
                super.put((Object)dest, (Object)sk);
            }
            catch (DataFormatException dfe) {}
        }
    }
}

