/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.crypto.Blinding;
import net.i2p.data.Base32;
import net.i2p.data.BlindData;
import net.i2p.data.Destination;
import net.i2p.data.EncryptedLeaseSet;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.LeaseSet2;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.i2cp.DestReplyMessage;
import net.i2p.data.i2cp.HostReplyMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.SessionId;
import net.i2p.router.JobImpl;
import net.i2p.router.NetworkDatabaseFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.util.Log;

class LookupDestJob
extends JobImpl {
    private final Log _log;
    private final ClientConnectionRunner _runner;
    private final long _reqID;
    private final long _timeout;
    private final Hash _hash;
    private final String _name;
    private final SessionId _sessID;
    private final Hash _fromLocalDest;
    private final BlindData _blindData;
    private static final long DEFAULT_TIMEOUT = 15000L;

    public LookupDestJob(RouterContext context, ClientConnectionRunner runner, Hash h, Hash fromLocalDest) {
        this(context, runner, -1L, 15000L, null, h, null, fromLocalDest);
    }

    public LookupDestJob(RouterContext context, ClientConnectionRunner runner, long reqID, long timeout, SessionId sessID, Hash h, String name, Hash fromLocalDest) {
        super(context);
        String nlc;
        this._log = context.logManager().getLog(LookupDestJob.class);
        if (h == null && name == null || h != null && name != null || reqID >= 0L && sessID == null || reqID < 0L && name != null) {
            this._log.warn("bad args");
            throw new IllegalArgumentException();
        }
        this._runner = runner;
        this._reqID = reqID;
        this._timeout = timeout;
        this._sessID = sessID;
        this._fromLocalDest = fromLocalDest;
        BlindData bd = null;
        if (name != null && name.length() >= 60 && (nlc = name.toLowerCase(Locale.US)).endsWith(".b32.i2p")) {
            byte[] b = Base32.decode((String)nlc.substring(0, nlc.length() - 8));
            if (b != null) {
                if (b.length == 32) {
                    h = Hash.create((byte[])b);
                    if (this._log.shouldDebug()) {
                        this._log.debug("Converting name lookup " + name + " to " + h);
                    }
                    name = null;
                } else if (b.length >= 35) {
                    try {
                        bd = Blinding.decode((I2PAppContext)context, (byte[])b);
                        SigningPublicKey spk = bd.getUnblindedPubKey();
                        BlindData bd2 = this.getContext().netDb().getBlindData(spk);
                        if (bd2 != null) {
                            if (bd.getAuthRequired() && bd2.getAuthPrivKey() == null || bd.getSecretRequired() && (bd2.getSecret() == null || bd2.getSecret().length() == 0)) {
                                if (this._log.shouldDebug()) {
                                    this._log.debug("No auth or secret, immediate fail " + bd);
                                }
                            } else {
                                bd = bd2;
                            }
                        } else {
                            long now = this.getContext().clock().now();
                            bd.setDate(now);
                            long exp = now + (bd.getAuthRequired() || bd.getSecretRequired() ? 31536000000L : 8812800000L);
                            bd.setExpiration(exp);
                            this.getContext().netDb().setBlindData(bd);
                        }
                        h = bd.getBlindedHash();
                        if (this._log.shouldDebug()) {
                            this._log.debug("Converting name lookup " + name + " to blinded " + h + " using BlindData:\n" + bd);
                        }
                        name = null;
                    }
                    catch (RuntimeException re) {
                        if (this._log.shouldWarn()) {
                            this._log.debug("Failed blinding conversion of " + name, (Throwable)re);
                        }
                        name = null;
                    }
                }
            } else {
                name = null;
            }
        }
        this._hash = h;
        this._name = name;
        this._blindData = bd;
    }

    @Override
    public String getName() {
        return this._name != null ? "HostName Lookup for Client" : "LeaseSet Lookup for Client";
    }

    @Override
    public void runJob() {
        if (this._blindData != null) {
            boolean fail2;
            boolean fail1 = this._blindData.getAuthRequired() && this._blindData.getAuthPrivKey() == null;
            boolean bl = fail2 = this._blindData.getSecretRequired() && (this._blindData.getSecret() == null || this._blindData.getSecret().length() == 0);
            if (fail1 || fail2) {
                int code = fail1 && fail2 ? 4 : (fail1 ? 3 : 2);
                if (this._log.shouldDebug()) {
                    this._log.debug("Failed b33 lookup " + this._blindData.getUnblindedPubKey() + " with code " + code);
                }
                this.returnFail(code);
                return;
            }
            Destination d = this._blindData.getDestination();
            if (d != null) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Found cached b33 lookup " + this._blindData.getUnblindedPubKey() + " to " + d);
                }
                this.returnDest(d);
                return;
            }
        }
        if (this._name != null) {
            Destination d = this.getContext().namingService().lookup(this._name);
            if (d != null) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Found name lookup " + this._name + " to " + d);
                }
                this.returnDest(d);
            } else {
                if (this._log.shouldDebug()) {
                    this._log.debug("Failed name lookup " + this._name);
                }
                this.returnFail();
            }
        } else if (this._hash != null) {
            NetworkDatabaseFacade db;
            DoneJob done = new DoneJob(this.getContext());
            long timeout = this._timeout;
            if (timeout > 1500L) {
                timeout -= 500L;
            }
            if ((db = this._runner.getFloodfillNetworkDatabaseFacade()) == null) {
                db = this.getContext().netDb();
            }
            ((NetworkDatabaseFacade)db).lookupDestination(this._hash, done, timeout, this._fromLocalDest);
        } else {
            this.returnFail(5);
        }
    }

    private void returnDest(Destination d) {
        Object msg = this._reqID >= 0L ? new HostReplyMessage(this._sessID, d, this._reqID) : new DestReplyMessage(d);
        try {
            this._runner.doSend((I2CPMessage)msg);
        }
        catch (I2CPMessageException i2CPMessageException) {
            // empty catch block
        }
    }

    private void returnFail() {
        this.returnFail(1);
    }

    private void returnFail(int code) {
        HostReplyMessage msg;
        if (this._reqID >= 0L) {
            msg = new HostReplyMessage(this._sessID, code, this._reqID);
        } else if (this._hash != null) {
            msg = new DestReplyMessage(this._hash);
        } else {
            return;
        }
        try {
            this._runner.doSend((I2CPMessage)msg);
        }
        catch (I2CPMessageException i2CPMessageException) {
            // empty catch block
        }
    }

    private class DoneJob
    extends JobImpl {
        public DoneJob(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        @Override
        public String getName() {
            return "LeaseSet Lookup Reply to Client";
        }

        @Override
        public void runJob() {
            EncryptedLeaseSet encls;
            LeaseSet2 decls;
            LeaseSet ls;
            Destination dest;
            NetworkDatabaseFacade db = LookupDestJob.this._runner.getFloodfillNetworkDatabaseFacade();
            if (db == null) {
                db = this.getContext().netDb();
            }
            if ((dest = db.lookupDestinationLocally(LookupDestJob.this._hash)) == null && LookupDestJob.this._blindData != null && (ls = db.lookupLeaseSetLocally(LookupDestJob.this._hash)) != null && ls.getType() == 5 && (decls = (encls = (EncryptedLeaseSet)ls).getDecryptedLeaseSet()) != null) {
                dest = decls.getDestination();
            }
            if (dest != null) {
                if (LookupDestJob.this._log.shouldDebug()) {
                    LookupDestJob.this._log.debug("Found hash lookup " + LookupDestJob.this._hash + " to " + dest);
                }
                LookupDestJob.this.returnDest(dest);
            } else {
                if (LookupDestJob.this._log.shouldDebug()) {
                    LookupDestJob.this._log.debug("Failed hash lookup " + LookupDestJob.this._hash);
                }
                LookupDestJob.this.returnFail();
            }
        }
    }
}

