/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.crypto.AESEngine;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;

public final class ElGamalAESEngine {
    private final Log _log;
    private static final int MIN_ENCRYPTED_SIZE = 80;
    private final I2PAppContext _context;
    public static final int MAX_TAGS_RECEIVED = 200;
    private static final int ELG_CLEARTEXT_LENGTH = 222;
    private static final int ELG_ENCRYPTED_LENGTH = 514;

    public ElGamalAESEngine(I2PAppContext ctx) {
        this._context = ctx;
        this._log = this._context.logManager().getLog(ElGamalAESEngine.class);
        this._context.statManager().createFrequencyStat("crypto.elGamalAES.encryptNewSession", "how frequently we encrypt to a new ElGamal/AES+SessionTag session?", "Encryption", new long[]{3600000L});
        this._context.statManager().createFrequencyStat("crypto.elGamalAES.encryptExistingSession", "how frequently we encrypt to an existing ElGamal/AES+SessionTag session?", "Encryption", new long[]{3600000L});
        this._context.statManager().createFrequencyStat("crypto.elGamalAES.decryptNewSession", "how frequently we decrypt with a new ElGamal/AES+SessionTag session?", "Encryption", new long[]{3600000L});
        this._context.statManager().createFrequencyStat("crypto.elGamalAES.decryptExistingSession", "how frequently we decrypt with an existing ElGamal/AES+SessionTag session?", "Encryption", new long[]{3600000L});
        this._context.statManager().createFrequencyStat("crypto.elGamalAES.decryptFailed", "how frequently we fail to decrypt with ElGamal/AES+SessionTag?", "Encryption", new long[]{3600000L});
    }

    @Deprecated
    public byte[] decrypt(byte[] data, PrivateKey targetPrivateKey) throws DataFormatException {
        return this.decrypt(data, targetPrivateKey, this._context.sessionKeyManager());
    }

    public byte[] decrypt(byte[] data, PrivateKey targetPrivateKey, SessionKeyManager keyManager) throws DataFormatException {
        byte[] decrypted;
        if (data == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Null data being decrypted?");
            }
            return null;
        }
        if (data.length < 80) {
            if (this._log.shouldWarn()) {
                this._log.warn("Data is less than the minimum size (" + data.length + " < " + 80 + ")");
            }
            return null;
        }
        if (targetPrivateKey.getType() != EncType.ELGAMAL_2048) {
            return null;
        }
        byte[] tag = new byte[32];
        System.arraycopy(data, 0, tag, 0, 32);
        SessionTag st = new SessionTag(tag);
        SessionKey key = keyManager.consumeTag(st);
        SessionKey foundKey = new SessionKey();
        SessionKey usedKey = new SessionKey();
        HashSet<SessionTag> foundTags = new HashSet<SessionTag>();
        boolean wasExisting = false;
        boolean shouldDebug = this._log.shouldDebug();
        if (key != null) {
            if (shouldDebug) {
                this._log.debug("Decrypting existing session with tag: " + st.toString() + ": key: " + key.toBase64() + ": " + data.length + " bytes ");
            }
            if ((decrypted = this.decryptExistingSession(data, key, targetPrivateKey, foundTags, usedKey, foundKey)) != null) {
                this._context.statManager().updateFrequency("crypto.elGamalAES.decryptExistingSession");
                if (!foundTags.isEmpty() && shouldDebug) {
                    this._log.debug("ElG/AES decrypt success with " + st + ": found tags: " + foundTags.size());
                }
                wasExisting = true;
            } else {
                this._context.statManager().updateFrequency("crypto.elGamalAES.decryptFailed");
                if (this._log.shouldLog(30)) {
                    this._log.warn("ElG decrypt fail: known tag [" + st + "], failed decrypt");
                }
            }
        } else if (data.length >= 514) {
            decrypted = this.decryptNewSession(data, targetPrivateKey, foundTags, usedKey, foundKey);
            if (decrypted != null) {
                this._context.statManager().updateFrequency("crypto.elGamalAES.decryptNewSession");
                if (!foundTags.isEmpty() && shouldDebug) {
                    this._log.debug("ElG decrypt success: found tags: " + foundTags.size());
                }
            } else {
                this._context.statManager().updateFrequency("crypto.elGamalAES.decryptFailed");
                if (this._log.shouldLog(30)) {
                    this._log.warn("ElG decrypt fail: unknown tag: " + st);
                }
            }
        } else {
            return null;
        }
        if (!foundTags.isEmpty()) {
            if (foundKey.getData() != null) {
                if (shouldDebug) {
                    this._log.debug("Found key: " + foundKey.toBase64() + " tags: " + foundTags + " wasExisting? " + wasExisting);
                }
                keyManager.tagsReceived(foundKey, foundTags);
            } else if (usedKey.getData() != null) {
                if (shouldDebug) {
                    this._log.debug("Used key: " + usedKey.toBase64() + " tags: " + foundTags + " wasExisting? " + wasExisting);
                }
                keyManager.tagsReceived(usedKey, foundTags);
            }
        }
        return decrypted;
    }

    public byte[] decryptFast(byte[] data, PrivateKey targetPrivateKey, SessionKeyManager keyManager) throws DataFormatException {
        byte[] decrypted;
        if (data == null) {
            return null;
        }
        if (data.length < 80) {
            return null;
        }
        byte[] tag = new byte[32];
        System.arraycopy(data, 0, tag, 0, 32);
        SessionTag st = new SessionTag(tag);
        SessionKey key = keyManager.consumeTag(st);
        if (key == null) {
            return null;
        }
        SessionKey foundKey = new SessionKey();
        SessionKey usedKey = new SessionKey();
        HashSet<SessionTag> foundTags = new HashSet<SessionTag>();
        boolean shouldDebug = this._log.shouldDebug();
        if (shouldDebug) {
            this._log.debug("Decrypting existing session with tag: " + st.toString() + ": key: " + key.toBase64() + ": " + data.length + " bytes");
        }
        if ((decrypted = this.decryptExistingSession(data, key, targetPrivateKey, foundTags, usedKey, foundKey)) != null) {
            this._context.statManager().updateFrequency("crypto.elGamalAES.decryptExistingSession");
            if (!foundTags.isEmpty() && shouldDebug) {
                this._log.debug("ElG/AES decrypt success with " + st + ": found tags: " + foundTags.size());
            }
            if (!foundTags.isEmpty()) {
                if (foundKey.getData() != null) {
                    if (shouldDebug) {
                        this._log.debug("Found key: " + foundKey.toBase64() + " in existing session");
                    }
                    keyManager.tagsReceived(foundKey, foundTags);
                } else if (usedKey.getData() != null) {
                    if (shouldDebug) {
                        this._log.debug("Used key: " + usedKey.toBase64() + " in existing session");
                    }
                    keyManager.tagsReceived(usedKey, foundTags);
                }
            }
        } else {
            this._context.statManager().updateFrequency("crypto.elGamalAES.decryptFailed");
            if (this._log.shouldLog(30)) {
                this._log.warn("ElG decrypt fail: known tag [" + st + "], failed decrypt");
            }
        }
        return decrypted;
    }

    public byte[] decryptSlow(byte[] data, PrivateKey targetPrivateKey, SessionKeyManager keyManager) throws DataFormatException {
        if (data == null) {
            return null;
        }
        if (data.length < 514) {
            return null;
        }
        SessionKey foundKey = new SessionKey();
        SessionKey usedKey = new SessionKey();
        HashSet<SessionTag> foundTags = new HashSet<SessionTag>();
        byte[] decrypted = this.decryptNewSession(data, targetPrivateKey, foundTags, usedKey, foundKey);
        boolean shouldDebug = this._log.shouldDebug();
        if (decrypted != null) {
            this._context.statManager().updateFrequency("crypto.elGamalAES.decryptNewSession");
        } else {
            this._context.statManager().updateFrequency("crypto.elGamalAES.decryptFailed");
            if (this._log.shouldLog(30)) {
                this._log.warn("ElG decrypt fail as new session");
            }
        }
        if (!foundTags.isEmpty()) {
            if (shouldDebug) {
                this._log.debug("ElG decrypt success: found tags: " + foundTags.size());
            }
            if (foundKey.getData() != null) {
                if (shouldDebug) {
                    this._log.debug("Found key: " + foundKey.toBase64() + " in new session");
                }
                keyManager.tagsReceived(foundKey, foundTags);
            } else if (usedKey.getData() != null) {
                if (shouldDebug) {
                    this._log.debug("Used key: " + usedKey.toBase64() + " in new session");
                }
                keyManager.tagsReceived(usedKey, foundTags);
            }
        }
        return decrypted;
    }

    private byte[] decryptNewSession(byte[] data, PrivateKey targetPrivateKey, Set<SessionTag> foundTags, SessionKey usedKey, SessionKey foundKey) throws DataFormatException {
        byte[] elgEncr = new byte[514];
        if (data.length > 514) {
            System.arraycopy(data, 0, elgEncr, 0, 514);
        } else {
            System.arraycopy(data, 0, elgEncr, 514 - data.length, data.length);
        }
        byte[] elgDecr = this._context.elGamalEngine().decrypt(elgEncr, targetPrivateKey);
        if (elgDecr == null) {
            return null;
        }
        int offset = 0;
        byte[] key = new byte[32];
        System.arraycopy(elgDecr, offset, key, 0, 32);
        usedKey.setData(key);
        byte[] preIV = SimpleByteCache.acquire((int)32);
        System.arraycopy(elgDecr, offset += 32, preIV, 0, 32);
        byte[] iv = this.halfHash(preIV);
        SimpleByteCache.release((byte[])preIV);
        this._context.random().harvester().feedEntropy("ElG/AES", elgDecr, offset += 32, elgDecr.length - offset);
        byte[] aesDecr = this.decryptAESBlock(data, 514, data.length - 514, usedKey, iv, null, foundTags, foundKey);
        SimpleByteCache.release((byte[])iv);
        return aesDecr;
    }

    private byte[] decryptExistingSession(byte[] data, SessionKey key, PrivateKey targetPrivateKey, Set<SessionTag> foundTags, SessionKey usedKey, SessionKey foundKey) throws DataFormatException {
        byte[] preIV = SimpleByteCache.acquire((int)32);
        System.arraycopy(data, 0, preIV, 0, 32);
        byte[] iv = this.halfHash(preIV);
        byte[] decrypted = this.decryptAESBlock(data, 32, data.length - 32, key, iv, preIV, foundTags, foundKey);
        SimpleByteCache.release((byte[])iv);
        SimpleByteCache.release((byte[])preIV);
        if (decrypted == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Decrypting looks negative... existing key fails with existing tag, lets try as a new one");
            }
            byte[] rv = this.decryptNewSession(data, targetPrivateKey, foundTags, usedKey, foundKey);
            if (this._log.shouldLog(30)) {
                if (rv == null) {
                    this._log.warn("Decrypting failed with a known existing tag as either an existing message or a new session");
                } else {
                    this._log.warn("Decrypting suceeded as a new session, even though it used an existing tag!");
                }
            }
            return rv;
        }
        usedKey.setData(key.getData());
        return decrypted;
    }

    byte[] decryptAESBlock(byte[] encrypted, int offset, int encryptedLen, SessionKey key, byte[] iv, byte[] sentTag, Set<SessionTag> foundTags, SessionKey foundKey) throws DataFormatException {
        byte[] decrypted = new byte[encryptedLen];
        this._context.aes().decrypt(encrypted, offset, decrypted, 0, key, iv, encryptedLen);
        try {
            byte flag;
            SessionKey newKey = null;
            ArrayList<SessionTag> tags = null;
            int cur = 0;
            long numTags = DataHelper.fromLong((byte[])decrypted, (int)cur, (int)2);
            if (numTags < 0L || numTags > 200L) {
                throw new IllegalArgumentException("Invalid number of session tags");
            }
            if (numTags > 0L) {
                tags = new ArrayList<SessionTag>((int)numTags);
            }
            cur += 2;
            if (numTags * 32L > (long)(decrypted.length - 2)) {
                throw new IllegalArgumentException("# tags: " + numTags + " is too many for " + (decrypted.length - 2));
            }
            int i = 0;
            while ((long)i < numTags) {
                byte[] tag = new byte[32];
                System.arraycopy(decrypted, cur, tag, 0, 32);
                cur += 32;
                tags.add(new SessionTag(tag));
                ++i;
            }
            long len = DataHelper.fromLong((byte[])decrypted, (int)cur, (int)4);
            if (len < 0L || len > (long)(decrypted.length - (cur += 4) - 32 - 1)) {
                throw new IllegalArgumentException("Invalid size of payload (" + len + ", remaining " + (decrypted.length - cur) + ")");
            }
            int hashIndex = cur;
            cur += 32;
            if ((flag = decrypted[cur++]) == 1) {
                byte[] rekeyVal = new byte[32];
                System.arraycopy(decrypted, cur, rekeyVal, 0, 32);
                cur += 32;
                newKey = new SessionKey();
                newKey.setData(rekeyVal);
            }
            byte[] unencrData = new byte[(int)len];
            System.arraycopy(decrypted, cur, unencrData, 0, (int)len);
            cur += (int)len;
            byte[] calcHash = SimpleByteCache.acquire((int)32);
            this._context.sha().calculateHash(unencrData, 0, (int)len, calcHash, 0);
            boolean eq = DataHelper.eq((byte[])decrypted, (int)hashIndex, (byte[])calcHash, (int)0, (int)32);
            SimpleByteCache.release((byte[])calcHash);
            if (eq) {
                if (tags != null) {
                    foundTags.addAll(tags);
                }
                if (newKey != null) {
                    foundKey.setData(newKey.getData());
                }
                return unencrData;
            }
            throw new RuntimeException("Hash does not match");
        }
        catch (RuntimeException e) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to decrypt AES block", (Throwable)e);
            }
            return null;
        }
    }

    public byte[] encrypt(byte[] data, PublicKey target, SessionKey key, Set<SessionTag> tagsForDelivery, SessionTag currentTag, SessionKey newKey, long paddedSize) {
        EncType type;
        if (target != null && (type = target.getType()) != EncType.ELGAMAL_2048) {
            throw new IllegalArgumentException("Bad public key type " + type);
        }
        if (currentTag == null) {
            if (this._log.shouldDebug()) {
                this._log.debug("Encrypting as new session");
            }
            this._context.statManager().updateFrequency("crypto.elGamalAES.encryptNewSession");
            return this.encryptNewSession(data, target, key, tagsForDelivery, newKey, paddedSize);
        }
        this._context.statManager().updateFrequency("crypto.elGamalAES.encryptExistingSession");
        byte[] rv = this.encryptExistingSession(data, key, tagsForDelivery, currentTag, newKey, paddedSize);
        if (this._log.shouldLog(10)) {
            this._log.debug("Existing session encrypted with tag: " + currentTag.toString() + ": " + rv.length + " bytes and key: " + key.toBase64());
        }
        return rv;
    }

    public byte[] encrypt(byte[] data, PublicKey target, SessionKey key, Set<SessionTag> tagsForDelivery, SessionTag currentTag, long paddedSize) {
        return this.encrypt(data, target, key, tagsForDelivery, currentTag, null, paddedSize);
    }

    @Deprecated
    public byte[] encrypt(byte[] data, PublicKey target, SessionKey key, Set<SessionTag> tagsForDelivery, long paddedSize) {
        return this.encrypt(data, target, key, tagsForDelivery, null, null, paddedSize);
    }

    @Deprecated
    public byte[] encrypt(byte[] data, PublicKey target, SessionKey key, long paddedSize) {
        return this.encrypt(data, target, key, null, null, null, paddedSize);
    }

    private byte[] encryptNewSession(byte[] data, PublicKey target, SessionKey key, Set<SessionTag> tagsForDelivery, SessionKey newKey, long paddedSize) {
        byte[] elgSrcData = new byte[222];
        System.arraycopy(key.getData(), 0, elgSrcData, 0, 32);
        this._context.random().nextBytes(elgSrcData, 32, 190);
        byte[] preIV = SimpleByteCache.acquire((int)32);
        System.arraycopy(elgSrcData, 32, preIV, 0, 32);
        byte[] elgEncr = this._context.elGamalEngine().encrypt(elgSrcData, target);
        if (elgEncr.length < 514) {
            byte[] elg = new byte[514];
            int diff = elg.length - elgEncr.length;
            System.arraycopy(elgEncr, 0, elg, diff, elgEncr.length);
            elgEncr = elg;
        }
        byte[] iv = this.halfHash(preIV);
        SimpleByteCache.release((byte[])preIV);
        byte[] aesEncr = this.encryptAESBlock(data, key, iv, tagsForDelivery, newKey, paddedSize);
        SimpleByteCache.release((byte[])iv);
        byte[] rv = new byte[elgEncr.length + aesEncr.length];
        System.arraycopy(elgEncr, 0, rv, 0, elgEncr.length);
        System.arraycopy(aesEncr, 0, rv, elgEncr.length, aesEncr.length);
        return rv;
    }

    private byte[] encryptExistingSession(byte[] data, SessionKey key, Set<SessionTag> tagsForDelivery, SessionTag currentTag, SessionKey newKey, long paddedSize) {
        byte[] rawTag = currentTag.getData();
        byte[] iv = this.halfHash(rawTag);
        byte[] aesEncr = this.encryptAESBlock(data, key, iv, tagsForDelivery, newKey, paddedSize, 32);
        SimpleByteCache.release((byte[])iv);
        System.arraycopy(rawTag, 0, aesEncr, 0, rawTag.length);
        return aesEncr;
    }

    private byte[] halfHash(byte[] preIV) {
        byte[] ivHash = SimpleByteCache.acquire((int)32);
        this._context.sha().calculateHash(preIV, 0, 32, ivHash, 0);
        byte[] iv = SimpleByteCache.acquire((int)16);
        System.arraycopy(ivHash, 0, iv, 0, 16);
        SimpleByteCache.release((byte[])ivHash);
        return iv;
    }

    final byte[] encryptAESBlock(byte[] data, SessionKey key, byte[] iv, Set<SessionTag> tagsForDelivery, SessionKey newKey, long paddedSize) {
        return this.encryptAESBlock(data, key, iv, tagsForDelivery, newKey, paddedSize, 0);
    }

    private final byte[] encryptAESBlock(byte[] data, SessionKey key, byte[] iv, Set<SessionTag> tagsForDelivery, SessionKey newKey, long paddedSize, int prefixBytes) {
        int tagCount = tagsForDelivery != null ? tagsForDelivery.size() : 0;
        int size = 2 + 32 * tagCount + 4 + 32 + (newKey == null ? 1 : 33) + data.length;
        int totalSize = size + AESEngine.getPaddingSize((int)size, (long)paddedSize);
        byte[] aesData = new byte[totalSize + prefixBytes];
        int cur = prefixBytes;
        DataHelper.toLong((byte[])aesData, (int)cur, (int)2, (long)tagCount);
        cur += 2;
        if (tagsForDelivery != null && !tagsForDelivery.isEmpty()) {
            for (SessionTag tag : tagsForDelivery) {
                System.arraycopy(tag.getData(), 0, aesData, cur, 32);
                cur += 32;
            }
        }
        DataHelper.toLong((byte[])aesData, (int)cur, (int)4, (long)data.length);
        this._context.sha().calculateHash(data, 0, data.length, aesData, cur += 4);
        cur += 32;
        if (newKey == null) {
            aesData[cur++] = 0;
        } else {
            aesData[cur++] = 1;
            System.arraycopy(newKey.getData(), 0, aesData, cur, 32);
            cur += 32;
        }
        System.arraycopy(data, 0, aesData, cur, data.length);
        byte[] padding = AESEngine.getPadding((I2PAppContext)this._context, (int)size, (long)paddedSize);
        System.arraycopy(padding, 0, aesData, cur += data.length, padding.length);
        cur += padding.length;
        this._context.aes().encrypt(aesData, prefixBytes, aesData, prefixBytes, key, iv, aesData.length - prefixBytes);
        return aesData;
    }
}

