/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.router.networkdb.kademlia.SearchState;
import net.i2p.router.networkdb.kademlia.UnsupportedCryptoException;
import net.i2p.util.Log;

class SearchUpdateReplyFoundJob
extends JobImpl
implements ReplyJob {
    private final Log _log;
    private I2NPMessage _message;
    private final Hash _peer;
    private final SearchState _state;
    private final KademliaNetworkDatabaseFacade _facade;
    private final SearchJob _job;
    private final TunnelInfo _outTunnel;
    private final TunnelInfo _replyTunnel;
    private final boolean _isFloodfillPeer;
    private final long _sentOn;

    public SearchUpdateReplyFoundJob(RouterContext context, RouterInfo peer, SearchState state, KademliaNetworkDatabaseFacade facade, SearchJob job) {
        this(context, peer, state, facade, job, null, null);
    }

    public SearchUpdateReplyFoundJob(RouterContext context, RouterInfo peer, SearchState state, KademliaNetworkDatabaseFacade facade, SearchJob job, TunnelInfo outTunnel, TunnelInfo replyTunnel) {
        super(context);
        this._log = context.logManager().getLog(SearchUpdateReplyFoundJob.class);
        this._peer = peer.getIdentity().getHash();
        this._isFloodfillPeer = FloodfillNetworkDatabaseFacade.isFloodfill(peer);
        this._state = state;
        this._facade = facade;
        this._job = job;
        this._outTunnel = outTunnel;
        this._replyTunnel = replyTunnel;
        this._sentOn = System.currentTimeMillis();
    }

    @Override
    public String getName() {
        return "Update Reply Found for Kademlia Search";
    }

    @Override
    public void runJob() {
        block16: {
            int type;
            int i;
            if (this._isFloodfillPeer) {
                this._job.decrementOutstandingFloodfillSearches();
            }
            I2NPMessage message = this._message;
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Reply from " + this._peer.toBase64() + " with message " + message.getClass().getSimpleName());
            }
            long howLong = System.currentTimeMillis() - this._sentOn;
            int msgSize = 1024;
            if (this._replyTunnel != null) {
                for (i = 0; i < this._replyTunnel.getLength(); ++i) {
                    this.getContext().profileManager().tunnelDataPushed(this._replyTunnel.getPeer(i), howLong, msgSize);
                }
                this._replyTunnel.incrementVerifiedBytesTransferred(msgSize);
            }
            if (this._outTunnel != null) {
                for (i = 0; i < this._outTunnel.getLength(); ++i) {
                    this.getContext().profileManager().tunnelDataPushed(this._outTunnel.getPeer(i), howLong, msgSize);
                }
                this._outTunnel.incrementVerifiedBytesTransferred(msgSize);
            }
            if ((type = message.getType()) == 1) {
                long timeToReply = this._state.dataFound(this._peer);
                DatabaseStoreMessage msg = (DatabaseStoreMessage)message;
                DatabaseEntry entry = msg.getEntry();
                this.getContext().profileManager().dbLookupSuccessful(this._peer, timeToReply);
                try {
                    if (entry.isLeaseSet()) {
                        LeaseSet ls = (LeaseSet)entry;
                        this._facade.store(ls.getHash(), ls);
                        break block16;
                    }
                    RouterInfo ri = (RouterInfo)entry;
                    this._facade.store(ri.getHash(), ri);
                }
                catch (UnsupportedCryptoException iae) {
                    this.getContext().profileManager().dbLookupSuccessful(this._peer, timeToReply);
                    this._state.abort();
                }
                catch (IllegalArgumentException iae) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Peer " + this._peer + " sent us invalid data: ", (Throwable)iae);
                    }
                    this.getContext().profileManager().dbLookupReply(this._peer, 0, 0, 1, 0, timeToReply);
                }
            } else if (type == 3) {
                this._job.replyFound((DatabaseSearchReplyMessage)message, this._peer);
            } else {
                if (this._log.shouldLog(40)) {
                    this._log.error(this.getJobId() + ": What?! Reply job matched a strange message: " + message);
                }
                return;
            }
        }
        this._job.searchNext();
    }

    @Override
    public void setMessage(I2NPMessage message) {
        this._message = message;
    }
}

