/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterIdentity;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.util.Log;

class OutboundEstablishState {
    protected final RouterContext _context;
    protected final Log _log;
    private byte[] _sentX;
    protected byte[] _bobIP;
    protected int _bobPort;
    private byte[] _receivedY;
    protected byte[] _aliceIP;
    protected int _alicePort;
    protected long _receivedRelayTag;
    private long _receivedSignedOnTime;
    private Signature _receivedSignature;
    private byte[] _receivedEncryptedSignature;
    private byte[] _receivedIV;
    private long _sentSignedOnTime;
    protected final long _establishBegin;
    protected long _lastSend;
    protected long _nextSend;
    protected RemoteHostId _remoteHostId;
    private final RemoteHostId _claimedAddress;
    protected final RouterIdentity _remotePeer;
    private final boolean _allowExtendedOptions;
    private final boolean _needIntroduction;
    private final SessionKey _introKey;
    private final Queue<OutNetMessage> _queuedMessages;
    protected OutboundState _currentState;
    private long _introductionNonce;
    private boolean _isFirstMessageOurDSM;
    private final UDPAddress _remoteAddress;
    private boolean _complete;
    private int _confirmedSentCount;
    protected int _requestSentCount;
    private int _introSentCount;
    private long _confirmedSentTime;
    protected long _requestSentTime;
    private long _introSentTime;
    protected int _rtt;
    protected static final long RETRANSMIT_DELAY = 1250L;
    private static final long MAX_DELAY = 15000L;
    private static final long WAIT_FOR_HOLE_PUNCH_DELAY = 500L;

    protected OutboundEstablishState(RouterContext ctx, RemoteHostId claimedAddress, RemoteHostId remoteHostId, RouterIdentity remotePeer, boolean needIntroduction, SessionKey introKey, UDPAddress addr) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        if (claimedAddress != null) {
            this._bobIP = claimedAddress.getIP();
            this._bobPort = claimedAddress.getPort();
        } else {
            this._bobPort = -1;
        }
        this._claimedAddress = claimedAddress;
        this._remoteHostId = remoteHostId;
        this._allowExtendedOptions = false;
        this._needIntroduction = needIntroduction;
        this._remotePeer = remotePeer;
        this._introKey = introKey;
        this._queuedMessages = new LinkedBlockingQueue<OutNetMessage>();
        this._establishBegin = ctx.clock().now();
        this._remoteAddress = addr;
        this._introductionNonce = -1L;
        if (addr.getIntroducerCount() > 0) {
            if (this._log.shouldLog(10)) {
                this._log.debug("new outbound establish to " + remotePeer.calculateHash() + ", with address: " + addr);
            }
            this._currentState = OutboundState.OB_STATE_PENDING_INTRO;
        } else {
            this._currentState = OutboundState.OB_STATE_UNKNOWN;
        }
    }

    public int getVersion() {
        return 1;
    }

    public synchronized OutboundState getState() {
        return this._currentState;
    }

    public synchronized boolean complete() {
        boolean already = this._complete;
        this._complete = true;
        return already;
    }

    public UDPAddress getRemoteAddress() {
        return this._remoteAddress;
    }

    public void setIntroNonce(long nonce) {
        this._introductionNonce = nonce;
    }

    public long getIntroNonce() {
        return this._introductionNonce;
    }

    public boolean isExtendedOptionsAllowed() {
        return this._allowExtendedOptions;
    }

    public boolean needIntroduction() {
        return this._needIntroduction;
    }

    synchronized int getRTT() {
        return this._rtt;
    }

    public void addMessage(OutNetMessage msg) {
        DatabaseStoreMessage dsm;
        I2NPMessage m;
        if (this._queuedMessages.isEmpty() && (m = msg.getMessage()).getType() == 1 && (dsm = (DatabaseStoreMessage)m).getKey().equals((Object)this._context.routerHash())) {
            if (this.getVersion() > 1) {
                return;
            }
            this._isFirstMessageOurDSM = true;
        }
        if (!this._queuedMessages.contains(msg)) {
            this._queuedMessages.offer(msg);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("attempt to add duplicate msg to queue: " + msg);
        }
    }

    public boolean isFirstMessageOurDSM() {
        return this._isFirstMessageOurDSM;
    }

    public OutNetMessage getNextQueuedMessage() {
        return this._queuedMessages.poll();
    }

    public RouterIdentity getRemoteIdentity() {
        return this._remotePeer;
    }

    public SessionKey getIntroKey() {
        return this._introKey;
    }

    public synchronized byte[] getSentIP() {
        return this._bobIP;
    }

    public synchronized int getSentPort() {
        return this._bobPort;
    }

    public synchronized boolean validateSessionCreated() {
        throw new UnsupportedOperationException("see override");
    }

    public synchronized void fail() {
        this._receivedY = null;
        this._aliceIP = null;
        this._receivedRelayTag = 0L;
        this._receivedSignedOnTime = -1L;
        this._receivedEncryptedSignature = null;
        this._receivedIV = null;
        this._receivedSignature = null;
        this._currentState = OutboundState.OB_STATE_VALIDATION_FAILED;
        this._nextSend = this._context.clock().now();
    }

    public synchronized long getReceivedRelayTag() {
        return this._receivedRelayTag;
    }

    public synchronized long getSentSignedOnTime() {
        return this._sentSignedOnTime;
    }

    public synchronized long getReceivedSignedOnTime() {
        return this._receivedSignedOnTime;
    }

    public synchronized byte[] getReceivedIP() {
        return this._aliceIP;
    }

    public synchronized int getReceivedPort() {
        return this._alicePort;
    }

    public synchronized void confirmedPacketsSent() {
        long delay;
        this._lastSend = this._context.clock().now();
        if (this._confirmedSentCount == 0) {
            delay = 1250L;
            this._confirmedSentTime = this._lastSend;
        } else {
            delay = Math.min(1250L << this._confirmedSentCount, this._confirmedSentTime + 15000L - this._lastSend);
        }
        ++this._confirmedSentCount;
        this._nextSend = this._lastSend + delay;
        if (this._log.shouldDebug()) {
            this._log.debug("Send confirm packets, nextSend in " + delay + " on " + this);
        }
        if (this._currentState == OutboundState.OB_STATE_UNKNOWN || this._currentState == OutboundState.OB_STATE_PENDING_INTRO || this._currentState == OutboundState.OB_STATE_INTRODUCED || this._currentState == OutboundState.OB_STATE_REQUEST_SENT || this._currentState == OutboundState.OB_STATE_CREATED_RECEIVED) {
            this._currentState = OutboundState.OB_STATE_CONFIRMED_PARTIALLY;
        }
    }

    public long getConfirmedSentTime() {
        return this._confirmedSentTime;
    }

    public synchronized void requestSent() {
        long delay;
        this._lastSend = this._context.clock().now();
        if (this._requestSentCount == 0) {
            delay = 1250L;
            this._requestSentTime = this._lastSend;
        } else {
            delay = Math.min(1250L << this._requestSentCount, this._requestSentTime + 15000L - this._lastSend);
        }
        ++this._requestSentCount;
        this._nextSend = this._lastSend + delay;
        if (this._log.shouldLog(10)) {
            this._log.debug("Send a request packet, nextSend in " + delay + " on " + this);
        }
        if (this._currentState == OutboundState.OB_STATE_UNKNOWN || this._currentState == OutboundState.OB_STATE_INTRODUCED) {
            this._currentState = OutboundState.OB_STATE_REQUEST_SENT;
        }
    }

    public long getRequestSentTime() {
        return this._requestSentTime;
    }

    public synchronized void introSent() {
        long delay;
        this._lastSend = this._context.clock().now();
        if (this._introSentCount == 0) {
            delay = 1250L;
            this._introSentTime = this._lastSend;
        } else {
            delay = Math.min(1250L << this._introSentCount, this._introSentTime + 15000L - this._lastSend);
        }
        ++this._introSentCount;
        this._nextSend = this._lastSend + delay;
        if (this._currentState == OutboundState.OB_STATE_UNKNOWN) {
            this._currentState = OutboundState.OB_STATE_PENDING_INTRO;
        }
    }

    public long getIntroSentTime() {
        return this._introSentTime;
    }

    public synchronized void introductionFailed() {
        this._nextSend = this._context.clock().now();
    }

    public synchronized void introduced(byte[] bobIP, int bobPort) {
        if (this._currentState != OutboundState.OB_STATE_PENDING_INTRO) {
            return;
        }
        this._nextSend = this._context.clock().now() + 500L;
        this._currentState = OutboundState.OB_STATE_INTRODUCED;
        if (this._claimedAddress != null && bobPort == this._bobPort && DataHelper.eq((byte[])bobIP, (byte[])this._bobIP)) {
            this._remoteHostId = this._claimedAddress;
        } else {
            this._bobIP = bobIP;
            this._bobPort = bobPort;
            this._remoteHostId = new RemoteHostId(bobIP, bobPort);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Introduced to " + this._remoteHostId + ", now lets get on with establishing");
        }
    }

    synchronized boolean receiveHolePunch() {
        if (this._currentState != OutboundState.OB_STATE_INTRODUCED) {
            return false;
        }
        if (this._requestSentCount > 0) {
            return false;
        }
        long now = this._context.clock().now();
        if (this._log.shouldLog(20)) {
            this._log.info(this.toString() + " accelerating SessionRequest by " + (this._nextSend - now) + " ms");
        }
        this._nextSend = now;
        return true;
    }

    public long getLifetime() {
        return this.getLifetime(this._context.clock().now());
    }

    public long getLifetime(long now) {
        return now - this._establishBegin;
    }

    public long getEstablishBeginTime() {
        return this._establishBegin;
    }

    public synchronized long getNextSendTime() {
        return this._nextSend;
    }

    RemoteHostId getRemoteHostId() {
        return this._remoteHostId;
    }

    RemoteHostId getClaimedAddress() {
        return this._claimedAddress;
    }

    public synchronized void dataReceived() {
        this.packetReceived();
        this._currentState = OutboundState.OB_STATE_CONFIRMED_COMPLETELY;
    }

    protected void packetReceived() {
        this._nextSend = this._context.clock().now();
    }

    public String toString() {
        return "OES " + this._remotePeer.getHash().toBase64().substring(0, 6) + ' ' + this._remoteHostId + " lifetime: " + DataHelper.formatDuration((long)this.getLifetime()) + ' ' + (Object)((Object)this._currentState);
    }

    public static enum OutboundState {
        OB_STATE_UNKNOWN,
        OB_STATE_REQUEST_SENT,
        OB_STATE_CREATED_RECEIVED,
        OB_STATE_CONFIRMED_PARTIALLY,
        OB_STATE_CONFIRMED_COMPLETELY,
        OB_STATE_PENDING_INTRO,
        OB_STATE_INTRODUCED,
        OB_STATE_VALIDATION_FAILED,
        OB_STATE_NEEDS_TOKEN,
        OB_STATE_TOKEN_REQUEST_SENT,
        OB_STATE_RETRY_RECEIVED,
        OB_STATE_REQUEST_SENT_NEW_TOKEN;

    }
}

