/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PacketBuilder2;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerState2;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

class OutboundMessageFragments {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final Set<PeerState> _activePeers;
    private Iterator<PeerState> _iterator;
    private volatile boolean _alive;
    private final PacketBuilder2 _builder2;
    static final int MAX_VOLLEYS = 10;
    private static final int MAX_WAIT = 1000;

    public OutboundMessageFragments(RouterContext ctx, UDPTransport transport, ActiveThrottle throttle) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(OutboundMessageFragments.class);
        this._transport = transport;
        this._activePeers = new ConcurrentHashSet(256);
        this._builder2 = transport.getBuilder2();
        this._alive = true;
        this._context.statManager().createRateStat("udp.sendVolleyTime", "Long it takes to send a full volley", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendConfirmTime", "How long it takes to send a message and get the ACK", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendConfirmFragments", "How many fragments are included in a fully ACKed message", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendFragmentsPerPacket", "How many fragments are sent in a data packet", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendConfirmVolley", "How many times did fragments need to be sent before ACK", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendFailed", "How many sends a failed message was pushed", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendAggressiveFailed", "How many volleys was a packet sent before we gave up", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.outboundActiveCount", "How many messages are in the peer's active pool", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.outboundActivePeers", "How many peers we are actively sending to", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendRejected", "What volley are we on when the peer was throttled", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.partialACKReceived", "How many fragments were partially ACKed", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPiggyback", "How many acks were piggybacked on a data packet (time == message lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPiggybackPartial", "How many partial acks were piggybacked on a data packet (time == message lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRequiredRateStat("udp.packetsRetransmitted", "Lifetime of packets during retransmission (ms)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.peerPacketsRetransmitted", "How many packets have been retransmitted to the peer (lifetime) when a burst of packets are retransmitted (period == packets transmitted, lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.blockedRetransmissions", "How packets have been transmitted to the peer when we blocked a retransmission to them?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendCycleTime", "How long it takes to cycle through all of the active messages?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendCycleTimeSlow", "How long it takes to cycle through all of the active messages, when its going slowly?", "udp", UDPTransport.RATES);
    }

    public synchronized void startup() {
        this._alive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        this._alive = false;
        this._activePeers.clear();
        Set<PeerState> set = this._activePeers;
        synchronized (set) {
            this._activePeers.notify();
        }
    }

    void dropPeer(PeerState peer) {
        if (this._log.shouldDebug()) {
            this._log.debug("Dropping peer " + peer.getRemotePeer());
        }
        peer.dropOutbound();
        this._activePeers.remove(peer);
    }

    public boolean waitForMoreAllowed() {
        return true;
    }

    public void add(OutNetMessage msg) {
        RouterInfo target = msg.getTarget();
        if (target == null) {
            return;
        }
        PeerState peer = this._transport.getPeerState(target.getIdentity().calculateHash());
        try {
            OutboundMessageState state = new OutboundMessageState((I2PAppContext)this._context, msg, peer);
            peer.add(state);
            this.add(peer, state.getMinSendSize());
        }
        catch (IllegalArgumentException iae) {
            this._transport.failed(msg, "Peer disconnected quickly");
            return;
        }
    }

    public void add(OutboundMessageState state, PeerState peer) {
        if (peer == null) {
            throw new RuntimeException("null peer for " + state);
        }
        peer.add(state);
        this.add(peer, state.getMinSendSize());
    }

    public void add(List<OutboundMessageState> states, PeerState peer) {
        if (peer == null) {
            throw new RuntimeException("null peer");
        }
        int sz = states.size();
        int min = peer.fragmentSize();
        for (int i = 0; i < sz; ++i) {
            OutboundMessageState state = states.get(i);
            peer.add(state);
            int fsz = state.getMinSendSize();
            if (fsz >= min) continue;
            min = fsz;
        }
        this.add(peer, min);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(PeerState peer, int size) {
        boolean added = this._activePeers.add(peer);
        if (added) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Add a new message to a new peer " + peer.getRemotePeer());
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Add a new message to an existing peer " + peer.getRemotePeer());
        }
        this._context.statManager().addRateData("udp.outboundActivePeers", (long)this._activePeers.size());
        if (added || size <= 0 || peer.getSendWindowBytesRemaining() >= size) {
            Set<PeerState> set = this._activePeers;
            synchronized (set) {
                this._activePeers.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UDPPacket> getNextVolley() {
        PeerState peer = null;
        List<OutboundMessageState> states = null;
        int peersProcessed = 0;
        int nextSendDelay = Integer.MAX_VALUE;
        while (this._alive && states == null) {
            if (this._iterator == null || !this._activePeers.isEmpty() && !this._iterator.hasNext()) {
                this._iterator = this._activePeers.iterator();
            }
            long now = this._context.clock().now();
            while (this._iterator.hasNext()) {
                PeerState p = this._iterator.next();
                int remaining = p.finishMessages(now);
                if (remaining <= 0) {
                    this._iterator.remove();
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("No more pending messages for " + p.getRemotePeer());
                    continue;
                }
                ++peersProcessed;
                states = p.allocateSend(now);
                if (states != null) {
                    peer = p;
                    break;
                }
                int delay = p.getNextDelay(now);
                if (delay < nextSendDelay) {
                    nextSendDelay = delay;
                }
                if (peersProcessed < this._activePeers.size()) continue;
                break;
            }
            if (states != null || peersProcessed < this._activePeers.size() || nextSendDelay <= 0) continue;
            peersProcessed = 0;
            int toWait = Math.min(Math.max(nextSendDelay, 10), 1000);
            if (this._log.shouldLog(10)) {
                this._log.debug("wait for " + toWait);
            }
            nextSendDelay = Integer.MAX_VALUE;
            Set<PeerState> set = this._activePeers;
            synchronized (set) {
                block13: {
                    try {
                        this._activePeers.wait(toWait);
                    }
                    catch (InterruptedException ie) {
                        if (!this._log.shouldLog(10)) break block13;
                        this._log.debug("Woken up while waiting");
                    }
                }
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending " + DataHelper.toString(states));
        }
        List<UDPPacket> packets = this.preparePackets(states, peer);
        return packets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void nudge() {
        Set<PeerState> set = this._activePeers;
        synchronized (set) {
            this._activePeers.notify();
        }
    }

    private List<UDPPacket> preparePackets(List<OutboundMessageState> states, PeerState peer) {
        if (states == null || peer == null) {
            return null;
        }
        ArrayList<PacketBuilder.Fragment> toSend = new ArrayList<PacketBuilder.Fragment>(8);
        for (OutboundMessageState state : states) {
            int queued = state.push(toSend);
            if (queued <= 0 || state.getMaxSends() <= 1) continue;
            int maxPktSz = state.fragmentSize(0);
            peer.messageRetransmitted(queued, maxPktSz += 3 + (peer.isIPv6() ? 80 : 60));
            long lifetime = state.getLifetime();
            int transmitted = peer.getPacketsTransmitted();
            this._context.statManager().addRateData("udp.peerPacketsRetransmitted", (long)peer.getPacketsRetransmitted(), (long)transmitted);
            this._context.statManager().addRateData("udp.packetsRetransmitted", lifetime, (long)transmitted);
            if (this._log.shouldLog(20)) {
                this._log.info("Retransmitting " + state + " to " + peer);
            }
            this._context.statManager().addRateData("udp.sendVolleyTime", lifetime, (long)queued);
        }
        if (toSend.isEmpty()) {
            return null;
        }
        int fragmentsToSend = toSend.size();
        ArrayList<PacketBuilder.Fragment> sendNext = new ArrayList<PacketBuilder.Fragment>(Math.min(toSend.size(), 4));
        ArrayList<UDPPacket> rv = new ArrayList<UDPPacket>(toSend.size());
        for (int i = 0; i < toSend.size(); ++i) {
            UDPPacket pkt;
            int maxAvail;
            int msgType;
            PacketBuilder.Fragment next = (PacketBuilder.Fragment)toSend.get(i);
            sendNext.add(next);
            OutboundMessageState state = next.state;
            OutNetMessage msg = state.getMessage();
            int n = msgType = msg != null ? msg.getMessageTypeId() : -1;
            if (this._log.shouldDebug()) {
                this._log.debug("Building packet for " + next + " to " + peer);
            }
            int curTotalDataSize = state.fragmentSize(next.num);
            curTotalDataSize += 3;
            if (next.num > 0) {
                curTotalDataSize += 5;
            }
            if (i + 1 < toSend.size() && (maxAvail = PacketBuilder2.getMaxAdditionalFragmentSize(peer, sendNext.size(), curTotalDataSize)) >= 16) {
                for (int j = i + 1; j < toSend.size(); ++j) {
                    next = (PacketBuilder.Fragment)toSend.get(j);
                    int nextDataSize = next.state.fragmentSize(next.num);
                    if (next.num > 0) {
                        nextDataSize += 5;
                    }
                    if (nextDataSize > maxAvail) continue;
                    toSend.remove(j);
                    --j;
                    sendNext.add(next);
                    maxAvail = PacketBuilder2.getMaxAdditionalFragmentSize(peer, sendNext.size(), curTotalDataSize += nextDataSize);
                    if (this._log.shouldLog(20)) {
                        this._log.info("Adding in additional " + next + " to " + peer);
                    }
                    if (maxAvail < 16) break;
                }
            }
            try {
                pkt = this._builder2.buildPacket(sendNext, (PeerState2)peer);
            }
            catch (IOException ioe) {
                pkt = null;
            }
            if (pkt != null) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Built packet with " + sendNext.size() + " fragments totalling " + curTotalDataSize + " data bytes to " + peer);
                }
            } else {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Build packet FAIL for " + DataHelper.toString(sendNext) + " to " + peer);
                }
                sendNext.clear();
                continue;
            }
            this._context.statManager().addRateData("udp.sendFragmentsPerPacket", (long)sendNext.size());
            rv.add(pkt);
            pkt.setFragmentCount(sendNext.size());
            pkt.setMessageType(msgType);
            sendNext.clear();
        }
        int sent = rv.size();
        peer.packetsTransmitted(sent);
        peer.clearWantedACKSendSince();
        if (this._log.shouldDebug()) {
            this._log.debug("Sent " + fragmentsToSend + " fragments of " + states.size() + " messages in " + sent + " packets to " + peer);
        }
        return rv;
    }

    public static interface ActiveThrottle {
        public void choke(Hash var1);

        public void unchoke(Hash var1);

        public boolean isChoked(Hash var1);
    }
}

