/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerTestManager;
import net.i2p.router.transport.udp.PeerTestState;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

class PeerTestEvent
extends SimpleTimer2.TimedEvent {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final PeerTestManager _testManager;
    private boolean _alive;
    private final AtomicLong _lastTested = new AtomicLong();
    private final AtomicLong _lastTestedV6 = new AtomicLong();
    private static final int NO_FORCE = 0;
    private static final int FORCE_IPV4 = 1;
    private static final int FORCE_IPV6 = 2;
    private int _forceRun;
    private boolean _lastTestIPv6 = true;
    private static final int TEST_FREQUENCY = 780000;
    private static final int MIN_TEST_FREQUENCY = 45000;

    PeerTestEvent(RouterContext ctx, UDPTransport udp, PeerTestManager ptmgr) {
        super(ctx.simpleTimer2());
        this._context = ctx;
        this._log = ctx.logManager().getLog(PeerTestEvent.class);
        this._transport = udp;
        this._testManager = ptmgr;
    }

    public synchronized void timeReached() {
        if (this.shouldTest()) {
            long now = this._context.clock().now();
            long sinceRunV4 = now - this._lastTested.get();
            long sinceRunV6 = now - this._lastTestedV6.get();
            boolean configV4fw = this._transport.isIPv4Firewalled();
            boolean configV6fw = this._transport.isIPv6Firewalled();
            boolean preferV4 = this._lastTestIPv6;
            if (!configV4fw && (this._forceRun & 1) != 0 && sinceRunV4 >= 45000L) {
                this.locked_runTest(false);
            } else if (!configV6fw && (this._forceRun & 2) != 0 && this._transport.hasIPv6Address() && sinceRunV6 >= 45000L) {
                this.locked_runTest(true);
            } else if (preferV4 && !configV4fw && sinceRunV4 >= 780000L && this._transport.getIPv6Config() != TransportUtil.IPv6Config.IPV6_ONLY) {
                this.locked_runTest(false);
            } else if (!configV6fw && this._transport.hasIPv6Address() && sinceRunV6 >= 780000L) {
                this.locked_runTest(true);
            } else if (!preferV4 && !configV4fw && sinceRunV4 >= 780000L && this._transport.getIPv6Config() != TransportUtil.IPv6Config.IPV6_ONLY) {
                this.locked_runTest(false);
            } else if (this._log.shouldDebug()) {
                this._log.debug("Test timer, no test run, last v4 test: " + new Date(this._lastTested.get()) + " last v6 test: " + new Date(this._lastTestedV6.get()));
            }
        }
        if (this._alive) {
            long delay;
            if (this._forceRun != 0) {
                delay = 45000L;
            } else {
                delay = 585000 + this._context.random().nextInt(195000);
                if (this._transport.hasIPv6Address() && this._transport.getIPv6Config() != TransportUtil.IPv6Config.IPV6_ONLY) {
                    delay /= 2L;
                }
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Test force? " + this._forceRun + " reschedule for " + DataHelper.formatDuration((long)delay), (Throwable)new Exception());
            }
            this.schedule(delay);
        }
    }

    public void reschedule(long delay) {
        if (this._log.shouldDebug()) {
            this._log.debug("Test force? " + this._forceRun + " reschedule for " + DataHelper.formatDuration((long)delay), (Throwable)new Exception());
        }
        super.reschedule(delay);
    }

    private void locked_runTest(boolean isIPv6) {
        this._lastTestIPv6 = isIPv6;
        PeerState bob = this._transport.pickTestPeer(PeerTestState.Role.BOB, 0, isIPv6, null);
        if (bob != null) {
            boolean started;
            if (this._log.shouldLog(20)) {
                this._log.info("Running periodic test with bob = " + bob);
            }
            if (started = this._testManager.runTest(bob)) {
                this.setLastTested(isIPv6);
            }
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Unable to run peer test, no peers available - v6? " + isIPv6);
        }
        this._forceRun &= ~(isIPv6 ? 2 : 1);
    }

    public synchronized void forceRunSoon(boolean isIPv6) {
        this.forceRunSoon(isIPv6, 45000L);
    }

    public synchronized void forceRunSoon(boolean isIPv6, long delay) {
        if (!isIPv6 && this._transport.isIPv4Firewalled()) {
            return;
        }
        if (isIPv6 && this._transport.isIPv6Firewalled()) {
            return;
        }
        this._forceRun |= isIPv6 ? 2 : 1;
        this.reschedule(delay);
    }

    public synchronized void forceRunImmediately(boolean isIPv6) {
        this.forceRunSoon(isIPv6, 5000L);
    }

    public synchronized void setIsAlive(boolean isAlive) {
        this._alive = isAlive;
        if (!isAlive) {
            this.cancel();
        }
    }

    public void setLastTested(boolean isIPv6) {
        long now = this._context.clock().now();
        if (isIPv6) {
            this._lastTestedV6.set(now);
        } else {
            this._lastTested.set(now);
        }
    }

    private boolean shouldTest() {
        return !this._context.router().isHidden() && !this._context.router().gracefulShutdownInProgress() && (!this._transport.isIPv4Firewalled() || !this._transport.isIPv6Firewalled());
    }
}

