/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.crypto.HKDF;
import net.i2p.crypto.SigType;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.router.transport.udp.PeerTestState;

final class SSU2Util {
    public static final int PROTOCOL_VERSION = 2;
    public static final int KEY_LEN = EncType.ECIES_X25519.getPubkeyLen();
    public static final int MAC_LEN = 16;
    public static final int CHACHA_IV_LEN = 12;
    public static final int INTRO_KEY_LEN = 32;
    public static final int SHORT_HEADER_SIZE = 16;
    public static final int LONG_HEADER_SIZE = 32;
    public static final int SESSION_HEADER_SIZE = 32 + KEY_LEN;
    public static final int DEST_CONN_ID_OFFSET = 0;
    public static final int PKT_NUM_OFFSET = 8;
    public static final int PKT_NUM_LEN = 4;
    public static final int TYPE_OFFSET = 12;
    public static final int VERSION_OFFSET = 13;
    public static final int SHORT_HEADER_FLAGS_OFFSET = 13;
    public static final int SHORT_HEADER_FLAGS_LEN = 3;
    public static final int NETID_OFFSET = 14;
    public static final int LONG_HEADER_FLAGS_OFFSET = 15;
    public static final int SRC_CONN_ID_OFFSET = 16;
    public static final int TOKEN_OFFSET = 24;
    public static final int HEADER_PROT_SAMPLE_LEN = 12;
    public static final int TOTAL_PROT_SAMPLE_LEN = 24;
    public static final int HEADER_PROT_SAMPLE_1_OFFSET = 24;
    public static final int HEADER_PROT_SAMPLE_2_OFFSET = 12;
    public static final int HEADER_PROT_DATA_LEN = 8;
    public static final int HEADER_PROT_1_OFFSET = 0;
    public static final int HEADER_PROT_2_OFFSET = 8;
    public static final int PADDING_MAX = 32;
    public static final int PADDING_MAX_SESSION_REQUEST = 32;
    public static final int PADDING_MAX_SESSION_CREATED = 64;
    public static final int MIN_DATA_LEN = 40;
    public static final int MIN_LONG_DATA_LEN = 56;
    public static final int MIN_HANDSHAKE_DATA_LEN;
    public static final int MIN_TOKEN_REQUEST_LEN = 56;
    public static final int MIN_RETRY_LEN = 56;
    public static final int MIN_SESSION_REQUEST_LEN;
    public static final int MIN_SESSION_CREATED_LEN;
    public static final int FIRST_FRAGMENT_HEADER_SIZE = 3;
    public static final int DATA_FOLLOWON_EXTRA_SIZE = 5;
    public static final int FOLLOWON_FRAGMENT_HEADER_SIZE = 8;
    public static final int DATA_HEADER_SIZE = 16;
    public static final byte SESSION_REQUEST_FLAG_BYTE = 0;
    public static final byte SESSION_CREATED_FLAG_BYTE = 1;
    public static final byte SESSION_CONFIRMED_FLAG_BYTE = 2;
    public static final byte DATA_FLAG_BYTE = 6;
    public static final byte PEER_TEST_FLAG_BYTE = 7;
    public static final byte RETRY_FLAG_BYTE = 9;
    public static final byte TOKEN_REQUEST_FLAG_BYTE = 10;
    public static final byte HOLE_PUNCH_FLAG_BYTE = 11;
    public static final String INFO_CREATED = "SessCreateHeader";
    public static final String INFO_CONFIRMED = "SessionConfirmed";
    public static final String INFO_DATA = "HKDFSSU2DataKeys";
    public static final byte[] ZEROLEN;
    public static final byte[] ZEROKEY;
    public static final byte[] RELAY_REQUEST_PROLOGUE;
    public static final byte[] RELAY_RESPONSE_PROLOGUE;
    public static final byte[] PEER_TEST_PROLOGUE;
    public static final int TEST_ACCEPT = 0;
    public static final int TEST_REJECT_BOB_UNSPEC = 1;
    public static final int TEST_REJECT_BOB_NO_CHARLIE = 2;
    public static final int TEST_REJECT_BOB_LIMIT = 3;
    public static final int TEST_REJECT_BOB_SIGFAIL = 4;
    public static final int TEST_REJECT_BOB_ADDRESS = 5;
    public static final int TEST_REJECT_CHARLIE_UNSPEC = 64;
    public static final int TEST_REJECT_CHARLIE_ADDRESS = 65;
    public static final int TEST_REJECT_CHARLIE_LIMIT = 66;
    public static final int TEST_REJECT_CHARLIE_SIGFAIL = 67;
    public static final int TEST_REJECT_CHARLIE_CONNECTED = 68;
    public static final int TEST_REJECT_CHARLIE_BANNED = 69;
    public static final int TEST_REJECT_CHARLIE_UNKNOWN_ALICE = 70;
    public static final int RELAY_ACCEPT = 0;
    public static final int RELAY_REJECT_BOB_UNSPEC = 1;
    public static final int RELAY_REJECT_BOB_BANNED_CHARLIE = 2;
    public static final int RELAY_REJECT_BOB_LIMIT = 3;
    public static final int RELAY_REJECT_BOB_SIGFAIL = 4;
    public static final int RELAY_REJECT_BOB_NO_TAG = 5;
    public static final int RELAY_REJECT_BOB_UNKNOWN_ALICE = 6;
    public static final int RELAY_REJECT_CHARLIE_UNSPEC = 64;
    public static final int RELAY_REJECT_CHARLIE_ADDRESS = 65;
    public static final int RELAY_REJECT_CHARLIE_LIMIT = 66;
    public static final int RELAY_REJECT_CHARLIE_SIGFAIL = 67;
    public static final int RELAY_REJECT_CHARLIE_CONNECTED = 68;
    public static final int RELAY_REJECT_CHARLIE_BANNED = 69;
    public static final int RELAY_REJECT_CHARLIE_UNKNOWN_ALICE = 70;
    public static final int REASON_UNSPEC = 0;
    public static final int REASON_TERMINATION = 1;
    public static final int REASON_TIMEOUT = 2;
    public static final int REASON_SHUTDOWN = 3;
    public static final int REASON_AEAD = 4;
    public static final int REASON_OPTIONS = 5;
    public static final int REASON_SIGTYPE = 6;
    public static final int REASON_SKEW = 7;
    public static final int REASON_PADDING = 8;
    public static final int REASON_FRAMING = 9;
    public static final int REASON_PAYLOAD = 10;
    public static final int REASON_MSG1 = 11;
    public static final int REASON_MSG2 = 12;
    public static final int REASON_MSG3 = 13;
    public static final int REASON_FRAME_TIMEOUT = 14;
    public static final int REASON_SIGFAIL = 15;
    public static final int REASON_S_MISMATCH = 16;
    public static final int REASON_BANNED = 17;
    public static final int REASON_TOKEN = 18;
    public static final int REASON_LIMITS = 19;
    public static final int REASON_VERSION = 20;
    public static final int REASON_NETID = 21;
    public static final int REASON_REPLACED = 22;

    private SSU2Util() {
    }

    public static byte[] hkdf(I2PAppContext ctx, byte[] key, String info) {
        HKDF hkdf = new HKDF(ctx);
        byte[] rv = new byte[32];
        hkdf.calculate(key, ZEROLEN, info, rv);
        return rv;
    }

    public static byte[] createPeerTestData(I2PAppContext ctx, Hash h, Hash h2, PeerTestState.Role role, long nonce, byte[] ip, int port, SigningPrivateKey spk) {
        Signature sig;
        int datalen = 12 + (ip != null ? ip.length : 0);
        byte[] data = new byte[datalen + spk.getType().getSigLen()];
        data[0] = 2;
        DataHelper.toLong((byte[])data, (int)1, (int)4, (long)nonce);
        DataHelper.toLong((byte[])data, (int)5, (int)4, (long)(ctx.clock().now() / 1000L));
        int iplen = ip != null ? ip.length : 0;
        data[9] = (byte)(ip != null ? iplen + 2 : 0);
        if (ip != null) {
            DataHelper.toLong((byte[])data, (int)10, (int)2, (long)port);
            System.arraycopy(ip, 0, data, 12, iplen);
        }
        if ((sig = SSU2Util.sign(ctx, PEER_TEST_PROLOGUE, h, h2, data, datalen, spk)) == null) {
            return null;
        }
        byte[] s = sig.getData();
        System.arraycopy(s, 0, data, datalen, s.length);
        return data;
    }

    public static byte[] createRelayRequestData(I2PAppContext ctx, Hash h, Hash h2, long nonce, long tag, byte[] ip, int port, SigningPrivateKey spk) {
        int datalen = 16 + ip.length;
        byte[] data = new byte[datalen];
        DataHelper.toLong((byte[])data, (int)0, (int)4, (long)nonce);
        DataHelper.toLong((byte[])data, (int)4, (int)4, (long)tag);
        DataHelper.toLong((byte[])data, (int)8, (int)4, (long)(ctx.clock().now() / 1000L));
        data[12] = 2;
        data[13] = (byte)(ip.length + 2);
        DataHelper.toLong((byte[])data, (int)14, (int)2, (long)port);
        System.arraycopy(ip, 0, data, 16, ip.length);
        Signature sig = SSU2Util.sign(ctx, RELAY_REQUEST_PROLOGUE, h, h2, data, datalen, spk);
        if (sig == null) {
            return null;
        }
        int len = 1 + datalen + spk.getType().getSigLen();
        byte[] rv = new byte[len];
        System.arraycopy(data, 0, rv, 1, data.length);
        byte[] s = sig.getData();
        System.arraycopy(s, 0, rv, 1 + datalen, s.length);
        return rv;
    }

    public static byte[] createRelayResponseData(I2PAppContext ctx, Hash h, int code, long nonce, byte[] ip, int port, SigningPrivateKey spk, long token) {
        Signature sig;
        int datalen = 10;
        if (ip != null) {
            datalen += 2 + ip.length;
        }
        byte[] data = new byte[datalen];
        DataHelper.toLong((byte[])data, (int)0, (int)4, (long)nonce);
        DataHelper.toLong((byte[])data, (int)4, (int)4, (long)(ctx.clock().now() / 1000L));
        data[8] = 2;
        if (ip != null) {
            data[9] = (byte)(ip.length + 2);
            DataHelper.toLong((byte[])data, (int)10, (int)2, (long)port);
            System.arraycopy(ip, 0, data, 12, ip.length);
        }
        if ((sig = SSU2Util.sign(ctx, RELAY_RESPONSE_PROLOGUE, h, null, data, datalen, spk)) == null) {
            return null;
        }
        int len = 2 + datalen + spk.getType().getSigLen();
        if (token != 0L) {
            len += 8;
        }
        byte[] rv = new byte[len];
        rv[1] = (byte)code;
        System.arraycopy(data, 0, rv, 2, data.length);
        byte[] s = sig.getData();
        System.arraycopy(s, 0, rv, 2 + datalen, s.length);
        if (token != 0L) {
            DataHelper.toLong8((byte[])rv, (int)(2 + datalen + s.length), (long)token);
        }
        return rv;
    }

    public static Signature sign(I2PAppContext ctx, byte[] prologue, Hash h, Hash h2, byte[] data, int datalen, SigningPrivateKey spk) {
        int len = prologue.length + 32 + datalen;
        if (h2 != null) {
            len += 32;
        }
        byte[] buf = new byte[len];
        System.arraycopy(prologue, 0, buf, 0, prologue.length);
        System.arraycopy(h.getData(), 0, buf, prologue.length, 32);
        int off = prologue.length + 32;
        if (h2 != null) {
            System.arraycopy(h2.getData(), 0, buf, off, 32);
            off += 32;
        }
        System.arraycopy(data, 0, buf, off, datalen);
        return ctx.dsa().sign(buf, spk);
    }

    public static boolean validateSig(I2PAppContext ctx, byte[] prologue, Hash h, Hash h2, byte[] data, SigningPublicKey spk) {
        SigType type = spk.getType();
        int siglen = type.getSigLen();
        int len = prologue.length + 32 + data.length - siglen;
        if (h2 != null) {
            len += 32;
        }
        byte[] buf = new byte[len];
        System.arraycopy(prologue, 0, buf, 0, prologue.length);
        System.arraycopy(h.getData(), 0, buf, prologue.length, 32);
        int off = prologue.length + 32;
        if (h2 != null) {
            System.arraycopy(h2.getData(), 0, buf, off, 32);
            off += 32;
        }
        System.arraycopy(data, 0, buf, off, data.length - siglen);
        byte[] bsig = new byte[siglen];
        System.arraycopy(data, data.length - siglen, bsig, 0, siglen);
        Signature sig = new Signature(type, bsig);
        return ctx.dsa().verifySignature(sig, buf, spk);
    }

    static {
        MIN_SESSION_REQUEST_LEN = MIN_HANDSHAKE_DATA_LEN = SESSION_HEADER_SIZE + 24;
        MIN_SESSION_CREATED_LEN = MIN_HANDSHAKE_DATA_LEN;
        ZEROLEN = new byte[0];
        ZEROKEY = new byte[KEY_LEN];
        RELAY_REQUEST_PROLOGUE = DataHelper.getASCII((String)"RelayRequestData");
        RELAY_RESPONSE_PROLOGUE = DataHelper.getASCII((String)"RelayAgreementOK");
        PEER_TEST_PROLOGUE = DataHelper.getASCII((String)"PeerTestValidate");
    }
}

