/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import net.i2p.data.Base64;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterAddress;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.udp.MTU;
import net.i2p.util.Addresses;
import net.i2p.util.LHMCache;
import net.i2p.util.SystemVersion;

class UDPAddress {
    private final String _host;
    private InetAddress _hostAddress;
    private final int _port;
    private final byte[] _introKey;
    private final String[] _introHosts;
    private final InetAddress[] _introAddresses;
    private final int[] _introPorts;
    private final byte[][] _introKeys;
    private final long[] _introTags;
    private final long[] _introExps;
    private final Hash[] _introHashes;
    private final int _mtu;
    private final boolean _isIPv4;
    private final boolean _isIPv6;
    public static final String PROP_PORT = "port";
    public static final String PROP_HOST = "host";
    public static final String PROP_INTRO_KEY = "key";
    public static final String PROP_MTU = "mtu";
    public static final String PROP_CAPACITY = "caps";
    public static final char CAPACITY_TESTING = 'B';
    public static final char CAPACITY_INTRODUCER = 'C';
    public static final String PROP_INTRO_HOST_PREFIX = "ihost";
    public static final String PROP_INTRO_PORT_PREFIX = "iport";
    public static final String PROP_INTRO_KEY_PREFIX = "ikey";
    public static final String PROP_INTRO_TAG_PREFIX = "itag";
    public static final String PROP_INTRO_EXP_PREFIX = "iexp";
    public static final String PROP_INTRO_HASH_PREFIX = "ih";
    static final int MAX_INTRODUCERS = 3;
    private static final String[] PROP_INTRO_HOST = new String[3];
    private static final String[] PROP_INTRO_PORT = new String[3];
    private static final String[] PROP_INTRO_IKEY = new String[3];
    static final String[] PROP_INTRO_TAG = new String[3];
    private static final String[] PROP_INTRO_EXP = new String[3];
    private static final String[] PROP_INTRO_HASH = new String[3];
    private static final Map<String, InetAddress> _inetAddressCache;

    public UDPAddress(RouterAddress addr) {
        byte[] ik;
        if (addr == null) {
            this._host = null;
            this._port = 0;
            this._introKey = null;
            this._introHosts = null;
            this._introAddresses = null;
            this._introPorts = null;
            this._introKeys = null;
            this._introTags = null;
            this._introExps = null;
            this._introHashes = null;
            this._mtu = 0;
            this._isIPv4 = false;
            this._isIPv6 = false;
            return;
        }
        this._host = addr.getHost();
        this._port = addr.getPort();
        String caps = addr.getOption(PROP_CAPACITY);
        this._isIPv4 = this._host != null && this._host.contains(".") || caps != null && caps.contains("4");
        this._isIPv6 = this._host != null && this._host.contains(":") || caps != null && caps.contains("6");
        boolean ssu2only = addr.getTransportStyle().equals("SSU2");
        int cmtu = 0;
        try {
            String mtu = addr.getOption(PROP_MTU);
            if (mtu != null) {
                boolean isIPv6;
                int imtu = Integer.parseInt(mtu);
                boolean bl = isIPv6 = this._host != null && this._host.contains(":");
                if (isIPv6 && imtu > 1420) {
                    if (imtu > 1472 && this._host.startsWith("2001:470:")) {
                        imtu = 1472;
                    } else if (this._host.startsWith("2a06:a004:")) {
                        imtu = 1420;
                    }
                }
                cmtu = ssu2only ? Math.min(imtu, 1500) : MTU.rectify(isIPv6, imtu);
            } else if (this._host != null) {
                if (this._host.startsWith("2001:470:")) {
                    cmtu = 1472;
                } else if (this._host.startsWith("2a06:a004:")) {
                    cmtu = 1420;
                }
            }
        }
        catch (NumberFormatException mtu) {
            // empty catch block
        }
        this._mtu = cmtu;
        String key = addr.getOption(PROP_INTRO_KEY);
        this._introKey = (byte[])(key != null ? (byte[])((ik = Base64.decode((String)key.trim())) != null && ik.length == 32 ? ik : null) : null);
        Object cintroKeys = null;
        long[] cintroTags = null;
        int[] cintroPorts = null;
        String[] cintroHosts = null;
        InetAddress[] cintroAddresses = null;
        long[] cintroExps = null;
        Hash[] cintroHashes = null;
        boolean ssu2enable = ssu2only || "2".equals(addr.getOption("v"));
        for (int i = 2; i >= 0; --i) {
            int p;
            byte[] ikey;
            String host;
            byte[] bhash;
            String shash;
            long tag;
            String t = addr.getOption(PROP_INTRO_TAG[i]);
            if (t == null) continue;
            try {
                tag = Long.parseLong(t);
                if (tag <= 0L) {
                }
            }
            catch (NumberFormatException nfe) {}
            continue;
            Hash hash = null;
            if (ssu2enable && (shash = addr.getOption(PROP_INTRO_HASH[i])) != null && (bhash = Base64.decode((String)shash)) != null && bhash.length == 32) {
                hash = Hash.create((byte[])bhash);
            }
            if (ssu2only) {
                if (hash == null) continue;
                host = null;
                ikey = null;
                p = 0;
            } else if (hash != null) {
                host = null;
                ikey = null;
                p = 0;
            } else {
                String k;
                String port;
                host = addr.getOption(PROP_INTRO_HOST[i]);
                if (host == null || (port = addr.getOption(PROP_INTRO_PORT[i])) == null || (k = addr.getOption(PROP_INTRO_IKEY[i])) == null || (ikey = Base64.decode((String)k)) == null || ikey.length != 32) continue;
                try {
                    p = Integer.parseInt(port);
                    if (!TransportUtil.isValidPort(p)) {
                    }
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            long exp = 0L;
            t = addr.getOption(PROP_INTRO_EXP[i]);
            if (t != null) {
                try {
                    exp = Long.parseLong(t) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (cintroTags == null) {
                if (!ssu2only) {
                    cintroHosts = new String[i + 1];
                    cintroPorts = new int[i + 1];
                    cintroAddresses = new InetAddress[i + 1];
                    cintroKeys = new byte[i + 1][];
                }
                cintroTags = new long[i + 1];
                cintroExps = new long[i + 1];
                if (ssu2enable) {
                    cintroHashes = new Hash[i + 1];
                }
            }
            if (!ssu2only) {
                cintroHosts[i] = host;
                cintroPorts[i] = p;
                cintroKeys[i] = ikey;
            }
            cintroTags[i] = tag;
            cintroExps[i] = exp;
            if (!ssu2enable) continue;
            cintroHashes[i] = hash;
        }
        int numOK = 0;
        if (cintroTags != null) {
            for (int i = 0; i < cintroTags.length; ++i) {
                if (cintroTags[i] <= 0L || (cintroHashes == null || cintroHashes[i] == null) && (cintroKeys == null || cintroKeys[i] == null || cintroPorts[i] <= 0 || cintroHosts[i] == null)) continue;
                ++numOK;
            }
            if (numOK != cintroTags.length) {
                int cur = 0;
                for (int i = 0; i < cintroTags.length; ++i) {
                    if (cintroTags[i] <= 0L || (cintroHashes == null || cintroHashes[i] == null) && (cintroKeys == null || cintroKeys[i] == null || cintroPorts[i] <= 0 || cintroHosts[i] == null)) continue;
                    if (cur != i) {
                        if (cintroKeys != null) {
                            cintroKeys[cur] = cintroKeys[i];
                            cintroHosts[cur] = cintroHosts[i];
                            cintroPorts[cur] = cintroPorts[i];
                        }
                        cintroTags[cur] = cintroTags[i];
                        cintroExps[cur] = cintroExps[i];
                    }
                    ++cur;
                }
                cintroTags = Arrays.copyOfRange(cintroTags, 0, numOK);
            }
        }
        this._introKeys = cintroKeys;
        this._introTags = cintroTags;
        this._introPorts = cintroPorts;
        this._introHosts = cintroHosts;
        this._introAddresses = cintroAddresses;
        this._introExps = cintroExps;
        this._introHashes = cintroHashes;
    }

    public String getHost() {
        return this._host;
    }

    InetAddress getHostAddress() {
        if (this._hostAddress == null) {
            this._hostAddress = UDPAddress.getByName(this._host);
        }
        return this._hostAddress;
    }

    public int getPort() {
        return this._port;
    }

    byte[] getIntroKey() {
        return this._introKey;
    }

    int getIntroducerCount() {
        return this._introTags == null ? 0 : this._introTags.length;
    }

    InetAddress getIntroducerHost(int i) {
        if (this._introAddresses == null) {
            return null;
        }
        if (this._introAddresses[i] == null) {
            this._introAddresses[i] = UDPAddress.getByName(this._introHosts[i]);
        }
        return this._introAddresses[i];
    }

    int getIntroducerPort(int i) {
        return this._introPorts != null ? this._introPorts[i] : 0;
    }

    byte[] getIntroducerKey(int i) {
        return this._introKeys != null ? this._introKeys[i] : null;
    }

    long getIntroducerTag(int i) {
        return this._introTags[i];
    }

    long getIntroducerExpiration(int i) {
        return this._introExps[i];
    }

    Hash getIntroducerHash(int i) {
        return this._introHashes != null ? this._introHashes[i] : null;
    }

    boolean isIPv4() {
        return this._isIPv4;
    }

    boolean isIPv6() {
        return this._isIPv6;
    }

    int getMTU() {
        return this._mtu;
    }

    public String toString() {
        StringBuilder rv = new StringBuilder(64);
        if (this._introHosts != null) {
            for (int i = 0; i < this._introHosts.length; ++i) {
                rv.append("ssu://");
                rv.append(this._introTags[i]).append('@');
                rv.append(this._introHosts[i]).append(':').append(this._introPorts[i]);
                if (i + 1 >= this._introKeys.length) continue;
                rv.append(", ");
            }
        } else if (this._host != null && this._port > 0) {
            rv.append("ssu://").append(this._host).append(':').append(this._port);
        } else {
            rv.append("ssu://autodetect.not.yet.complete:").append(this._port);
        }
        return rv.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress getByName(String host) {
        InetAddress rv;
        if (host == null) {
            return null;
        }
        Map<String, InetAddress> map = _inetAddressCache;
        synchronized (map) {
            rv = _inetAddressCache.get(host);
        }
        if (rv == null && Addresses.isIPAddress((String)host)) {
            try {
                rv = InetAddress.getByName(host);
                map = _inetAddressCache;
                synchronized (map) {
                    _inetAddressCache.put(host, rv);
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache() {
        Map<String, InetAddress> map = _inetAddressCache;
        synchronized (map) {
            _inetAddressCache.clear();
        }
    }

    static {
        for (int i = 0; i < 3; ++i) {
            UDPAddress.PROP_INTRO_HOST[i] = PROP_INTRO_HOST_PREFIX + i;
            UDPAddress.PROP_INTRO_PORT[i] = PROP_INTRO_PORT_PREFIX + i;
            UDPAddress.PROP_INTRO_IKEY[i] = PROP_INTRO_KEY_PREFIX + i;
            UDPAddress.PROP_INTRO_TAG[i] = PROP_INTRO_TAG_PREFIX + i;
            UDPAddress.PROP_INTRO_EXP[i] = PROP_INTRO_EXP_PREFIX + i;
            UDPAddress.PROP_INTRO_HASH[i] = PROP_INTRO_HASH_PREFIX + i;
        }
        long maxMemory = SystemVersion.getMaxMemory();
        long min = 128L;
        long max = 2048L;
        int size = (int)Math.max(min, Math.min(max, 1L + maxMemory / 262144L));
        _inetAddressCache = new LHMCache(size);
    }
}

