/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.Base64;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.TunnelId;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.router.tunnel.HopConfig;

public abstract class TunnelCreatorConfig
implements TunnelInfo {
    protected final RouterContext _context;
    private final Hash _destination;
    private final HopConfig[] _config;
    private final Hash[] _peers;
    private volatile long _expiration;
    private List<Integer> _order;
    private long _replyMessageId;
    private final boolean _isInbound;
    private int _messagesProcessed;
    private long _verifiedBytesTransferred;
    private final AtomicInteger _failures = new AtomicInteger();
    private boolean _reused;
    private int _priority;
    private long _peakThroughputCurrentTotal;
    private long _peakThroughputLastCoallesce = System.currentTimeMillis();
    private Hash _blankHash;
    private SessionKey[] _ChaReplyKeys;
    private byte[][] _ChaReplyADs;
    private final SessionKey[] _AESReplyKeys;
    private final byte[][] _AESReplyIVs;
    private MessageWrapper.OneTimeSession _garlicReplyKeys;
    public static final int REPLY_IV_LENGTH = 16;
    private static final int MAX_CONSECUTIVE_TEST_FAILURES = 3;

    public TunnelCreatorConfig(RouterContext ctx, int length, boolean isInbound) {
        this(ctx, length, isInbound, null);
    }

    public TunnelCreatorConfig(RouterContext ctx, int length, boolean isInbound, Hash destination) {
        this._context = ctx;
        if (length <= 0) {
            throw new IllegalArgumentException("0 length?  0 hop tunnels are 1 length!");
        }
        this._config = new HopConfig[length];
        this._peers = new Hash[length];
        for (int i = 0; i < length; ++i) {
            this._config[i] = new HopConfig();
        }
        this._isInbound = isInbound;
        this._destination = destination;
        this._AESReplyKeys = new SessionKey[length];
        this._AESReplyIVs = new byte[length][];
    }

    @Override
    public int getLength() {
        return this._config.length;
    }

    public Properties getOptions() {
        return null;
    }

    public HopConfig getConfig(int hop) {
        return this._config[hop];
    }

    @Override
    public TunnelId getReceiveTunnelId(int hop) {
        return this._config[hop].getReceiveTunnel();
    }

    @Override
    public TunnelId getSendTunnelId(int hop) {
        return this._config[hop].getSendTunnel();
    }

    @Override
    public Hash getPeer(int hop) {
        return this._peers[hop];
    }

    public void setPeer(int hop, Hash peer) {
        this._peers[hop] = peer;
    }

    @Override
    public Hash getGateway() {
        return this._peers[0];
    }

    @Override
    public Hash getEndpoint() {
        return this._peers[this._peers.length - 1];
    }

    @Override
    public Hash getFarEnd() {
        return this._peers[this._isInbound ? 0 : this._peers.length - 1];
    }

    @Override
    public boolean isInbound() {
        return this._isInbound;
    }

    @Override
    public Hash getDestination() {
        return this._destination;
    }

    @Override
    public long getExpiration() {
        return this._expiration;
    }

    public void setExpiration(long when) {
        this._expiration = when;
    }

    public List<Integer> getReplyOrder() {
        return this._order;
    }

    public void setReplyOrder(List<Integer> order) {
        this._order = order;
    }

    public long getReplyMessageId() {
        return this._replyMessageId;
    }

    public void setReplyMessageId(long id) {
        this._replyMessageId = id;
    }

    public synchronized void incrementProcessedMessages() {
        ++this._messagesProcessed;
    }

    @Override
    public synchronized int getProcessedMessagesCount() {
        return this._messagesProcessed;
    }

    @Override
    public synchronized void incrementVerifiedBytesTransferred(int bytes) {
        this._verifiedBytesTransferred += (long)bytes;
        this._peakThroughputCurrentTotal += (long)bytes;
        long now = System.currentTimeMillis();
        long timeSince = now - this._peakThroughputLastCoallesce;
        if (timeSince >= 60000L) {
            long tot = this._peakThroughputCurrentTotal;
            int normalized = (int)((double)tot * 60.0 * 1000.0 / (double)timeSince);
            this._peakThroughputLastCoallesce = now;
            this._peakThroughputCurrentTotal = 0L;
            if (this._context != null) {
                int start = this._isInbound ? 0 : 1;
                int end = this._isInbound ? this._peers.length - 1 : this._peers.length;
                for (int i = start; i < end; ++i) {
                    this._context.profileManager().tunnelDataPushed1m(this._peers[i], normalized);
                }
            }
        }
    }

    @Override
    public synchronized long getVerifiedBytesTransferred() {
        return this._verifiedBytesTransferred;
    }

    public boolean tunnelFailed() {
        boolean rv;
        boolean bl = rv = this._failures.incrementAndGet() <= 3;
        if (!rv) {
            this._reused = true;
        }
        return rv;
    }

    public void tunnelFailedCompletely() {
        this._failures.addAndGet(4);
        this._reused = true;
    }

    @Override
    public boolean getTunnelFailed() {
        return this._failures.get() > 3;
    }

    public int getTunnelFailures() {
        return this._failures.get();
    }

    @Override
    public void testSuccessful(int ms) {
        this._failures.set(0);
    }

    @Override
    public boolean wasReused() {
        return this._reused;
    }

    @Override
    public void setReused() {
        this._reused = true;
    }

    public int getPriority() {
        return this._priority;
    }

    public void setPriority(int priority) {
        this._priority = priority;
    }

    public void setAESReplyKeys(int hop, SessionKey key, byte[] iv) {
        if (iv.length != 16) {
            throw new IllegalArgumentException();
        }
        this._AESReplyKeys[hop] = key;
        this._AESReplyIVs[hop] = iv;
    }

    public SessionKey getAESReplyKey(int hop) {
        return this._AESReplyKeys[hop];
    }

    public byte[] getAESReplyIV(int hop) {
        return this._AESReplyIVs[hop];
    }

    public Hash getBlankHash() {
        return this._blankHash;
    }

    public void setBlankHash(Hash h) {
        this._blankHash = h;
    }

    public void setChaChaReplyKeys(int hop, SessionKey key, byte[] ad) {
        if (this._ChaReplyKeys == null) {
            this._ChaReplyKeys = new SessionKey[this._config.length];
            this._ChaReplyADs = new byte[this._config.length][];
        }
        this._ChaReplyKeys[hop] = key;
        this._ChaReplyADs[hop] = ad;
    }

    public boolean isEC(int hop) {
        if (this._ChaReplyKeys == null) {
            return false;
        }
        return this._ChaReplyKeys[hop] != null;
    }

    public SessionKey getChaChaReplyKey(int hop) {
        if (this._ChaReplyKeys == null) {
            return null;
        }
        return this._ChaReplyKeys[hop];
    }

    public byte[] getChaChaReplyAD(int hop) {
        if (this._ChaReplyADs == null) {
            return null;
        }
        return this._ChaReplyADs[hop];
    }

    public void setGarlicReplyKeys(MessageWrapper.OneTimeSession keys) {
        this._garlicReplyKeys = keys;
    }

    public MessageWrapper.OneTimeSession getGarlicReplyKeys() {
        return this._garlicReplyKeys;
    }

    public String toString() {
        int fails;
        StringBuilder buf = new StringBuilder(128);
        if (this._isInbound) {
            buf.append("IB");
        } else {
            buf.append("OB");
        }
        if (this._destination == null) {
            buf.append(" expl");
        } else {
            buf.append(" client ").append(Base64.encode((byte[])this._destination.getData(), (int)0, (int)3));
        }
        buf.append(": GW ");
        for (int i = 0; i < this._peers.length; ++i) {
            buf.append(this._peers[i].toBase64(), 0, 4);
            long id = this._config[i].getReceiveTunnelId();
            if (id != 0L) {
                if (!this._isInbound || i != this._peers.length - 1) {
                    buf.append(this.isEC(i) ? " EC:" : " ElG:");
                } else {
                    buf.append(' ');
                }
                buf.append(id);
            } else {
                buf.append(" me");
            }
            id = this._config[i].getSendTunnelId();
            if (id != 0L) {
                buf.append('.');
                buf.append(id);
            } else if (this._isInbound || i == 0) {
                buf.append(".me");
            }
            if (i + 1 >= this._peers.length) continue;
            buf.append("-->");
        }
        buf.append(" exp. ").append(new Date(this._expiration));
        if (this._replyMessageId > 0L) {
            buf.append(" replyMsgID ").append(this._replyMessageId);
        }
        if (this._messagesProcessed > 0) {
            buf.append(" with ").append(this._messagesProcessed).append("/").append(this._verifiedBytesTransferred).append(" msgs/bytes");
        }
        if ((fails = this._failures.get()) > 0) {
            buf.append(" with ").append(fails).append(" consec. failures");
        }
        return buf.toString();
    }

    public String toStringFull() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append(this.toString());
        for (int i = 0; i < this._peers.length; ++i) {
            if (i == 0) {
                buf.append("\nGW   ");
            } else if (i == this._peers.length - 1) {
                buf.append("\nEP   ");
            } else {
                buf.append("\nHop ").append(i);
            }
            buf.append(": ").append(this._config[i]);
        }
        if (this._garlicReplyKeys != null) {
            buf.append("\nGarlic reply key: ").append(this._garlicReplyKeys.key).append(" tag: ").append(this._garlicReplyKeys.rtag);
        }
        return buf.toString();
    }
}

