/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleTimer;

class RequestThrottler {
    private final RouterContext context;
    private final ObjectCounter<Hash> counter;
    private final Log _log;
    private static final int LIFETIME_PORTION = 6;
    private static final int MIN_LIMIT = 7;
    private static final int MAX_LIMIT = 27;
    private static final int PERCENT_LIMIT = 2;
    private static final long CLEAN_TIME = 110000L;

    RequestThrottler(RouterContext ctx) {
        this.context = ctx;
        this.counter = new ObjectCounter();
        this._log = ctx.logManager().getLog(RequestThrottler.class);
        ctx.simpleTimer2().addPeriodicEvent((SimpleTimer.TimedEvent)new Cleaner(), 110000L);
    }

    boolean shouldThrottle(Hash h) {
        int numTunnels = this.context.tunnelManager().getParticipatingCount();
        int limit = Math.max(7, Math.min(27, numTunnels * 2 / 100));
        int count = this.counter.increment((Object)h);
        boolean rv = count > limit;
        return rv;
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        public void timeReached() {
            RequestThrottler.this.counter.clear();
        }
    }
}

